<?php
/**
 * SalesRuleDataRuleInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesRuleDataRuleInterface Class Doc Comment
 *
 * @category Class
 * @description Interface RuleInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesRuleDataRuleInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-rule-data-rule-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'rule_id' => 'int',
        'name' => 'string',
        'store_labels' => '\Magento2\Model\SalesRuleDataRuleLabelInterface[]',
        'description' => 'string',
        'website_ids' => 'int[]',
        'customer_group_ids' => 'int[]',
        'from_date' => 'string',
        'to_date' => 'string',
        'uses_per_customer' => 'int',
        'is_active' => 'bool',
        'condition' => '\Magento2\Model\SalesRuleDataConditionInterface',
        'action_condition' => '\Magento2\Model\SalesRuleDataConditionInterface',
        'stop_rules_processing' => 'bool',
        'is_advanced' => 'bool',
        'product_ids' => 'int[]',
        'sort_order' => 'int',
        'simple_action' => 'string',
        'discount_amount' => 'float',
        'discount_qty' => 'float',
        'discount_step' => 'int',
        'apply_to_shipping' => 'bool',
        'times_used' => 'int',
        'is_rss' => 'bool',
        'coupon_type' => 'string',
        'use_auto_generation' => 'bool',
        'uses_per_coupon' => 'int',
        'simple_free_shipping' => 'string',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'rule_id' => null,
        'name' => null,
        'store_labels' => null,
        'description' => null,
        'website_ids' => null,
        'customer_group_ids' => null,
        'from_date' => null,
        'to_date' => null,
        'uses_per_customer' => null,
        'is_active' => null,
        'condition' => null,
        'action_condition' => null,
        'stop_rules_processing' => null,
        'is_advanced' => null,
        'product_ids' => null,
        'sort_order' => null,
        'simple_action' => null,
        'discount_amount' => null,
        'discount_qty' => null,
        'discount_step' => null,
        'apply_to_shipping' => null,
        'times_used' => null,
        'is_rss' => null,
        'coupon_type' => null,
        'use_auto_generation' => null,
        'uses_per_coupon' => null,
        'simple_free_shipping' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rule_id' => 'rule_id',
        'name' => 'name',
        'store_labels' => 'store_labels',
        'description' => 'description',
        'website_ids' => 'website_ids',
        'customer_group_ids' => 'customer_group_ids',
        'from_date' => 'from_date',
        'to_date' => 'to_date',
        'uses_per_customer' => 'uses_per_customer',
        'is_active' => 'is_active',
        'condition' => 'condition',
        'action_condition' => 'action_condition',
        'stop_rules_processing' => 'stop_rules_processing',
        'is_advanced' => 'is_advanced',
        'product_ids' => 'product_ids',
        'sort_order' => 'sort_order',
        'simple_action' => 'simple_action',
        'discount_amount' => 'discount_amount',
        'discount_qty' => 'discount_qty',
        'discount_step' => 'discount_step',
        'apply_to_shipping' => 'apply_to_shipping',
        'times_used' => 'times_used',
        'is_rss' => 'is_rss',
        'coupon_type' => 'coupon_type',
        'use_auto_generation' => 'use_auto_generation',
        'uses_per_coupon' => 'uses_per_coupon',
        'simple_free_shipping' => 'simple_free_shipping',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'rule_id' => 'setRuleId',
        'name' => 'setName',
        'store_labels' => 'setStoreLabels',
        'description' => 'setDescription',
        'website_ids' => 'setWebsiteIds',
        'customer_group_ids' => 'setCustomerGroupIds',
        'from_date' => 'setFromDate',
        'to_date' => 'setToDate',
        'uses_per_customer' => 'setUsesPerCustomer',
        'is_active' => 'setIsActive',
        'condition' => 'setCondition',
        'action_condition' => 'setActionCondition',
        'stop_rules_processing' => 'setStopRulesProcessing',
        'is_advanced' => 'setIsAdvanced',
        'product_ids' => 'setProductIds',
        'sort_order' => 'setSortOrder',
        'simple_action' => 'setSimpleAction',
        'discount_amount' => 'setDiscountAmount',
        'discount_qty' => 'setDiscountQty',
        'discount_step' => 'setDiscountStep',
        'apply_to_shipping' => 'setApplyToShipping',
        'times_used' => 'setTimesUsed',
        'is_rss' => 'setIsRss',
        'coupon_type' => 'setCouponType',
        'use_auto_generation' => 'setUseAutoGeneration',
        'uses_per_coupon' => 'setUsesPerCoupon',
        'simple_free_shipping' => 'setSimpleFreeShipping',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'rule_id' => 'getRuleId',
        'name' => 'getName',
        'store_labels' => 'getStoreLabels',
        'description' => 'getDescription',
        'website_ids' => 'getWebsiteIds',
        'customer_group_ids' => 'getCustomerGroupIds',
        'from_date' => 'getFromDate',
        'to_date' => 'getToDate',
        'uses_per_customer' => 'getUsesPerCustomer',
        'is_active' => 'getIsActive',
        'condition' => 'getCondition',
        'action_condition' => 'getActionCondition',
        'stop_rules_processing' => 'getStopRulesProcessing',
        'is_advanced' => 'getIsAdvanced',
        'product_ids' => 'getProductIds',
        'sort_order' => 'getSortOrder',
        'simple_action' => 'getSimpleAction',
        'discount_amount' => 'getDiscountAmount',
        'discount_qty' => 'getDiscountQty',
        'discount_step' => 'getDiscountStep',
        'apply_to_shipping' => 'getApplyToShipping',
        'times_used' => 'getTimesUsed',
        'is_rss' => 'getIsRss',
        'coupon_type' => 'getCouponType',
        'use_auto_generation' => 'getUseAutoGeneration',
        'uses_per_coupon' => 'getUsesPerCoupon',
        'simple_free_shipping' => 'getSimpleFreeShipping',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['rule_id'] = $data['rule_id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['store_labels'] = $data['store_labels'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['website_ids'] = $data['website_ids'] ?? null;
        $this->container['customer_group_ids'] = $data['customer_group_ids'] ?? null;
        $this->container['from_date'] = $data['from_date'] ?? null;
        $this->container['to_date'] = $data['to_date'] ?? null;
        $this->container['uses_per_customer'] = $data['uses_per_customer'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['condition'] = $data['condition'] ?? null;
        $this->container['action_condition'] = $data['action_condition'] ?? null;
        $this->container['stop_rules_processing'] = $data['stop_rules_processing'] ?? null;
        $this->container['is_advanced'] = $data['is_advanced'] ?? null;
        $this->container['product_ids'] = $data['product_ids'] ?? null;
        $this->container['sort_order'] = $data['sort_order'] ?? null;
        $this->container['simple_action'] = $data['simple_action'] ?? null;
        $this->container['discount_amount'] = $data['discount_amount'] ?? null;
        $this->container['discount_qty'] = $data['discount_qty'] ?? null;
        $this->container['discount_step'] = $data['discount_step'] ?? null;
        $this->container['apply_to_shipping'] = $data['apply_to_shipping'] ?? null;
        $this->container['times_used'] = $data['times_used'] ?? null;
        $this->container['is_rss'] = $data['is_rss'] ?? null;
        $this->container['coupon_type'] = $data['coupon_type'] ?? null;
        $this->container['use_auto_generation'] = $data['use_auto_generation'] ?? null;
        $this->container['uses_per_coupon'] = $data['uses_per_coupon'] ?? null;
        $this->container['simple_free_shipping'] = $data['simple_free_shipping'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['website_ids'] === null) {
            $invalidProperties[] = "'website_ids' can't be null";
        }
        if ($this->container['customer_group_ids'] === null) {
            $invalidProperties[] = "'customer_group_ids' can't be null";
        }
        if ($this->container['uses_per_customer'] === null) {
            $invalidProperties[] = "'uses_per_customer' can't be null";
        }
        if ($this->container['is_active'] === null) {
            $invalidProperties[] = "'is_active' can't be null";
        }
        if ($this->container['stop_rules_processing'] === null) {
            $invalidProperties[] = "'stop_rules_processing' can't be null";
        }
        if ($this->container['is_advanced'] === null) {
            $invalidProperties[] = "'is_advanced' can't be null";
        }
        if ($this->container['sort_order'] === null) {
            $invalidProperties[] = "'sort_order' can't be null";
        }
        if ($this->container['discount_amount'] === null) {
            $invalidProperties[] = "'discount_amount' can't be null";
        }
        if ($this->container['discount_step'] === null) {
            $invalidProperties[] = "'discount_step' can't be null";
        }
        if ($this->container['apply_to_shipping'] === null) {
            $invalidProperties[] = "'apply_to_shipping' can't be null";
        }
        if ($this->container['times_used'] === null) {
            $invalidProperties[] = "'times_used' can't be null";
        }
        if ($this->container['is_rss'] === null) {
            $invalidProperties[] = "'is_rss' can't be null";
        }
        if ($this->container['coupon_type'] === null) {
            $invalidProperties[] = "'coupon_type' can't be null";
        }
        if ($this->container['use_auto_generation'] === null) {
            $invalidProperties[] = "'use_auto_generation' can't be null";
        }
        if ($this->container['uses_per_coupon'] === null) {
            $invalidProperties[] = "'uses_per_coupon' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets rule_id
     *
     * @return int|null
     */
    public function getRuleId()
    {
        return $this->container['rule_id'];
    }

    /**
     * Sets rule_id
     *
     * @param int|null $rule_id Rule id
     *
     * @return self
     */
    public function setRuleId($rule_id)
    {
        $this->container['rule_id'] = $rule_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Rule name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets store_labels
     *
     * @return \Magento2\Model\SalesRuleDataRuleLabelInterface[]|null
     */
    public function getStoreLabels()
    {
        return $this->container['store_labels'];
    }

    /**
     * Sets store_labels
     *
     * @param \Magento2\Model\SalesRuleDataRuleLabelInterface[]|null $store_labels Display label
     *
     * @return self
     */
    public function setStoreLabels($store_labels)
    {
        $this->container['store_labels'] = $store_labels;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets website_ids
     *
     * @return int[]
     */
    public function getWebsiteIds()
    {
        return $this->container['website_ids'];
    }

    /**
     * Sets website_ids
     *
     * @param int[] $website_ids A list of websites the rule applies to
     *
     * @return self
     */
    public function setWebsiteIds($website_ids)
    {
        $this->container['website_ids'] = $website_ids;

        return $this;
    }

    /**
     * Gets customer_group_ids
     *
     * @return int[]
     */
    public function getCustomerGroupIds()
    {
        return $this->container['customer_group_ids'];
    }

    /**
     * Sets customer_group_ids
     *
     * @param int[] $customer_group_ids Ids of customer groups that the rule applies to
     *
     * @return self
     */
    public function setCustomerGroupIds($customer_group_ids)
    {
        $this->container['customer_group_ids'] = $customer_group_ids;

        return $this;
    }

    /**
     * Gets from_date
     *
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->container['from_date'];
    }

    /**
     * Sets from_date
     *
     * @param string|null $from_date The start date when the coupon is active
     *
     * @return self
     */
    public function setFromDate($from_date)
    {
        $this->container['from_date'] = $from_date;

        return $this;
    }

    /**
     * Gets to_date
     *
     * @return string|null
     */
    public function getToDate()
    {
        return $this->container['to_date'];
    }

    /**
     * Sets to_date
     *
     * @param string|null $to_date The end date when the coupon is active
     *
     * @return self
     */
    public function setToDate($to_date)
    {
        $this->container['to_date'] = $to_date;

        return $this;
    }

    /**
     * Gets uses_per_customer
     *
     * @return int
     */
    public function getUsesPerCustomer()
    {
        return $this->container['uses_per_customer'];
    }

    /**
     * Sets uses_per_customer
     *
     * @param int $uses_per_customer Number of uses per customer
     *
     * @return self
     */
    public function setUsesPerCustomer($uses_per_customer)
    {
        $this->container['uses_per_customer'] = $uses_per_customer;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool $is_active The coupon is active
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return \Magento2\Model\SalesRuleDataConditionInterface|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param \Magento2\Model\SalesRuleDataConditionInterface|null $condition condition
     *
     * @return self
     */
    public function setCondition($condition)
    {
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets action_condition
     *
     * @return \Magento2\Model\SalesRuleDataConditionInterface|null
     */
    public function getActionCondition()
    {
        return $this->container['action_condition'];
    }

    /**
     * Sets action_condition
     *
     * @param \Magento2\Model\SalesRuleDataConditionInterface|null $action_condition action_condition
     *
     * @return self
     */
    public function setActionCondition($action_condition)
    {
        $this->container['action_condition'] = $action_condition;

        return $this;
    }

    /**
     * Gets stop_rules_processing
     *
     * @return bool
     */
    public function getStopRulesProcessing()
    {
        return $this->container['stop_rules_processing'];
    }

    /**
     * Sets stop_rules_processing
     *
     * @param bool $stop_rules_processing To stop rule processing
     *
     * @return self
     */
    public function setStopRulesProcessing($stop_rules_processing)
    {
        $this->container['stop_rules_processing'] = $stop_rules_processing;

        return $this;
    }

    /**
     * Gets is_advanced
     *
     * @return bool
     */
    public function getIsAdvanced()
    {
        return $this->container['is_advanced'];
    }

    /**
     * Sets is_advanced
     *
     * @param bool $is_advanced Is this field needed
     *
     * @return self
     */
    public function setIsAdvanced($is_advanced)
    {
        $this->container['is_advanced'] = $is_advanced;

        return $this;
    }

    /**
     * Gets product_ids
     *
     * @return int[]|null
     */
    public function getProductIds()
    {
        return $this->container['product_ids'];
    }

    /**
     * Sets product_ids
     *
     * @param int[]|null $product_ids Product ids
     *
     * @return self
     */
    public function setProductIds($product_ids)
    {
        $this->container['product_ids'] = $product_ids;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int $sort_order Sort order
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets simple_action
     *
     * @return string|null
     */
    public function getSimpleAction()
    {
        return $this->container['simple_action'];
    }

    /**
     * Sets simple_action
     *
     * @param string|null $simple_action Simple action of the rule
     *
     * @return self
     */
    public function setSimpleAction($simple_action)
    {
        $this->container['simple_action'] = $simple_action;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float $discount_amount Discount amount
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_qty
     *
     * @return float|null
     */
    public function getDiscountQty()
    {
        return $this->container['discount_qty'];
    }

    /**
     * Sets discount_qty
     *
     * @param float|null $discount_qty Maximum qty discount is applied
     *
     * @return self
     */
    public function setDiscountQty($discount_qty)
    {
        $this->container['discount_qty'] = $discount_qty;

        return $this;
    }

    /**
     * Gets discount_step
     *
     * @return int
     */
    public function getDiscountStep()
    {
        return $this->container['discount_step'];
    }

    /**
     * Sets discount_step
     *
     * @param int $discount_step Discount step
     *
     * @return self
     */
    public function setDiscountStep($discount_step)
    {
        $this->container['discount_step'] = $discount_step;

        return $this;
    }

    /**
     * Gets apply_to_shipping
     *
     * @return bool
     */
    public function getApplyToShipping()
    {
        return $this->container['apply_to_shipping'];
    }

    /**
     * Sets apply_to_shipping
     *
     * @param bool $apply_to_shipping The rule applies to shipping
     *
     * @return self
     */
    public function setApplyToShipping($apply_to_shipping)
    {
        $this->container['apply_to_shipping'] = $apply_to_shipping;

        return $this;
    }

    /**
     * Gets times_used
     *
     * @return int
     */
    public function getTimesUsed()
    {
        return $this->container['times_used'];
    }

    /**
     * Sets times_used
     *
     * @param int $times_used How many times the rule has been used
     *
     * @return self
     */
    public function setTimesUsed($times_used)
    {
        $this->container['times_used'] = $times_used;

        return $this;
    }

    /**
     * Gets is_rss
     *
     * @return bool
     */
    public function getIsRss()
    {
        return $this->container['is_rss'];
    }

    /**
     * Sets is_rss
     *
     * @param bool $is_rss Whether the rule is in RSS
     *
     * @return self
     */
    public function setIsRss($is_rss)
    {
        $this->container['is_rss'] = $is_rss;

        return $this;
    }

    /**
     * Gets coupon_type
     *
     * @return string
     */
    public function getCouponType()
    {
        return $this->container['coupon_type'];
    }

    /**
     * Sets coupon_type
     *
     * @param string $coupon_type Coupon type
     *
     * @return self
     */
    public function setCouponType($coupon_type)
    {
        $this->container['coupon_type'] = $coupon_type;

        return $this;
    }

    /**
     * Gets use_auto_generation
     *
     * @return bool
     */
    public function getUseAutoGeneration()
    {
        return $this->container['use_auto_generation'];
    }

    /**
     * Sets use_auto_generation
     *
     * @param bool $use_auto_generation To auto generate coupon
     *
     * @return self
     */
    public function setUseAutoGeneration($use_auto_generation)
    {
        $this->container['use_auto_generation'] = $use_auto_generation;

        return $this;
    }

    /**
     * Gets uses_per_coupon
     *
     * @return int
     */
    public function getUsesPerCoupon()
    {
        return $this->container['uses_per_coupon'];
    }

    /**
     * Sets uses_per_coupon
     *
     * @param int $uses_per_coupon Limit of uses per coupon
     *
     * @return self
     */
    public function setUsesPerCoupon($uses_per_coupon)
    {
        $this->container['uses_per_coupon'] = $uses_per_coupon;

        return $this;
    }

    /**
     * Gets simple_free_shipping
     *
     * @return string|null
     */
    public function getSimpleFreeShipping()
    {
        return $this->container['simple_free_shipping'];
    }

    /**
     * Sets simple_free_shipping
     *
     * @param string|null $simple_free_shipping To grant free shipping
     *
     * @return self
     */
    public function setSimpleFreeShipping($simple_free_shipping)
    {
        $this->container['simple_free_shipping'] = $simple_free_shipping;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\SalesRule\\Api\\Data\\RuleInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


