<?php
/**
 * SalesDataTotalInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesDataTotalInterface Class Doc Comment
 *
 * @category Class
 * @description Interface TotalInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesDataTotalInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-data-total-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'base_shipping_amount' => 'float',
        'base_shipping_canceled' => 'float',
        'base_shipping_discount_amount' => 'float',
        'base_shipping_discount_tax_compensation_amnt' => 'float',
        'base_shipping_incl_tax' => 'float',
        'base_shipping_invoiced' => 'float',
        'base_shipping_refunded' => 'float',
        'base_shipping_tax_amount' => 'float',
        'base_shipping_tax_refunded' => 'float',
        'shipping_amount' => 'float',
        'shipping_canceled' => 'float',
        'shipping_discount_amount' => 'float',
        'shipping_discount_tax_compensation_amount' => 'float',
        'shipping_incl_tax' => 'float',
        'shipping_invoiced' => 'float',
        'shipping_refunded' => 'float',
        'shipping_tax_amount' => 'float',
        'shipping_tax_refunded' => 'float',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'base_shipping_amount' => null,
        'base_shipping_canceled' => null,
        'base_shipping_discount_amount' => null,
        'base_shipping_discount_tax_compensation_amnt' => null,
        'base_shipping_incl_tax' => null,
        'base_shipping_invoiced' => null,
        'base_shipping_refunded' => null,
        'base_shipping_tax_amount' => null,
        'base_shipping_tax_refunded' => null,
        'shipping_amount' => null,
        'shipping_canceled' => null,
        'shipping_discount_amount' => null,
        'shipping_discount_tax_compensation_amount' => null,
        'shipping_incl_tax' => null,
        'shipping_invoiced' => null,
        'shipping_refunded' => null,
        'shipping_tax_amount' => null,
        'shipping_tax_refunded' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'base_shipping_amount' => 'base_shipping_amount',
        'base_shipping_canceled' => 'base_shipping_canceled',
        'base_shipping_discount_amount' => 'base_shipping_discount_amount',
        'base_shipping_discount_tax_compensation_amnt' => 'base_shipping_discount_tax_compensation_amnt',
        'base_shipping_incl_tax' => 'base_shipping_incl_tax',
        'base_shipping_invoiced' => 'base_shipping_invoiced',
        'base_shipping_refunded' => 'base_shipping_refunded',
        'base_shipping_tax_amount' => 'base_shipping_tax_amount',
        'base_shipping_tax_refunded' => 'base_shipping_tax_refunded',
        'shipping_amount' => 'shipping_amount',
        'shipping_canceled' => 'shipping_canceled',
        'shipping_discount_amount' => 'shipping_discount_amount',
        'shipping_discount_tax_compensation_amount' => 'shipping_discount_tax_compensation_amount',
        'shipping_incl_tax' => 'shipping_incl_tax',
        'shipping_invoiced' => 'shipping_invoiced',
        'shipping_refunded' => 'shipping_refunded',
        'shipping_tax_amount' => 'shipping_tax_amount',
        'shipping_tax_refunded' => 'shipping_tax_refunded',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'base_shipping_amount' => 'setBaseShippingAmount',
        'base_shipping_canceled' => 'setBaseShippingCanceled',
        'base_shipping_discount_amount' => 'setBaseShippingDiscountAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'setBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'setBaseShippingInclTax',
        'base_shipping_invoiced' => 'setBaseShippingInvoiced',
        'base_shipping_refunded' => 'setBaseShippingRefunded',
        'base_shipping_tax_amount' => 'setBaseShippingTaxAmount',
        'base_shipping_tax_refunded' => 'setBaseShippingTaxRefunded',
        'shipping_amount' => 'setShippingAmount',
        'shipping_canceled' => 'setShippingCanceled',
        'shipping_discount_amount' => 'setShippingDiscountAmount',
        'shipping_discount_tax_compensation_amount' => 'setShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'setShippingInclTax',
        'shipping_invoiced' => 'setShippingInvoiced',
        'shipping_refunded' => 'setShippingRefunded',
        'shipping_tax_amount' => 'setShippingTaxAmount',
        'shipping_tax_refunded' => 'setShippingTaxRefunded',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'base_shipping_amount' => 'getBaseShippingAmount',
        'base_shipping_canceled' => 'getBaseShippingCanceled',
        'base_shipping_discount_amount' => 'getBaseShippingDiscountAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'getBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'getBaseShippingInclTax',
        'base_shipping_invoiced' => 'getBaseShippingInvoiced',
        'base_shipping_refunded' => 'getBaseShippingRefunded',
        'base_shipping_tax_amount' => 'getBaseShippingTaxAmount',
        'base_shipping_tax_refunded' => 'getBaseShippingTaxRefunded',
        'shipping_amount' => 'getShippingAmount',
        'shipping_canceled' => 'getShippingCanceled',
        'shipping_discount_amount' => 'getShippingDiscountAmount',
        'shipping_discount_tax_compensation_amount' => 'getShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'getShippingInclTax',
        'shipping_invoiced' => 'getShippingInvoiced',
        'shipping_refunded' => 'getShippingRefunded',
        'shipping_tax_amount' => 'getShippingTaxAmount',
        'shipping_tax_refunded' => 'getShippingTaxRefunded',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['base_shipping_amount'] = $data['base_shipping_amount'] ?? null;
        $this->container['base_shipping_canceled'] = $data['base_shipping_canceled'] ?? null;
        $this->container['base_shipping_discount_amount'] = $data['base_shipping_discount_amount'] ?? null;
        $this->container['base_shipping_discount_tax_compensation_amnt'] = $data['base_shipping_discount_tax_compensation_amnt'] ?? null;
        $this->container['base_shipping_incl_tax'] = $data['base_shipping_incl_tax'] ?? null;
        $this->container['base_shipping_invoiced'] = $data['base_shipping_invoiced'] ?? null;
        $this->container['base_shipping_refunded'] = $data['base_shipping_refunded'] ?? null;
        $this->container['base_shipping_tax_amount'] = $data['base_shipping_tax_amount'] ?? null;
        $this->container['base_shipping_tax_refunded'] = $data['base_shipping_tax_refunded'] ?? null;
        $this->container['shipping_amount'] = $data['shipping_amount'] ?? null;
        $this->container['shipping_canceled'] = $data['shipping_canceled'] ?? null;
        $this->container['shipping_discount_amount'] = $data['shipping_discount_amount'] ?? null;
        $this->container['shipping_discount_tax_compensation_amount'] = $data['shipping_discount_tax_compensation_amount'] ?? null;
        $this->container['shipping_incl_tax'] = $data['shipping_incl_tax'] ?? null;
        $this->container['shipping_invoiced'] = $data['shipping_invoiced'] ?? null;
        $this->container['shipping_refunded'] = $data['shipping_refunded'] ?? null;
        $this->container['shipping_tax_amount'] = $data['shipping_tax_amount'] ?? null;
        $this->container['shipping_tax_refunded'] = $data['shipping_tax_refunded'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets base_shipping_amount
     *
     * @return float|null
     */
    public function getBaseShippingAmount()
    {
        return $this->container['base_shipping_amount'];
    }

    /**
     * Sets base_shipping_amount
     *
     * @param float|null $base_shipping_amount Base shipping amount.
     *
     * @return self
     */
    public function setBaseShippingAmount($base_shipping_amount)
    {
        $this->container['base_shipping_amount'] = $base_shipping_amount;

        return $this;
    }

    /**
     * Gets base_shipping_canceled
     *
     * @return float|null
     */
    public function getBaseShippingCanceled()
    {
        return $this->container['base_shipping_canceled'];
    }

    /**
     * Sets base_shipping_canceled
     *
     * @param float|null $base_shipping_canceled Base shipping canceled.
     *
     * @return self
     */
    public function setBaseShippingCanceled($base_shipping_canceled)
    {
        $this->container['base_shipping_canceled'] = $base_shipping_canceled;

        return $this;
    }

    /**
     * Gets base_shipping_discount_amount
     *
     * @return float|null
     */
    public function getBaseShippingDiscountAmount()
    {
        return $this->container['base_shipping_discount_amount'];
    }

    /**
     * Sets base_shipping_discount_amount
     *
     * @param float|null $base_shipping_discount_amount Base shipping discount amount.
     *
     * @return self
     */
    public function setBaseShippingDiscountAmount($base_shipping_discount_amount)
    {
        $this->container['base_shipping_discount_amount'] = $base_shipping_discount_amount;

        return $this;
    }

    /**
     * Gets base_shipping_discount_tax_compensation_amnt
     *
     * @return float|null
     */
    public function getBaseShippingDiscountTaxCompensationAmnt()
    {
        return $this->container['base_shipping_discount_tax_compensation_amnt'];
    }

    /**
     * Sets base_shipping_discount_tax_compensation_amnt
     *
     * @param float|null $base_shipping_discount_tax_compensation_amnt Base shipping discount tax compensation amount.
     *
     * @return self
     */
    public function setBaseShippingDiscountTaxCompensationAmnt($base_shipping_discount_tax_compensation_amnt)
    {
        $this->container['base_shipping_discount_tax_compensation_amnt'] = $base_shipping_discount_tax_compensation_amnt;

        return $this;
    }

    /**
     * Gets base_shipping_incl_tax
     *
     * @return float|null
     */
    public function getBaseShippingInclTax()
    {
        return $this->container['base_shipping_incl_tax'];
    }

    /**
     * Sets base_shipping_incl_tax
     *
     * @param float|null $base_shipping_incl_tax Base shipping including tax.
     *
     * @return self
     */
    public function setBaseShippingInclTax($base_shipping_incl_tax)
    {
        $this->container['base_shipping_incl_tax'] = $base_shipping_incl_tax;

        return $this;
    }

    /**
     * Gets base_shipping_invoiced
     *
     * @return float|null
     */
    public function getBaseShippingInvoiced()
    {
        return $this->container['base_shipping_invoiced'];
    }

    /**
     * Sets base_shipping_invoiced
     *
     * @param float|null $base_shipping_invoiced Base shipping invoiced.
     *
     * @return self
     */
    public function setBaseShippingInvoiced($base_shipping_invoiced)
    {
        $this->container['base_shipping_invoiced'] = $base_shipping_invoiced;

        return $this;
    }

    /**
     * Gets base_shipping_refunded
     *
     * @return float|null
     */
    public function getBaseShippingRefunded()
    {
        return $this->container['base_shipping_refunded'];
    }

    /**
     * Sets base_shipping_refunded
     *
     * @param float|null $base_shipping_refunded Base shipping refunded.
     *
     * @return self
     */
    public function setBaseShippingRefunded($base_shipping_refunded)
    {
        $this->container['base_shipping_refunded'] = $base_shipping_refunded;

        return $this;
    }

    /**
     * Gets base_shipping_tax_amount
     *
     * @return float|null
     */
    public function getBaseShippingTaxAmount()
    {
        return $this->container['base_shipping_tax_amount'];
    }

    /**
     * Sets base_shipping_tax_amount
     *
     * @param float|null $base_shipping_tax_amount Base shipping tax amount.
     *
     * @return self
     */
    public function setBaseShippingTaxAmount($base_shipping_tax_amount)
    {
        $this->container['base_shipping_tax_amount'] = $base_shipping_tax_amount;

        return $this;
    }

    /**
     * Gets base_shipping_tax_refunded
     *
     * @return float|null
     */
    public function getBaseShippingTaxRefunded()
    {
        return $this->container['base_shipping_tax_refunded'];
    }

    /**
     * Sets base_shipping_tax_refunded
     *
     * @param float|null $base_shipping_tax_refunded Base shipping tax refunded.
     *
     * @return self
     */
    public function setBaseShippingTaxRefunded($base_shipping_tax_refunded)
    {
        $this->container['base_shipping_tax_refunded'] = $base_shipping_tax_refunded;

        return $this;
    }

    /**
     * Gets shipping_amount
     *
     * @return float|null
     */
    public function getShippingAmount()
    {
        return $this->container['shipping_amount'];
    }

    /**
     * Sets shipping_amount
     *
     * @param float|null $shipping_amount Shipping amount.
     *
     * @return self
     */
    public function setShippingAmount($shipping_amount)
    {
        $this->container['shipping_amount'] = $shipping_amount;

        return $this;
    }

    /**
     * Gets shipping_canceled
     *
     * @return float|null
     */
    public function getShippingCanceled()
    {
        return $this->container['shipping_canceled'];
    }

    /**
     * Sets shipping_canceled
     *
     * @param float|null $shipping_canceled Shipping canceled amount.
     *
     * @return self
     */
    public function setShippingCanceled($shipping_canceled)
    {
        $this->container['shipping_canceled'] = $shipping_canceled;

        return $this;
    }

    /**
     * Gets shipping_discount_amount
     *
     * @return float|null
     */
    public function getShippingDiscountAmount()
    {
        return $this->container['shipping_discount_amount'];
    }

    /**
     * Sets shipping_discount_amount
     *
     * @param float|null $shipping_discount_amount Shipping discount amount.
     *
     * @return self
     */
    public function setShippingDiscountAmount($shipping_discount_amount)
    {
        $this->container['shipping_discount_amount'] = $shipping_discount_amount;

        return $this;
    }

    /**
     * Gets shipping_discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getShippingDiscountTaxCompensationAmount()
    {
        return $this->container['shipping_discount_tax_compensation_amount'];
    }

    /**
     * Sets shipping_discount_tax_compensation_amount
     *
     * @param float|null $shipping_discount_tax_compensation_amount Shipping discount tax compensation amount.
     *
     * @return self
     */
    public function setShippingDiscountTaxCompensationAmount($shipping_discount_tax_compensation_amount)
    {
        $this->container['shipping_discount_tax_compensation_amount'] = $shipping_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets shipping_incl_tax
     *
     * @return float|null
     */
    public function getShippingInclTax()
    {
        return $this->container['shipping_incl_tax'];
    }

    /**
     * Sets shipping_incl_tax
     *
     * @param float|null $shipping_incl_tax Shipping including tax amount.
     *
     * @return self
     */
    public function setShippingInclTax($shipping_incl_tax)
    {
        $this->container['shipping_incl_tax'] = $shipping_incl_tax;

        return $this;
    }

    /**
     * Gets shipping_invoiced
     *
     * @return float|null
     */
    public function getShippingInvoiced()
    {
        return $this->container['shipping_invoiced'];
    }

    /**
     * Sets shipping_invoiced
     *
     * @param float|null $shipping_invoiced Shipping invoiced amount.
     *
     * @return self
     */
    public function setShippingInvoiced($shipping_invoiced)
    {
        $this->container['shipping_invoiced'] = $shipping_invoiced;

        return $this;
    }

    /**
     * Gets shipping_refunded
     *
     * @return float|null
     */
    public function getShippingRefunded()
    {
        return $this->container['shipping_refunded'];
    }

    /**
     * Sets shipping_refunded
     *
     * @param float|null $shipping_refunded Shipping refunded amount.
     *
     * @return self
     */
    public function setShippingRefunded($shipping_refunded)
    {
        $this->container['shipping_refunded'] = $shipping_refunded;

        return $this;
    }

    /**
     * Gets shipping_tax_amount
     *
     * @return float|null
     */
    public function getShippingTaxAmount()
    {
        return $this->container['shipping_tax_amount'];
    }

    /**
     * Sets shipping_tax_amount
     *
     * @param float|null $shipping_tax_amount Shipping tax amount.
     *
     * @return self
     */
    public function setShippingTaxAmount($shipping_tax_amount)
    {
        $this->container['shipping_tax_amount'] = $shipping_tax_amount;

        return $this;
    }

    /**
     * Gets shipping_tax_refunded
     *
     * @return float|null
     */
    public function getShippingTaxRefunded()
    {
        return $this->container['shipping_tax_refunded'];
    }

    /**
     * Sets shipping_tax_refunded
     *
     * @param float|null $shipping_tax_refunded Shipping tax refunded amount.
     *
     * @return self
     */
    public function setShippingTaxRefunded($shipping_tax_refunded)
    {
        $this->container['shipping_tax_refunded'] = $shipping_tax_refunded;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Sales\\Api\\Data\\TotalInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


