<?php
/**
 * SalesDataShipmentInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesDataShipmentInterface Class Doc Comment
 *
 * @category Class
 * @description Shipment interface. A shipment is a delivery package that contains products. A shipment document accompanies the shipment. This document lists the products and their quantities in the delivery package.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesDataShipmentInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-data-shipment-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'billing_address_id' => 'int',
        'created_at' => 'string',
        'customer_id' => 'int',
        'email_sent' => 'int',
        'entity_id' => 'int',
        'increment_id' => 'string',
        'order_id' => 'int',
        'packages' => '\Magento2\Model\SalesDataShipmentPackageInterface[]',
        'shipment_status' => 'int',
        'shipping_address_id' => 'int',
        'shipping_label' => 'string',
        'store_id' => 'int',
        'total_qty' => 'float',
        'total_weight' => 'float',
        'updated_at' => 'string',
        'items' => '\Magento2\Model\SalesDataShipmentItemInterface[]',
        'tracks' => '\Magento2\Model\SalesDataShipmentTrackInterface[]',
        'comments' => '\Magento2\Model\SalesDataShipmentCommentInterface[]',
        'extension_attributes' => '\Magento2\Model\SalesDataShipmentExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'billing_address_id' => null,
        'created_at' => null,
        'customer_id' => null,
        'email_sent' => null,
        'entity_id' => null,
        'increment_id' => null,
        'order_id' => null,
        'packages' => null,
        'shipment_status' => null,
        'shipping_address_id' => null,
        'shipping_label' => null,
        'store_id' => null,
        'total_qty' => null,
        'total_weight' => null,
        'updated_at' => null,
        'items' => null,
        'tracks' => null,
        'comments' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'billing_address_id' => 'billing_address_id',
        'created_at' => 'created_at',
        'customer_id' => 'customer_id',
        'email_sent' => 'email_sent',
        'entity_id' => 'entity_id',
        'increment_id' => 'increment_id',
        'order_id' => 'order_id',
        'packages' => 'packages',
        'shipment_status' => 'shipment_status',
        'shipping_address_id' => 'shipping_address_id',
        'shipping_label' => 'shipping_label',
        'store_id' => 'store_id',
        'total_qty' => 'total_qty',
        'total_weight' => 'total_weight',
        'updated_at' => 'updated_at',
        'items' => 'items',
        'tracks' => 'tracks',
        'comments' => 'comments',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'billing_address_id' => 'setBillingAddressId',
        'created_at' => 'setCreatedAt',
        'customer_id' => 'setCustomerId',
        'email_sent' => 'setEmailSent',
        'entity_id' => 'setEntityId',
        'increment_id' => 'setIncrementId',
        'order_id' => 'setOrderId',
        'packages' => 'setPackages',
        'shipment_status' => 'setShipmentStatus',
        'shipping_address_id' => 'setShippingAddressId',
        'shipping_label' => 'setShippingLabel',
        'store_id' => 'setStoreId',
        'total_qty' => 'setTotalQty',
        'total_weight' => 'setTotalWeight',
        'updated_at' => 'setUpdatedAt',
        'items' => 'setItems',
        'tracks' => 'setTracks',
        'comments' => 'setComments',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'billing_address_id' => 'getBillingAddressId',
        'created_at' => 'getCreatedAt',
        'customer_id' => 'getCustomerId',
        'email_sent' => 'getEmailSent',
        'entity_id' => 'getEntityId',
        'increment_id' => 'getIncrementId',
        'order_id' => 'getOrderId',
        'packages' => 'getPackages',
        'shipment_status' => 'getShipmentStatus',
        'shipping_address_id' => 'getShippingAddressId',
        'shipping_label' => 'getShippingLabel',
        'store_id' => 'getStoreId',
        'total_qty' => 'getTotalQty',
        'total_weight' => 'getTotalWeight',
        'updated_at' => 'getUpdatedAt',
        'items' => 'getItems',
        'tracks' => 'getTracks',
        'comments' => 'getComments',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['billing_address_id'] = $data['billing_address_id'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['email_sent'] = $data['email_sent'] ?? null;
        $this->container['entity_id'] = $data['entity_id'] ?? null;
        $this->container['increment_id'] = $data['increment_id'] ?? null;
        $this->container['order_id'] = $data['order_id'] ?? null;
        $this->container['packages'] = $data['packages'] ?? null;
        $this->container['shipment_status'] = $data['shipment_status'] ?? null;
        $this->container['shipping_address_id'] = $data['shipping_address_id'] ?? null;
        $this->container['shipping_label'] = $data['shipping_label'] ?? null;
        $this->container['store_id'] = $data['store_id'] ?? null;
        $this->container['total_qty'] = $data['total_qty'] ?? null;
        $this->container['total_weight'] = $data['total_weight'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
        $this->container['tracks'] = $data['tracks'] ?? null;
        $this->container['comments'] = $data['comments'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['order_id'] === null) {
            $invalidProperties[] = "'order_id' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        if ($this->container['tracks'] === null) {
            $invalidProperties[] = "'tracks' can't be null";
        }
        if ($this->container['comments'] === null) {
            $invalidProperties[] = "'comments' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets billing_address_id
     *
     * @return int|null
     */
    public function getBillingAddressId()
    {
        return $this->container['billing_address_id'];
    }

    /**
     * Sets billing_address_id
     *
     * @param int|null $billing_address_id Billing address ID.
     *
     * @return self
     */
    public function setBillingAddressId($billing_address_id)
    {
        $this->container['billing_address_id'] = $billing_address_id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Created-at timestamp.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Customer ID.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets email_sent
     *
     * @return int|null
     */
    public function getEmailSent()
    {
        return $this->container['email_sent'];
    }

    /**
     * Sets email_sent
     *
     * @param int|null $email_sent Email-sent flag value.
     *
     * @return self
     */
    public function setEmailSent($email_sent)
    {
        $this->container['email_sent'] = $email_sent;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int|null $entity_id Shipment ID.
     *
     * @return self
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets increment_id
     *
     * @return string|null
     */
    public function getIncrementId()
    {
        return $this->container['increment_id'];
    }

    /**
     * Sets increment_id
     *
     * @param string|null $increment_id Increment ID.
     *
     * @return self
     */
    public function setIncrementId($increment_id)
    {
        $this->container['increment_id'] = $increment_id;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int $order_id Order ID.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets packages
     *
     * @return \Magento2\Model\SalesDataShipmentPackageInterface[]|null
     */
    public function getPackages()
    {
        return $this->container['packages'];
    }

    /**
     * Sets packages
     *
     * @param \Magento2\Model\SalesDataShipmentPackageInterface[]|null $packages Array of packages, if any. Otherwise, null.
     *
     * @return self
     */
    public function setPackages($packages)
    {
        $this->container['packages'] = $packages;

        return $this;
    }

    /**
     * Gets shipment_status
     *
     * @return int|null
     */
    public function getShipmentStatus()
    {
        return $this->container['shipment_status'];
    }

    /**
     * Sets shipment_status
     *
     * @param int|null $shipment_status Shipment status.
     *
     * @return self
     */
    public function setShipmentStatus($shipment_status)
    {
        $this->container['shipment_status'] = $shipment_status;

        return $this;
    }

    /**
     * Gets shipping_address_id
     *
     * @return int|null
     */
    public function getShippingAddressId()
    {
        return $this->container['shipping_address_id'];
    }

    /**
     * Sets shipping_address_id
     *
     * @param int|null $shipping_address_id Shipping address ID.
     *
     * @return self
     */
    public function setShippingAddressId($shipping_address_id)
    {
        $this->container['shipping_address_id'] = $shipping_address_id;

        return $this;
    }

    /**
     * Gets shipping_label
     *
     * @return string|null
     */
    public function getShippingLabel()
    {
        return $this->container['shipping_label'];
    }

    /**
     * Sets shipping_label
     *
     * @param string|null $shipping_label Shipping label.
     *
     * @return self
     */
    public function setShippingLabel($shipping_label)
    {
        $this->container['shipping_label'] = $shipping_label;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int|null
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int|null $store_id Store ID.
     *
     * @return self
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets total_qty
     *
     * @return float|null
     */
    public function getTotalQty()
    {
        return $this->container['total_qty'];
    }

    /**
     * Sets total_qty
     *
     * @param float|null $total_qty Total quantity.
     *
     * @return self
     */
    public function setTotalQty($total_qty)
    {
        $this->container['total_qty'] = $total_qty;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight Total weight.
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Updated-at timestamp.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Magento2\Model\SalesDataShipmentItemInterface[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Magento2\Model\SalesDataShipmentItemInterface[] $items Array of items.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets tracks
     *
     * @return \Magento2\Model\SalesDataShipmentTrackInterface[]
     */
    public function getTracks()
    {
        return $this->container['tracks'];
    }

    /**
     * Sets tracks
     *
     * @param \Magento2\Model\SalesDataShipmentTrackInterface[] $tracks Array of tracks.
     *
     * @return self
     */
    public function setTracks($tracks)
    {
        $this->container['tracks'] = $tracks;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return \Magento2\Model\SalesDataShipmentCommentInterface[]
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param \Magento2\Model\SalesDataShipmentCommentInterface[] $comments Array of comments.
     *
     * @return self
     */
    public function setComments($comments)
    {
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Magento2\Model\SalesDataShipmentExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Magento2\Model\SalesDataShipmentExtensionInterface|null $extension_attributes extension_attributes
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


