<?php
/**
 * SalesDataOrderPaymentInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesDataOrderPaymentInterface Class Doc Comment
 *
 * @category Class
 * @description Order payment interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesDataOrderPaymentInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-data-order-payment-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'account_status' => 'string',
        'additional_data' => 'string',
        'additional_information' => 'string[]',
        'address_status' => 'string',
        'amount_authorized' => 'float',
        'amount_canceled' => 'float',
        'amount_ordered' => 'float',
        'amount_paid' => 'float',
        'amount_refunded' => 'float',
        'anet_trans_method' => 'string',
        'base_amount_authorized' => 'float',
        'base_amount_canceled' => 'float',
        'base_amount_ordered' => 'float',
        'base_amount_paid' => 'float',
        'base_amount_paid_online' => 'float',
        'base_amount_refunded' => 'float',
        'base_amount_refunded_online' => 'float',
        'base_shipping_amount' => 'float',
        'base_shipping_captured' => 'float',
        'base_shipping_refunded' => 'float',
        'cc_approval' => 'string',
        'cc_avs_status' => 'string',
        'cc_cid_status' => 'string',
        'cc_debug_request_body' => 'string',
        'cc_debug_response_body' => 'string',
        'cc_debug_response_serialized' => 'string',
        'cc_exp_month' => 'string',
        'cc_exp_year' => 'string',
        'cc_last4' => 'string',
        'cc_number_enc' => 'string',
        'cc_owner' => 'string',
        'cc_secure_verify' => 'string',
        'cc_ss_issue' => 'string',
        'cc_ss_start_month' => 'string',
        'cc_ss_start_year' => 'string',
        'cc_status' => 'string',
        'cc_status_description' => 'string',
        'cc_trans_id' => 'string',
        'cc_type' => 'string',
        'echeck_account_name' => 'string',
        'echeck_account_type' => 'string',
        'echeck_bank_name' => 'string',
        'echeck_routing_number' => 'string',
        'echeck_type' => 'string',
        'entity_id' => 'int',
        'last_trans_id' => 'string',
        'method' => 'string',
        'parent_id' => 'int',
        'po_number' => 'string',
        'protection_eligibility' => 'string',
        'quote_payment_id' => 'int',
        'shipping_amount' => 'float',
        'shipping_captured' => 'float',
        'shipping_refunded' => 'float',
        'extension_attributes' => '\Magento2\Model\SalesDataOrderPaymentExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'account_status' => null,
        'additional_data' => null,
        'additional_information' => null,
        'address_status' => null,
        'amount_authorized' => null,
        'amount_canceled' => null,
        'amount_ordered' => null,
        'amount_paid' => null,
        'amount_refunded' => null,
        'anet_trans_method' => null,
        'base_amount_authorized' => null,
        'base_amount_canceled' => null,
        'base_amount_ordered' => null,
        'base_amount_paid' => null,
        'base_amount_paid_online' => null,
        'base_amount_refunded' => null,
        'base_amount_refunded_online' => null,
        'base_shipping_amount' => null,
        'base_shipping_captured' => null,
        'base_shipping_refunded' => null,
        'cc_approval' => null,
        'cc_avs_status' => null,
        'cc_cid_status' => null,
        'cc_debug_request_body' => null,
        'cc_debug_response_body' => null,
        'cc_debug_response_serialized' => null,
        'cc_exp_month' => null,
        'cc_exp_year' => null,
        'cc_last4' => null,
        'cc_number_enc' => null,
        'cc_owner' => null,
        'cc_secure_verify' => null,
        'cc_ss_issue' => null,
        'cc_ss_start_month' => null,
        'cc_ss_start_year' => null,
        'cc_status' => null,
        'cc_status_description' => null,
        'cc_trans_id' => null,
        'cc_type' => null,
        'echeck_account_name' => null,
        'echeck_account_type' => null,
        'echeck_bank_name' => null,
        'echeck_routing_number' => null,
        'echeck_type' => null,
        'entity_id' => null,
        'last_trans_id' => null,
        'method' => null,
        'parent_id' => null,
        'po_number' => null,
        'protection_eligibility' => null,
        'quote_payment_id' => null,
        'shipping_amount' => null,
        'shipping_captured' => null,
        'shipping_refunded' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'account_status' => 'account_status',
        'additional_data' => 'additional_data',
        'additional_information' => 'additional_information',
        'address_status' => 'address_status',
        'amount_authorized' => 'amount_authorized',
        'amount_canceled' => 'amount_canceled',
        'amount_ordered' => 'amount_ordered',
        'amount_paid' => 'amount_paid',
        'amount_refunded' => 'amount_refunded',
        'anet_trans_method' => 'anet_trans_method',
        'base_amount_authorized' => 'base_amount_authorized',
        'base_amount_canceled' => 'base_amount_canceled',
        'base_amount_ordered' => 'base_amount_ordered',
        'base_amount_paid' => 'base_amount_paid',
        'base_amount_paid_online' => 'base_amount_paid_online',
        'base_amount_refunded' => 'base_amount_refunded',
        'base_amount_refunded_online' => 'base_amount_refunded_online',
        'base_shipping_amount' => 'base_shipping_amount',
        'base_shipping_captured' => 'base_shipping_captured',
        'base_shipping_refunded' => 'base_shipping_refunded',
        'cc_approval' => 'cc_approval',
        'cc_avs_status' => 'cc_avs_status',
        'cc_cid_status' => 'cc_cid_status',
        'cc_debug_request_body' => 'cc_debug_request_body',
        'cc_debug_response_body' => 'cc_debug_response_body',
        'cc_debug_response_serialized' => 'cc_debug_response_serialized',
        'cc_exp_month' => 'cc_exp_month',
        'cc_exp_year' => 'cc_exp_year',
        'cc_last4' => 'cc_last4',
        'cc_number_enc' => 'cc_number_enc',
        'cc_owner' => 'cc_owner',
        'cc_secure_verify' => 'cc_secure_verify',
        'cc_ss_issue' => 'cc_ss_issue',
        'cc_ss_start_month' => 'cc_ss_start_month',
        'cc_ss_start_year' => 'cc_ss_start_year',
        'cc_status' => 'cc_status',
        'cc_status_description' => 'cc_status_description',
        'cc_trans_id' => 'cc_trans_id',
        'cc_type' => 'cc_type',
        'echeck_account_name' => 'echeck_account_name',
        'echeck_account_type' => 'echeck_account_type',
        'echeck_bank_name' => 'echeck_bank_name',
        'echeck_routing_number' => 'echeck_routing_number',
        'echeck_type' => 'echeck_type',
        'entity_id' => 'entity_id',
        'last_trans_id' => 'last_trans_id',
        'method' => 'method',
        'parent_id' => 'parent_id',
        'po_number' => 'po_number',
        'protection_eligibility' => 'protection_eligibility',
        'quote_payment_id' => 'quote_payment_id',
        'shipping_amount' => 'shipping_amount',
        'shipping_captured' => 'shipping_captured',
        'shipping_refunded' => 'shipping_refunded',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'account_status' => 'setAccountStatus',
        'additional_data' => 'setAdditionalData',
        'additional_information' => 'setAdditionalInformation',
        'address_status' => 'setAddressStatus',
        'amount_authorized' => 'setAmountAuthorized',
        'amount_canceled' => 'setAmountCanceled',
        'amount_ordered' => 'setAmountOrdered',
        'amount_paid' => 'setAmountPaid',
        'amount_refunded' => 'setAmountRefunded',
        'anet_trans_method' => 'setAnetTransMethod',
        'base_amount_authorized' => 'setBaseAmountAuthorized',
        'base_amount_canceled' => 'setBaseAmountCanceled',
        'base_amount_ordered' => 'setBaseAmountOrdered',
        'base_amount_paid' => 'setBaseAmountPaid',
        'base_amount_paid_online' => 'setBaseAmountPaidOnline',
        'base_amount_refunded' => 'setBaseAmountRefunded',
        'base_amount_refunded_online' => 'setBaseAmountRefundedOnline',
        'base_shipping_amount' => 'setBaseShippingAmount',
        'base_shipping_captured' => 'setBaseShippingCaptured',
        'base_shipping_refunded' => 'setBaseShippingRefunded',
        'cc_approval' => 'setCcApproval',
        'cc_avs_status' => 'setCcAvsStatus',
        'cc_cid_status' => 'setCcCidStatus',
        'cc_debug_request_body' => 'setCcDebugRequestBody',
        'cc_debug_response_body' => 'setCcDebugResponseBody',
        'cc_debug_response_serialized' => 'setCcDebugResponseSerialized',
        'cc_exp_month' => 'setCcExpMonth',
        'cc_exp_year' => 'setCcExpYear',
        'cc_last4' => 'setCcLast4',
        'cc_number_enc' => 'setCcNumberEnc',
        'cc_owner' => 'setCcOwner',
        'cc_secure_verify' => 'setCcSecureVerify',
        'cc_ss_issue' => 'setCcSsIssue',
        'cc_ss_start_month' => 'setCcSsStartMonth',
        'cc_ss_start_year' => 'setCcSsStartYear',
        'cc_status' => 'setCcStatus',
        'cc_status_description' => 'setCcStatusDescription',
        'cc_trans_id' => 'setCcTransId',
        'cc_type' => 'setCcType',
        'echeck_account_name' => 'setEcheckAccountName',
        'echeck_account_type' => 'setEcheckAccountType',
        'echeck_bank_name' => 'setEcheckBankName',
        'echeck_routing_number' => 'setEcheckRoutingNumber',
        'echeck_type' => 'setEcheckType',
        'entity_id' => 'setEntityId',
        'last_trans_id' => 'setLastTransId',
        'method' => 'setMethod',
        'parent_id' => 'setParentId',
        'po_number' => 'setPoNumber',
        'protection_eligibility' => 'setProtectionEligibility',
        'quote_payment_id' => 'setQuotePaymentId',
        'shipping_amount' => 'setShippingAmount',
        'shipping_captured' => 'setShippingCaptured',
        'shipping_refunded' => 'setShippingRefunded',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'account_status' => 'getAccountStatus',
        'additional_data' => 'getAdditionalData',
        'additional_information' => 'getAdditionalInformation',
        'address_status' => 'getAddressStatus',
        'amount_authorized' => 'getAmountAuthorized',
        'amount_canceled' => 'getAmountCanceled',
        'amount_ordered' => 'getAmountOrdered',
        'amount_paid' => 'getAmountPaid',
        'amount_refunded' => 'getAmountRefunded',
        'anet_trans_method' => 'getAnetTransMethod',
        'base_amount_authorized' => 'getBaseAmountAuthorized',
        'base_amount_canceled' => 'getBaseAmountCanceled',
        'base_amount_ordered' => 'getBaseAmountOrdered',
        'base_amount_paid' => 'getBaseAmountPaid',
        'base_amount_paid_online' => 'getBaseAmountPaidOnline',
        'base_amount_refunded' => 'getBaseAmountRefunded',
        'base_amount_refunded_online' => 'getBaseAmountRefundedOnline',
        'base_shipping_amount' => 'getBaseShippingAmount',
        'base_shipping_captured' => 'getBaseShippingCaptured',
        'base_shipping_refunded' => 'getBaseShippingRefunded',
        'cc_approval' => 'getCcApproval',
        'cc_avs_status' => 'getCcAvsStatus',
        'cc_cid_status' => 'getCcCidStatus',
        'cc_debug_request_body' => 'getCcDebugRequestBody',
        'cc_debug_response_body' => 'getCcDebugResponseBody',
        'cc_debug_response_serialized' => 'getCcDebugResponseSerialized',
        'cc_exp_month' => 'getCcExpMonth',
        'cc_exp_year' => 'getCcExpYear',
        'cc_last4' => 'getCcLast4',
        'cc_number_enc' => 'getCcNumberEnc',
        'cc_owner' => 'getCcOwner',
        'cc_secure_verify' => 'getCcSecureVerify',
        'cc_ss_issue' => 'getCcSsIssue',
        'cc_ss_start_month' => 'getCcSsStartMonth',
        'cc_ss_start_year' => 'getCcSsStartYear',
        'cc_status' => 'getCcStatus',
        'cc_status_description' => 'getCcStatusDescription',
        'cc_trans_id' => 'getCcTransId',
        'cc_type' => 'getCcType',
        'echeck_account_name' => 'getEcheckAccountName',
        'echeck_account_type' => 'getEcheckAccountType',
        'echeck_bank_name' => 'getEcheckBankName',
        'echeck_routing_number' => 'getEcheckRoutingNumber',
        'echeck_type' => 'getEcheckType',
        'entity_id' => 'getEntityId',
        'last_trans_id' => 'getLastTransId',
        'method' => 'getMethod',
        'parent_id' => 'getParentId',
        'po_number' => 'getPoNumber',
        'protection_eligibility' => 'getProtectionEligibility',
        'quote_payment_id' => 'getQuotePaymentId',
        'shipping_amount' => 'getShippingAmount',
        'shipping_captured' => 'getShippingCaptured',
        'shipping_refunded' => 'getShippingRefunded',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['account_status'] = $data['account_status'] ?? null;
        $this->container['additional_data'] = $data['additional_data'] ?? null;
        $this->container['additional_information'] = $data['additional_information'] ?? null;
        $this->container['address_status'] = $data['address_status'] ?? null;
        $this->container['amount_authorized'] = $data['amount_authorized'] ?? null;
        $this->container['amount_canceled'] = $data['amount_canceled'] ?? null;
        $this->container['amount_ordered'] = $data['amount_ordered'] ?? null;
        $this->container['amount_paid'] = $data['amount_paid'] ?? null;
        $this->container['amount_refunded'] = $data['amount_refunded'] ?? null;
        $this->container['anet_trans_method'] = $data['anet_trans_method'] ?? null;
        $this->container['base_amount_authorized'] = $data['base_amount_authorized'] ?? null;
        $this->container['base_amount_canceled'] = $data['base_amount_canceled'] ?? null;
        $this->container['base_amount_ordered'] = $data['base_amount_ordered'] ?? null;
        $this->container['base_amount_paid'] = $data['base_amount_paid'] ?? null;
        $this->container['base_amount_paid_online'] = $data['base_amount_paid_online'] ?? null;
        $this->container['base_amount_refunded'] = $data['base_amount_refunded'] ?? null;
        $this->container['base_amount_refunded_online'] = $data['base_amount_refunded_online'] ?? null;
        $this->container['base_shipping_amount'] = $data['base_shipping_amount'] ?? null;
        $this->container['base_shipping_captured'] = $data['base_shipping_captured'] ?? null;
        $this->container['base_shipping_refunded'] = $data['base_shipping_refunded'] ?? null;
        $this->container['cc_approval'] = $data['cc_approval'] ?? null;
        $this->container['cc_avs_status'] = $data['cc_avs_status'] ?? null;
        $this->container['cc_cid_status'] = $data['cc_cid_status'] ?? null;
        $this->container['cc_debug_request_body'] = $data['cc_debug_request_body'] ?? null;
        $this->container['cc_debug_response_body'] = $data['cc_debug_response_body'] ?? null;
        $this->container['cc_debug_response_serialized'] = $data['cc_debug_response_serialized'] ?? null;
        $this->container['cc_exp_month'] = $data['cc_exp_month'] ?? null;
        $this->container['cc_exp_year'] = $data['cc_exp_year'] ?? null;
        $this->container['cc_last4'] = $data['cc_last4'] ?? null;
        $this->container['cc_number_enc'] = $data['cc_number_enc'] ?? null;
        $this->container['cc_owner'] = $data['cc_owner'] ?? null;
        $this->container['cc_secure_verify'] = $data['cc_secure_verify'] ?? null;
        $this->container['cc_ss_issue'] = $data['cc_ss_issue'] ?? null;
        $this->container['cc_ss_start_month'] = $data['cc_ss_start_month'] ?? null;
        $this->container['cc_ss_start_year'] = $data['cc_ss_start_year'] ?? null;
        $this->container['cc_status'] = $data['cc_status'] ?? null;
        $this->container['cc_status_description'] = $data['cc_status_description'] ?? null;
        $this->container['cc_trans_id'] = $data['cc_trans_id'] ?? null;
        $this->container['cc_type'] = $data['cc_type'] ?? null;
        $this->container['echeck_account_name'] = $data['echeck_account_name'] ?? null;
        $this->container['echeck_account_type'] = $data['echeck_account_type'] ?? null;
        $this->container['echeck_bank_name'] = $data['echeck_bank_name'] ?? null;
        $this->container['echeck_routing_number'] = $data['echeck_routing_number'] ?? null;
        $this->container['echeck_type'] = $data['echeck_type'] ?? null;
        $this->container['entity_id'] = $data['entity_id'] ?? null;
        $this->container['last_trans_id'] = $data['last_trans_id'] ?? null;
        $this->container['method'] = $data['method'] ?? null;
        $this->container['parent_id'] = $data['parent_id'] ?? null;
        $this->container['po_number'] = $data['po_number'] ?? null;
        $this->container['protection_eligibility'] = $data['protection_eligibility'] ?? null;
        $this->container['quote_payment_id'] = $data['quote_payment_id'] ?? null;
        $this->container['shipping_amount'] = $data['shipping_amount'] ?? null;
        $this->container['shipping_captured'] = $data['shipping_captured'] ?? null;
        $this->container['shipping_refunded'] = $data['shipping_refunded'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['account_status'] === null) {
            $invalidProperties[] = "'account_status' can't be null";
        }
        if ($this->container['additional_information'] === null) {
            $invalidProperties[] = "'additional_information' can't be null";
        }
        if ($this->container['cc_last4'] === null) {
            $invalidProperties[] = "'cc_last4' can't be null";
        }
        if ($this->container['method'] === null) {
            $invalidProperties[] = "'method' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets account_status
     *
     * @return string
     */
    public function getAccountStatus()
    {
        return $this->container['account_status'];
    }

    /**
     * Sets account_status
     *
     * @param string $account_status Account status.
     *
     * @return self
     */
    public function setAccountStatus($account_status)
    {
        $this->container['account_status'] = $account_status;

        return $this;
    }

    /**
     * Gets additional_data
     *
     * @return string|null
     */
    public function getAdditionalData()
    {
        return $this->container['additional_data'];
    }

    /**
     * Sets additional_data
     *
     * @param string|null $additional_data Additional data.
     *
     * @return self
     */
    public function setAdditionalData($additional_data)
    {
        $this->container['additional_data'] = $additional_data;

        return $this;
    }

    /**
     * Gets additional_information
     *
     * @return string[]
     */
    public function getAdditionalInformation()
    {
        return $this->container['additional_information'];
    }

    /**
     * Sets additional_information
     *
     * @param string[] $additional_information Array of additional information.
     *
     * @return self
     */
    public function setAdditionalInformation($additional_information)
    {
        $this->container['additional_information'] = $additional_information;

        return $this;
    }

    /**
     * Gets address_status
     *
     * @return string|null
     */
    public function getAddressStatus()
    {
        return $this->container['address_status'];
    }

    /**
     * Sets address_status
     *
     * @param string|null $address_status Address status.
     *
     * @return self
     */
    public function setAddressStatus($address_status)
    {
        $this->container['address_status'] = $address_status;

        return $this;
    }

    /**
     * Gets amount_authorized
     *
     * @return float|null
     */
    public function getAmountAuthorized()
    {
        return $this->container['amount_authorized'];
    }

    /**
     * Sets amount_authorized
     *
     * @param float|null $amount_authorized Amount authorized.
     *
     * @return self
     */
    public function setAmountAuthorized($amount_authorized)
    {
        $this->container['amount_authorized'] = $amount_authorized;

        return $this;
    }

    /**
     * Gets amount_canceled
     *
     * @return float|null
     */
    public function getAmountCanceled()
    {
        return $this->container['amount_canceled'];
    }

    /**
     * Sets amount_canceled
     *
     * @param float|null $amount_canceled Amount canceled.
     *
     * @return self
     */
    public function setAmountCanceled($amount_canceled)
    {
        $this->container['amount_canceled'] = $amount_canceled;

        return $this;
    }

    /**
     * Gets amount_ordered
     *
     * @return float|null
     */
    public function getAmountOrdered()
    {
        return $this->container['amount_ordered'];
    }

    /**
     * Sets amount_ordered
     *
     * @param float|null $amount_ordered Amount ordered.
     *
     * @return self
     */
    public function setAmountOrdered($amount_ordered)
    {
        $this->container['amount_ordered'] = $amount_ordered;

        return $this;
    }

    /**
     * Gets amount_paid
     *
     * @return float|null
     */
    public function getAmountPaid()
    {
        return $this->container['amount_paid'];
    }

    /**
     * Sets amount_paid
     *
     * @param float|null $amount_paid Amount paid.
     *
     * @return self
     */
    public function setAmountPaid($amount_paid)
    {
        $this->container['amount_paid'] = $amount_paid;

        return $this;
    }

    /**
     * Gets amount_refunded
     *
     * @return float|null
     */
    public function getAmountRefunded()
    {
        return $this->container['amount_refunded'];
    }

    /**
     * Sets amount_refunded
     *
     * @param float|null $amount_refunded Amount refunded.
     *
     * @return self
     */
    public function setAmountRefunded($amount_refunded)
    {
        $this->container['amount_refunded'] = $amount_refunded;

        return $this;
    }

    /**
     * Gets anet_trans_method
     *
     * @return string|null
     */
    public function getAnetTransMethod()
    {
        return $this->container['anet_trans_method'];
    }

    /**
     * Sets anet_trans_method
     *
     * @param string|null $anet_trans_method Anet transaction method.
     *
     * @return self
     */
    public function setAnetTransMethod($anet_trans_method)
    {
        $this->container['anet_trans_method'] = $anet_trans_method;

        return $this;
    }

    /**
     * Gets base_amount_authorized
     *
     * @return float|null
     */
    public function getBaseAmountAuthorized()
    {
        return $this->container['base_amount_authorized'];
    }

    /**
     * Sets base_amount_authorized
     *
     * @param float|null $base_amount_authorized Base amount authorized.
     *
     * @return self
     */
    public function setBaseAmountAuthorized($base_amount_authorized)
    {
        $this->container['base_amount_authorized'] = $base_amount_authorized;

        return $this;
    }

    /**
     * Gets base_amount_canceled
     *
     * @return float|null
     */
    public function getBaseAmountCanceled()
    {
        return $this->container['base_amount_canceled'];
    }

    /**
     * Sets base_amount_canceled
     *
     * @param float|null $base_amount_canceled Base amount canceled.
     *
     * @return self
     */
    public function setBaseAmountCanceled($base_amount_canceled)
    {
        $this->container['base_amount_canceled'] = $base_amount_canceled;

        return $this;
    }

    /**
     * Gets base_amount_ordered
     *
     * @return float|null
     */
    public function getBaseAmountOrdered()
    {
        return $this->container['base_amount_ordered'];
    }

    /**
     * Sets base_amount_ordered
     *
     * @param float|null $base_amount_ordered Base amount ordered.
     *
     * @return self
     */
    public function setBaseAmountOrdered($base_amount_ordered)
    {
        $this->container['base_amount_ordered'] = $base_amount_ordered;

        return $this;
    }

    /**
     * Gets base_amount_paid
     *
     * @return float|null
     */
    public function getBaseAmountPaid()
    {
        return $this->container['base_amount_paid'];
    }

    /**
     * Sets base_amount_paid
     *
     * @param float|null $base_amount_paid Base amount paid.
     *
     * @return self
     */
    public function setBaseAmountPaid($base_amount_paid)
    {
        $this->container['base_amount_paid'] = $base_amount_paid;

        return $this;
    }

    /**
     * Gets base_amount_paid_online
     *
     * @return float|null
     */
    public function getBaseAmountPaidOnline()
    {
        return $this->container['base_amount_paid_online'];
    }

    /**
     * Sets base_amount_paid_online
     *
     * @param float|null $base_amount_paid_online Base amount paid online.
     *
     * @return self
     */
    public function setBaseAmountPaidOnline($base_amount_paid_online)
    {
        $this->container['base_amount_paid_online'] = $base_amount_paid_online;

        return $this;
    }

    /**
     * Gets base_amount_refunded
     *
     * @return float|null
     */
    public function getBaseAmountRefunded()
    {
        return $this->container['base_amount_refunded'];
    }

    /**
     * Sets base_amount_refunded
     *
     * @param float|null $base_amount_refunded Base amount refunded.
     *
     * @return self
     */
    public function setBaseAmountRefunded($base_amount_refunded)
    {
        $this->container['base_amount_refunded'] = $base_amount_refunded;

        return $this;
    }

    /**
     * Gets base_amount_refunded_online
     *
     * @return float|null
     */
    public function getBaseAmountRefundedOnline()
    {
        return $this->container['base_amount_refunded_online'];
    }

    /**
     * Sets base_amount_refunded_online
     *
     * @param float|null $base_amount_refunded_online Base amount refunded online.
     *
     * @return self
     */
    public function setBaseAmountRefundedOnline($base_amount_refunded_online)
    {
        $this->container['base_amount_refunded_online'] = $base_amount_refunded_online;

        return $this;
    }

    /**
     * Gets base_shipping_amount
     *
     * @return float|null
     */
    public function getBaseShippingAmount()
    {
        return $this->container['base_shipping_amount'];
    }

    /**
     * Sets base_shipping_amount
     *
     * @param float|null $base_shipping_amount Base shipping amount.
     *
     * @return self
     */
    public function setBaseShippingAmount($base_shipping_amount)
    {
        $this->container['base_shipping_amount'] = $base_shipping_amount;

        return $this;
    }

    /**
     * Gets base_shipping_captured
     *
     * @return float|null
     */
    public function getBaseShippingCaptured()
    {
        return $this->container['base_shipping_captured'];
    }

    /**
     * Sets base_shipping_captured
     *
     * @param float|null $base_shipping_captured Base shipping captured amount.
     *
     * @return self
     */
    public function setBaseShippingCaptured($base_shipping_captured)
    {
        $this->container['base_shipping_captured'] = $base_shipping_captured;

        return $this;
    }

    /**
     * Gets base_shipping_refunded
     *
     * @return float|null
     */
    public function getBaseShippingRefunded()
    {
        return $this->container['base_shipping_refunded'];
    }

    /**
     * Sets base_shipping_refunded
     *
     * @param float|null $base_shipping_refunded Base shipping refunded amount.
     *
     * @return self
     */
    public function setBaseShippingRefunded($base_shipping_refunded)
    {
        $this->container['base_shipping_refunded'] = $base_shipping_refunded;

        return $this;
    }

    /**
     * Gets cc_approval
     *
     * @return string|null
     */
    public function getCcApproval()
    {
        return $this->container['cc_approval'];
    }

    /**
     * Sets cc_approval
     *
     * @param string|null $cc_approval Credit card approval.
     *
     * @return self
     */
    public function setCcApproval($cc_approval)
    {
        $this->container['cc_approval'] = $cc_approval;

        return $this;
    }

    /**
     * Gets cc_avs_status
     *
     * @return string|null
     */
    public function getCcAvsStatus()
    {
        return $this->container['cc_avs_status'];
    }

    /**
     * Sets cc_avs_status
     *
     * @param string|null $cc_avs_status Credit card avs status.
     *
     * @return self
     */
    public function setCcAvsStatus($cc_avs_status)
    {
        $this->container['cc_avs_status'] = $cc_avs_status;

        return $this;
    }

    /**
     * Gets cc_cid_status
     *
     * @return string|null
     */
    public function getCcCidStatus()
    {
        return $this->container['cc_cid_status'];
    }

    /**
     * Sets cc_cid_status
     *
     * @param string|null $cc_cid_status Credit card CID status.
     *
     * @return self
     */
    public function setCcCidStatus($cc_cid_status)
    {
        $this->container['cc_cid_status'] = $cc_cid_status;

        return $this;
    }

    /**
     * Gets cc_debug_request_body
     *
     * @return string|null
     */
    public function getCcDebugRequestBody()
    {
        return $this->container['cc_debug_request_body'];
    }

    /**
     * Sets cc_debug_request_body
     *
     * @param string|null $cc_debug_request_body Credit card debug request body.
     *
     * @return self
     */
    public function setCcDebugRequestBody($cc_debug_request_body)
    {
        $this->container['cc_debug_request_body'] = $cc_debug_request_body;

        return $this;
    }

    /**
     * Gets cc_debug_response_body
     *
     * @return string|null
     */
    public function getCcDebugResponseBody()
    {
        return $this->container['cc_debug_response_body'];
    }

    /**
     * Sets cc_debug_response_body
     *
     * @param string|null $cc_debug_response_body Credit card debug response body.
     *
     * @return self
     */
    public function setCcDebugResponseBody($cc_debug_response_body)
    {
        $this->container['cc_debug_response_body'] = $cc_debug_response_body;

        return $this;
    }

    /**
     * Gets cc_debug_response_serialized
     *
     * @return string|null
     */
    public function getCcDebugResponseSerialized()
    {
        return $this->container['cc_debug_response_serialized'];
    }

    /**
     * Sets cc_debug_response_serialized
     *
     * @param string|null $cc_debug_response_serialized Credit card debug response serialized.
     *
     * @return self
     */
    public function setCcDebugResponseSerialized($cc_debug_response_serialized)
    {
        $this->container['cc_debug_response_serialized'] = $cc_debug_response_serialized;

        return $this;
    }

    /**
     * Gets cc_exp_month
     *
     * @return string|null
     */
    public function getCcExpMonth()
    {
        return $this->container['cc_exp_month'];
    }

    /**
     * Sets cc_exp_month
     *
     * @param string|null $cc_exp_month Credit card expiration month.
     *
     * @return self
     */
    public function setCcExpMonth($cc_exp_month)
    {
        $this->container['cc_exp_month'] = $cc_exp_month;

        return $this;
    }

    /**
     * Gets cc_exp_year
     *
     * @return string|null
     */
    public function getCcExpYear()
    {
        return $this->container['cc_exp_year'];
    }

    /**
     * Sets cc_exp_year
     *
     * @param string|null $cc_exp_year Credit card expiration year.
     *
     * @return self
     */
    public function setCcExpYear($cc_exp_year)
    {
        $this->container['cc_exp_year'] = $cc_exp_year;

        return $this;
    }

    /**
     * Gets cc_last4
     *
     * @return string
     */
    public function getCcLast4()
    {
        return $this->container['cc_last4'];
    }

    /**
     * Sets cc_last4
     *
     * @param string $cc_last4 Last four digits of the credit card.
     *
     * @return self
     */
    public function setCcLast4($cc_last4)
    {
        $this->container['cc_last4'] = $cc_last4;

        return $this;
    }

    /**
     * Gets cc_number_enc
     *
     * @return string|null
     */
    public function getCcNumberEnc()
    {
        return $this->container['cc_number_enc'];
    }

    /**
     * Sets cc_number_enc
     *
     * @param string|null $cc_number_enc Encrypted credit card number.
     *
     * @return self
     */
    public function setCcNumberEnc($cc_number_enc)
    {
        $this->container['cc_number_enc'] = $cc_number_enc;

        return $this;
    }

    /**
     * Gets cc_owner
     *
     * @return string|null
     */
    public function getCcOwner()
    {
        return $this->container['cc_owner'];
    }

    /**
     * Sets cc_owner
     *
     * @param string|null $cc_owner Credit card number.
     *
     * @return self
     */
    public function setCcOwner($cc_owner)
    {
        $this->container['cc_owner'] = $cc_owner;

        return $this;
    }

    /**
     * Gets cc_secure_verify
     *
     * @return string|null
     */
    public function getCcSecureVerify()
    {
        return $this->container['cc_secure_verify'];
    }

    /**
     * Sets cc_secure_verify
     *
     * @param string|null $cc_secure_verify Credit card secure verify.
     *
     * @return self
     */
    public function setCcSecureVerify($cc_secure_verify)
    {
        $this->container['cc_secure_verify'] = $cc_secure_verify;

        return $this;
    }

    /**
     * Gets cc_ss_issue
     *
     * @return string|null
     */
    public function getCcSsIssue()
    {
        return $this->container['cc_ss_issue'];
    }

    /**
     * Sets cc_ss_issue
     *
     * @param string|null $cc_ss_issue Credit card SS issue.
     *
     * @return self
     */
    public function setCcSsIssue($cc_ss_issue)
    {
        $this->container['cc_ss_issue'] = $cc_ss_issue;

        return $this;
    }

    /**
     * Gets cc_ss_start_month
     *
     * @return string|null
     */
    public function getCcSsStartMonth()
    {
        return $this->container['cc_ss_start_month'];
    }

    /**
     * Sets cc_ss_start_month
     *
     * @param string|null $cc_ss_start_month Credit card SS start month.
     *
     * @return self
     */
    public function setCcSsStartMonth($cc_ss_start_month)
    {
        $this->container['cc_ss_start_month'] = $cc_ss_start_month;

        return $this;
    }

    /**
     * Gets cc_ss_start_year
     *
     * @return string|null
     */
    public function getCcSsStartYear()
    {
        return $this->container['cc_ss_start_year'];
    }

    /**
     * Sets cc_ss_start_year
     *
     * @param string|null $cc_ss_start_year Credit card SS start year.
     *
     * @return self
     */
    public function setCcSsStartYear($cc_ss_start_year)
    {
        $this->container['cc_ss_start_year'] = $cc_ss_start_year;

        return $this;
    }

    /**
     * Gets cc_status
     *
     * @return string|null
     */
    public function getCcStatus()
    {
        return $this->container['cc_status'];
    }

    /**
     * Sets cc_status
     *
     * @param string|null $cc_status Credit card status.
     *
     * @return self
     */
    public function setCcStatus($cc_status)
    {
        $this->container['cc_status'] = $cc_status;

        return $this;
    }

    /**
     * Gets cc_status_description
     *
     * @return string|null
     */
    public function getCcStatusDescription()
    {
        return $this->container['cc_status_description'];
    }

    /**
     * Sets cc_status_description
     *
     * @param string|null $cc_status_description Credit card status description.
     *
     * @return self
     */
    public function setCcStatusDescription($cc_status_description)
    {
        $this->container['cc_status_description'] = $cc_status_description;

        return $this;
    }

    /**
     * Gets cc_trans_id
     *
     * @return string|null
     */
    public function getCcTransId()
    {
        return $this->container['cc_trans_id'];
    }

    /**
     * Sets cc_trans_id
     *
     * @param string|null $cc_trans_id Credit card transaction ID.
     *
     * @return self
     */
    public function setCcTransId($cc_trans_id)
    {
        $this->container['cc_trans_id'] = $cc_trans_id;

        return $this;
    }

    /**
     * Gets cc_type
     *
     * @return string|null
     */
    public function getCcType()
    {
        return $this->container['cc_type'];
    }

    /**
     * Sets cc_type
     *
     * @param string|null $cc_type Credit card type.
     *
     * @return self
     */
    public function setCcType($cc_type)
    {
        $this->container['cc_type'] = $cc_type;

        return $this;
    }

    /**
     * Gets echeck_account_name
     *
     * @return string|null
     */
    public function getEcheckAccountName()
    {
        return $this->container['echeck_account_name'];
    }

    /**
     * Sets echeck_account_name
     *
     * @param string|null $echeck_account_name eCheck account name.
     *
     * @return self
     */
    public function setEcheckAccountName($echeck_account_name)
    {
        $this->container['echeck_account_name'] = $echeck_account_name;

        return $this;
    }

    /**
     * Gets echeck_account_type
     *
     * @return string|null
     */
    public function getEcheckAccountType()
    {
        return $this->container['echeck_account_type'];
    }

    /**
     * Sets echeck_account_type
     *
     * @param string|null $echeck_account_type eCheck account type.
     *
     * @return self
     */
    public function setEcheckAccountType($echeck_account_type)
    {
        $this->container['echeck_account_type'] = $echeck_account_type;

        return $this;
    }

    /**
     * Gets echeck_bank_name
     *
     * @return string|null
     */
    public function getEcheckBankName()
    {
        return $this->container['echeck_bank_name'];
    }

    /**
     * Sets echeck_bank_name
     *
     * @param string|null $echeck_bank_name eCheck bank name.
     *
     * @return self
     */
    public function setEcheckBankName($echeck_bank_name)
    {
        $this->container['echeck_bank_name'] = $echeck_bank_name;

        return $this;
    }

    /**
     * Gets echeck_routing_number
     *
     * @return string|null
     */
    public function getEcheckRoutingNumber()
    {
        return $this->container['echeck_routing_number'];
    }

    /**
     * Sets echeck_routing_number
     *
     * @param string|null $echeck_routing_number eCheck routing number.
     *
     * @return self
     */
    public function setEcheckRoutingNumber($echeck_routing_number)
    {
        $this->container['echeck_routing_number'] = $echeck_routing_number;

        return $this;
    }

    /**
     * Gets echeck_type
     *
     * @return string|null
     */
    public function getEcheckType()
    {
        return $this->container['echeck_type'];
    }

    /**
     * Sets echeck_type
     *
     * @param string|null $echeck_type eCheck type.
     *
     * @return self
     */
    public function setEcheckType($echeck_type)
    {
        $this->container['echeck_type'] = $echeck_type;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int|null $entity_id Entity ID.
     *
     * @return self
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets last_trans_id
     *
     * @return string|null
     */
    public function getLastTransId()
    {
        return $this->container['last_trans_id'];
    }

    /**
     * Sets last_trans_id
     *
     * @param string|null $last_trans_id Last transaction ID.
     *
     * @return self
     */
    public function setLastTransId($last_trans_id)
    {
        $this->container['last_trans_id'] = $last_trans_id;

        return $this;
    }

    /**
     * Gets method
     *
     * @return string
     */
    public function getMethod()
    {
        return $this->container['method'];
    }

    /**
     * Sets method
     *
     * @param string $method Method.
     *
     * @return self
     */
    public function setMethod($method)
    {
        $this->container['method'] = $method;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int|null
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int|null $parent_id Parent ID.
     *
     * @return self
     */
    public function setParentId($parent_id)
    {
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets po_number
     *
     * @return string|null
     */
    public function getPoNumber()
    {
        return $this->container['po_number'];
    }

    /**
     * Sets po_number
     *
     * @param string|null $po_number PO number.
     *
     * @return self
     */
    public function setPoNumber($po_number)
    {
        $this->container['po_number'] = $po_number;

        return $this;
    }

    /**
     * Gets protection_eligibility
     *
     * @return string|null
     */
    public function getProtectionEligibility()
    {
        return $this->container['protection_eligibility'];
    }

    /**
     * Sets protection_eligibility
     *
     * @param string|null $protection_eligibility Protection eligibility.
     *
     * @return self
     */
    public function setProtectionEligibility($protection_eligibility)
    {
        $this->container['protection_eligibility'] = $protection_eligibility;

        return $this;
    }

    /**
     * Gets quote_payment_id
     *
     * @return int|null
     */
    public function getQuotePaymentId()
    {
        return $this->container['quote_payment_id'];
    }

    /**
     * Sets quote_payment_id
     *
     * @param int|null $quote_payment_id Quote payment ID.
     *
     * @return self
     */
    public function setQuotePaymentId($quote_payment_id)
    {
        $this->container['quote_payment_id'] = $quote_payment_id;

        return $this;
    }

    /**
     * Gets shipping_amount
     *
     * @return float|null
     */
    public function getShippingAmount()
    {
        return $this->container['shipping_amount'];
    }

    /**
     * Sets shipping_amount
     *
     * @param float|null $shipping_amount Shipping amount.
     *
     * @return self
     */
    public function setShippingAmount($shipping_amount)
    {
        $this->container['shipping_amount'] = $shipping_amount;

        return $this;
    }

    /**
     * Gets shipping_captured
     *
     * @return float|null
     */
    public function getShippingCaptured()
    {
        return $this->container['shipping_captured'];
    }

    /**
     * Sets shipping_captured
     *
     * @param float|null $shipping_captured Shipping captured.
     *
     * @return self
     */
    public function setShippingCaptured($shipping_captured)
    {
        $this->container['shipping_captured'] = $shipping_captured;

        return $this;
    }

    /**
     * Gets shipping_refunded
     *
     * @return float|null
     */
    public function getShippingRefunded()
    {
        return $this->container['shipping_refunded'];
    }

    /**
     * Sets shipping_refunded
     *
     * @param float|null $shipping_refunded Shipping refunded.
     *
     * @return self
     */
    public function setShippingRefunded($shipping_refunded)
    {
        $this->container['shipping_refunded'] = $shipping_refunded;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Magento2\Model\SalesDataOrderPaymentExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Magento2\Model\SalesDataOrderPaymentExtensionInterface|null $extension_attributes extension_attributes
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


