<?php
/**
 * SalesDataOrderItemInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesDataOrderItemInterface Class Doc Comment
 *
 * @category Class
 * @description Order item interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesDataOrderItemInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-data-order-item-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'additional_data' => 'string',
        'amount_refunded' => 'float',
        'applied_rule_ids' => 'string',
        'base_amount_refunded' => 'float',
        'base_cost' => 'float',
        'base_discount_amount' => 'float',
        'base_discount_invoiced' => 'float',
        'base_discount_refunded' => 'float',
        'base_discount_tax_compensation_amount' => 'float',
        'base_discount_tax_compensation_invoiced' => 'float',
        'base_discount_tax_compensation_refunded' => 'float',
        'base_original_price' => 'float',
        'base_price' => 'float',
        'base_price_incl_tax' => 'float',
        'base_row_invoiced' => 'float',
        'base_row_total' => 'float',
        'base_row_total_incl_tax' => 'float',
        'base_tax_amount' => 'float',
        'base_tax_before_discount' => 'float',
        'base_tax_invoiced' => 'float',
        'base_tax_refunded' => 'float',
        'base_weee_tax_applied_amount' => 'float',
        'base_weee_tax_applied_row_amnt' => 'float',
        'base_weee_tax_disposition' => 'float',
        'base_weee_tax_row_disposition' => 'float',
        'created_at' => 'string',
        'description' => 'string',
        'discount_amount' => 'float',
        'discount_invoiced' => 'float',
        'discount_percent' => 'float',
        'discount_refunded' => 'float',
        'event_id' => 'int',
        'ext_order_item_id' => 'string',
        'free_shipping' => 'int',
        'gw_base_price' => 'float',
        'gw_base_price_invoiced' => 'float',
        'gw_base_price_refunded' => 'float',
        'gw_base_tax_amount' => 'float',
        'gw_base_tax_amount_invoiced' => 'float',
        'gw_base_tax_amount_refunded' => 'float',
        'gw_id' => 'int',
        'gw_price' => 'float',
        'gw_price_invoiced' => 'float',
        'gw_price_refunded' => 'float',
        'gw_tax_amount' => 'float',
        'gw_tax_amount_invoiced' => 'float',
        'gw_tax_amount_refunded' => 'float',
        'discount_tax_compensation_amount' => 'float',
        'discount_tax_compensation_canceled' => 'float',
        'discount_tax_compensation_invoiced' => 'float',
        'discount_tax_compensation_refunded' => 'float',
        'is_qty_decimal' => 'int',
        'is_virtual' => 'int',
        'item_id' => 'int',
        'locked_do_invoice' => 'int',
        'locked_do_ship' => 'int',
        'name' => 'string',
        'no_discount' => 'int',
        'order_id' => 'int',
        'original_price' => 'float',
        'parent_item_id' => 'int',
        'price' => 'float',
        'price_incl_tax' => 'float',
        'product_id' => 'int',
        'product_type' => 'string',
        'qty_backordered' => 'float',
        'qty_canceled' => 'float',
        'qty_invoiced' => 'float',
        'qty_ordered' => 'float',
        'qty_refunded' => 'float',
        'qty_returned' => 'float',
        'qty_shipped' => 'float',
        'quote_item_id' => 'int',
        'row_invoiced' => 'float',
        'row_total' => 'float',
        'row_total_incl_tax' => 'float',
        'row_weight' => 'float',
        'sku' => 'string',
        'store_id' => 'int',
        'tax_amount' => 'float',
        'tax_before_discount' => 'float',
        'tax_canceled' => 'float',
        'tax_invoiced' => 'float',
        'tax_percent' => 'float',
        'tax_refunded' => 'float',
        'updated_at' => 'string',
        'weee_tax_applied' => 'string',
        'weee_tax_applied_amount' => 'float',
        'weee_tax_applied_row_amount' => 'float',
        'weee_tax_disposition' => 'float',
        'weee_tax_row_disposition' => 'float',
        'weight' => 'float',
        'parent_item' => '\Magento2\Model\SalesDataOrderItemInterface',
        'product_option' => '\Magento2\Model\CatalogDataProductOptionInterface',
        'extension_attributes' => '\Magento2\Model\SalesDataOrderItemExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'additional_data' => null,
        'amount_refunded' => null,
        'applied_rule_ids' => null,
        'base_amount_refunded' => null,
        'base_cost' => null,
        'base_discount_amount' => null,
        'base_discount_invoiced' => null,
        'base_discount_refunded' => null,
        'base_discount_tax_compensation_amount' => null,
        'base_discount_tax_compensation_invoiced' => null,
        'base_discount_tax_compensation_refunded' => null,
        'base_original_price' => null,
        'base_price' => null,
        'base_price_incl_tax' => null,
        'base_row_invoiced' => null,
        'base_row_total' => null,
        'base_row_total_incl_tax' => null,
        'base_tax_amount' => null,
        'base_tax_before_discount' => null,
        'base_tax_invoiced' => null,
        'base_tax_refunded' => null,
        'base_weee_tax_applied_amount' => null,
        'base_weee_tax_applied_row_amnt' => null,
        'base_weee_tax_disposition' => null,
        'base_weee_tax_row_disposition' => null,
        'created_at' => null,
        'description' => null,
        'discount_amount' => null,
        'discount_invoiced' => null,
        'discount_percent' => null,
        'discount_refunded' => null,
        'event_id' => null,
        'ext_order_item_id' => null,
        'free_shipping' => null,
        'gw_base_price' => null,
        'gw_base_price_invoiced' => null,
        'gw_base_price_refunded' => null,
        'gw_base_tax_amount' => null,
        'gw_base_tax_amount_invoiced' => null,
        'gw_base_tax_amount_refunded' => null,
        'gw_id' => null,
        'gw_price' => null,
        'gw_price_invoiced' => null,
        'gw_price_refunded' => null,
        'gw_tax_amount' => null,
        'gw_tax_amount_invoiced' => null,
        'gw_tax_amount_refunded' => null,
        'discount_tax_compensation_amount' => null,
        'discount_tax_compensation_canceled' => null,
        'discount_tax_compensation_invoiced' => null,
        'discount_tax_compensation_refunded' => null,
        'is_qty_decimal' => null,
        'is_virtual' => null,
        'item_id' => null,
        'locked_do_invoice' => null,
        'locked_do_ship' => null,
        'name' => null,
        'no_discount' => null,
        'order_id' => null,
        'original_price' => null,
        'parent_item_id' => null,
        'price' => null,
        'price_incl_tax' => null,
        'product_id' => null,
        'product_type' => null,
        'qty_backordered' => null,
        'qty_canceled' => null,
        'qty_invoiced' => null,
        'qty_ordered' => null,
        'qty_refunded' => null,
        'qty_returned' => null,
        'qty_shipped' => null,
        'quote_item_id' => null,
        'row_invoiced' => null,
        'row_total' => null,
        'row_total_incl_tax' => null,
        'row_weight' => null,
        'sku' => null,
        'store_id' => null,
        'tax_amount' => null,
        'tax_before_discount' => null,
        'tax_canceled' => null,
        'tax_invoiced' => null,
        'tax_percent' => null,
        'tax_refunded' => null,
        'updated_at' => null,
        'weee_tax_applied' => null,
        'weee_tax_applied_amount' => null,
        'weee_tax_applied_row_amount' => null,
        'weee_tax_disposition' => null,
        'weee_tax_row_disposition' => null,
        'weight' => null,
        'parent_item' => null,
        'product_option' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'additional_data' => 'additional_data',
        'amount_refunded' => 'amount_refunded',
        'applied_rule_ids' => 'applied_rule_ids',
        'base_amount_refunded' => 'base_amount_refunded',
        'base_cost' => 'base_cost',
        'base_discount_amount' => 'base_discount_amount',
        'base_discount_invoiced' => 'base_discount_invoiced',
        'base_discount_refunded' => 'base_discount_refunded',
        'base_discount_tax_compensation_amount' => 'base_discount_tax_compensation_amount',
        'base_discount_tax_compensation_invoiced' => 'base_discount_tax_compensation_invoiced',
        'base_discount_tax_compensation_refunded' => 'base_discount_tax_compensation_refunded',
        'base_original_price' => 'base_original_price',
        'base_price' => 'base_price',
        'base_price_incl_tax' => 'base_price_incl_tax',
        'base_row_invoiced' => 'base_row_invoiced',
        'base_row_total' => 'base_row_total',
        'base_row_total_incl_tax' => 'base_row_total_incl_tax',
        'base_tax_amount' => 'base_tax_amount',
        'base_tax_before_discount' => 'base_tax_before_discount',
        'base_tax_invoiced' => 'base_tax_invoiced',
        'base_tax_refunded' => 'base_tax_refunded',
        'base_weee_tax_applied_amount' => 'base_weee_tax_applied_amount',
        'base_weee_tax_applied_row_amnt' => 'base_weee_tax_applied_row_amnt',
        'base_weee_tax_disposition' => 'base_weee_tax_disposition',
        'base_weee_tax_row_disposition' => 'base_weee_tax_row_disposition',
        'created_at' => 'created_at',
        'description' => 'description',
        'discount_amount' => 'discount_amount',
        'discount_invoiced' => 'discount_invoiced',
        'discount_percent' => 'discount_percent',
        'discount_refunded' => 'discount_refunded',
        'event_id' => 'event_id',
        'ext_order_item_id' => 'ext_order_item_id',
        'free_shipping' => 'free_shipping',
        'gw_base_price' => 'gw_base_price',
        'gw_base_price_invoiced' => 'gw_base_price_invoiced',
        'gw_base_price_refunded' => 'gw_base_price_refunded',
        'gw_base_tax_amount' => 'gw_base_tax_amount',
        'gw_base_tax_amount_invoiced' => 'gw_base_tax_amount_invoiced',
        'gw_base_tax_amount_refunded' => 'gw_base_tax_amount_refunded',
        'gw_id' => 'gw_id',
        'gw_price' => 'gw_price',
        'gw_price_invoiced' => 'gw_price_invoiced',
        'gw_price_refunded' => 'gw_price_refunded',
        'gw_tax_amount' => 'gw_tax_amount',
        'gw_tax_amount_invoiced' => 'gw_tax_amount_invoiced',
        'gw_tax_amount_refunded' => 'gw_tax_amount_refunded',
        'discount_tax_compensation_amount' => 'discount_tax_compensation_amount',
        'discount_tax_compensation_canceled' => 'discount_tax_compensation_canceled',
        'discount_tax_compensation_invoiced' => 'discount_tax_compensation_invoiced',
        'discount_tax_compensation_refunded' => 'discount_tax_compensation_refunded',
        'is_qty_decimal' => 'is_qty_decimal',
        'is_virtual' => 'is_virtual',
        'item_id' => 'item_id',
        'locked_do_invoice' => 'locked_do_invoice',
        'locked_do_ship' => 'locked_do_ship',
        'name' => 'name',
        'no_discount' => 'no_discount',
        'order_id' => 'order_id',
        'original_price' => 'original_price',
        'parent_item_id' => 'parent_item_id',
        'price' => 'price',
        'price_incl_tax' => 'price_incl_tax',
        'product_id' => 'product_id',
        'product_type' => 'product_type',
        'qty_backordered' => 'qty_backordered',
        'qty_canceled' => 'qty_canceled',
        'qty_invoiced' => 'qty_invoiced',
        'qty_ordered' => 'qty_ordered',
        'qty_refunded' => 'qty_refunded',
        'qty_returned' => 'qty_returned',
        'qty_shipped' => 'qty_shipped',
        'quote_item_id' => 'quote_item_id',
        'row_invoiced' => 'row_invoiced',
        'row_total' => 'row_total',
        'row_total_incl_tax' => 'row_total_incl_tax',
        'row_weight' => 'row_weight',
        'sku' => 'sku',
        'store_id' => 'store_id',
        'tax_amount' => 'tax_amount',
        'tax_before_discount' => 'tax_before_discount',
        'tax_canceled' => 'tax_canceled',
        'tax_invoiced' => 'tax_invoiced',
        'tax_percent' => 'tax_percent',
        'tax_refunded' => 'tax_refunded',
        'updated_at' => 'updated_at',
        'weee_tax_applied' => 'weee_tax_applied',
        'weee_tax_applied_amount' => 'weee_tax_applied_amount',
        'weee_tax_applied_row_amount' => 'weee_tax_applied_row_amount',
        'weee_tax_disposition' => 'weee_tax_disposition',
        'weee_tax_row_disposition' => 'weee_tax_row_disposition',
        'weight' => 'weight',
        'parent_item' => 'parent_item',
        'product_option' => 'product_option',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'additional_data' => 'setAdditionalData',
        'amount_refunded' => 'setAmountRefunded',
        'applied_rule_ids' => 'setAppliedRuleIds',
        'base_amount_refunded' => 'setBaseAmountRefunded',
        'base_cost' => 'setBaseCost',
        'base_discount_amount' => 'setBaseDiscountAmount',
        'base_discount_invoiced' => 'setBaseDiscountInvoiced',
        'base_discount_refunded' => 'setBaseDiscountRefunded',
        'base_discount_tax_compensation_amount' => 'setBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'setBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'setBaseDiscountTaxCompensationRefunded',
        'base_original_price' => 'setBaseOriginalPrice',
        'base_price' => 'setBasePrice',
        'base_price_incl_tax' => 'setBasePriceInclTax',
        'base_row_invoiced' => 'setBaseRowInvoiced',
        'base_row_total' => 'setBaseRowTotal',
        'base_row_total_incl_tax' => 'setBaseRowTotalInclTax',
        'base_tax_amount' => 'setBaseTaxAmount',
        'base_tax_before_discount' => 'setBaseTaxBeforeDiscount',
        'base_tax_invoiced' => 'setBaseTaxInvoiced',
        'base_tax_refunded' => 'setBaseTaxRefunded',
        'base_weee_tax_applied_amount' => 'setBaseWeeeTaxAppliedAmount',
        'base_weee_tax_applied_row_amnt' => 'setBaseWeeeTaxAppliedRowAmnt',
        'base_weee_tax_disposition' => 'setBaseWeeeTaxDisposition',
        'base_weee_tax_row_disposition' => 'setBaseWeeeTaxRowDisposition',
        'created_at' => 'setCreatedAt',
        'description' => 'setDescription',
        'discount_amount' => 'setDiscountAmount',
        'discount_invoiced' => 'setDiscountInvoiced',
        'discount_percent' => 'setDiscountPercent',
        'discount_refunded' => 'setDiscountRefunded',
        'event_id' => 'setEventId',
        'ext_order_item_id' => 'setExtOrderItemId',
        'free_shipping' => 'setFreeShipping',
        'gw_base_price' => 'setGwBasePrice',
        'gw_base_price_invoiced' => 'setGwBasePriceInvoiced',
        'gw_base_price_refunded' => 'setGwBasePriceRefunded',
        'gw_base_tax_amount' => 'setGwBaseTaxAmount',
        'gw_base_tax_amount_invoiced' => 'setGwBaseTaxAmountInvoiced',
        'gw_base_tax_amount_refunded' => 'setGwBaseTaxAmountRefunded',
        'gw_id' => 'setGwId',
        'gw_price' => 'setGwPrice',
        'gw_price_invoiced' => 'setGwPriceInvoiced',
        'gw_price_refunded' => 'setGwPriceRefunded',
        'gw_tax_amount' => 'setGwTaxAmount',
        'gw_tax_amount_invoiced' => 'setGwTaxAmountInvoiced',
        'gw_tax_amount_refunded' => 'setGwTaxAmountRefunded',
        'discount_tax_compensation_amount' => 'setDiscountTaxCompensationAmount',
        'discount_tax_compensation_canceled' => 'setDiscountTaxCompensationCanceled',
        'discount_tax_compensation_invoiced' => 'setDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'setDiscountTaxCompensationRefunded',
        'is_qty_decimal' => 'setIsQtyDecimal',
        'is_virtual' => 'setIsVirtual',
        'item_id' => 'setItemId',
        'locked_do_invoice' => 'setLockedDoInvoice',
        'locked_do_ship' => 'setLockedDoShip',
        'name' => 'setName',
        'no_discount' => 'setNoDiscount',
        'order_id' => 'setOrderId',
        'original_price' => 'setOriginalPrice',
        'parent_item_id' => 'setParentItemId',
        'price' => 'setPrice',
        'price_incl_tax' => 'setPriceInclTax',
        'product_id' => 'setProductId',
        'product_type' => 'setProductType',
        'qty_backordered' => 'setQtyBackordered',
        'qty_canceled' => 'setQtyCanceled',
        'qty_invoiced' => 'setQtyInvoiced',
        'qty_ordered' => 'setQtyOrdered',
        'qty_refunded' => 'setQtyRefunded',
        'qty_returned' => 'setQtyReturned',
        'qty_shipped' => 'setQtyShipped',
        'quote_item_id' => 'setQuoteItemId',
        'row_invoiced' => 'setRowInvoiced',
        'row_total' => 'setRowTotal',
        'row_total_incl_tax' => 'setRowTotalInclTax',
        'row_weight' => 'setRowWeight',
        'sku' => 'setSku',
        'store_id' => 'setStoreId',
        'tax_amount' => 'setTaxAmount',
        'tax_before_discount' => 'setTaxBeforeDiscount',
        'tax_canceled' => 'setTaxCanceled',
        'tax_invoiced' => 'setTaxInvoiced',
        'tax_percent' => 'setTaxPercent',
        'tax_refunded' => 'setTaxRefunded',
        'updated_at' => 'setUpdatedAt',
        'weee_tax_applied' => 'setWeeeTaxApplied',
        'weee_tax_applied_amount' => 'setWeeeTaxAppliedAmount',
        'weee_tax_applied_row_amount' => 'setWeeeTaxAppliedRowAmount',
        'weee_tax_disposition' => 'setWeeeTaxDisposition',
        'weee_tax_row_disposition' => 'setWeeeTaxRowDisposition',
        'weight' => 'setWeight',
        'parent_item' => 'setParentItem',
        'product_option' => 'setProductOption',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'additional_data' => 'getAdditionalData',
        'amount_refunded' => 'getAmountRefunded',
        'applied_rule_ids' => 'getAppliedRuleIds',
        'base_amount_refunded' => 'getBaseAmountRefunded',
        'base_cost' => 'getBaseCost',
        'base_discount_amount' => 'getBaseDiscountAmount',
        'base_discount_invoiced' => 'getBaseDiscountInvoiced',
        'base_discount_refunded' => 'getBaseDiscountRefunded',
        'base_discount_tax_compensation_amount' => 'getBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'getBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'getBaseDiscountTaxCompensationRefunded',
        'base_original_price' => 'getBaseOriginalPrice',
        'base_price' => 'getBasePrice',
        'base_price_incl_tax' => 'getBasePriceInclTax',
        'base_row_invoiced' => 'getBaseRowInvoiced',
        'base_row_total' => 'getBaseRowTotal',
        'base_row_total_incl_tax' => 'getBaseRowTotalInclTax',
        'base_tax_amount' => 'getBaseTaxAmount',
        'base_tax_before_discount' => 'getBaseTaxBeforeDiscount',
        'base_tax_invoiced' => 'getBaseTaxInvoiced',
        'base_tax_refunded' => 'getBaseTaxRefunded',
        'base_weee_tax_applied_amount' => 'getBaseWeeeTaxAppliedAmount',
        'base_weee_tax_applied_row_amnt' => 'getBaseWeeeTaxAppliedRowAmnt',
        'base_weee_tax_disposition' => 'getBaseWeeeTaxDisposition',
        'base_weee_tax_row_disposition' => 'getBaseWeeeTaxRowDisposition',
        'created_at' => 'getCreatedAt',
        'description' => 'getDescription',
        'discount_amount' => 'getDiscountAmount',
        'discount_invoiced' => 'getDiscountInvoiced',
        'discount_percent' => 'getDiscountPercent',
        'discount_refunded' => 'getDiscountRefunded',
        'event_id' => 'getEventId',
        'ext_order_item_id' => 'getExtOrderItemId',
        'free_shipping' => 'getFreeShipping',
        'gw_base_price' => 'getGwBasePrice',
        'gw_base_price_invoiced' => 'getGwBasePriceInvoiced',
        'gw_base_price_refunded' => 'getGwBasePriceRefunded',
        'gw_base_tax_amount' => 'getGwBaseTaxAmount',
        'gw_base_tax_amount_invoiced' => 'getGwBaseTaxAmountInvoiced',
        'gw_base_tax_amount_refunded' => 'getGwBaseTaxAmountRefunded',
        'gw_id' => 'getGwId',
        'gw_price' => 'getGwPrice',
        'gw_price_invoiced' => 'getGwPriceInvoiced',
        'gw_price_refunded' => 'getGwPriceRefunded',
        'gw_tax_amount' => 'getGwTaxAmount',
        'gw_tax_amount_invoiced' => 'getGwTaxAmountInvoiced',
        'gw_tax_amount_refunded' => 'getGwTaxAmountRefunded',
        'discount_tax_compensation_amount' => 'getDiscountTaxCompensationAmount',
        'discount_tax_compensation_canceled' => 'getDiscountTaxCompensationCanceled',
        'discount_tax_compensation_invoiced' => 'getDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'getDiscountTaxCompensationRefunded',
        'is_qty_decimal' => 'getIsQtyDecimal',
        'is_virtual' => 'getIsVirtual',
        'item_id' => 'getItemId',
        'locked_do_invoice' => 'getLockedDoInvoice',
        'locked_do_ship' => 'getLockedDoShip',
        'name' => 'getName',
        'no_discount' => 'getNoDiscount',
        'order_id' => 'getOrderId',
        'original_price' => 'getOriginalPrice',
        'parent_item_id' => 'getParentItemId',
        'price' => 'getPrice',
        'price_incl_tax' => 'getPriceInclTax',
        'product_id' => 'getProductId',
        'product_type' => 'getProductType',
        'qty_backordered' => 'getQtyBackordered',
        'qty_canceled' => 'getQtyCanceled',
        'qty_invoiced' => 'getQtyInvoiced',
        'qty_ordered' => 'getQtyOrdered',
        'qty_refunded' => 'getQtyRefunded',
        'qty_returned' => 'getQtyReturned',
        'qty_shipped' => 'getQtyShipped',
        'quote_item_id' => 'getQuoteItemId',
        'row_invoiced' => 'getRowInvoiced',
        'row_total' => 'getRowTotal',
        'row_total_incl_tax' => 'getRowTotalInclTax',
        'row_weight' => 'getRowWeight',
        'sku' => 'getSku',
        'store_id' => 'getStoreId',
        'tax_amount' => 'getTaxAmount',
        'tax_before_discount' => 'getTaxBeforeDiscount',
        'tax_canceled' => 'getTaxCanceled',
        'tax_invoiced' => 'getTaxInvoiced',
        'tax_percent' => 'getTaxPercent',
        'tax_refunded' => 'getTaxRefunded',
        'updated_at' => 'getUpdatedAt',
        'weee_tax_applied' => 'getWeeeTaxApplied',
        'weee_tax_applied_amount' => 'getWeeeTaxAppliedAmount',
        'weee_tax_applied_row_amount' => 'getWeeeTaxAppliedRowAmount',
        'weee_tax_disposition' => 'getWeeeTaxDisposition',
        'weee_tax_row_disposition' => 'getWeeeTaxRowDisposition',
        'weight' => 'getWeight',
        'parent_item' => 'getParentItem',
        'product_option' => 'getProductOption',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['additional_data'] = $data['additional_data'] ?? null;
        $this->container['amount_refunded'] = $data['amount_refunded'] ?? null;
        $this->container['applied_rule_ids'] = $data['applied_rule_ids'] ?? null;
        $this->container['base_amount_refunded'] = $data['base_amount_refunded'] ?? null;
        $this->container['base_cost'] = $data['base_cost'] ?? null;
        $this->container['base_discount_amount'] = $data['base_discount_amount'] ?? null;
        $this->container['base_discount_invoiced'] = $data['base_discount_invoiced'] ?? null;
        $this->container['base_discount_refunded'] = $data['base_discount_refunded'] ?? null;
        $this->container['base_discount_tax_compensation_amount'] = $data['base_discount_tax_compensation_amount'] ?? null;
        $this->container['base_discount_tax_compensation_invoiced'] = $data['base_discount_tax_compensation_invoiced'] ?? null;
        $this->container['base_discount_tax_compensation_refunded'] = $data['base_discount_tax_compensation_refunded'] ?? null;
        $this->container['base_original_price'] = $data['base_original_price'] ?? null;
        $this->container['base_price'] = $data['base_price'] ?? null;
        $this->container['base_price_incl_tax'] = $data['base_price_incl_tax'] ?? null;
        $this->container['base_row_invoiced'] = $data['base_row_invoiced'] ?? null;
        $this->container['base_row_total'] = $data['base_row_total'] ?? null;
        $this->container['base_row_total_incl_tax'] = $data['base_row_total_incl_tax'] ?? null;
        $this->container['base_tax_amount'] = $data['base_tax_amount'] ?? null;
        $this->container['base_tax_before_discount'] = $data['base_tax_before_discount'] ?? null;
        $this->container['base_tax_invoiced'] = $data['base_tax_invoiced'] ?? null;
        $this->container['base_tax_refunded'] = $data['base_tax_refunded'] ?? null;
        $this->container['base_weee_tax_applied_amount'] = $data['base_weee_tax_applied_amount'] ?? null;
        $this->container['base_weee_tax_applied_row_amnt'] = $data['base_weee_tax_applied_row_amnt'] ?? null;
        $this->container['base_weee_tax_disposition'] = $data['base_weee_tax_disposition'] ?? null;
        $this->container['base_weee_tax_row_disposition'] = $data['base_weee_tax_row_disposition'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['discount_amount'] = $data['discount_amount'] ?? null;
        $this->container['discount_invoiced'] = $data['discount_invoiced'] ?? null;
        $this->container['discount_percent'] = $data['discount_percent'] ?? null;
        $this->container['discount_refunded'] = $data['discount_refunded'] ?? null;
        $this->container['event_id'] = $data['event_id'] ?? null;
        $this->container['ext_order_item_id'] = $data['ext_order_item_id'] ?? null;
        $this->container['free_shipping'] = $data['free_shipping'] ?? null;
        $this->container['gw_base_price'] = $data['gw_base_price'] ?? null;
        $this->container['gw_base_price_invoiced'] = $data['gw_base_price_invoiced'] ?? null;
        $this->container['gw_base_price_refunded'] = $data['gw_base_price_refunded'] ?? null;
        $this->container['gw_base_tax_amount'] = $data['gw_base_tax_amount'] ?? null;
        $this->container['gw_base_tax_amount_invoiced'] = $data['gw_base_tax_amount_invoiced'] ?? null;
        $this->container['gw_base_tax_amount_refunded'] = $data['gw_base_tax_amount_refunded'] ?? null;
        $this->container['gw_id'] = $data['gw_id'] ?? null;
        $this->container['gw_price'] = $data['gw_price'] ?? null;
        $this->container['gw_price_invoiced'] = $data['gw_price_invoiced'] ?? null;
        $this->container['gw_price_refunded'] = $data['gw_price_refunded'] ?? null;
        $this->container['gw_tax_amount'] = $data['gw_tax_amount'] ?? null;
        $this->container['gw_tax_amount_invoiced'] = $data['gw_tax_amount_invoiced'] ?? null;
        $this->container['gw_tax_amount_refunded'] = $data['gw_tax_amount_refunded'] ?? null;
        $this->container['discount_tax_compensation_amount'] = $data['discount_tax_compensation_amount'] ?? null;
        $this->container['discount_tax_compensation_canceled'] = $data['discount_tax_compensation_canceled'] ?? null;
        $this->container['discount_tax_compensation_invoiced'] = $data['discount_tax_compensation_invoiced'] ?? null;
        $this->container['discount_tax_compensation_refunded'] = $data['discount_tax_compensation_refunded'] ?? null;
        $this->container['is_qty_decimal'] = $data['is_qty_decimal'] ?? null;
        $this->container['is_virtual'] = $data['is_virtual'] ?? null;
        $this->container['item_id'] = $data['item_id'] ?? null;
        $this->container['locked_do_invoice'] = $data['locked_do_invoice'] ?? null;
        $this->container['locked_do_ship'] = $data['locked_do_ship'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['no_discount'] = $data['no_discount'] ?? null;
        $this->container['order_id'] = $data['order_id'] ?? null;
        $this->container['original_price'] = $data['original_price'] ?? null;
        $this->container['parent_item_id'] = $data['parent_item_id'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['price_incl_tax'] = $data['price_incl_tax'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['product_type'] = $data['product_type'] ?? null;
        $this->container['qty_backordered'] = $data['qty_backordered'] ?? null;
        $this->container['qty_canceled'] = $data['qty_canceled'] ?? null;
        $this->container['qty_invoiced'] = $data['qty_invoiced'] ?? null;
        $this->container['qty_ordered'] = $data['qty_ordered'] ?? null;
        $this->container['qty_refunded'] = $data['qty_refunded'] ?? null;
        $this->container['qty_returned'] = $data['qty_returned'] ?? null;
        $this->container['qty_shipped'] = $data['qty_shipped'] ?? null;
        $this->container['quote_item_id'] = $data['quote_item_id'] ?? null;
        $this->container['row_invoiced'] = $data['row_invoiced'] ?? null;
        $this->container['row_total'] = $data['row_total'] ?? null;
        $this->container['row_total_incl_tax'] = $data['row_total_incl_tax'] ?? null;
        $this->container['row_weight'] = $data['row_weight'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['store_id'] = $data['store_id'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['tax_before_discount'] = $data['tax_before_discount'] ?? null;
        $this->container['tax_canceled'] = $data['tax_canceled'] ?? null;
        $this->container['tax_invoiced'] = $data['tax_invoiced'] ?? null;
        $this->container['tax_percent'] = $data['tax_percent'] ?? null;
        $this->container['tax_refunded'] = $data['tax_refunded'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['weee_tax_applied'] = $data['weee_tax_applied'] ?? null;
        $this->container['weee_tax_applied_amount'] = $data['weee_tax_applied_amount'] ?? null;
        $this->container['weee_tax_applied_row_amount'] = $data['weee_tax_applied_row_amount'] ?? null;
        $this->container['weee_tax_disposition'] = $data['weee_tax_disposition'] ?? null;
        $this->container['weee_tax_row_disposition'] = $data['weee_tax_row_disposition'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['parent_item'] = $data['parent_item'] ?? null;
        $this->container['product_option'] = $data['product_option'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets additional_data
     *
     * @return string|null
     */
    public function getAdditionalData()
    {
        return $this->container['additional_data'];
    }

    /**
     * Sets additional_data
     *
     * @param string|null $additional_data Additional data.
     *
     * @return self
     */
    public function setAdditionalData($additional_data)
    {
        $this->container['additional_data'] = $additional_data;

        return $this;
    }

    /**
     * Gets amount_refunded
     *
     * @return float|null
     */
    public function getAmountRefunded()
    {
        return $this->container['amount_refunded'];
    }

    /**
     * Sets amount_refunded
     *
     * @param float|null $amount_refunded Amount refunded.
     *
     * @return self
     */
    public function setAmountRefunded($amount_refunded)
    {
        $this->container['amount_refunded'] = $amount_refunded;

        return $this;
    }

    /**
     * Gets applied_rule_ids
     *
     * @return string|null
     */
    public function getAppliedRuleIds()
    {
        return $this->container['applied_rule_ids'];
    }

    /**
     * Sets applied_rule_ids
     *
     * @param string|null $applied_rule_ids Applied rule IDs.
     *
     * @return self
     */
    public function setAppliedRuleIds($applied_rule_ids)
    {
        $this->container['applied_rule_ids'] = $applied_rule_ids;

        return $this;
    }

    /**
     * Gets base_amount_refunded
     *
     * @return float|null
     */
    public function getBaseAmountRefunded()
    {
        return $this->container['base_amount_refunded'];
    }

    /**
     * Sets base_amount_refunded
     *
     * @param float|null $base_amount_refunded Base amount refunded.
     *
     * @return self
     */
    public function setBaseAmountRefunded($base_amount_refunded)
    {
        $this->container['base_amount_refunded'] = $base_amount_refunded;

        return $this;
    }

    /**
     * Gets base_cost
     *
     * @return float|null
     */
    public function getBaseCost()
    {
        return $this->container['base_cost'];
    }

    /**
     * Sets base_cost
     *
     * @param float|null $base_cost Base cost.
     *
     * @return self
     */
    public function setBaseCost($base_cost)
    {
        $this->container['base_cost'] = $base_cost;

        return $this;
    }

    /**
     * Gets base_discount_amount
     *
     * @return float|null
     */
    public function getBaseDiscountAmount()
    {
        return $this->container['base_discount_amount'];
    }

    /**
     * Sets base_discount_amount
     *
     * @param float|null $base_discount_amount Base discount amount.
     *
     * @return self
     */
    public function setBaseDiscountAmount($base_discount_amount)
    {
        $this->container['base_discount_amount'] = $base_discount_amount;

        return $this;
    }

    /**
     * Gets base_discount_invoiced
     *
     * @return float|null
     */
    public function getBaseDiscountInvoiced()
    {
        return $this->container['base_discount_invoiced'];
    }

    /**
     * Sets base_discount_invoiced
     *
     * @param float|null $base_discount_invoiced Base discount invoiced.
     *
     * @return self
     */
    public function setBaseDiscountInvoiced($base_discount_invoiced)
    {
        $this->container['base_discount_invoiced'] = $base_discount_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_refunded
     *
     * @return float|null
     */
    public function getBaseDiscountRefunded()
    {
        return $this->container['base_discount_refunded'];
    }

    /**
     * Sets base_discount_refunded
     *
     * @param float|null $base_discount_refunded Base discount refunded.
     *
     * @return self
     */
    public function setBaseDiscountRefunded($base_discount_refunded)
    {
        $this->container['base_discount_refunded'] = $base_discount_refunded;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationAmount()
    {
        return $this->container['base_discount_tax_compensation_amount'];
    }

    /**
     * Sets base_discount_tax_compensation_amount
     *
     * @param float|null $base_discount_tax_compensation_amount Base discount tax compensation amount.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationAmount($base_discount_tax_compensation_amount)
    {
        $this->container['base_discount_tax_compensation_amount'] = $base_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_invoiced
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationInvoiced()
    {
        return $this->container['base_discount_tax_compensation_invoiced'];
    }

    /**
     * Sets base_discount_tax_compensation_invoiced
     *
     * @param float|null $base_discount_tax_compensation_invoiced Base discount tax compensation invoiced.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationInvoiced($base_discount_tax_compensation_invoiced)
    {
        $this->container['base_discount_tax_compensation_invoiced'] = $base_discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_refunded
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationRefunded()
    {
        return $this->container['base_discount_tax_compensation_refunded'];
    }

    /**
     * Sets base_discount_tax_compensation_refunded
     *
     * @param float|null $base_discount_tax_compensation_refunded Base discount tax compensation refunded.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationRefunded($base_discount_tax_compensation_refunded)
    {
        $this->container['base_discount_tax_compensation_refunded'] = $base_discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets base_original_price
     *
     * @return float|null
     */
    public function getBaseOriginalPrice()
    {
        return $this->container['base_original_price'];
    }

    /**
     * Sets base_original_price
     *
     * @param float|null $base_original_price Base original price.
     *
     * @return self
     */
    public function setBaseOriginalPrice($base_original_price)
    {
        $this->container['base_original_price'] = $base_original_price;

        return $this;
    }

    /**
     * Gets base_price
     *
     * @return float|null
     */
    public function getBasePrice()
    {
        return $this->container['base_price'];
    }

    /**
     * Sets base_price
     *
     * @param float|null $base_price Base price.
     *
     * @return self
     */
    public function setBasePrice($base_price)
    {
        $this->container['base_price'] = $base_price;

        return $this;
    }

    /**
     * Gets base_price_incl_tax
     *
     * @return float|null
     */
    public function getBasePriceInclTax()
    {
        return $this->container['base_price_incl_tax'];
    }

    /**
     * Sets base_price_incl_tax
     *
     * @param float|null $base_price_incl_tax Base price including tax.
     *
     * @return self
     */
    public function setBasePriceInclTax($base_price_incl_tax)
    {
        $this->container['base_price_incl_tax'] = $base_price_incl_tax;

        return $this;
    }

    /**
     * Gets base_row_invoiced
     *
     * @return float|null
     */
    public function getBaseRowInvoiced()
    {
        return $this->container['base_row_invoiced'];
    }

    /**
     * Sets base_row_invoiced
     *
     * @param float|null $base_row_invoiced Base row invoiced.
     *
     * @return self
     */
    public function setBaseRowInvoiced($base_row_invoiced)
    {
        $this->container['base_row_invoiced'] = $base_row_invoiced;

        return $this;
    }

    /**
     * Gets base_row_total
     *
     * @return float|null
     */
    public function getBaseRowTotal()
    {
        return $this->container['base_row_total'];
    }

    /**
     * Sets base_row_total
     *
     * @param float|null $base_row_total Base row total.
     *
     * @return self
     */
    public function setBaseRowTotal($base_row_total)
    {
        $this->container['base_row_total'] = $base_row_total;

        return $this;
    }

    /**
     * Gets base_row_total_incl_tax
     *
     * @return float|null
     */
    public function getBaseRowTotalInclTax()
    {
        return $this->container['base_row_total_incl_tax'];
    }

    /**
     * Sets base_row_total_incl_tax
     *
     * @param float|null $base_row_total_incl_tax Base row total including tax.
     *
     * @return self
     */
    public function setBaseRowTotalInclTax($base_row_total_incl_tax)
    {
        $this->container['base_row_total_incl_tax'] = $base_row_total_incl_tax;

        return $this;
    }

    /**
     * Gets base_tax_amount
     *
     * @return float|null
     */
    public function getBaseTaxAmount()
    {
        return $this->container['base_tax_amount'];
    }

    /**
     * Sets base_tax_amount
     *
     * @param float|null $base_tax_amount Base tax amount.
     *
     * @return self
     */
    public function setBaseTaxAmount($base_tax_amount)
    {
        $this->container['base_tax_amount'] = $base_tax_amount;

        return $this;
    }

    /**
     * Gets base_tax_before_discount
     *
     * @return float|null
     */
    public function getBaseTaxBeforeDiscount()
    {
        return $this->container['base_tax_before_discount'];
    }

    /**
     * Sets base_tax_before_discount
     *
     * @param float|null $base_tax_before_discount Base tax before discount.
     *
     * @return self
     */
    public function setBaseTaxBeforeDiscount($base_tax_before_discount)
    {
        $this->container['base_tax_before_discount'] = $base_tax_before_discount;

        return $this;
    }

    /**
     * Gets base_tax_invoiced
     *
     * @return float|null
     */
    public function getBaseTaxInvoiced()
    {
        return $this->container['base_tax_invoiced'];
    }

    /**
     * Sets base_tax_invoiced
     *
     * @param float|null $base_tax_invoiced Base tax invoiced.
     *
     * @return self
     */
    public function setBaseTaxInvoiced($base_tax_invoiced)
    {
        $this->container['base_tax_invoiced'] = $base_tax_invoiced;

        return $this;
    }

    /**
     * Gets base_tax_refunded
     *
     * @return float|null
     */
    public function getBaseTaxRefunded()
    {
        return $this->container['base_tax_refunded'];
    }

    /**
     * Sets base_tax_refunded
     *
     * @param float|null $base_tax_refunded Base tax refunded.
     *
     * @return self
     */
    public function setBaseTaxRefunded($base_tax_refunded)
    {
        $this->container['base_tax_refunded'] = $base_tax_refunded;

        return $this;
    }

    /**
     * Gets base_weee_tax_applied_amount
     *
     * @return float|null
     */
    public function getBaseWeeeTaxAppliedAmount()
    {
        return $this->container['base_weee_tax_applied_amount'];
    }

    /**
     * Sets base_weee_tax_applied_amount
     *
     * @param float|null $base_weee_tax_applied_amount Base WEEE tax applied amount.
     *
     * @return self
     */
    public function setBaseWeeeTaxAppliedAmount($base_weee_tax_applied_amount)
    {
        $this->container['base_weee_tax_applied_amount'] = $base_weee_tax_applied_amount;

        return $this;
    }

    /**
     * Gets base_weee_tax_applied_row_amnt
     *
     * @return float|null
     */
    public function getBaseWeeeTaxAppliedRowAmnt()
    {
        return $this->container['base_weee_tax_applied_row_amnt'];
    }

    /**
     * Sets base_weee_tax_applied_row_amnt
     *
     * @param float|null $base_weee_tax_applied_row_amnt Base WEEE tax applied row amount.
     *
     * @return self
     */
    public function setBaseWeeeTaxAppliedRowAmnt($base_weee_tax_applied_row_amnt)
    {
        $this->container['base_weee_tax_applied_row_amnt'] = $base_weee_tax_applied_row_amnt;

        return $this;
    }

    /**
     * Gets base_weee_tax_disposition
     *
     * @return float|null
     */
    public function getBaseWeeeTaxDisposition()
    {
        return $this->container['base_weee_tax_disposition'];
    }

    /**
     * Sets base_weee_tax_disposition
     *
     * @param float|null $base_weee_tax_disposition Base WEEE tax disposition.
     *
     * @return self
     */
    public function setBaseWeeeTaxDisposition($base_weee_tax_disposition)
    {
        $this->container['base_weee_tax_disposition'] = $base_weee_tax_disposition;

        return $this;
    }

    /**
     * Gets base_weee_tax_row_disposition
     *
     * @return float|null
     */
    public function getBaseWeeeTaxRowDisposition()
    {
        return $this->container['base_weee_tax_row_disposition'];
    }

    /**
     * Sets base_weee_tax_row_disposition
     *
     * @param float|null $base_weee_tax_row_disposition Base WEEE tax row disposition.
     *
     * @return self
     */
    public function setBaseWeeeTaxRowDisposition($base_weee_tax_row_disposition)
    {
        $this->container['base_weee_tax_row_disposition'] = $base_weee_tax_row_disposition;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Created-at timestamp.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Description.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float|null $discount_amount Discount amount.
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_invoiced
     *
     * @return float|null
     */
    public function getDiscountInvoiced()
    {
        return $this->container['discount_invoiced'];
    }

    /**
     * Sets discount_invoiced
     *
     * @param float|null $discount_invoiced Discount invoiced.
     *
     * @return self
     */
    public function setDiscountInvoiced($discount_invoiced)
    {
        $this->container['discount_invoiced'] = $discount_invoiced;

        return $this;
    }

    /**
     * Gets discount_percent
     *
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->container['discount_percent'];
    }

    /**
     * Sets discount_percent
     *
     * @param float|null $discount_percent Discount percent.
     *
     * @return self
     */
    public function setDiscountPercent($discount_percent)
    {
        $this->container['discount_percent'] = $discount_percent;

        return $this;
    }

    /**
     * Gets discount_refunded
     *
     * @return float|null
     */
    public function getDiscountRefunded()
    {
        return $this->container['discount_refunded'];
    }

    /**
     * Sets discount_refunded
     *
     * @param float|null $discount_refunded Discount refunded.
     *
     * @return self
     */
    public function setDiscountRefunded($discount_refunded)
    {
        $this->container['discount_refunded'] = $discount_refunded;

        return $this;
    }

    /**
     * Gets event_id
     *
     * @return int|null
     */
    public function getEventId()
    {
        return $this->container['event_id'];
    }

    /**
     * Sets event_id
     *
     * @param int|null $event_id Event ID.
     *
     * @return self
     */
    public function setEventId($event_id)
    {
        $this->container['event_id'] = $event_id;

        return $this;
    }

    /**
     * Gets ext_order_item_id
     *
     * @return string|null
     */
    public function getExtOrderItemId()
    {
        return $this->container['ext_order_item_id'];
    }

    /**
     * Sets ext_order_item_id
     *
     * @param string|null $ext_order_item_id External order item ID.
     *
     * @return self
     */
    public function setExtOrderItemId($ext_order_item_id)
    {
        $this->container['ext_order_item_id'] = $ext_order_item_id;

        return $this;
    }

    /**
     * Gets free_shipping
     *
     * @return int|null
     */
    public function getFreeShipping()
    {
        return $this->container['free_shipping'];
    }

    /**
     * Sets free_shipping
     *
     * @param int|null $free_shipping Free-shipping flag value.
     *
     * @return self
     */
    public function setFreeShipping($free_shipping)
    {
        $this->container['free_shipping'] = $free_shipping;

        return $this;
    }

    /**
     * Gets gw_base_price
     *
     * @return float|null
     */
    public function getGwBasePrice()
    {
        return $this->container['gw_base_price'];
    }

    /**
     * Sets gw_base_price
     *
     * @param float|null $gw_base_price GW base price.
     *
     * @return self
     */
    public function setGwBasePrice($gw_base_price)
    {
        $this->container['gw_base_price'] = $gw_base_price;

        return $this;
    }

    /**
     * Gets gw_base_price_invoiced
     *
     * @return float|null
     */
    public function getGwBasePriceInvoiced()
    {
        return $this->container['gw_base_price_invoiced'];
    }

    /**
     * Sets gw_base_price_invoiced
     *
     * @param float|null $gw_base_price_invoiced GW base price invoiced.
     *
     * @return self
     */
    public function setGwBasePriceInvoiced($gw_base_price_invoiced)
    {
        $this->container['gw_base_price_invoiced'] = $gw_base_price_invoiced;

        return $this;
    }

    /**
     * Gets gw_base_price_refunded
     *
     * @return float|null
     */
    public function getGwBasePriceRefunded()
    {
        return $this->container['gw_base_price_refunded'];
    }

    /**
     * Sets gw_base_price_refunded
     *
     * @param float|null $gw_base_price_refunded GW base price refunded.
     *
     * @return self
     */
    public function setGwBasePriceRefunded($gw_base_price_refunded)
    {
        $this->container['gw_base_price_refunded'] = $gw_base_price_refunded;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount
     *
     * @return float|null
     */
    public function getGwBaseTaxAmount()
    {
        return $this->container['gw_base_tax_amount'];
    }

    /**
     * Sets gw_base_tax_amount
     *
     * @param float|null $gw_base_tax_amount GW base tax amount.
     *
     * @return self
     */
    public function setGwBaseTaxAmount($gw_base_tax_amount)
    {
        $this->container['gw_base_tax_amount'] = $gw_base_tax_amount;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount_invoiced
     *
     * @return float|null
     */
    public function getGwBaseTaxAmountInvoiced()
    {
        return $this->container['gw_base_tax_amount_invoiced'];
    }

    /**
     * Sets gw_base_tax_amount_invoiced
     *
     * @param float|null $gw_base_tax_amount_invoiced GW base tax amount invoiced.
     *
     * @return self
     */
    public function setGwBaseTaxAmountInvoiced($gw_base_tax_amount_invoiced)
    {
        $this->container['gw_base_tax_amount_invoiced'] = $gw_base_tax_amount_invoiced;

        return $this;
    }

    /**
     * Gets gw_base_tax_amount_refunded
     *
     * @return float|null
     */
    public function getGwBaseTaxAmountRefunded()
    {
        return $this->container['gw_base_tax_amount_refunded'];
    }

    /**
     * Sets gw_base_tax_amount_refunded
     *
     * @param float|null $gw_base_tax_amount_refunded GW base tax amount refunded.
     *
     * @return self
     */
    public function setGwBaseTaxAmountRefunded($gw_base_tax_amount_refunded)
    {
        $this->container['gw_base_tax_amount_refunded'] = $gw_base_tax_amount_refunded;

        return $this;
    }

    /**
     * Gets gw_id
     *
     * @return int|null
     */
    public function getGwId()
    {
        return $this->container['gw_id'];
    }

    /**
     * Sets gw_id
     *
     * @param int|null $gw_id GW ID.
     *
     * @return self
     */
    public function setGwId($gw_id)
    {
        $this->container['gw_id'] = $gw_id;

        return $this;
    }

    /**
     * Gets gw_price
     *
     * @return float|null
     */
    public function getGwPrice()
    {
        return $this->container['gw_price'];
    }

    /**
     * Sets gw_price
     *
     * @param float|null $gw_price GW price.
     *
     * @return self
     */
    public function setGwPrice($gw_price)
    {
        $this->container['gw_price'] = $gw_price;

        return $this;
    }

    /**
     * Gets gw_price_invoiced
     *
     * @return float|null
     */
    public function getGwPriceInvoiced()
    {
        return $this->container['gw_price_invoiced'];
    }

    /**
     * Sets gw_price_invoiced
     *
     * @param float|null $gw_price_invoiced GW price invoiced.
     *
     * @return self
     */
    public function setGwPriceInvoiced($gw_price_invoiced)
    {
        $this->container['gw_price_invoiced'] = $gw_price_invoiced;

        return $this;
    }

    /**
     * Gets gw_price_refunded
     *
     * @return float|null
     */
    public function getGwPriceRefunded()
    {
        return $this->container['gw_price_refunded'];
    }

    /**
     * Sets gw_price_refunded
     *
     * @param float|null $gw_price_refunded GW price refunded.
     *
     * @return self
     */
    public function setGwPriceRefunded($gw_price_refunded)
    {
        $this->container['gw_price_refunded'] = $gw_price_refunded;

        return $this;
    }

    /**
     * Gets gw_tax_amount
     *
     * @return float|null
     */
    public function getGwTaxAmount()
    {
        return $this->container['gw_tax_amount'];
    }

    /**
     * Sets gw_tax_amount
     *
     * @param float|null $gw_tax_amount GW tax amount.
     *
     * @return self
     */
    public function setGwTaxAmount($gw_tax_amount)
    {
        $this->container['gw_tax_amount'] = $gw_tax_amount;

        return $this;
    }

    /**
     * Gets gw_tax_amount_invoiced
     *
     * @return float|null
     */
    public function getGwTaxAmountInvoiced()
    {
        return $this->container['gw_tax_amount_invoiced'];
    }

    /**
     * Sets gw_tax_amount_invoiced
     *
     * @param float|null $gw_tax_amount_invoiced GW tax amount invoiced.
     *
     * @return self
     */
    public function setGwTaxAmountInvoiced($gw_tax_amount_invoiced)
    {
        $this->container['gw_tax_amount_invoiced'] = $gw_tax_amount_invoiced;

        return $this;
    }

    /**
     * Gets gw_tax_amount_refunded
     *
     * @return float|null
     */
    public function getGwTaxAmountRefunded()
    {
        return $this->container['gw_tax_amount_refunded'];
    }

    /**
     * Sets gw_tax_amount_refunded
     *
     * @param float|null $gw_tax_amount_refunded GW tax amount refunded.
     *
     * @return self
     */
    public function setGwTaxAmountRefunded($gw_tax_amount_refunded)
    {
        $this->container['gw_tax_amount_refunded'] = $gw_tax_amount_refunded;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationAmount()
    {
        return $this->container['discount_tax_compensation_amount'];
    }

    /**
     * Sets discount_tax_compensation_amount
     *
     * @param float|null $discount_tax_compensation_amount Discount tax compensation amount.
     *
     * @return self
     */
    public function setDiscountTaxCompensationAmount($discount_tax_compensation_amount)
    {
        $this->container['discount_tax_compensation_amount'] = $discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_canceled
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationCanceled()
    {
        return $this->container['discount_tax_compensation_canceled'];
    }

    /**
     * Sets discount_tax_compensation_canceled
     *
     * @param float|null $discount_tax_compensation_canceled Discount tax compensation canceled.
     *
     * @return self
     */
    public function setDiscountTaxCompensationCanceled($discount_tax_compensation_canceled)
    {
        $this->container['discount_tax_compensation_canceled'] = $discount_tax_compensation_canceled;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_invoiced
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationInvoiced()
    {
        return $this->container['discount_tax_compensation_invoiced'];
    }

    /**
     * Sets discount_tax_compensation_invoiced
     *
     * @param float|null $discount_tax_compensation_invoiced Discount tax compensation invoiced.
     *
     * @return self
     */
    public function setDiscountTaxCompensationInvoiced($discount_tax_compensation_invoiced)
    {
        $this->container['discount_tax_compensation_invoiced'] = $discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_refunded
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationRefunded()
    {
        return $this->container['discount_tax_compensation_refunded'];
    }

    /**
     * Sets discount_tax_compensation_refunded
     *
     * @param float|null $discount_tax_compensation_refunded Discount tax compensation refunded.
     *
     * @return self
     */
    public function setDiscountTaxCompensationRefunded($discount_tax_compensation_refunded)
    {
        $this->container['discount_tax_compensation_refunded'] = $discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets is_qty_decimal
     *
     * @return int|null
     */
    public function getIsQtyDecimal()
    {
        return $this->container['is_qty_decimal'];
    }

    /**
     * Sets is_qty_decimal
     *
     * @param int|null $is_qty_decimal Is-quantity-decimal flag value.
     *
     * @return self
     */
    public function setIsQtyDecimal($is_qty_decimal)
    {
        $this->container['is_qty_decimal'] = $is_qty_decimal;

        return $this;
    }

    /**
     * Gets is_virtual
     *
     * @return int|null
     */
    public function getIsVirtual()
    {
        return $this->container['is_virtual'];
    }

    /**
     * Sets is_virtual
     *
     * @param int|null $is_virtual Is-virtual flag value.
     *
     * @return self
     */
    public function setIsVirtual($is_virtual)
    {
        $this->container['is_virtual'] = $is_virtual;

        return $this;
    }

    /**
     * Gets item_id
     *
     * @return int|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int|null $item_id Item ID.
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets locked_do_invoice
     *
     * @return int|null
     */
    public function getLockedDoInvoice()
    {
        return $this->container['locked_do_invoice'];
    }

    /**
     * Sets locked_do_invoice
     *
     * @param int|null $locked_do_invoice Locked DO invoice flag value.
     *
     * @return self
     */
    public function setLockedDoInvoice($locked_do_invoice)
    {
        $this->container['locked_do_invoice'] = $locked_do_invoice;

        return $this;
    }

    /**
     * Gets locked_do_ship
     *
     * @return int|null
     */
    public function getLockedDoShip()
    {
        return $this->container['locked_do_ship'];
    }

    /**
     * Sets locked_do_ship
     *
     * @param int|null $locked_do_ship Locked DO ship flag value.
     *
     * @return self
     */
    public function setLockedDoShip($locked_do_ship)
    {
        $this->container['locked_do_ship'] = $locked_do_ship;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets no_discount
     *
     * @return int|null
     */
    public function getNoDiscount()
    {
        return $this->container['no_discount'];
    }

    /**
     * Sets no_discount
     *
     * @param int|null $no_discount No-discount flag value.
     *
     * @return self
     */
    public function setNoDiscount($no_discount)
    {
        $this->container['no_discount'] = $no_discount;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return int|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param int|null $order_id Order ID.
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets original_price
     *
     * @return float|null
     */
    public function getOriginalPrice()
    {
        return $this->container['original_price'];
    }

    /**
     * Sets original_price
     *
     * @param float|null $original_price Original price.
     *
     * @return self
     */
    public function setOriginalPrice($original_price)
    {
        $this->container['original_price'] = $original_price;

        return $this;
    }

    /**
     * Gets parent_item_id
     *
     * @return int|null
     */
    public function getParentItemId()
    {
        return $this->container['parent_item_id'];
    }

    /**
     * Sets parent_item_id
     *
     * @param int|null $parent_item_id Parent item ID.
     *
     * @return self
     */
    public function setParentItemId($parent_item_id)
    {
        $this->container['parent_item_id'] = $parent_item_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price Price.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets price_incl_tax
     *
     * @return float|null
     */
    public function getPriceInclTax()
    {
        return $this->container['price_incl_tax'];
    }

    /**
     * Sets price_incl_tax
     *
     * @param float|null $price_incl_tax Price including tax.
     *
     * @return self
     */
    public function setPriceInclTax($price_incl_tax)
    {
        $this->container['price_incl_tax'] = $price_incl_tax;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id Product ID.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets product_type
     *
     * @return string|null
     */
    public function getProductType()
    {
        return $this->container['product_type'];
    }

    /**
     * Sets product_type
     *
     * @param string|null $product_type Product type.
     *
     * @return self
     */
    public function setProductType($product_type)
    {
        $this->container['product_type'] = $product_type;

        return $this;
    }

    /**
     * Gets qty_backordered
     *
     * @return float|null
     */
    public function getQtyBackordered()
    {
        return $this->container['qty_backordered'];
    }

    /**
     * Sets qty_backordered
     *
     * @param float|null $qty_backordered Quantity backordered.
     *
     * @return self
     */
    public function setQtyBackordered($qty_backordered)
    {
        $this->container['qty_backordered'] = $qty_backordered;

        return $this;
    }

    /**
     * Gets qty_canceled
     *
     * @return float|null
     */
    public function getQtyCanceled()
    {
        return $this->container['qty_canceled'];
    }

    /**
     * Sets qty_canceled
     *
     * @param float|null $qty_canceled Quantity canceled.
     *
     * @return self
     */
    public function setQtyCanceled($qty_canceled)
    {
        $this->container['qty_canceled'] = $qty_canceled;

        return $this;
    }

    /**
     * Gets qty_invoiced
     *
     * @return float|null
     */
    public function getQtyInvoiced()
    {
        return $this->container['qty_invoiced'];
    }

    /**
     * Sets qty_invoiced
     *
     * @param float|null $qty_invoiced Quantity invoiced.
     *
     * @return self
     */
    public function setQtyInvoiced($qty_invoiced)
    {
        $this->container['qty_invoiced'] = $qty_invoiced;

        return $this;
    }

    /**
     * Gets qty_ordered
     *
     * @return float|null
     */
    public function getQtyOrdered()
    {
        return $this->container['qty_ordered'];
    }

    /**
     * Sets qty_ordered
     *
     * @param float|null $qty_ordered Quantity ordered.
     *
     * @return self
     */
    public function setQtyOrdered($qty_ordered)
    {
        $this->container['qty_ordered'] = $qty_ordered;

        return $this;
    }

    /**
     * Gets qty_refunded
     *
     * @return float|null
     */
    public function getQtyRefunded()
    {
        return $this->container['qty_refunded'];
    }

    /**
     * Sets qty_refunded
     *
     * @param float|null $qty_refunded Quantity refunded.
     *
     * @return self
     */
    public function setQtyRefunded($qty_refunded)
    {
        $this->container['qty_refunded'] = $qty_refunded;

        return $this;
    }

    /**
     * Gets qty_returned
     *
     * @return float|null
     */
    public function getQtyReturned()
    {
        return $this->container['qty_returned'];
    }

    /**
     * Sets qty_returned
     *
     * @param float|null $qty_returned Quantity returned.
     *
     * @return self
     */
    public function setQtyReturned($qty_returned)
    {
        $this->container['qty_returned'] = $qty_returned;

        return $this;
    }

    /**
     * Gets qty_shipped
     *
     * @return float|null
     */
    public function getQtyShipped()
    {
        return $this->container['qty_shipped'];
    }

    /**
     * Sets qty_shipped
     *
     * @param float|null $qty_shipped Quantity shipped.
     *
     * @return self
     */
    public function setQtyShipped($qty_shipped)
    {
        $this->container['qty_shipped'] = $qty_shipped;

        return $this;
    }

    /**
     * Gets quote_item_id
     *
     * @return int|null
     */
    public function getQuoteItemId()
    {
        return $this->container['quote_item_id'];
    }

    /**
     * Sets quote_item_id
     *
     * @param int|null $quote_item_id Quote item ID.
     *
     * @return self
     */
    public function setQuoteItemId($quote_item_id)
    {
        $this->container['quote_item_id'] = $quote_item_id;

        return $this;
    }

    /**
     * Gets row_invoiced
     *
     * @return float|null
     */
    public function getRowInvoiced()
    {
        return $this->container['row_invoiced'];
    }

    /**
     * Sets row_invoiced
     *
     * @param float|null $row_invoiced Row invoiced.
     *
     * @return self
     */
    public function setRowInvoiced($row_invoiced)
    {
        $this->container['row_invoiced'] = $row_invoiced;

        return $this;
    }

    /**
     * Gets row_total
     *
     * @return float|null
     */
    public function getRowTotal()
    {
        return $this->container['row_total'];
    }

    /**
     * Sets row_total
     *
     * @param float|null $row_total Row total.
     *
     * @return self
     */
    public function setRowTotal($row_total)
    {
        $this->container['row_total'] = $row_total;

        return $this;
    }

    /**
     * Gets row_total_incl_tax
     *
     * @return float|null
     */
    public function getRowTotalInclTax()
    {
        return $this->container['row_total_incl_tax'];
    }

    /**
     * Sets row_total_incl_tax
     *
     * @param float|null $row_total_incl_tax Row total including tax.
     *
     * @return self
     */
    public function setRowTotalInclTax($row_total_incl_tax)
    {
        $this->container['row_total_incl_tax'] = $row_total_incl_tax;

        return $this;
    }

    /**
     * Gets row_weight
     *
     * @return float|null
     */
    public function getRowWeight()
    {
        return $this->container['row_weight'];
    }

    /**
     * Sets row_weight
     *
     * @param float|null $row_weight Row weight.
     *
     * @return self
     */
    public function setRowWeight($row_weight)
    {
        $this->container['row_weight'] = $row_weight;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku SKU.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int|null
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int|null $store_id Store ID.
     *
     * @return self
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float|null $tax_amount Tax amount.
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_before_discount
     *
     * @return float|null
     */
    public function getTaxBeforeDiscount()
    {
        return $this->container['tax_before_discount'];
    }

    /**
     * Sets tax_before_discount
     *
     * @param float|null $tax_before_discount Tax before discount.
     *
     * @return self
     */
    public function setTaxBeforeDiscount($tax_before_discount)
    {
        $this->container['tax_before_discount'] = $tax_before_discount;

        return $this;
    }

    /**
     * Gets tax_canceled
     *
     * @return float|null
     */
    public function getTaxCanceled()
    {
        return $this->container['tax_canceled'];
    }

    /**
     * Sets tax_canceled
     *
     * @param float|null $tax_canceled Tax canceled.
     *
     * @return self
     */
    public function setTaxCanceled($tax_canceled)
    {
        $this->container['tax_canceled'] = $tax_canceled;

        return $this;
    }

    /**
     * Gets tax_invoiced
     *
     * @return float|null
     */
    public function getTaxInvoiced()
    {
        return $this->container['tax_invoiced'];
    }

    /**
     * Sets tax_invoiced
     *
     * @param float|null $tax_invoiced Tax invoiced.
     *
     * @return self
     */
    public function setTaxInvoiced($tax_invoiced)
    {
        $this->container['tax_invoiced'] = $tax_invoiced;

        return $this;
    }

    /**
     * Gets tax_percent
     *
     * @return float|null
     */
    public function getTaxPercent()
    {
        return $this->container['tax_percent'];
    }

    /**
     * Sets tax_percent
     *
     * @param float|null $tax_percent Tax percent.
     *
     * @return self
     */
    public function setTaxPercent($tax_percent)
    {
        $this->container['tax_percent'] = $tax_percent;

        return $this;
    }

    /**
     * Gets tax_refunded
     *
     * @return float|null
     */
    public function getTaxRefunded()
    {
        return $this->container['tax_refunded'];
    }

    /**
     * Sets tax_refunded
     *
     * @param float|null $tax_refunded Tax refunded.
     *
     * @return self
     */
    public function setTaxRefunded($tax_refunded)
    {
        $this->container['tax_refunded'] = $tax_refunded;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Updated-at timestamp.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets weee_tax_applied
     *
     * @return string|null
     */
    public function getWeeeTaxApplied()
    {
        return $this->container['weee_tax_applied'];
    }

    /**
     * Sets weee_tax_applied
     *
     * @param string|null $weee_tax_applied WEEE tax applied.
     *
     * @return self
     */
    public function setWeeeTaxApplied($weee_tax_applied)
    {
        $this->container['weee_tax_applied'] = $weee_tax_applied;

        return $this;
    }

    /**
     * Gets weee_tax_applied_amount
     *
     * @return float|null
     */
    public function getWeeeTaxAppliedAmount()
    {
        return $this->container['weee_tax_applied_amount'];
    }

    /**
     * Sets weee_tax_applied_amount
     *
     * @param float|null $weee_tax_applied_amount WEEE tax applied amount.
     *
     * @return self
     */
    public function setWeeeTaxAppliedAmount($weee_tax_applied_amount)
    {
        $this->container['weee_tax_applied_amount'] = $weee_tax_applied_amount;

        return $this;
    }

    /**
     * Gets weee_tax_applied_row_amount
     *
     * @return float|null
     */
    public function getWeeeTaxAppliedRowAmount()
    {
        return $this->container['weee_tax_applied_row_amount'];
    }

    /**
     * Sets weee_tax_applied_row_amount
     *
     * @param float|null $weee_tax_applied_row_amount WEEE tax applied row amount.
     *
     * @return self
     */
    public function setWeeeTaxAppliedRowAmount($weee_tax_applied_row_amount)
    {
        $this->container['weee_tax_applied_row_amount'] = $weee_tax_applied_row_amount;

        return $this;
    }

    /**
     * Gets weee_tax_disposition
     *
     * @return float|null
     */
    public function getWeeeTaxDisposition()
    {
        return $this->container['weee_tax_disposition'];
    }

    /**
     * Sets weee_tax_disposition
     *
     * @param float|null $weee_tax_disposition WEEE tax disposition.
     *
     * @return self
     */
    public function setWeeeTaxDisposition($weee_tax_disposition)
    {
        $this->container['weee_tax_disposition'] = $weee_tax_disposition;

        return $this;
    }

    /**
     * Gets weee_tax_row_disposition
     *
     * @return float|null
     */
    public function getWeeeTaxRowDisposition()
    {
        return $this->container['weee_tax_row_disposition'];
    }

    /**
     * Sets weee_tax_row_disposition
     *
     * @param float|null $weee_tax_row_disposition WEEE tax row disposition.
     *
     * @return self
     */
    public function setWeeeTaxRowDisposition($weee_tax_row_disposition)
    {
        $this->container['weee_tax_row_disposition'] = $weee_tax_row_disposition;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Weight.
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets parent_item
     *
     * @return \Magento2\Model\SalesDataOrderItemInterface|null
     */
    public function getParentItem()
    {
        return $this->container['parent_item'];
    }

    /**
     * Sets parent_item
     *
     * @param \Magento2\Model\SalesDataOrderItemInterface|null $parent_item parent_item
     *
     * @return self
     */
    public function setParentItem($parent_item)
    {
        $this->container['parent_item'] = $parent_item;

        return $this;
    }

    /**
     * Gets product_option
     *
     * @return \Magento2\Model\CatalogDataProductOptionInterface|null
     */
    public function getProductOption()
    {
        return $this->container['product_option'];
    }

    /**
     * Sets product_option
     *
     * @param \Magento2\Model\CatalogDataProductOptionInterface|null $product_option product_option
     *
     * @return self
     */
    public function setProductOption($product_option)
    {
        $this->container['product_option'] = $product_option;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Magento2\Model\SalesDataOrderItemExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Magento2\Model\SalesDataOrderItemExtensionInterface|null $extension_attributes extension_attributes
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


