<?php
/**
 * SalesDataOrderInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * SalesDataOrderInterface Class Doc Comment
 *
 * @category Class
 * @description Order interface. An order is a document that a web store issues to a customer. Magento generates a sales order that lists the product items, billing and shipping addresses, and shipping and payment methods. A corresponding external document, known as a purchase order, is emailed to the customer.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class SalesDataOrderInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'sales-data-order-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'adjustment_negative' => 'float',
        'adjustment_positive' => 'float',
        'applied_rule_ids' => 'string',
        'base_adjustment_negative' => 'float',
        'base_adjustment_positive' => 'float',
        'base_currency_code' => 'string',
        'base_discount_amount' => 'float',
        'base_discount_canceled' => 'float',
        'base_discount_invoiced' => 'float',
        'base_discount_refunded' => 'float',
        'base_grand_total' => 'float',
        'base_discount_tax_compensation_amount' => 'float',
        'base_discount_tax_compensation_invoiced' => 'float',
        'base_discount_tax_compensation_refunded' => 'float',
        'base_shipping_amount' => 'float',
        'base_shipping_canceled' => 'float',
        'base_shipping_discount_amount' => 'float',
        'base_shipping_discount_tax_compensation_amnt' => 'float',
        'base_shipping_incl_tax' => 'float',
        'base_shipping_invoiced' => 'float',
        'base_shipping_refunded' => 'float',
        'base_shipping_tax_amount' => 'float',
        'base_shipping_tax_refunded' => 'float',
        'base_subtotal' => 'float',
        'base_subtotal_canceled' => 'float',
        'base_subtotal_incl_tax' => 'float',
        'base_subtotal_invoiced' => 'float',
        'base_subtotal_refunded' => 'float',
        'base_tax_amount' => 'float',
        'base_tax_canceled' => 'float',
        'base_tax_invoiced' => 'float',
        'base_tax_refunded' => 'float',
        'base_total_canceled' => 'float',
        'base_total_due' => 'float',
        'base_total_invoiced' => 'float',
        'base_total_invoiced_cost' => 'float',
        'base_total_offline_refunded' => 'float',
        'base_total_online_refunded' => 'float',
        'base_total_paid' => 'float',
        'base_total_qty_ordered' => 'float',
        'base_total_refunded' => 'float',
        'base_to_global_rate' => 'float',
        'base_to_order_rate' => 'float',
        'billing_address_id' => 'int',
        'can_ship_partially' => 'int',
        'can_ship_partially_item' => 'int',
        'coupon_code' => 'string',
        'created_at' => 'string',
        'customer_dob' => 'string',
        'customer_email' => 'string',
        'customer_firstname' => 'string',
        'customer_gender' => 'int',
        'customer_group_id' => 'int',
        'customer_id' => 'int',
        'customer_is_guest' => 'int',
        'customer_lastname' => 'string',
        'customer_middlename' => 'string',
        'customer_note' => 'string',
        'customer_note_notify' => 'int',
        'customer_prefix' => 'string',
        'customer_suffix' => 'string',
        'customer_taxvat' => 'string',
        'discount_amount' => 'float',
        'discount_canceled' => 'float',
        'discount_description' => 'string',
        'discount_invoiced' => 'float',
        'discount_refunded' => 'float',
        'edit_increment' => 'int',
        'email_sent' => 'int',
        'entity_id' => 'int',
        'ext_customer_id' => 'string',
        'ext_order_id' => 'string',
        'forced_shipment_with_invoice' => 'int',
        'global_currency_code' => 'string',
        'grand_total' => 'float',
        'discount_tax_compensation_amount' => 'float',
        'discount_tax_compensation_invoiced' => 'float',
        'discount_tax_compensation_refunded' => 'float',
        'hold_before_state' => 'string',
        'hold_before_status' => 'string',
        'increment_id' => 'string',
        'is_virtual' => 'int',
        'order_currency_code' => 'string',
        'original_increment_id' => 'string',
        'payment_authorization_amount' => 'float',
        'payment_auth_expiration' => 'int',
        'protect_code' => 'string',
        'quote_address_id' => 'int',
        'quote_id' => 'int',
        'relation_child_id' => 'string',
        'relation_child_real_id' => 'string',
        'relation_parent_id' => 'string',
        'relation_parent_real_id' => 'string',
        'remote_ip' => 'string',
        'shipping_amount' => 'float',
        'shipping_canceled' => 'float',
        'shipping_description' => 'string',
        'shipping_discount_amount' => 'float',
        'shipping_discount_tax_compensation_amount' => 'float',
        'shipping_incl_tax' => 'float',
        'shipping_invoiced' => 'float',
        'shipping_refunded' => 'float',
        'shipping_tax_amount' => 'float',
        'shipping_tax_refunded' => 'float',
        'state' => 'string',
        'status' => 'string',
        'store_currency_code' => 'string',
        'store_id' => 'int',
        'store_name' => 'string',
        'store_to_base_rate' => 'float',
        'store_to_order_rate' => 'float',
        'subtotal' => 'float',
        'subtotal_canceled' => 'float',
        'subtotal_incl_tax' => 'float',
        'subtotal_invoiced' => 'float',
        'subtotal_refunded' => 'float',
        'tax_amount' => 'float',
        'tax_canceled' => 'float',
        'tax_invoiced' => 'float',
        'tax_refunded' => 'float',
        'total_canceled' => 'float',
        'total_due' => 'float',
        'total_invoiced' => 'float',
        'total_item_count' => 'int',
        'total_offline_refunded' => 'float',
        'total_online_refunded' => 'float',
        'total_paid' => 'float',
        'total_qty_ordered' => 'float',
        'total_refunded' => 'float',
        'updated_at' => 'string',
        'weight' => 'float',
        'x_forwarded_for' => 'string',
        'items' => '\Magento2\Model\SalesDataOrderItemInterface[]',
        'billing_address' => '\Magento2\Model\SalesDataOrderAddressInterface',
        'payment' => '\Magento2\Model\SalesDataOrderPaymentInterface',
        'status_histories' => '\Magento2\Model\SalesDataOrderStatusHistoryInterface[]',
        'extension_attributes' => '\Magento2\Model\SalesDataOrderExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'adjustment_negative' => null,
        'adjustment_positive' => null,
        'applied_rule_ids' => null,
        'base_adjustment_negative' => null,
        'base_adjustment_positive' => null,
        'base_currency_code' => null,
        'base_discount_amount' => null,
        'base_discount_canceled' => null,
        'base_discount_invoiced' => null,
        'base_discount_refunded' => null,
        'base_grand_total' => null,
        'base_discount_tax_compensation_amount' => null,
        'base_discount_tax_compensation_invoiced' => null,
        'base_discount_tax_compensation_refunded' => null,
        'base_shipping_amount' => null,
        'base_shipping_canceled' => null,
        'base_shipping_discount_amount' => null,
        'base_shipping_discount_tax_compensation_amnt' => null,
        'base_shipping_incl_tax' => null,
        'base_shipping_invoiced' => null,
        'base_shipping_refunded' => null,
        'base_shipping_tax_amount' => null,
        'base_shipping_tax_refunded' => null,
        'base_subtotal' => null,
        'base_subtotal_canceled' => null,
        'base_subtotal_incl_tax' => null,
        'base_subtotal_invoiced' => null,
        'base_subtotal_refunded' => null,
        'base_tax_amount' => null,
        'base_tax_canceled' => null,
        'base_tax_invoiced' => null,
        'base_tax_refunded' => null,
        'base_total_canceled' => null,
        'base_total_due' => null,
        'base_total_invoiced' => null,
        'base_total_invoiced_cost' => null,
        'base_total_offline_refunded' => null,
        'base_total_online_refunded' => null,
        'base_total_paid' => null,
        'base_total_qty_ordered' => null,
        'base_total_refunded' => null,
        'base_to_global_rate' => null,
        'base_to_order_rate' => null,
        'billing_address_id' => null,
        'can_ship_partially' => null,
        'can_ship_partially_item' => null,
        'coupon_code' => null,
        'created_at' => null,
        'customer_dob' => null,
        'customer_email' => null,
        'customer_firstname' => null,
        'customer_gender' => null,
        'customer_group_id' => null,
        'customer_id' => null,
        'customer_is_guest' => null,
        'customer_lastname' => null,
        'customer_middlename' => null,
        'customer_note' => null,
        'customer_note_notify' => null,
        'customer_prefix' => null,
        'customer_suffix' => null,
        'customer_taxvat' => null,
        'discount_amount' => null,
        'discount_canceled' => null,
        'discount_description' => null,
        'discount_invoiced' => null,
        'discount_refunded' => null,
        'edit_increment' => null,
        'email_sent' => null,
        'entity_id' => null,
        'ext_customer_id' => null,
        'ext_order_id' => null,
        'forced_shipment_with_invoice' => null,
        'global_currency_code' => null,
        'grand_total' => null,
        'discount_tax_compensation_amount' => null,
        'discount_tax_compensation_invoiced' => null,
        'discount_tax_compensation_refunded' => null,
        'hold_before_state' => null,
        'hold_before_status' => null,
        'increment_id' => null,
        'is_virtual' => null,
        'order_currency_code' => null,
        'original_increment_id' => null,
        'payment_authorization_amount' => null,
        'payment_auth_expiration' => null,
        'protect_code' => null,
        'quote_address_id' => null,
        'quote_id' => null,
        'relation_child_id' => null,
        'relation_child_real_id' => null,
        'relation_parent_id' => null,
        'relation_parent_real_id' => null,
        'remote_ip' => null,
        'shipping_amount' => null,
        'shipping_canceled' => null,
        'shipping_description' => null,
        'shipping_discount_amount' => null,
        'shipping_discount_tax_compensation_amount' => null,
        'shipping_incl_tax' => null,
        'shipping_invoiced' => null,
        'shipping_refunded' => null,
        'shipping_tax_amount' => null,
        'shipping_tax_refunded' => null,
        'state' => null,
        'status' => null,
        'store_currency_code' => null,
        'store_id' => null,
        'store_name' => null,
        'store_to_base_rate' => null,
        'store_to_order_rate' => null,
        'subtotal' => null,
        'subtotal_canceled' => null,
        'subtotal_incl_tax' => null,
        'subtotal_invoiced' => null,
        'subtotal_refunded' => null,
        'tax_amount' => null,
        'tax_canceled' => null,
        'tax_invoiced' => null,
        'tax_refunded' => null,
        'total_canceled' => null,
        'total_due' => null,
        'total_invoiced' => null,
        'total_item_count' => null,
        'total_offline_refunded' => null,
        'total_online_refunded' => null,
        'total_paid' => null,
        'total_qty_ordered' => null,
        'total_refunded' => null,
        'updated_at' => null,
        'weight' => null,
        'x_forwarded_for' => null,
        'items' => null,
        'billing_address' => null,
        'payment' => null,
        'status_histories' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'adjustment_negative' => 'adjustment_negative',
        'adjustment_positive' => 'adjustment_positive',
        'applied_rule_ids' => 'applied_rule_ids',
        'base_adjustment_negative' => 'base_adjustment_negative',
        'base_adjustment_positive' => 'base_adjustment_positive',
        'base_currency_code' => 'base_currency_code',
        'base_discount_amount' => 'base_discount_amount',
        'base_discount_canceled' => 'base_discount_canceled',
        'base_discount_invoiced' => 'base_discount_invoiced',
        'base_discount_refunded' => 'base_discount_refunded',
        'base_grand_total' => 'base_grand_total',
        'base_discount_tax_compensation_amount' => 'base_discount_tax_compensation_amount',
        'base_discount_tax_compensation_invoiced' => 'base_discount_tax_compensation_invoiced',
        'base_discount_tax_compensation_refunded' => 'base_discount_tax_compensation_refunded',
        'base_shipping_amount' => 'base_shipping_amount',
        'base_shipping_canceled' => 'base_shipping_canceled',
        'base_shipping_discount_amount' => 'base_shipping_discount_amount',
        'base_shipping_discount_tax_compensation_amnt' => 'base_shipping_discount_tax_compensation_amnt',
        'base_shipping_incl_tax' => 'base_shipping_incl_tax',
        'base_shipping_invoiced' => 'base_shipping_invoiced',
        'base_shipping_refunded' => 'base_shipping_refunded',
        'base_shipping_tax_amount' => 'base_shipping_tax_amount',
        'base_shipping_tax_refunded' => 'base_shipping_tax_refunded',
        'base_subtotal' => 'base_subtotal',
        'base_subtotal_canceled' => 'base_subtotal_canceled',
        'base_subtotal_incl_tax' => 'base_subtotal_incl_tax',
        'base_subtotal_invoiced' => 'base_subtotal_invoiced',
        'base_subtotal_refunded' => 'base_subtotal_refunded',
        'base_tax_amount' => 'base_tax_amount',
        'base_tax_canceled' => 'base_tax_canceled',
        'base_tax_invoiced' => 'base_tax_invoiced',
        'base_tax_refunded' => 'base_tax_refunded',
        'base_total_canceled' => 'base_total_canceled',
        'base_total_due' => 'base_total_due',
        'base_total_invoiced' => 'base_total_invoiced',
        'base_total_invoiced_cost' => 'base_total_invoiced_cost',
        'base_total_offline_refunded' => 'base_total_offline_refunded',
        'base_total_online_refunded' => 'base_total_online_refunded',
        'base_total_paid' => 'base_total_paid',
        'base_total_qty_ordered' => 'base_total_qty_ordered',
        'base_total_refunded' => 'base_total_refunded',
        'base_to_global_rate' => 'base_to_global_rate',
        'base_to_order_rate' => 'base_to_order_rate',
        'billing_address_id' => 'billing_address_id',
        'can_ship_partially' => 'can_ship_partially',
        'can_ship_partially_item' => 'can_ship_partially_item',
        'coupon_code' => 'coupon_code',
        'created_at' => 'created_at',
        'customer_dob' => 'customer_dob',
        'customer_email' => 'customer_email',
        'customer_firstname' => 'customer_firstname',
        'customer_gender' => 'customer_gender',
        'customer_group_id' => 'customer_group_id',
        'customer_id' => 'customer_id',
        'customer_is_guest' => 'customer_is_guest',
        'customer_lastname' => 'customer_lastname',
        'customer_middlename' => 'customer_middlename',
        'customer_note' => 'customer_note',
        'customer_note_notify' => 'customer_note_notify',
        'customer_prefix' => 'customer_prefix',
        'customer_suffix' => 'customer_suffix',
        'customer_taxvat' => 'customer_taxvat',
        'discount_amount' => 'discount_amount',
        'discount_canceled' => 'discount_canceled',
        'discount_description' => 'discount_description',
        'discount_invoiced' => 'discount_invoiced',
        'discount_refunded' => 'discount_refunded',
        'edit_increment' => 'edit_increment',
        'email_sent' => 'email_sent',
        'entity_id' => 'entity_id',
        'ext_customer_id' => 'ext_customer_id',
        'ext_order_id' => 'ext_order_id',
        'forced_shipment_with_invoice' => 'forced_shipment_with_invoice',
        'global_currency_code' => 'global_currency_code',
        'grand_total' => 'grand_total',
        'discount_tax_compensation_amount' => 'discount_tax_compensation_amount',
        'discount_tax_compensation_invoiced' => 'discount_tax_compensation_invoiced',
        'discount_tax_compensation_refunded' => 'discount_tax_compensation_refunded',
        'hold_before_state' => 'hold_before_state',
        'hold_before_status' => 'hold_before_status',
        'increment_id' => 'increment_id',
        'is_virtual' => 'is_virtual',
        'order_currency_code' => 'order_currency_code',
        'original_increment_id' => 'original_increment_id',
        'payment_authorization_amount' => 'payment_authorization_amount',
        'payment_auth_expiration' => 'payment_auth_expiration',
        'protect_code' => 'protect_code',
        'quote_address_id' => 'quote_address_id',
        'quote_id' => 'quote_id',
        'relation_child_id' => 'relation_child_id',
        'relation_child_real_id' => 'relation_child_real_id',
        'relation_parent_id' => 'relation_parent_id',
        'relation_parent_real_id' => 'relation_parent_real_id',
        'remote_ip' => 'remote_ip',
        'shipping_amount' => 'shipping_amount',
        'shipping_canceled' => 'shipping_canceled',
        'shipping_description' => 'shipping_description',
        'shipping_discount_amount' => 'shipping_discount_amount',
        'shipping_discount_tax_compensation_amount' => 'shipping_discount_tax_compensation_amount',
        'shipping_incl_tax' => 'shipping_incl_tax',
        'shipping_invoiced' => 'shipping_invoiced',
        'shipping_refunded' => 'shipping_refunded',
        'shipping_tax_amount' => 'shipping_tax_amount',
        'shipping_tax_refunded' => 'shipping_tax_refunded',
        'state' => 'state',
        'status' => 'status',
        'store_currency_code' => 'store_currency_code',
        'store_id' => 'store_id',
        'store_name' => 'store_name',
        'store_to_base_rate' => 'store_to_base_rate',
        'store_to_order_rate' => 'store_to_order_rate',
        'subtotal' => 'subtotal',
        'subtotal_canceled' => 'subtotal_canceled',
        'subtotal_incl_tax' => 'subtotal_incl_tax',
        'subtotal_invoiced' => 'subtotal_invoiced',
        'subtotal_refunded' => 'subtotal_refunded',
        'tax_amount' => 'tax_amount',
        'tax_canceled' => 'tax_canceled',
        'tax_invoiced' => 'tax_invoiced',
        'tax_refunded' => 'tax_refunded',
        'total_canceled' => 'total_canceled',
        'total_due' => 'total_due',
        'total_invoiced' => 'total_invoiced',
        'total_item_count' => 'total_item_count',
        'total_offline_refunded' => 'total_offline_refunded',
        'total_online_refunded' => 'total_online_refunded',
        'total_paid' => 'total_paid',
        'total_qty_ordered' => 'total_qty_ordered',
        'total_refunded' => 'total_refunded',
        'updated_at' => 'updated_at',
        'weight' => 'weight',
        'x_forwarded_for' => 'x_forwarded_for',
        'items' => 'items',
        'billing_address' => 'billing_address',
        'payment' => 'payment',
        'status_histories' => 'status_histories',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'adjustment_negative' => 'setAdjustmentNegative',
        'adjustment_positive' => 'setAdjustmentPositive',
        'applied_rule_ids' => 'setAppliedRuleIds',
        'base_adjustment_negative' => 'setBaseAdjustmentNegative',
        'base_adjustment_positive' => 'setBaseAdjustmentPositive',
        'base_currency_code' => 'setBaseCurrencyCode',
        'base_discount_amount' => 'setBaseDiscountAmount',
        'base_discount_canceled' => 'setBaseDiscountCanceled',
        'base_discount_invoiced' => 'setBaseDiscountInvoiced',
        'base_discount_refunded' => 'setBaseDiscountRefunded',
        'base_grand_total' => 'setBaseGrandTotal',
        'base_discount_tax_compensation_amount' => 'setBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'setBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'setBaseDiscountTaxCompensationRefunded',
        'base_shipping_amount' => 'setBaseShippingAmount',
        'base_shipping_canceled' => 'setBaseShippingCanceled',
        'base_shipping_discount_amount' => 'setBaseShippingDiscountAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'setBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'setBaseShippingInclTax',
        'base_shipping_invoiced' => 'setBaseShippingInvoiced',
        'base_shipping_refunded' => 'setBaseShippingRefunded',
        'base_shipping_tax_amount' => 'setBaseShippingTaxAmount',
        'base_shipping_tax_refunded' => 'setBaseShippingTaxRefunded',
        'base_subtotal' => 'setBaseSubtotal',
        'base_subtotal_canceled' => 'setBaseSubtotalCanceled',
        'base_subtotal_incl_tax' => 'setBaseSubtotalInclTax',
        'base_subtotal_invoiced' => 'setBaseSubtotalInvoiced',
        'base_subtotal_refunded' => 'setBaseSubtotalRefunded',
        'base_tax_amount' => 'setBaseTaxAmount',
        'base_tax_canceled' => 'setBaseTaxCanceled',
        'base_tax_invoiced' => 'setBaseTaxInvoiced',
        'base_tax_refunded' => 'setBaseTaxRefunded',
        'base_total_canceled' => 'setBaseTotalCanceled',
        'base_total_due' => 'setBaseTotalDue',
        'base_total_invoiced' => 'setBaseTotalInvoiced',
        'base_total_invoiced_cost' => 'setBaseTotalInvoicedCost',
        'base_total_offline_refunded' => 'setBaseTotalOfflineRefunded',
        'base_total_online_refunded' => 'setBaseTotalOnlineRefunded',
        'base_total_paid' => 'setBaseTotalPaid',
        'base_total_qty_ordered' => 'setBaseTotalQtyOrdered',
        'base_total_refunded' => 'setBaseTotalRefunded',
        'base_to_global_rate' => 'setBaseToGlobalRate',
        'base_to_order_rate' => 'setBaseToOrderRate',
        'billing_address_id' => 'setBillingAddressId',
        'can_ship_partially' => 'setCanShipPartially',
        'can_ship_partially_item' => 'setCanShipPartiallyItem',
        'coupon_code' => 'setCouponCode',
        'created_at' => 'setCreatedAt',
        'customer_dob' => 'setCustomerDob',
        'customer_email' => 'setCustomerEmail',
        'customer_firstname' => 'setCustomerFirstname',
        'customer_gender' => 'setCustomerGender',
        'customer_group_id' => 'setCustomerGroupId',
        'customer_id' => 'setCustomerId',
        'customer_is_guest' => 'setCustomerIsGuest',
        'customer_lastname' => 'setCustomerLastname',
        'customer_middlename' => 'setCustomerMiddlename',
        'customer_note' => 'setCustomerNote',
        'customer_note_notify' => 'setCustomerNoteNotify',
        'customer_prefix' => 'setCustomerPrefix',
        'customer_suffix' => 'setCustomerSuffix',
        'customer_taxvat' => 'setCustomerTaxvat',
        'discount_amount' => 'setDiscountAmount',
        'discount_canceled' => 'setDiscountCanceled',
        'discount_description' => 'setDiscountDescription',
        'discount_invoiced' => 'setDiscountInvoiced',
        'discount_refunded' => 'setDiscountRefunded',
        'edit_increment' => 'setEditIncrement',
        'email_sent' => 'setEmailSent',
        'entity_id' => 'setEntityId',
        'ext_customer_id' => 'setExtCustomerId',
        'ext_order_id' => 'setExtOrderId',
        'forced_shipment_with_invoice' => 'setForcedShipmentWithInvoice',
        'global_currency_code' => 'setGlobalCurrencyCode',
        'grand_total' => 'setGrandTotal',
        'discount_tax_compensation_amount' => 'setDiscountTaxCompensationAmount',
        'discount_tax_compensation_invoiced' => 'setDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'setDiscountTaxCompensationRefunded',
        'hold_before_state' => 'setHoldBeforeState',
        'hold_before_status' => 'setHoldBeforeStatus',
        'increment_id' => 'setIncrementId',
        'is_virtual' => 'setIsVirtual',
        'order_currency_code' => 'setOrderCurrencyCode',
        'original_increment_id' => 'setOriginalIncrementId',
        'payment_authorization_amount' => 'setPaymentAuthorizationAmount',
        'payment_auth_expiration' => 'setPaymentAuthExpiration',
        'protect_code' => 'setProtectCode',
        'quote_address_id' => 'setQuoteAddressId',
        'quote_id' => 'setQuoteId',
        'relation_child_id' => 'setRelationChildId',
        'relation_child_real_id' => 'setRelationChildRealId',
        'relation_parent_id' => 'setRelationParentId',
        'relation_parent_real_id' => 'setRelationParentRealId',
        'remote_ip' => 'setRemoteIp',
        'shipping_amount' => 'setShippingAmount',
        'shipping_canceled' => 'setShippingCanceled',
        'shipping_description' => 'setShippingDescription',
        'shipping_discount_amount' => 'setShippingDiscountAmount',
        'shipping_discount_tax_compensation_amount' => 'setShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'setShippingInclTax',
        'shipping_invoiced' => 'setShippingInvoiced',
        'shipping_refunded' => 'setShippingRefunded',
        'shipping_tax_amount' => 'setShippingTaxAmount',
        'shipping_tax_refunded' => 'setShippingTaxRefunded',
        'state' => 'setState',
        'status' => 'setStatus',
        'store_currency_code' => 'setStoreCurrencyCode',
        'store_id' => 'setStoreId',
        'store_name' => 'setStoreName',
        'store_to_base_rate' => 'setStoreToBaseRate',
        'store_to_order_rate' => 'setStoreToOrderRate',
        'subtotal' => 'setSubtotal',
        'subtotal_canceled' => 'setSubtotalCanceled',
        'subtotal_incl_tax' => 'setSubtotalInclTax',
        'subtotal_invoiced' => 'setSubtotalInvoiced',
        'subtotal_refunded' => 'setSubtotalRefunded',
        'tax_amount' => 'setTaxAmount',
        'tax_canceled' => 'setTaxCanceled',
        'tax_invoiced' => 'setTaxInvoiced',
        'tax_refunded' => 'setTaxRefunded',
        'total_canceled' => 'setTotalCanceled',
        'total_due' => 'setTotalDue',
        'total_invoiced' => 'setTotalInvoiced',
        'total_item_count' => 'setTotalItemCount',
        'total_offline_refunded' => 'setTotalOfflineRefunded',
        'total_online_refunded' => 'setTotalOnlineRefunded',
        'total_paid' => 'setTotalPaid',
        'total_qty_ordered' => 'setTotalQtyOrdered',
        'total_refunded' => 'setTotalRefunded',
        'updated_at' => 'setUpdatedAt',
        'weight' => 'setWeight',
        'x_forwarded_for' => 'setXForwardedFor',
        'items' => 'setItems',
        'billing_address' => 'setBillingAddress',
        'payment' => 'setPayment',
        'status_histories' => 'setStatusHistories',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'adjustment_negative' => 'getAdjustmentNegative',
        'adjustment_positive' => 'getAdjustmentPositive',
        'applied_rule_ids' => 'getAppliedRuleIds',
        'base_adjustment_negative' => 'getBaseAdjustmentNegative',
        'base_adjustment_positive' => 'getBaseAdjustmentPositive',
        'base_currency_code' => 'getBaseCurrencyCode',
        'base_discount_amount' => 'getBaseDiscountAmount',
        'base_discount_canceled' => 'getBaseDiscountCanceled',
        'base_discount_invoiced' => 'getBaseDiscountInvoiced',
        'base_discount_refunded' => 'getBaseDiscountRefunded',
        'base_grand_total' => 'getBaseGrandTotal',
        'base_discount_tax_compensation_amount' => 'getBaseDiscountTaxCompensationAmount',
        'base_discount_tax_compensation_invoiced' => 'getBaseDiscountTaxCompensationInvoiced',
        'base_discount_tax_compensation_refunded' => 'getBaseDiscountTaxCompensationRefunded',
        'base_shipping_amount' => 'getBaseShippingAmount',
        'base_shipping_canceled' => 'getBaseShippingCanceled',
        'base_shipping_discount_amount' => 'getBaseShippingDiscountAmount',
        'base_shipping_discount_tax_compensation_amnt' => 'getBaseShippingDiscountTaxCompensationAmnt',
        'base_shipping_incl_tax' => 'getBaseShippingInclTax',
        'base_shipping_invoiced' => 'getBaseShippingInvoiced',
        'base_shipping_refunded' => 'getBaseShippingRefunded',
        'base_shipping_tax_amount' => 'getBaseShippingTaxAmount',
        'base_shipping_tax_refunded' => 'getBaseShippingTaxRefunded',
        'base_subtotal' => 'getBaseSubtotal',
        'base_subtotal_canceled' => 'getBaseSubtotalCanceled',
        'base_subtotal_incl_tax' => 'getBaseSubtotalInclTax',
        'base_subtotal_invoiced' => 'getBaseSubtotalInvoiced',
        'base_subtotal_refunded' => 'getBaseSubtotalRefunded',
        'base_tax_amount' => 'getBaseTaxAmount',
        'base_tax_canceled' => 'getBaseTaxCanceled',
        'base_tax_invoiced' => 'getBaseTaxInvoiced',
        'base_tax_refunded' => 'getBaseTaxRefunded',
        'base_total_canceled' => 'getBaseTotalCanceled',
        'base_total_due' => 'getBaseTotalDue',
        'base_total_invoiced' => 'getBaseTotalInvoiced',
        'base_total_invoiced_cost' => 'getBaseTotalInvoicedCost',
        'base_total_offline_refunded' => 'getBaseTotalOfflineRefunded',
        'base_total_online_refunded' => 'getBaseTotalOnlineRefunded',
        'base_total_paid' => 'getBaseTotalPaid',
        'base_total_qty_ordered' => 'getBaseTotalQtyOrdered',
        'base_total_refunded' => 'getBaseTotalRefunded',
        'base_to_global_rate' => 'getBaseToGlobalRate',
        'base_to_order_rate' => 'getBaseToOrderRate',
        'billing_address_id' => 'getBillingAddressId',
        'can_ship_partially' => 'getCanShipPartially',
        'can_ship_partially_item' => 'getCanShipPartiallyItem',
        'coupon_code' => 'getCouponCode',
        'created_at' => 'getCreatedAt',
        'customer_dob' => 'getCustomerDob',
        'customer_email' => 'getCustomerEmail',
        'customer_firstname' => 'getCustomerFirstname',
        'customer_gender' => 'getCustomerGender',
        'customer_group_id' => 'getCustomerGroupId',
        'customer_id' => 'getCustomerId',
        'customer_is_guest' => 'getCustomerIsGuest',
        'customer_lastname' => 'getCustomerLastname',
        'customer_middlename' => 'getCustomerMiddlename',
        'customer_note' => 'getCustomerNote',
        'customer_note_notify' => 'getCustomerNoteNotify',
        'customer_prefix' => 'getCustomerPrefix',
        'customer_suffix' => 'getCustomerSuffix',
        'customer_taxvat' => 'getCustomerTaxvat',
        'discount_amount' => 'getDiscountAmount',
        'discount_canceled' => 'getDiscountCanceled',
        'discount_description' => 'getDiscountDescription',
        'discount_invoiced' => 'getDiscountInvoiced',
        'discount_refunded' => 'getDiscountRefunded',
        'edit_increment' => 'getEditIncrement',
        'email_sent' => 'getEmailSent',
        'entity_id' => 'getEntityId',
        'ext_customer_id' => 'getExtCustomerId',
        'ext_order_id' => 'getExtOrderId',
        'forced_shipment_with_invoice' => 'getForcedShipmentWithInvoice',
        'global_currency_code' => 'getGlobalCurrencyCode',
        'grand_total' => 'getGrandTotal',
        'discount_tax_compensation_amount' => 'getDiscountTaxCompensationAmount',
        'discount_tax_compensation_invoiced' => 'getDiscountTaxCompensationInvoiced',
        'discount_tax_compensation_refunded' => 'getDiscountTaxCompensationRefunded',
        'hold_before_state' => 'getHoldBeforeState',
        'hold_before_status' => 'getHoldBeforeStatus',
        'increment_id' => 'getIncrementId',
        'is_virtual' => 'getIsVirtual',
        'order_currency_code' => 'getOrderCurrencyCode',
        'original_increment_id' => 'getOriginalIncrementId',
        'payment_authorization_amount' => 'getPaymentAuthorizationAmount',
        'payment_auth_expiration' => 'getPaymentAuthExpiration',
        'protect_code' => 'getProtectCode',
        'quote_address_id' => 'getQuoteAddressId',
        'quote_id' => 'getQuoteId',
        'relation_child_id' => 'getRelationChildId',
        'relation_child_real_id' => 'getRelationChildRealId',
        'relation_parent_id' => 'getRelationParentId',
        'relation_parent_real_id' => 'getRelationParentRealId',
        'remote_ip' => 'getRemoteIp',
        'shipping_amount' => 'getShippingAmount',
        'shipping_canceled' => 'getShippingCanceled',
        'shipping_description' => 'getShippingDescription',
        'shipping_discount_amount' => 'getShippingDiscountAmount',
        'shipping_discount_tax_compensation_amount' => 'getShippingDiscountTaxCompensationAmount',
        'shipping_incl_tax' => 'getShippingInclTax',
        'shipping_invoiced' => 'getShippingInvoiced',
        'shipping_refunded' => 'getShippingRefunded',
        'shipping_tax_amount' => 'getShippingTaxAmount',
        'shipping_tax_refunded' => 'getShippingTaxRefunded',
        'state' => 'getState',
        'status' => 'getStatus',
        'store_currency_code' => 'getStoreCurrencyCode',
        'store_id' => 'getStoreId',
        'store_name' => 'getStoreName',
        'store_to_base_rate' => 'getStoreToBaseRate',
        'store_to_order_rate' => 'getStoreToOrderRate',
        'subtotal' => 'getSubtotal',
        'subtotal_canceled' => 'getSubtotalCanceled',
        'subtotal_incl_tax' => 'getSubtotalInclTax',
        'subtotal_invoiced' => 'getSubtotalInvoiced',
        'subtotal_refunded' => 'getSubtotalRefunded',
        'tax_amount' => 'getTaxAmount',
        'tax_canceled' => 'getTaxCanceled',
        'tax_invoiced' => 'getTaxInvoiced',
        'tax_refunded' => 'getTaxRefunded',
        'total_canceled' => 'getTotalCanceled',
        'total_due' => 'getTotalDue',
        'total_invoiced' => 'getTotalInvoiced',
        'total_item_count' => 'getTotalItemCount',
        'total_offline_refunded' => 'getTotalOfflineRefunded',
        'total_online_refunded' => 'getTotalOnlineRefunded',
        'total_paid' => 'getTotalPaid',
        'total_qty_ordered' => 'getTotalQtyOrdered',
        'total_refunded' => 'getTotalRefunded',
        'updated_at' => 'getUpdatedAt',
        'weight' => 'getWeight',
        'x_forwarded_for' => 'getXForwardedFor',
        'items' => 'getItems',
        'billing_address' => 'getBillingAddress',
        'payment' => 'getPayment',
        'status_histories' => 'getStatusHistories',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['adjustment_negative'] = $data['adjustment_negative'] ?? null;
        $this->container['adjustment_positive'] = $data['adjustment_positive'] ?? null;
        $this->container['applied_rule_ids'] = $data['applied_rule_ids'] ?? null;
        $this->container['base_adjustment_negative'] = $data['base_adjustment_negative'] ?? null;
        $this->container['base_adjustment_positive'] = $data['base_adjustment_positive'] ?? null;
        $this->container['base_currency_code'] = $data['base_currency_code'] ?? null;
        $this->container['base_discount_amount'] = $data['base_discount_amount'] ?? null;
        $this->container['base_discount_canceled'] = $data['base_discount_canceled'] ?? null;
        $this->container['base_discount_invoiced'] = $data['base_discount_invoiced'] ?? null;
        $this->container['base_discount_refunded'] = $data['base_discount_refunded'] ?? null;
        $this->container['base_grand_total'] = $data['base_grand_total'] ?? null;
        $this->container['base_discount_tax_compensation_amount'] = $data['base_discount_tax_compensation_amount'] ?? null;
        $this->container['base_discount_tax_compensation_invoiced'] = $data['base_discount_tax_compensation_invoiced'] ?? null;
        $this->container['base_discount_tax_compensation_refunded'] = $data['base_discount_tax_compensation_refunded'] ?? null;
        $this->container['base_shipping_amount'] = $data['base_shipping_amount'] ?? null;
        $this->container['base_shipping_canceled'] = $data['base_shipping_canceled'] ?? null;
        $this->container['base_shipping_discount_amount'] = $data['base_shipping_discount_amount'] ?? null;
        $this->container['base_shipping_discount_tax_compensation_amnt'] = $data['base_shipping_discount_tax_compensation_amnt'] ?? null;
        $this->container['base_shipping_incl_tax'] = $data['base_shipping_incl_tax'] ?? null;
        $this->container['base_shipping_invoiced'] = $data['base_shipping_invoiced'] ?? null;
        $this->container['base_shipping_refunded'] = $data['base_shipping_refunded'] ?? null;
        $this->container['base_shipping_tax_amount'] = $data['base_shipping_tax_amount'] ?? null;
        $this->container['base_shipping_tax_refunded'] = $data['base_shipping_tax_refunded'] ?? null;
        $this->container['base_subtotal'] = $data['base_subtotal'] ?? null;
        $this->container['base_subtotal_canceled'] = $data['base_subtotal_canceled'] ?? null;
        $this->container['base_subtotal_incl_tax'] = $data['base_subtotal_incl_tax'] ?? null;
        $this->container['base_subtotal_invoiced'] = $data['base_subtotal_invoiced'] ?? null;
        $this->container['base_subtotal_refunded'] = $data['base_subtotal_refunded'] ?? null;
        $this->container['base_tax_amount'] = $data['base_tax_amount'] ?? null;
        $this->container['base_tax_canceled'] = $data['base_tax_canceled'] ?? null;
        $this->container['base_tax_invoiced'] = $data['base_tax_invoiced'] ?? null;
        $this->container['base_tax_refunded'] = $data['base_tax_refunded'] ?? null;
        $this->container['base_total_canceled'] = $data['base_total_canceled'] ?? null;
        $this->container['base_total_due'] = $data['base_total_due'] ?? null;
        $this->container['base_total_invoiced'] = $data['base_total_invoiced'] ?? null;
        $this->container['base_total_invoiced_cost'] = $data['base_total_invoiced_cost'] ?? null;
        $this->container['base_total_offline_refunded'] = $data['base_total_offline_refunded'] ?? null;
        $this->container['base_total_online_refunded'] = $data['base_total_online_refunded'] ?? null;
        $this->container['base_total_paid'] = $data['base_total_paid'] ?? null;
        $this->container['base_total_qty_ordered'] = $data['base_total_qty_ordered'] ?? null;
        $this->container['base_total_refunded'] = $data['base_total_refunded'] ?? null;
        $this->container['base_to_global_rate'] = $data['base_to_global_rate'] ?? null;
        $this->container['base_to_order_rate'] = $data['base_to_order_rate'] ?? null;
        $this->container['billing_address_id'] = $data['billing_address_id'] ?? null;
        $this->container['can_ship_partially'] = $data['can_ship_partially'] ?? null;
        $this->container['can_ship_partially_item'] = $data['can_ship_partially_item'] ?? null;
        $this->container['coupon_code'] = $data['coupon_code'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['customer_dob'] = $data['customer_dob'] ?? null;
        $this->container['customer_email'] = $data['customer_email'] ?? null;
        $this->container['customer_firstname'] = $data['customer_firstname'] ?? null;
        $this->container['customer_gender'] = $data['customer_gender'] ?? null;
        $this->container['customer_group_id'] = $data['customer_group_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['customer_is_guest'] = $data['customer_is_guest'] ?? null;
        $this->container['customer_lastname'] = $data['customer_lastname'] ?? null;
        $this->container['customer_middlename'] = $data['customer_middlename'] ?? null;
        $this->container['customer_note'] = $data['customer_note'] ?? null;
        $this->container['customer_note_notify'] = $data['customer_note_notify'] ?? null;
        $this->container['customer_prefix'] = $data['customer_prefix'] ?? null;
        $this->container['customer_suffix'] = $data['customer_suffix'] ?? null;
        $this->container['customer_taxvat'] = $data['customer_taxvat'] ?? null;
        $this->container['discount_amount'] = $data['discount_amount'] ?? null;
        $this->container['discount_canceled'] = $data['discount_canceled'] ?? null;
        $this->container['discount_description'] = $data['discount_description'] ?? null;
        $this->container['discount_invoiced'] = $data['discount_invoiced'] ?? null;
        $this->container['discount_refunded'] = $data['discount_refunded'] ?? null;
        $this->container['edit_increment'] = $data['edit_increment'] ?? null;
        $this->container['email_sent'] = $data['email_sent'] ?? null;
        $this->container['entity_id'] = $data['entity_id'] ?? null;
        $this->container['ext_customer_id'] = $data['ext_customer_id'] ?? null;
        $this->container['ext_order_id'] = $data['ext_order_id'] ?? null;
        $this->container['forced_shipment_with_invoice'] = $data['forced_shipment_with_invoice'] ?? null;
        $this->container['global_currency_code'] = $data['global_currency_code'] ?? null;
        $this->container['grand_total'] = $data['grand_total'] ?? null;
        $this->container['discount_tax_compensation_amount'] = $data['discount_tax_compensation_amount'] ?? null;
        $this->container['discount_tax_compensation_invoiced'] = $data['discount_tax_compensation_invoiced'] ?? null;
        $this->container['discount_tax_compensation_refunded'] = $data['discount_tax_compensation_refunded'] ?? null;
        $this->container['hold_before_state'] = $data['hold_before_state'] ?? null;
        $this->container['hold_before_status'] = $data['hold_before_status'] ?? null;
        $this->container['increment_id'] = $data['increment_id'] ?? null;
        $this->container['is_virtual'] = $data['is_virtual'] ?? null;
        $this->container['order_currency_code'] = $data['order_currency_code'] ?? null;
        $this->container['original_increment_id'] = $data['original_increment_id'] ?? null;
        $this->container['payment_authorization_amount'] = $data['payment_authorization_amount'] ?? null;
        $this->container['payment_auth_expiration'] = $data['payment_auth_expiration'] ?? null;
        $this->container['protect_code'] = $data['protect_code'] ?? null;
        $this->container['quote_address_id'] = $data['quote_address_id'] ?? null;
        $this->container['quote_id'] = $data['quote_id'] ?? null;
        $this->container['relation_child_id'] = $data['relation_child_id'] ?? null;
        $this->container['relation_child_real_id'] = $data['relation_child_real_id'] ?? null;
        $this->container['relation_parent_id'] = $data['relation_parent_id'] ?? null;
        $this->container['relation_parent_real_id'] = $data['relation_parent_real_id'] ?? null;
        $this->container['remote_ip'] = $data['remote_ip'] ?? null;
        $this->container['shipping_amount'] = $data['shipping_amount'] ?? null;
        $this->container['shipping_canceled'] = $data['shipping_canceled'] ?? null;
        $this->container['shipping_description'] = $data['shipping_description'] ?? null;
        $this->container['shipping_discount_amount'] = $data['shipping_discount_amount'] ?? null;
        $this->container['shipping_discount_tax_compensation_amount'] = $data['shipping_discount_tax_compensation_amount'] ?? null;
        $this->container['shipping_incl_tax'] = $data['shipping_incl_tax'] ?? null;
        $this->container['shipping_invoiced'] = $data['shipping_invoiced'] ?? null;
        $this->container['shipping_refunded'] = $data['shipping_refunded'] ?? null;
        $this->container['shipping_tax_amount'] = $data['shipping_tax_amount'] ?? null;
        $this->container['shipping_tax_refunded'] = $data['shipping_tax_refunded'] ?? null;
        $this->container['state'] = $data['state'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['store_currency_code'] = $data['store_currency_code'] ?? null;
        $this->container['store_id'] = $data['store_id'] ?? null;
        $this->container['store_name'] = $data['store_name'] ?? null;
        $this->container['store_to_base_rate'] = $data['store_to_base_rate'] ?? null;
        $this->container['store_to_order_rate'] = $data['store_to_order_rate'] ?? null;
        $this->container['subtotal'] = $data['subtotal'] ?? null;
        $this->container['subtotal_canceled'] = $data['subtotal_canceled'] ?? null;
        $this->container['subtotal_incl_tax'] = $data['subtotal_incl_tax'] ?? null;
        $this->container['subtotal_invoiced'] = $data['subtotal_invoiced'] ?? null;
        $this->container['subtotal_refunded'] = $data['subtotal_refunded'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['tax_canceled'] = $data['tax_canceled'] ?? null;
        $this->container['tax_invoiced'] = $data['tax_invoiced'] ?? null;
        $this->container['tax_refunded'] = $data['tax_refunded'] ?? null;
        $this->container['total_canceled'] = $data['total_canceled'] ?? null;
        $this->container['total_due'] = $data['total_due'] ?? null;
        $this->container['total_invoiced'] = $data['total_invoiced'] ?? null;
        $this->container['total_item_count'] = $data['total_item_count'] ?? null;
        $this->container['total_offline_refunded'] = $data['total_offline_refunded'] ?? null;
        $this->container['total_online_refunded'] = $data['total_online_refunded'] ?? null;
        $this->container['total_paid'] = $data['total_paid'] ?? null;
        $this->container['total_qty_ordered'] = $data['total_qty_ordered'] ?? null;
        $this->container['total_refunded'] = $data['total_refunded'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['weight'] = $data['weight'] ?? null;
        $this->container['x_forwarded_for'] = $data['x_forwarded_for'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
        $this->container['billing_address'] = $data['billing_address'] ?? null;
        $this->container['payment'] = $data['payment'] ?? null;
        $this->container['status_histories'] = $data['status_histories'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['base_grand_total'] === null) {
            $invalidProperties[] = "'base_grand_total' can't be null";
        }
        if ($this->container['customer_email'] === null) {
            $invalidProperties[] = "'customer_email' can't be null";
        }
        if ($this->container['grand_total'] === null) {
            $invalidProperties[] = "'grand_total' can't be null";
        }
        if ($this->container['items'] === null) {
            $invalidProperties[] = "'items' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets adjustment_negative
     *
     * @return float|null
     */
    public function getAdjustmentNegative()
    {
        return $this->container['adjustment_negative'];
    }

    /**
     * Sets adjustment_negative
     *
     * @param float|null $adjustment_negative Negative adjustment value.
     *
     * @return self
     */
    public function setAdjustmentNegative($adjustment_negative)
    {
        $this->container['adjustment_negative'] = $adjustment_negative;

        return $this;
    }

    /**
     * Gets adjustment_positive
     *
     * @return float|null
     */
    public function getAdjustmentPositive()
    {
        return $this->container['adjustment_positive'];
    }

    /**
     * Sets adjustment_positive
     *
     * @param float|null $adjustment_positive Positive adjustment value.
     *
     * @return self
     */
    public function setAdjustmentPositive($adjustment_positive)
    {
        $this->container['adjustment_positive'] = $adjustment_positive;

        return $this;
    }

    /**
     * Gets applied_rule_ids
     *
     * @return string|null
     */
    public function getAppliedRuleIds()
    {
        return $this->container['applied_rule_ids'];
    }

    /**
     * Sets applied_rule_ids
     *
     * @param string|null $applied_rule_ids Applied rule IDs.
     *
     * @return self
     */
    public function setAppliedRuleIds($applied_rule_ids)
    {
        $this->container['applied_rule_ids'] = $applied_rule_ids;

        return $this;
    }

    /**
     * Gets base_adjustment_negative
     *
     * @return float|null
     */
    public function getBaseAdjustmentNegative()
    {
        return $this->container['base_adjustment_negative'];
    }

    /**
     * Sets base_adjustment_negative
     *
     * @param float|null $base_adjustment_negative Base negative adjustment value.
     *
     * @return self
     */
    public function setBaseAdjustmentNegative($base_adjustment_negative)
    {
        $this->container['base_adjustment_negative'] = $base_adjustment_negative;

        return $this;
    }

    /**
     * Gets base_adjustment_positive
     *
     * @return float|null
     */
    public function getBaseAdjustmentPositive()
    {
        return $this->container['base_adjustment_positive'];
    }

    /**
     * Sets base_adjustment_positive
     *
     * @param float|null $base_adjustment_positive Base positive adjustment value.
     *
     * @return self
     */
    public function setBaseAdjustmentPositive($base_adjustment_positive)
    {
        $this->container['base_adjustment_positive'] = $base_adjustment_positive;

        return $this;
    }

    /**
     * Gets base_currency_code
     *
     * @return string|null
     */
    public function getBaseCurrencyCode()
    {
        return $this->container['base_currency_code'];
    }

    /**
     * Sets base_currency_code
     *
     * @param string|null $base_currency_code Base currency code.
     *
     * @return self
     */
    public function setBaseCurrencyCode($base_currency_code)
    {
        $this->container['base_currency_code'] = $base_currency_code;

        return $this;
    }

    /**
     * Gets base_discount_amount
     *
     * @return float|null
     */
    public function getBaseDiscountAmount()
    {
        return $this->container['base_discount_amount'];
    }

    /**
     * Sets base_discount_amount
     *
     * @param float|null $base_discount_amount Base discount amount.
     *
     * @return self
     */
    public function setBaseDiscountAmount($base_discount_amount)
    {
        $this->container['base_discount_amount'] = $base_discount_amount;

        return $this;
    }

    /**
     * Gets base_discount_canceled
     *
     * @return float|null
     */
    public function getBaseDiscountCanceled()
    {
        return $this->container['base_discount_canceled'];
    }

    /**
     * Sets base_discount_canceled
     *
     * @param float|null $base_discount_canceled Base discount canceled.
     *
     * @return self
     */
    public function setBaseDiscountCanceled($base_discount_canceled)
    {
        $this->container['base_discount_canceled'] = $base_discount_canceled;

        return $this;
    }

    /**
     * Gets base_discount_invoiced
     *
     * @return float|null
     */
    public function getBaseDiscountInvoiced()
    {
        return $this->container['base_discount_invoiced'];
    }

    /**
     * Sets base_discount_invoiced
     *
     * @param float|null $base_discount_invoiced Base discount invoiced.
     *
     * @return self
     */
    public function setBaseDiscountInvoiced($base_discount_invoiced)
    {
        $this->container['base_discount_invoiced'] = $base_discount_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_refunded
     *
     * @return float|null
     */
    public function getBaseDiscountRefunded()
    {
        return $this->container['base_discount_refunded'];
    }

    /**
     * Sets base_discount_refunded
     *
     * @param float|null $base_discount_refunded Base discount refunded.
     *
     * @return self
     */
    public function setBaseDiscountRefunded($base_discount_refunded)
    {
        $this->container['base_discount_refunded'] = $base_discount_refunded;

        return $this;
    }

    /**
     * Gets base_grand_total
     *
     * @return float
     */
    public function getBaseGrandTotal()
    {
        return $this->container['base_grand_total'];
    }

    /**
     * Sets base_grand_total
     *
     * @param float $base_grand_total Base grand total.
     *
     * @return self
     */
    public function setBaseGrandTotal($base_grand_total)
    {
        $this->container['base_grand_total'] = $base_grand_total;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationAmount()
    {
        return $this->container['base_discount_tax_compensation_amount'];
    }

    /**
     * Sets base_discount_tax_compensation_amount
     *
     * @param float|null $base_discount_tax_compensation_amount Base discount tax compensation amount.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationAmount($base_discount_tax_compensation_amount)
    {
        $this->container['base_discount_tax_compensation_amount'] = $base_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_invoiced
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationInvoiced()
    {
        return $this->container['base_discount_tax_compensation_invoiced'];
    }

    /**
     * Sets base_discount_tax_compensation_invoiced
     *
     * @param float|null $base_discount_tax_compensation_invoiced Base discount tax compensation invoiced.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationInvoiced($base_discount_tax_compensation_invoiced)
    {
        $this->container['base_discount_tax_compensation_invoiced'] = $base_discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets base_discount_tax_compensation_refunded
     *
     * @return float|null
     */
    public function getBaseDiscountTaxCompensationRefunded()
    {
        return $this->container['base_discount_tax_compensation_refunded'];
    }

    /**
     * Sets base_discount_tax_compensation_refunded
     *
     * @param float|null $base_discount_tax_compensation_refunded Base discount tax compensation refunded.
     *
     * @return self
     */
    public function setBaseDiscountTaxCompensationRefunded($base_discount_tax_compensation_refunded)
    {
        $this->container['base_discount_tax_compensation_refunded'] = $base_discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets base_shipping_amount
     *
     * @return float|null
     */
    public function getBaseShippingAmount()
    {
        return $this->container['base_shipping_amount'];
    }

    /**
     * Sets base_shipping_amount
     *
     * @param float|null $base_shipping_amount Base shipping amount.
     *
     * @return self
     */
    public function setBaseShippingAmount($base_shipping_amount)
    {
        $this->container['base_shipping_amount'] = $base_shipping_amount;

        return $this;
    }

    /**
     * Gets base_shipping_canceled
     *
     * @return float|null
     */
    public function getBaseShippingCanceled()
    {
        return $this->container['base_shipping_canceled'];
    }

    /**
     * Sets base_shipping_canceled
     *
     * @param float|null $base_shipping_canceled Base shipping canceled.
     *
     * @return self
     */
    public function setBaseShippingCanceled($base_shipping_canceled)
    {
        $this->container['base_shipping_canceled'] = $base_shipping_canceled;

        return $this;
    }

    /**
     * Gets base_shipping_discount_amount
     *
     * @return float|null
     */
    public function getBaseShippingDiscountAmount()
    {
        return $this->container['base_shipping_discount_amount'];
    }

    /**
     * Sets base_shipping_discount_amount
     *
     * @param float|null $base_shipping_discount_amount Base shipping discount amount.
     *
     * @return self
     */
    public function setBaseShippingDiscountAmount($base_shipping_discount_amount)
    {
        $this->container['base_shipping_discount_amount'] = $base_shipping_discount_amount;

        return $this;
    }

    /**
     * Gets base_shipping_discount_tax_compensation_amnt
     *
     * @return float|null
     */
    public function getBaseShippingDiscountTaxCompensationAmnt()
    {
        return $this->container['base_shipping_discount_tax_compensation_amnt'];
    }

    /**
     * Sets base_shipping_discount_tax_compensation_amnt
     *
     * @param float|null $base_shipping_discount_tax_compensation_amnt Base shipping discount tax compensation amount.
     *
     * @return self
     */
    public function setBaseShippingDiscountTaxCompensationAmnt($base_shipping_discount_tax_compensation_amnt)
    {
        $this->container['base_shipping_discount_tax_compensation_amnt'] = $base_shipping_discount_tax_compensation_amnt;

        return $this;
    }

    /**
     * Gets base_shipping_incl_tax
     *
     * @return float|null
     */
    public function getBaseShippingInclTax()
    {
        return $this->container['base_shipping_incl_tax'];
    }

    /**
     * Sets base_shipping_incl_tax
     *
     * @param float|null $base_shipping_incl_tax Base shipping including tax.
     *
     * @return self
     */
    public function setBaseShippingInclTax($base_shipping_incl_tax)
    {
        $this->container['base_shipping_incl_tax'] = $base_shipping_incl_tax;

        return $this;
    }

    /**
     * Gets base_shipping_invoiced
     *
     * @return float|null
     */
    public function getBaseShippingInvoiced()
    {
        return $this->container['base_shipping_invoiced'];
    }

    /**
     * Sets base_shipping_invoiced
     *
     * @param float|null $base_shipping_invoiced Base shipping invoiced.
     *
     * @return self
     */
    public function setBaseShippingInvoiced($base_shipping_invoiced)
    {
        $this->container['base_shipping_invoiced'] = $base_shipping_invoiced;

        return $this;
    }

    /**
     * Gets base_shipping_refunded
     *
     * @return float|null
     */
    public function getBaseShippingRefunded()
    {
        return $this->container['base_shipping_refunded'];
    }

    /**
     * Sets base_shipping_refunded
     *
     * @param float|null $base_shipping_refunded Base shipping refunded.
     *
     * @return self
     */
    public function setBaseShippingRefunded($base_shipping_refunded)
    {
        $this->container['base_shipping_refunded'] = $base_shipping_refunded;

        return $this;
    }

    /**
     * Gets base_shipping_tax_amount
     *
     * @return float|null
     */
    public function getBaseShippingTaxAmount()
    {
        return $this->container['base_shipping_tax_amount'];
    }

    /**
     * Sets base_shipping_tax_amount
     *
     * @param float|null $base_shipping_tax_amount Base shipping tax amount.
     *
     * @return self
     */
    public function setBaseShippingTaxAmount($base_shipping_tax_amount)
    {
        $this->container['base_shipping_tax_amount'] = $base_shipping_tax_amount;

        return $this;
    }

    /**
     * Gets base_shipping_tax_refunded
     *
     * @return float|null
     */
    public function getBaseShippingTaxRefunded()
    {
        return $this->container['base_shipping_tax_refunded'];
    }

    /**
     * Sets base_shipping_tax_refunded
     *
     * @param float|null $base_shipping_tax_refunded Base shipping tax refunded.
     *
     * @return self
     */
    public function setBaseShippingTaxRefunded($base_shipping_tax_refunded)
    {
        $this->container['base_shipping_tax_refunded'] = $base_shipping_tax_refunded;

        return $this;
    }

    /**
     * Gets base_subtotal
     *
     * @return float|null
     */
    public function getBaseSubtotal()
    {
        return $this->container['base_subtotal'];
    }

    /**
     * Sets base_subtotal
     *
     * @param float|null $base_subtotal Base subtotal.
     *
     * @return self
     */
    public function setBaseSubtotal($base_subtotal)
    {
        $this->container['base_subtotal'] = $base_subtotal;

        return $this;
    }

    /**
     * Gets base_subtotal_canceled
     *
     * @return float|null
     */
    public function getBaseSubtotalCanceled()
    {
        return $this->container['base_subtotal_canceled'];
    }

    /**
     * Sets base_subtotal_canceled
     *
     * @param float|null $base_subtotal_canceled Base subtotal canceled.
     *
     * @return self
     */
    public function setBaseSubtotalCanceled($base_subtotal_canceled)
    {
        $this->container['base_subtotal_canceled'] = $base_subtotal_canceled;

        return $this;
    }

    /**
     * Gets base_subtotal_incl_tax
     *
     * @return float|null
     */
    public function getBaseSubtotalInclTax()
    {
        return $this->container['base_subtotal_incl_tax'];
    }

    /**
     * Sets base_subtotal_incl_tax
     *
     * @param float|null $base_subtotal_incl_tax Base subtotal including tax.
     *
     * @return self
     */
    public function setBaseSubtotalInclTax($base_subtotal_incl_tax)
    {
        $this->container['base_subtotal_incl_tax'] = $base_subtotal_incl_tax;

        return $this;
    }

    /**
     * Gets base_subtotal_invoiced
     *
     * @return float|null
     */
    public function getBaseSubtotalInvoiced()
    {
        return $this->container['base_subtotal_invoiced'];
    }

    /**
     * Sets base_subtotal_invoiced
     *
     * @param float|null $base_subtotal_invoiced Base subtotal invoiced.
     *
     * @return self
     */
    public function setBaseSubtotalInvoiced($base_subtotal_invoiced)
    {
        $this->container['base_subtotal_invoiced'] = $base_subtotal_invoiced;

        return $this;
    }

    /**
     * Gets base_subtotal_refunded
     *
     * @return float|null
     */
    public function getBaseSubtotalRefunded()
    {
        return $this->container['base_subtotal_refunded'];
    }

    /**
     * Sets base_subtotal_refunded
     *
     * @param float|null $base_subtotal_refunded Base subtotal refunded.
     *
     * @return self
     */
    public function setBaseSubtotalRefunded($base_subtotal_refunded)
    {
        $this->container['base_subtotal_refunded'] = $base_subtotal_refunded;

        return $this;
    }

    /**
     * Gets base_tax_amount
     *
     * @return float|null
     */
    public function getBaseTaxAmount()
    {
        return $this->container['base_tax_amount'];
    }

    /**
     * Sets base_tax_amount
     *
     * @param float|null $base_tax_amount Base tax amount.
     *
     * @return self
     */
    public function setBaseTaxAmount($base_tax_amount)
    {
        $this->container['base_tax_amount'] = $base_tax_amount;

        return $this;
    }

    /**
     * Gets base_tax_canceled
     *
     * @return float|null
     */
    public function getBaseTaxCanceled()
    {
        return $this->container['base_tax_canceled'];
    }

    /**
     * Sets base_tax_canceled
     *
     * @param float|null $base_tax_canceled Base tax canceled.
     *
     * @return self
     */
    public function setBaseTaxCanceled($base_tax_canceled)
    {
        $this->container['base_tax_canceled'] = $base_tax_canceled;

        return $this;
    }

    /**
     * Gets base_tax_invoiced
     *
     * @return float|null
     */
    public function getBaseTaxInvoiced()
    {
        return $this->container['base_tax_invoiced'];
    }

    /**
     * Sets base_tax_invoiced
     *
     * @param float|null $base_tax_invoiced Base tax invoiced.
     *
     * @return self
     */
    public function setBaseTaxInvoiced($base_tax_invoiced)
    {
        $this->container['base_tax_invoiced'] = $base_tax_invoiced;

        return $this;
    }

    /**
     * Gets base_tax_refunded
     *
     * @return float|null
     */
    public function getBaseTaxRefunded()
    {
        return $this->container['base_tax_refunded'];
    }

    /**
     * Sets base_tax_refunded
     *
     * @param float|null $base_tax_refunded Base tax refunded.
     *
     * @return self
     */
    public function setBaseTaxRefunded($base_tax_refunded)
    {
        $this->container['base_tax_refunded'] = $base_tax_refunded;

        return $this;
    }

    /**
     * Gets base_total_canceled
     *
     * @return float|null
     */
    public function getBaseTotalCanceled()
    {
        return $this->container['base_total_canceled'];
    }

    /**
     * Sets base_total_canceled
     *
     * @param float|null $base_total_canceled Base total canceled.
     *
     * @return self
     */
    public function setBaseTotalCanceled($base_total_canceled)
    {
        $this->container['base_total_canceled'] = $base_total_canceled;

        return $this;
    }

    /**
     * Gets base_total_due
     *
     * @return float|null
     */
    public function getBaseTotalDue()
    {
        return $this->container['base_total_due'];
    }

    /**
     * Sets base_total_due
     *
     * @param float|null $base_total_due Base total due.
     *
     * @return self
     */
    public function setBaseTotalDue($base_total_due)
    {
        $this->container['base_total_due'] = $base_total_due;

        return $this;
    }

    /**
     * Gets base_total_invoiced
     *
     * @return float|null
     */
    public function getBaseTotalInvoiced()
    {
        return $this->container['base_total_invoiced'];
    }

    /**
     * Sets base_total_invoiced
     *
     * @param float|null $base_total_invoiced Base total invoiced.
     *
     * @return self
     */
    public function setBaseTotalInvoiced($base_total_invoiced)
    {
        $this->container['base_total_invoiced'] = $base_total_invoiced;

        return $this;
    }

    /**
     * Gets base_total_invoiced_cost
     *
     * @return float|null
     */
    public function getBaseTotalInvoicedCost()
    {
        return $this->container['base_total_invoiced_cost'];
    }

    /**
     * Sets base_total_invoiced_cost
     *
     * @param float|null $base_total_invoiced_cost Base total invoiced cost.
     *
     * @return self
     */
    public function setBaseTotalInvoicedCost($base_total_invoiced_cost)
    {
        $this->container['base_total_invoiced_cost'] = $base_total_invoiced_cost;

        return $this;
    }

    /**
     * Gets base_total_offline_refunded
     *
     * @return float|null
     */
    public function getBaseTotalOfflineRefunded()
    {
        return $this->container['base_total_offline_refunded'];
    }

    /**
     * Sets base_total_offline_refunded
     *
     * @param float|null $base_total_offline_refunded Base total offline refunded.
     *
     * @return self
     */
    public function setBaseTotalOfflineRefunded($base_total_offline_refunded)
    {
        $this->container['base_total_offline_refunded'] = $base_total_offline_refunded;

        return $this;
    }

    /**
     * Gets base_total_online_refunded
     *
     * @return float|null
     */
    public function getBaseTotalOnlineRefunded()
    {
        return $this->container['base_total_online_refunded'];
    }

    /**
     * Sets base_total_online_refunded
     *
     * @param float|null $base_total_online_refunded Base total online refunded.
     *
     * @return self
     */
    public function setBaseTotalOnlineRefunded($base_total_online_refunded)
    {
        $this->container['base_total_online_refunded'] = $base_total_online_refunded;

        return $this;
    }

    /**
     * Gets base_total_paid
     *
     * @return float|null
     */
    public function getBaseTotalPaid()
    {
        return $this->container['base_total_paid'];
    }

    /**
     * Sets base_total_paid
     *
     * @param float|null $base_total_paid Base total paid.
     *
     * @return self
     */
    public function setBaseTotalPaid($base_total_paid)
    {
        $this->container['base_total_paid'] = $base_total_paid;

        return $this;
    }

    /**
     * Gets base_total_qty_ordered
     *
     * @return float|null
     */
    public function getBaseTotalQtyOrdered()
    {
        return $this->container['base_total_qty_ordered'];
    }

    /**
     * Sets base_total_qty_ordered
     *
     * @param float|null $base_total_qty_ordered Base total quantity ordered.
     *
     * @return self
     */
    public function setBaseTotalQtyOrdered($base_total_qty_ordered)
    {
        $this->container['base_total_qty_ordered'] = $base_total_qty_ordered;

        return $this;
    }

    /**
     * Gets base_total_refunded
     *
     * @return float|null
     */
    public function getBaseTotalRefunded()
    {
        return $this->container['base_total_refunded'];
    }

    /**
     * Sets base_total_refunded
     *
     * @param float|null $base_total_refunded Base total refunded.
     *
     * @return self
     */
    public function setBaseTotalRefunded($base_total_refunded)
    {
        $this->container['base_total_refunded'] = $base_total_refunded;

        return $this;
    }

    /**
     * Gets base_to_global_rate
     *
     * @return float|null
     */
    public function getBaseToGlobalRate()
    {
        return $this->container['base_to_global_rate'];
    }

    /**
     * Sets base_to_global_rate
     *
     * @param float|null $base_to_global_rate Base-to-global rate.
     *
     * @return self
     */
    public function setBaseToGlobalRate($base_to_global_rate)
    {
        $this->container['base_to_global_rate'] = $base_to_global_rate;

        return $this;
    }

    /**
     * Gets base_to_order_rate
     *
     * @return float|null
     */
    public function getBaseToOrderRate()
    {
        return $this->container['base_to_order_rate'];
    }

    /**
     * Sets base_to_order_rate
     *
     * @param float|null $base_to_order_rate Base-to-order rate.
     *
     * @return self
     */
    public function setBaseToOrderRate($base_to_order_rate)
    {
        $this->container['base_to_order_rate'] = $base_to_order_rate;

        return $this;
    }

    /**
     * Gets billing_address_id
     *
     * @return int|null
     */
    public function getBillingAddressId()
    {
        return $this->container['billing_address_id'];
    }

    /**
     * Sets billing_address_id
     *
     * @param int|null $billing_address_id Billing address ID.
     *
     * @return self
     */
    public function setBillingAddressId($billing_address_id)
    {
        $this->container['billing_address_id'] = $billing_address_id;

        return $this;
    }

    /**
     * Gets can_ship_partially
     *
     * @return int|null
     */
    public function getCanShipPartially()
    {
        return $this->container['can_ship_partially'];
    }

    /**
     * Sets can_ship_partially
     *
     * @param int|null $can_ship_partially Can-ship-partially flag value.
     *
     * @return self
     */
    public function setCanShipPartially($can_ship_partially)
    {
        $this->container['can_ship_partially'] = $can_ship_partially;

        return $this;
    }

    /**
     * Gets can_ship_partially_item
     *
     * @return int|null
     */
    public function getCanShipPartiallyItem()
    {
        return $this->container['can_ship_partially_item'];
    }

    /**
     * Sets can_ship_partially_item
     *
     * @param int|null $can_ship_partially_item Can-ship-partially-item flag value.
     *
     * @return self
     */
    public function setCanShipPartiallyItem($can_ship_partially_item)
    {
        $this->container['can_ship_partially_item'] = $can_ship_partially_item;

        return $this;
    }

    /**
     * Gets coupon_code
     *
     * @return string|null
     */
    public function getCouponCode()
    {
        return $this->container['coupon_code'];
    }

    /**
     * Sets coupon_code
     *
     * @param string|null $coupon_code Coupon code.
     *
     * @return self
     */
    public function setCouponCode($coupon_code)
    {
        $this->container['coupon_code'] = $coupon_code;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Created-at timestamp.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets customer_dob
     *
     * @return string|null
     */
    public function getCustomerDob()
    {
        return $this->container['customer_dob'];
    }

    /**
     * Sets customer_dob
     *
     * @param string|null $customer_dob Customer date-of-birth (DOB).
     *
     * @return self
     */
    public function setCustomerDob($customer_dob)
    {
        $this->container['customer_dob'] = $customer_dob;

        return $this;
    }

    /**
     * Gets customer_email
     *
     * @return string
     */
    public function getCustomerEmail()
    {
        return $this->container['customer_email'];
    }

    /**
     * Sets customer_email
     *
     * @param string $customer_email Customer email address.
     *
     * @return self
     */
    public function setCustomerEmail($customer_email)
    {
        $this->container['customer_email'] = $customer_email;

        return $this;
    }

    /**
     * Gets customer_firstname
     *
     * @return string|null
     */
    public function getCustomerFirstname()
    {
        return $this->container['customer_firstname'];
    }

    /**
     * Sets customer_firstname
     *
     * @param string|null $customer_firstname Customer first name.
     *
     * @return self
     */
    public function setCustomerFirstname($customer_firstname)
    {
        $this->container['customer_firstname'] = $customer_firstname;

        return $this;
    }

    /**
     * Gets customer_gender
     *
     * @return int|null
     */
    public function getCustomerGender()
    {
        return $this->container['customer_gender'];
    }

    /**
     * Sets customer_gender
     *
     * @param int|null $customer_gender Customer gender.
     *
     * @return self
     */
    public function setCustomerGender($customer_gender)
    {
        $this->container['customer_gender'] = $customer_gender;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return int|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param int|null $customer_group_id Customer group ID.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Customer ID.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets customer_is_guest
     *
     * @return int|null
     */
    public function getCustomerIsGuest()
    {
        return $this->container['customer_is_guest'];
    }

    /**
     * Sets customer_is_guest
     *
     * @param int|null $customer_is_guest Customer-is-guest flag value.
     *
     * @return self
     */
    public function setCustomerIsGuest($customer_is_guest)
    {
        $this->container['customer_is_guest'] = $customer_is_guest;

        return $this;
    }

    /**
     * Gets customer_lastname
     *
     * @return string|null
     */
    public function getCustomerLastname()
    {
        return $this->container['customer_lastname'];
    }

    /**
     * Sets customer_lastname
     *
     * @param string|null $customer_lastname Customer last name.
     *
     * @return self
     */
    public function setCustomerLastname($customer_lastname)
    {
        $this->container['customer_lastname'] = $customer_lastname;

        return $this;
    }

    /**
     * Gets customer_middlename
     *
     * @return string|null
     */
    public function getCustomerMiddlename()
    {
        return $this->container['customer_middlename'];
    }

    /**
     * Sets customer_middlename
     *
     * @param string|null $customer_middlename Customer middle name.
     *
     * @return self
     */
    public function setCustomerMiddlename($customer_middlename)
    {
        $this->container['customer_middlename'] = $customer_middlename;

        return $this;
    }

    /**
     * Gets customer_note
     *
     * @return string|null
     */
    public function getCustomerNote()
    {
        return $this->container['customer_note'];
    }

    /**
     * Sets customer_note
     *
     * @param string|null $customer_note Customer note.
     *
     * @return self
     */
    public function setCustomerNote($customer_note)
    {
        $this->container['customer_note'] = $customer_note;

        return $this;
    }

    /**
     * Gets customer_note_notify
     *
     * @return int|null
     */
    public function getCustomerNoteNotify()
    {
        return $this->container['customer_note_notify'];
    }

    /**
     * Sets customer_note_notify
     *
     * @param int|null $customer_note_notify Customer-note-notify flag value.
     *
     * @return self
     */
    public function setCustomerNoteNotify($customer_note_notify)
    {
        $this->container['customer_note_notify'] = $customer_note_notify;

        return $this;
    }

    /**
     * Gets customer_prefix
     *
     * @return string|null
     */
    public function getCustomerPrefix()
    {
        return $this->container['customer_prefix'];
    }

    /**
     * Sets customer_prefix
     *
     * @param string|null $customer_prefix Customer prefix.
     *
     * @return self
     */
    public function setCustomerPrefix($customer_prefix)
    {
        $this->container['customer_prefix'] = $customer_prefix;

        return $this;
    }

    /**
     * Gets customer_suffix
     *
     * @return string|null
     */
    public function getCustomerSuffix()
    {
        return $this->container['customer_suffix'];
    }

    /**
     * Sets customer_suffix
     *
     * @param string|null $customer_suffix Customer suffix.
     *
     * @return self
     */
    public function setCustomerSuffix($customer_suffix)
    {
        $this->container['customer_suffix'] = $customer_suffix;

        return $this;
    }

    /**
     * Gets customer_taxvat
     *
     * @return string|null
     */
    public function getCustomerTaxvat()
    {
        return $this->container['customer_taxvat'];
    }

    /**
     * Sets customer_taxvat
     *
     * @param string|null $customer_taxvat Customer value-added tax (VAT).
     *
     * @return self
     */
    public function setCustomerTaxvat($customer_taxvat)
    {
        $this->container['customer_taxvat'] = $customer_taxvat;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float|null $discount_amount Discount amount.
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets discount_canceled
     *
     * @return float|null
     */
    public function getDiscountCanceled()
    {
        return $this->container['discount_canceled'];
    }

    /**
     * Sets discount_canceled
     *
     * @param float|null $discount_canceled Discount canceled.
     *
     * @return self
     */
    public function setDiscountCanceled($discount_canceled)
    {
        $this->container['discount_canceled'] = $discount_canceled;

        return $this;
    }

    /**
     * Gets discount_description
     *
     * @return string|null
     */
    public function getDiscountDescription()
    {
        return $this->container['discount_description'];
    }

    /**
     * Sets discount_description
     *
     * @param string|null $discount_description Discount description.
     *
     * @return self
     */
    public function setDiscountDescription($discount_description)
    {
        $this->container['discount_description'] = $discount_description;

        return $this;
    }

    /**
     * Gets discount_invoiced
     *
     * @return float|null
     */
    public function getDiscountInvoiced()
    {
        return $this->container['discount_invoiced'];
    }

    /**
     * Sets discount_invoiced
     *
     * @param float|null $discount_invoiced Discount invoiced.
     *
     * @return self
     */
    public function setDiscountInvoiced($discount_invoiced)
    {
        $this->container['discount_invoiced'] = $discount_invoiced;

        return $this;
    }

    /**
     * Gets discount_refunded
     *
     * @return float|null
     */
    public function getDiscountRefunded()
    {
        return $this->container['discount_refunded'];
    }

    /**
     * Sets discount_refunded
     *
     * @param float|null $discount_refunded Discount refunded amount.
     *
     * @return self
     */
    public function setDiscountRefunded($discount_refunded)
    {
        $this->container['discount_refunded'] = $discount_refunded;

        return $this;
    }

    /**
     * Gets edit_increment
     *
     * @return int|null
     */
    public function getEditIncrement()
    {
        return $this->container['edit_increment'];
    }

    /**
     * Sets edit_increment
     *
     * @param int|null $edit_increment Edit increment value.
     *
     * @return self
     */
    public function setEditIncrement($edit_increment)
    {
        $this->container['edit_increment'] = $edit_increment;

        return $this;
    }

    /**
     * Gets email_sent
     *
     * @return int|null
     */
    public function getEmailSent()
    {
        return $this->container['email_sent'];
    }

    /**
     * Sets email_sent
     *
     * @param int|null $email_sent Email-sent flag value.
     *
     * @return self
     */
    public function setEmailSent($email_sent)
    {
        $this->container['email_sent'] = $email_sent;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return int|null
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param int|null $entity_id Order ID.
     *
     * @return self
     */
    public function setEntityId($entity_id)
    {
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets ext_customer_id
     *
     * @return string|null
     */
    public function getExtCustomerId()
    {
        return $this->container['ext_customer_id'];
    }

    /**
     * Sets ext_customer_id
     *
     * @param string|null $ext_customer_id External customer ID.
     *
     * @return self
     */
    public function setExtCustomerId($ext_customer_id)
    {
        $this->container['ext_customer_id'] = $ext_customer_id;

        return $this;
    }

    /**
     * Gets ext_order_id
     *
     * @return string|null
     */
    public function getExtOrderId()
    {
        return $this->container['ext_order_id'];
    }

    /**
     * Sets ext_order_id
     *
     * @param string|null $ext_order_id External order ID.
     *
     * @return self
     */
    public function setExtOrderId($ext_order_id)
    {
        $this->container['ext_order_id'] = $ext_order_id;

        return $this;
    }

    /**
     * Gets forced_shipment_with_invoice
     *
     * @return int|null
     */
    public function getForcedShipmentWithInvoice()
    {
        return $this->container['forced_shipment_with_invoice'];
    }

    /**
     * Sets forced_shipment_with_invoice
     *
     * @param int|null $forced_shipment_with_invoice Forced-shipment-with-invoice flag value.
     *
     * @return self
     */
    public function setForcedShipmentWithInvoice($forced_shipment_with_invoice)
    {
        $this->container['forced_shipment_with_invoice'] = $forced_shipment_with_invoice;

        return $this;
    }

    /**
     * Gets global_currency_code
     *
     * @return string|null
     */
    public function getGlobalCurrencyCode()
    {
        return $this->container['global_currency_code'];
    }

    /**
     * Sets global_currency_code
     *
     * @param string|null $global_currency_code Global currency code.
     *
     * @return self
     */
    public function setGlobalCurrencyCode($global_currency_code)
    {
        $this->container['global_currency_code'] = $global_currency_code;

        return $this;
    }

    /**
     * Gets grand_total
     *
     * @return float
     */
    public function getGrandTotal()
    {
        return $this->container['grand_total'];
    }

    /**
     * Sets grand_total
     *
     * @param float $grand_total Grand total.
     *
     * @return self
     */
    public function setGrandTotal($grand_total)
    {
        $this->container['grand_total'] = $grand_total;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationAmount()
    {
        return $this->container['discount_tax_compensation_amount'];
    }

    /**
     * Sets discount_tax_compensation_amount
     *
     * @param float|null $discount_tax_compensation_amount Discount tax compensation amount.
     *
     * @return self
     */
    public function setDiscountTaxCompensationAmount($discount_tax_compensation_amount)
    {
        $this->container['discount_tax_compensation_amount'] = $discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_invoiced
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationInvoiced()
    {
        return $this->container['discount_tax_compensation_invoiced'];
    }

    /**
     * Sets discount_tax_compensation_invoiced
     *
     * @param float|null $discount_tax_compensation_invoiced Discount tax compensation invoiced amount.
     *
     * @return self
     */
    public function setDiscountTaxCompensationInvoiced($discount_tax_compensation_invoiced)
    {
        $this->container['discount_tax_compensation_invoiced'] = $discount_tax_compensation_invoiced;

        return $this;
    }

    /**
     * Gets discount_tax_compensation_refunded
     *
     * @return float|null
     */
    public function getDiscountTaxCompensationRefunded()
    {
        return $this->container['discount_tax_compensation_refunded'];
    }

    /**
     * Sets discount_tax_compensation_refunded
     *
     * @param float|null $discount_tax_compensation_refunded Discount tax compensation refunded amount.
     *
     * @return self
     */
    public function setDiscountTaxCompensationRefunded($discount_tax_compensation_refunded)
    {
        $this->container['discount_tax_compensation_refunded'] = $discount_tax_compensation_refunded;

        return $this;
    }

    /**
     * Gets hold_before_state
     *
     * @return string|null
     */
    public function getHoldBeforeState()
    {
        return $this->container['hold_before_state'];
    }

    /**
     * Sets hold_before_state
     *
     * @param string|null $hold_before_state Hold before state.
     *
     * @return self
     */
    public function setHoldBeforeState($hold_before_state)
    {
        $this->container['hold_before_state'] = $hold_before_state;

        return $this;
    }

    /**
     * Gets hold_before_status
     *
     * @return string|null
     */
    public function getHoldBeforeStatus()
    {
        return $this->container['hold_before_status'];
    }

    /**
     * Sets hold_before_status
     *
     * @param string|null $hold_before_status Hold before status.
     *
     * @return self
     */
    public function setHoldBeforeStatus($hold_before_status)
    {
        $this->container['hold_before_status'] = $hold_before_status;

        return $this;
    }

    /**
     * Gets increment_id
     *
     * @return string|null
     */
    public function getIncrementId()
    {
        return $this->container['increment_id'];
    }

    /**
     * Sets increment_id
     *
     * @param string|null $increment_id Increment ID.
     *
     * @return self
     */
    public function setIncrementId($increment_id)
    {
        $this->container['increment_id'] = $increment_id;

        return $this;
    }

    /**
     * Gets is_virtual
     *
     * @return int|null
     */
    public function getIsVirtual()
    {
        return $this->container['is_virtual'];
    }

    /**
     * Sets is_virtual
     *
     * @param int|null $is_virtual Is-virtual flag value.
     *
     * @return self
     */
    public function setIsVirtual($is_virtual)
    {
        $this->container['is_virtual'] = $is_virtual;

        return $this;
    }

    /**
     * Gets order_currency_code
     *
     * @return string|null
     */
    public function getOrderCurrencyCode()
    {
        return $this->container['order_currency_code'];
    }

    /**
     * Sets order_currency_code
     *
     * @param string|null $order_currency_code Order currency code.
     *
     * @return self
     */
    public function setOrderCurrencyCode($order_currency_code)
    {
        $this->container['order_currency_code'] = $order_currency_code;

        return $this;
    }

    /**
     * Gets original_increment_id
     *
     * @return string|null
     */
    public function getOriginalIncrementId()
    {
        return $this->container['original_increment_id'];
    }

    /**
     * Sets original_increment_id
     *
     * @param string|null $original_increment_id Original increment ID.
     *
     * @return self
     */
    public function setOriginalIncrementId($original_increment_id)
    {
        $this->container['original_increment_id'] = $original_increment_id;

        return $this;
    }

    /**
     * Gets payment_authorization_amount
     *
     * @return float|null
     */
    public function getPaymentAuthorizationAmount()
    {
        return $this->container['payment_authorization_amount'];
    }

    /**
     * Sets payment_authorization_amount
     *
     * @param float|null $payment_authorization_amount Payment authorization amount.
     *
     * @return self
     */
    public function setPaymentAuthorizationAmount($payment_authorization_amount)
    {
        $this->container['payment_authorization_amount'] = $payment_authorization_amount;

        return $this;
    }

    /**
     * Gets payment_auth_expiration
     *
     * @return int|null
     */
    public function getPaymentAuthExpiration()
    {
        return $this->container['payment_auth_expiration'];
    }

    /**
     * Sets payment_auth_expiration
     *
     * @param int|null $payment_auth_expiration Payment authorization expiration date.
     *
     * @return self
     */
    public function setPaymentAuthExpiration($payment_auth_expiration)
    {
        $this->container['payment_auth_expiration'] = $payment_auth_expiration;

        return $this;
    }

    /**
     * Gets protect_code
     *
     * @return string|null
     */
    public function getProtectCode()
    {
        return $this->container['protect_code'];
    }

    /**
     * Sets protect_code
     *
     * @param string|null $protect_code Protect code.
     *
     * @return self
     */
    public function setProtectCode($protect_code)
    {
        $this->container['protect_code'] = $protect_code;

        return $this;
    }

    /**
     * Gets quote_address_id
     *
     * @return int|null
     */
    public function getQuoteAddressId()
    {
        return $this->container['quote_address_id'];
    }

    /**
     * Sets quote_address_id
     *
     * @param int|null $quote_address_id Quote address ID.
     *
     * @return self
     */
    public function setQuoteAddressId($quote_address_id)
    {
        $this->container['quote_address_id'] = $quote_address_id;

        return $this;
    }

    /**
     * Gets quote_id
     *
     * @return int|null
     */
    public function getQuoteId()
    {
        return $this->container['quote_id'];
    }

    /**
     * Sets quote_id
     *
     * @param int|null $quote_id Quote ID.
     *
     * @return self
     */
    public function setQuoteId($quote_id)
    {
        $this->container['quote_id'] = $quote_id;

        return $this;
    }

    /**
     * Gets relation_child_id
     *
     * @return string|null
     */
    public function getRelationChildId()
    {
        return $this->container['relation_child_id'];
    }

    /**
     * Sets relation_child_id
     *
     * @param string|null $relation_child_id Relation child ID.
     *
     * @return self
     */
    public function setRelationChildId($relation_child_id)
    {
        $this->container['relation_child_id'] = $relation_child_id;

        return $this;
    }

    /**
     * Gets relation_child_real_id
     *
     * @return string|null
     */
    public function getRelationChildRealId()
    {
        return $this->container['relation_child_real_id'];
    }

    /**
     * Sets relation_child_real_id
     *
     * @param string|null $relation_child_real_id Relation child real ID.
     *
     * @return self
     */
    public function setRelationChildRealId($relation_child_real_id)
    {
        $this->container['relation_child_real_id'] = $relation_child_real_id;

        return $this;
    }

    /**
     * Gets relation_parent_id
     *
     * @return string|null
     */
    public function getRelationParentId()
    {
        return $this->container['relation_parent_id'];
    }

    /**
     * Sets relation_parent_id
     *
     * @param string|null $relation_parent_id Relation parent ID.
     *
     * @return self
     */
    public function setRelationParentId($relation_parent_id)
    {
        $this->container['relation_parent_id'] = $relation_parent_id;

        return $this;
    }

    /**
     * Gets relation_parent_real_id
     *
     * @return string|null
     */
    public function getRelationParentRealId()
    {
        return $this->container['relation_parent_real_id'];
    }

    /**
     * Sets relation_parent_real_id
     *
     * @param string|null $relation_parent_real_id Relation parent real ID.
     *
     * @return self
     */
    public function setRelationParentRealId($relation_parent_real_id)
    {
        $this->container['relation_parent_real_id'] = $relation_parent_real_id;

        return $this;
    }

    /**
     * Gets remote_ip
     *
     * @return string|null
     */
    public function getRemoteIp()
    {
        return $this->container['remote_ip'];
    }

    /**
     * Sets remote_ip
     *
     * @param string|null $remote_ip Remote IP address.
     *
     * @return self
     */
    public function setRemoteIp($remote_ip)
    {
        $this->container['remote_ip'] = $remote_ip;

        return $this;
    }

    /**
     * Gets shipping_amount
     *
     * @return float|null
     */
    public function getShippingAmount()
    {
        return $this->container['shipping_amount'];
    }

    /**
     * Sets shipping_amount
     *
     * @param float|null $shipping_amount Shipping amount.
     *
     * @return self
     */
    public function setShippingAmount($shipping_amount)
    {
        $this->container['shipping_amount'] = $shipping_amount;

        return $this;
    }

    /**
     * Gets shipping_canceled
     *
     * @return float|null
     */
    public function getShippingCanceled()
    {
        return $this->container['shipping_canceled'];
    }

    /**
     * Sets shipping_canceled
     *
     * @param float|null $shipping_canceled Shipping canceled amount.
     *
     * @return self
     */
    public function setShippingCanceled($shipping_canceled)
    {
        $this->container['shipping_canceled'] = $shipping_canceled;

        return $this;
    }

    /**
     * Gets shipping_description
     *
     * @return string|null
     */
    public function getShippingDescription()
    {
        return $this->container['shipping_description'];
    }

    /**
     * Sets shipping_description
     *
     * @param string|null $shipping_description Shipping description.
     *
     * @return self
     */
    public function setShippingDescription($shipping_description)
    {
        $this->container['shipping_description'] = $shipping_description;

        return $this;
    }

    /**
     * Gets shipping_discount_amount
     *
     * @return float|null
     */
    public function getShippingDiscountAmount()
    {
        return $this->container['shipping_discount_amount'];
    }

    /**
     * Sets shipping_discount_amount
     *
     * @param float|null $shipping_discount_amount Shipping discount amount.
     *
     * @return self
     */
    public function setShippingDiscountAmount($shipping_discount_amount)
    {
        $this->container['shipping_discount_amount'] = $shipping_discount_amount;

        return $this;
    }

    /**
     * Gets shipping_discount_tax_compensation_amount
     *
     * @return float|null
     */
    public function getShippingDiscountTaxCompensationAmount()
    {
        return $this->container['shipping_discount_tax_compensation_amount'];
    }

    /**
     * Sets shipping_discount_tax_compensation_amount
     *
     * @param float|null $shipping_discount_tax_compensation_amount Shipping discount tax compensation amount.
     *
     * @return self
     */
    public function setShippingDiscountTaxCompensationAmount($shipping_discount_tax_compensation_amount)
    {
        $this->container['shipping_discount_tax_compensation_amount'] = $shipping_discount_tax_compensation_amount;

        return $this;
    }

    /**
     * Gets shipping_incl_tax
     *
     * @return float|null
     */
    public function getShippingInclTax()
    {
        return $this->container['shipping_incl_tax'];
    }

    /**
     * Sets shipping_incl_tax
     *
     * @param float|null $shipping_incl_tax Shipping including tax amount.
     *
     * @return self
     */
    public function setShippingInclTax($shipping_incl_tax)
    {
        $this->container['shipping_incl_tax'] = $shipping_incl_tax;

        return $this;
    }

    /**
     * Gets shipping_invoiced
     *
     * @return float|null
     */
    public function getShippingInvoiced()
    {
        return $this->container['shipping_invoiced'];
    }

    /**
     * Sets shipping_invoiced
     *
     * @param float|null $shipping_invoiced Shipping invoiced amount.
     *
     * @return self
     */
    public function setShippingInvoiced($shipping_invoiced)
    {
        $this->container['shipping_invoiced'] = $shipping_invoiced;

        return $this;
    }

    /**
     * Gets shipping_refunded
     *
     * @return float|null
     */
    public function getShippingRefunded()
    {
        return $this->container['shipping_refunded'];
    }

    /**
     * Sets shipping_refunded
     *
     * @param float|null $shipping_refunded Shipping refunded amount.
     *
     * @return self
     */
    public function setShippingRefunded($shipping_refunded)
    {
        $this->container['shipping_refunded'] = $shipping_refunded;

        return $this;
    }

    /**
     * Gets shipping_tax_amount
     *
     * @return float|null
     */
    public function getShippingTaxAmount()
    {
        return $this->container['shipping_tax_amount'];
    }

    /**
     * Sets shipping_tax_amount
     *
     * @param float|null $shipping_tax_amount Shipping tax amount.
     *
     * @return self
     */
    public function setShippingTaxAmount($shipping_tax_amount)
    {
        $this->container['shipping_tax_amount'] = $shipping_tax_amount;

        return $this;
    }

    /**
     * Gets shipping_tax_refunded
     *
     * @return float|null
     */
    public function getShippingTaxRefunded()
    {
        return $this->container['shipping_tax_refunded'];
    }

    /**
     * Sets shipping_tax_refunded
     *
     * @param float|null $shipping_tax_refunded Shipping tax refunded amount.
     *
     * @return self
     */
    public function setShippingTaxRefunded($shipping_tax_refunded)
    {
        $this->container['shipping_tax_refunded'] = $shipping_tax_refunded;

        return $this;
    }

    /**
     * Gets state
     *
     * @return string|null
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     *
     * @param string|null $state State.
     *
     * @return self
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Status.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets store_currency_code
     *
     * @return string|null
     */
    public function getStoreCurrencyCode()
    {
        return $this->container['store_currency_code'];
    }

    /**
     * Sets store_currency_code
     *
     * @param string|null $store_currency_code Store currency code.
     *
     * @return self
     */
    public function setStoreCurrencyCode($store_currency_code)
    {
        $this->container['store_currency_code'] = $store_currency_code;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int|null
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int|null $store_id Store ID.
     *
     * @return self
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets store_name
     *
     * @return string|null
     */
    public function getStoreName()
    {
        return $this->container['store_name'];
    }

    /**
     * Sets store_name
     *
     * @param string|null $store_name Store name.
     *
     * @return self
     */
    public function setStoreName($store_name)
    {
        $this->container['store_name'] = $store_name;

        return $this;
    }

    /**
     * Gets store_to_base_rate
     *
     * @return float|null
     */
    public function getStoreToBaseRate()
    {
        return $this->container['store_to_base_rate'];
    }

    /**
     * Sets store_to_base_rate
     *
     * @param float|null $store_to_base_rate Store-to-base rate.
     *
     * @return self
     */
    public function setStoreToBaseRate($store_to_base_rate)
    {
        $this->container['store_to_base_rate'] = $store_to_base_rate;

        return $this;
    }

    /**
     * Gets store_to_order_rate
     *
     * @return float|null
     */
    public function getStoreToOrderRate()
    {
        return $this->container['store_to_order_rate'];
    }

    /**
     * Sets store_to_order_rate
     *
     * @param float|null $store_to_order_rate Store-to-order rate.
     *
     * @return self
     */
    public function setStoreToOrderRate($store_to_order_rate)
    {
        $this->container['store_to_order_rate'] = $store_to_order_rate;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return float|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param float|null $subtotal Subtotal.
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets subtotal_canceled
     *
     * @return float|null
     */
    public function getSubtotalCanceled()
    {
        return $this->container['subtotal_canceled'];
    }

    /**
     * Sets subtotal_canceled
     *
     * @param float|null $subtotal_canceled Subtotal canceled amount.
     *
     * @return self
     */
    public function setSubtotalCanceled($subtotal_canceled)
    {
        $this->container['subtotal_canceled'] = $subtotal_canceled;

        return $this;
    }

    /**
     * Gets subtotal_incl_tax
     *
     * @return float|null
     */
    public function getSubtotalInclTax()
    {
        return $this->container['subtotal_incl_tax'];
    }

    /**
     * Sets subtotal_incl_tax
     *
     * @param float|null $subtotal_incl_tax Subtotal including tax amount.
     *
     * @return self
     */
    public function setSubtotalInclTax($subtotal_incl_tax)
    {
        $this->container['subtotal_incl_tax'] = $subtotal_incl_tax;

        return $this;
    }

    /**
     * Gets subtotal_invoiced
     *
     * @return float|null
     */
    public function getSubtotalInvoiced()
    {
        return $this->container['subtotal_invoiced'];
    }

    /**
     * Sets subtotal_invoiced
     *
     * @param float|null $subtotal_invoiced Subtotal invoiced amount.
     *
     * @return self
     */
    public function setSubtotalInvoiced($subtotal_invoiced)
    {
        $this->container['subtotal_invoiced'] = $subtotal_invoiced;

        return $this;
    }

    /**
     * Gets subtotal_refunded
     *
     * @return float|null
     */
    public function getSubtotalRefunded()
    {
        return $this->container['subtotal_refunded'];
    }

    /**
     * Sets subtotal_refunded
     *
     * @param float|null $subtotal_refunded Subtotal refunded amount.
     *
     * @return self
     */
    public function setSubtotalRefunded($subtotal_refunded)
    {
        $this->container['subtotal_refunded'] = $subtotal_refunded;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float|null $tax_amount Tax amount.
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets tax_canceled
     *
     * @return float|null
     */
    public function getTaxCanceled()
    {
        return $this->container['tax_canceled'];
    }

    /**
     * Sets tax_canceled
     *
     * @param float|null $tax_canceled Tax canceled amount.
     *
     * @return self
     */
    public function setTaxCanceled($tax_canceled)
    {
        $this->container['tax_canceled'] = $tax_canceled;

        return $this;
    }

    /**
     * Gets tax_invoiced
     *
     * @return float|null
     */
    public function getTaxInvoiced()
    {
        return $this->container['tax_invoiced'];
    }

    /**
     * Sets tax_invoiced
     *
     * @param float|null $tax_invoiced Tax invoiced amount.
     *
     * @return self
     */
    public function setTaxInvoiced($tax_invoiced)
    {
        $this->container['tax_invoiced'] = $tax_invoiced;

        return $this;
    }

    /**
     * Gets tax_refunded
     *
     * @return float|null
     */
    public function getTaxRefunded()
    {
        return $this->container['tax_refunded'];
    }

    /**
     * Sets tax_refunded
     *
     * @param float|null $tax_refunded Tax refunded amount.
     *
     * @return self
     */
    public function setTaxRefunded($tax_refunded)
    {
        $this->container['tax_refunded'] = $tax_refunded;

        return $this;
    }

    /**
     * Gets total_canceled
     *
     * @return float|null
     */
    public function getTotalCanceled()
    {
        return $this->container['total_canceled'];
    }

    /**
     * Sets total_canceled
     *
     * @param float|null $total_canceled Total canceled.
     *
     * @return self
     */
    public function setTotalCanceled($total_canceled)
    {
        $this->container['total_canceled'] = $total_canceled;

        return $this;
    }

    /**
     * Gets total_due
     *
     * @return float|null
     */
    public function getTotalDue()
    {
        return $this->container['total_due'];
    }

    /**
     * Sets total_due
     *
     * @param float|null $total_due Total due.
     *
     * @return self
     */
    public function setTotalDue($total_due)
    {
        $this->container['total_due'] = $total_due;

        return $this;
    }

    /**
     * Gets total_invoiced
     *
     * @return float|null
     */
    public function getTotalInvoiced()
    {
        return $this->container['total_invoiced'];
    }

    /**
     * Sets total_invoiced
     *
     * @param float|null $total_invoiced Total invoiced amount.
     *
     * @return self
     */
    public function setTotalInvoiced($total_invoiced)
    {
        $this->container['total_invoiced'] = $total_invoiced;

        return $this;
    }

    /**
     * Gets total_item_count
     *
     * @return int|null
     */
    public function getTotalItemCount()
    {
        return $this->container['total_item_count'];
    }

    /**
     * Sets total_item_count
     *
     * @param int|null $total_item_count Total item count.
     *
     * @return self
     */
    public function setTotalItemCount($total_item_count)
    {
        $this->container['total_item_count'] = $total_item_count;

        return $this;
    }

    /**
     * Gets total_offline_refunded
     *
     * @return float|null
     */
    public function getTotalOfflineRefunded()
    {
        return $this->container['total_offline_refunded'];
    }

    /**
     * Sets total_offline_refunded
     *
     * @param float|null $total_offline_refunded Total offline refunded amount.
     *
     * @return self
     */
    public function setTotalOfflineRefunded($total_offline_refunded)
    {
        $this->container['total_offline_refunded'] = $total_offline_refunded;

        return $this;
    }

    /**
     * Gets total_online_refunded
     *
     * @return float|null
     */
    public function getTotalOnlineRefunded()
    {
        return $this->container['total_online_refunded'];
    }

    /**
     * Sets total_online_refunded
     *
     * @param float|null $total_online_refunded Total online refunded amount.
     *
     * @return self
     */
    public function setTotalOnlineRefunded($total_online_refunded)
    {
        $this->container['total_online_refunded'] = $total_online_refunded;

        return $this;
    }

    /**
     * Gets total_paid
     *
     * @return float|null
     */
    public function getTotalPaid()
    {
        return $this->container['total_paid'];
    }

    /**
     * Sets total_paid
     *
     * @param float|null $total_paid Total paid.
     *
     * @return self
     */
    public function setTotalPaid($total_paid)
    {
        $this->container['total_paid'] = $total_paid;

        return $this;
    }

    /**
     * Gets total_qty_ordered
     *
     * @return float|null
     */
    public function getTotalQtyOrdered()
    {
        return $this->container['total_qty_ordered'];
    }

    /**
     * Sets total_qty_ordered
     *
     * @param float|null $total_qty_ordered Total quantity ordered.
     *
     * @return self
     */
    public function setTotalQtyOrdered($total_qty_ordered)
    {
        $this->container['total_qty_ordered'] = $total_qty_ordered;

        return $this;
    }

    /**
     * Gets total_refunded
     *
     * @return float|null
     */
    public function getTotalRefunded()
    {
        return $this->container['total_refunded'];
    }

    /**
     * Sets total_refunded
     *
     * @param float|null $total_refunded Total amount refunded.
     *
     * @return self
     */
    public function setTotalRefunded($total_refunded)
    {
        $this->container['total_refunded'] = $total_refunded;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Updated-at timestamp.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Weight.
     *
     * @return self
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets x_forwarded_for
     *
     * @return string|null
     */
    public function getXForwardedFor()
    {
        return $this->container['x_forwarded_for'];
    }

    /**
     * Sets x_forwarded_for
     *
     * @param string|null $x_forwarded_for X-Forwarded-For field value.
     *
     * @return self
     */
    public function setXForwardedFor($x_forwarded_for)
    {
        $this->container['x_forwarded_for'] = $x_forwarded_for;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Magento2\Model\SalesDataOrderItemInterface[]
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Magento2\Model\SalesDataOrderItemInterface[] $items Array of items.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \Magento2\Model\SalesDataOrderAddressInterface|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Magento2\Model\SalesDataOrderAddressInterface|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets payment
     *
     * @return \Magento2\Model\SalesDataOrderPaymentInterface|null
     */
    public function getPayment()
    {
        return $this->container['payment'];
    }

    /**
     * Sets payment
     *
     * @param \Magento2\Model\SalesDataOrderPaymentInterface|null $payment payment
     *
     * @return self
     */
    public function setPayment($payment)
    {
        $this->container['payment'] = $payment;

        return $this;
    }

    /**
     * Gets status_histories
     *
     * @return \Magento2\Model\SalesDataOrderStatusHistoryInterface[]|null
     */
    public function getStatusHistories()
    {
        return $this->container['status_histories'];
    }

    /**
     * Sets status_histories
     *
     * @param \Magento2\Model\SalesDataOrderStatusHistoryInterface[]|null $status_histories Array of status histories.
     *
     * @return self
     */
    public function setStatusHistories($status_histories)
    {
        $this->container['status_histories'] = $status_histories;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Magento2\Model\SalesDataOrderExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Magento2\Model\SalesDataOrderExtensionInterface|null $extension_attributes extension_attributes
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


