<?php
/**
 * QuoteDataTotalsItemInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * QuoteDataTotalsItemInterface Class Doc Comment
 *
 * @category Class
 * @description Interface TotalsItemInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class QuoteDataTotalsItemInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'quote-data-totals-item-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_id' => 'int',
        'price' => 'float',
        'base_price' => 'float',
        'qty' => 'float',
        'row_total' => 'float',
        'base_row_total' => 'float',
        'row_total_with_discount' => 'float',
        'tax_amount' => 'float',
        'base_tax_amount' => 'float',
        'tax_percent' => 'float',
        'discount_amount' => 'float',
        'base_discount_amount' => 'float',
        'discount_percent' => 'float',
        'price_incl_tax' => 'float',
        'base_price_incl_tax' => 'float',
        'row_total_incl_tax' => 'float',
        'base_row_total_incl_tax' => 'float',
        'options' => 'string',
        'weee_tax_applied_amount' => 'float',
        'weee_tax_applied' => 'string',
        'extension_attributes' => 'object',
        'name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_id' => null,
        'price' => null,
        'base_price' => null,
        'qty' => null,
        'row_total' => null,
        'base_row_total' => null,
        'row_total_with_discount' => null,
        'tax_amount' => null,
        'base_tax_amount' => null,
        'tax_percent' => null,
        'discount_amount' => null,
        'base_discount_amount' => null,
        'discount_percent' => null,
        'price_incl_tax' => null,
        'base_price_incl_tax' => null,
        'row_total_incl_tax' => null,
        'base_row_total_incl_tax' => null,
        'options' => null,
        'weee_tax_applied_amount' => null,
        'weee_tax_applied' => null,
        'extension_attributes' => null,
        'name' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_id' => 'item_id',
        'price' => 'price',
        'base_price' => 'base_price',
        'qty' => 'qty',
        'row_total' => 'row_total',
        'base_row_total' => 'base_row_total',
        'row_total_with_discount' => 'row_total_with_discount',
        'tax_amount' => 'tax_amount',
        'base_tax_amount' => 'base_tax_amount',
        'tax_percent' => 'tax_percent',
        'discount_amount' => 'discount_amount',
        'base_discount_amount' => 'base_discount_amount',
        'discount_percent' => 'discount_percent',
        'price_incl_tax' => 'price_incl_tax',
        'base_price_incl_tax' => 'base_price_incl_tax',
        'row_total_incl_tax' => 'row_total_incl_tax',
        'base_row_total_incl_tax' => 'base_row_total_incl_tax',
        'options' => 'options',
        'weee_tax_applied_amount' => 'weee_tax_applied_amount',
        'weee_tax_applied' => 'weee_tax_applied',
        'extension_attributes' => 'extension_attributes',
        'name' => 'name'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_id' => 'setItemId',
        'price' => 'setPrice',
        'base_price' => 'setBasePrice',
        'qty' => 'setQty',
        'row_total' => 'setRowTotal',
        'base_row_total' => 'setBaseRowTotal',
        'row_total_with_discount' => 'setRowTotalWithDiscount',
        'tax_amount' => 'setTaxAmount',
        'base_tax_amount' => 'setBaseTaxAmount',
        'tax_percent' => 'setTaxPercent',
        'discount_amount' => 'setDiscountAmount',
        'base_discount_amount' => 'setBaseDiscountAmount',
        'discount_percent' => 'setDiscountPercent',
        'price_incl_tax' => 'setPriceInclTax',
        'base_price_incl_tax' => 'setBasePriceInclTax',
        'row_total_incl_tax' => 'setRowTotalInclTax',
        'base_row_total_incl_tax' => 'setBaseRowTotalInclTax',
        'options' => 'setOptions',
        'weee_tax_applied_amount' => 'setWeeeTaxAppliedAmount',
        'weee_tax_applied' => 'setWeeeTaxApplied',
        'extension_attributes' => 'setExtensionAttributes',
        'name' => 'setName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_id' => 'getItemId',
        'price' => 'getPrice',
        'base_price' => 'getBasePrice',
        'qty' => 'getQty',
        'row_total' => 'getRowTotal',
        'base_row_total' => 'getBaseRowTotal',
        'row_total_with_discount' => 'getRowTotalWithDiscount',
        'tax_amount' => 'getTaxAmount',
        'base_tax_amount' => 'getBaseTaxAmount',
        'tax_percent' => 'getTaxPercent',
        'discount_amount' => 'getDiscountAmount',
        'base_discount_amount' => 'getBaseDiscountAmount',
        'discount_percent' => 'getDiscountPercent',
        'price_incl_tax' => 'getPriceInclTax',
        'base_price_incl_tax' => 'getBasePriceInclTax',
        'row_total_incl_tax' => 'getRowTotalInclTax',
        'base_row_total_incl_tax' => 'getBaseRowTotalInclTax',
        'options' => 'getOptions',
        'weee_tax_applied_amount' => 'getWeeeTaxAppliedAmount',
        'weee_tax_applied' => 'getWeeeTaxApplied',
        'extension_attributes' => 'getExtensionAttributes',
        'name' => 'getName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['item_id'] = $data['item_id'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['base_price'] = $data['base_price'] ?? null;
        $this->container['qty'] = $data['qty'] ?? null;
        $this->container['row_total'] = $data['row_total'] ?? null;
        $this->container['base_row_total'] = $data['base_row_total'] ?? null;
        $this->container['row_total_with_discount'] = $data['row_total_with_discount'] ?? null;
        $this->container['tax_amount'] = $data['tax_amount'] ?? null;
        $this->container['base_tax_amount'] = $data['base_tax_amount'] ?? null;
        $this->container['tax_percent'] = $data['tax_percent'] ?? null;
        $this->container['discount_amount'] = $data['discount_amount'] ?? null;
        $this->container['base_discount_amount'] = $data['base_discount_amount'] ?? null;
        $this->container['discount_percent'] = $data['discount_percent'] ?? null;
        $this->container['price_incl_tax'] = $data['price_incl_tax'] ?? null;
        $this->container['base_price_incl_tax'] = $data['base_price_incl_tax'] ?? null;
        $this->container['row_total_incl_tax'] = $data['row_total_incl_tax'] ?? null;
        $this->container['base_row_total_incl_tax'] = $data['base_row_total_incl_tax'] ?? null;
        $this->container['options'] = $data['options'] ?? null;
        $this->container['weee_tax_applied_amount'] = $data['weee_tax_applied_amount'] ?? null;
        $this->container['weee_tax_applied'] = $data['weee_tax_applied'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['item_id'] === null) {
            $invalidProperties[] = "'item_id' can't be null";
        }
        if ($this->container['price'] === null) {
            $invalidProperties[] = "'price' can't be null";
        }
        if ($this->container['base_price'] === null) {
            $invalidProperties[] = "'base_price' can't be null";
        }
        if ($this->container['qty'] === null) {
            $invalidProperties[] = "'qty' can't be null";
        }
        if ($this->container['row_total'] === null) {
            $invalidProperties[] = "'row_total' can't be null";
        }
        if ($this->container['base_row_total'] === null) {
            $invalidProperties[] = "'base_row_total' can't be null";
        }
        if ($this->container['options'] === null) {
            $invalidProperties[] = "'options' can't be null";
        }
        if ($this->container['weee_tax_applied_amount'] === null) {
            $invalidProperties[] = "'weee_tax_applied_amount' can't be null";
        }
        if ($this->container['weee_tax_applied'] === null) {
            $invalidProperties[] = "'weee_tax_applied' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_id
     *
     * @return int
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int $item_id Item id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float $price Item price in quote currency.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets base_price
     *
     * @return float
     */
    public function getBasePrice()
    {
        return $this->container['base_price'];
    }

    /**
     * Sets base_price
     *
     * @param float $base_price Item price in base currency.
     *
     * @return self
     */
    public function setBasePrice($base_price)
    {
        $this->container['base_price'] = $base_price;

        return $this;
    }

    /**
     * Gets qty
     *
     * @return float
     */
    public function getQty()
    {
        return $this->container['qty'];
    }

    /**
     * Sets qty
     *
     * @param float $qty Item quantity.
     *
     * @return self
     */
    public function setQty($qty)
    {
        $this->container['qty'] = $qty;

        return $this;
    }

    /**
     * Gets row_total
     *
     * @return float
     */
    public function getRowTotal()
    {
        return $this->container['row_total'];
    }

    /**
     * Sets row_total
     *
     * @param float $row_total Row total in quote currency.
     *
     * @return self
     */
    public function setRowTotal($row_total)
    {
        $this->container['row_total'] = $row_total;

        return $this;
    }

    /**
     * Gets base_row_total
     *
     * @return float
     */
    public function getBaseRowTotal()
    {
        return $this->container['base_row_total'];
    }

    /**
     * Sets base_row_total
     *
     * @param float $base_row_total Row total in base currency.
     *
     * @return self
     */
    public function setBaseRowTotal($base_row_total)
    {
        $this->container['base_row_total'] = $base_row_total;

        return $this;
    }

    /**
     * Gets row_total_with_discount
     *
     * @return float|null
     */
    public function getRowTotalWithDiscount()
    {
        return $this->container['row_total_with_discount'];
    }

    /**
     * Sets row_total_with_discount
     *
     * @param float|null $row_total_with_discount Row total with discount in quote currency. Otherwise, null.
     *
     * @return self
     */
    public function setRowTotalWithDiscount($row_total_with_discount)
    {
        $this->container['row_total_with_discount'] = $row_total_with_discount;

        return $this;
    }

    /**
     * Gets tax_amount
     *
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->container['tax_amount'];
    }

    /**
     * Sets tax_amount
     *
     * @param float|null $tax_amount Tax amount in quote currency. Otherwise, null.
     *
     * @return self
     */
    public function setTaxAmount($tax_amount)
    {
        $this->container['tax_amount'] = $tax_amount;

        return $this;
    }

    /**
     * Gets base_tax_amount
     *
     * @return float|null
     */
    public function getBaseTaxAmount()
    {
        return $this->container['base_tax_amount'];
    }

    /**
     * Sets base_tax_amount
     *
     * @param float|null $base_tax_amount Tax amount in base currency. Otherwise, null.
     *
     * @return self
     */
    public function setBaseTaxAmount($base_tax_amount)
    {
        $this->container['base_tax_amount'] = $base_tax_amount;

        return $this;
    }

    /**
     * Gets tax_percent
     *
     * @return float|null
     */
    public function getTaxPercent()
    {
        return $this->container['tax_percent'];
    }

    /**
     * Sets tax_percent
     *
     * @param float|null $tax_percent Tax percent. Otherwise, null.
     *
     * @return self
     */
    public function setTaxPercent($tax_percent)
    {
        $this->container['tax_percent'] = $tax_percent;

        return $this;
    }

    /**
     * Gets discount_amount
     *
     * @return float|null
     */
    public function getDiscountAmount()
    {
        return $this->container['discount_amount'];
    }

    /**
     * Sets discount_amount
     *
     * @param float|null $discount_amount Discount amount in quote currency. Otherwise, null.
     *
     * @return self
     */
    public function setDiscountAmount($discount_amount)
    {
        $this->container['discount_amount'] = $discount_amount;

        return $this;
    }

    /**
     * Gets base_discount_amount
     *
     * @return float|null
     */
    public function getBaseDiscountAmount()
    {
        return $this->container['base_discount_amount'];
    }

    /**
     * Sets base_discount_amount
     *
     * @param float|null $base_discount_amount Discount amount in base currency. Otherwise, null.
     *
     * @return self
     */
    public function setBaseDiscountAmount($base_discount_amount)
    {
        $this->container['base_discount_amount'] = $base_discount_amount;

        return $this;
    }

    /**
     * Gets discount_percent
     *
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->container['discount_percent'];
    }

    /**
     * Sets discount_percent
     *
     * @param float|null $discount_percent Discount percent. Otherwise, null.
     *
     * @return self
     */
    public function setDiscountPercent($discount_percent)
    {
        $this->container['discount_percent'] = $discount_percent;

        return $this;
    }

    /**
     * Gets price_incl_tax
     *
     * @return float|null
     */
    public function getPriceInclTax()
    {
        return $this->container['price_incl_tax'];
    }

    /**
     * Sets price_incl_tax
     *
     * @param float|null $price_incl_tax Price including tax in quote currency. Otherwise, null.
     *
     * @return self
     */
    public function setPriceInclTax($price_incl_tax)
    {
        $this->container['price_incl_tax'] = $price_incl_tax;

        return $this;
    }

    /**
     * Gets base_price_incl_tax
     *
     * @return float|null
     */
    public function getBasePriceInclTax()
    {
        return $this->container['base_price_incl_tax'];
    }

    /**
     * Sets base_price_incl_tax
     *
     * @param float|null $base_price_incl_tax Price including tax in base currency. Otherwise, null.
     *
     * @return self
     */
    public function setBasePriceInclTax($base_price_incl_tax)
    {
        $this->container['base_price_incl_tax'] = $base_price_incl_tax;

        return $this;
    }

    /**
     * Gets row_total_incl_tax
     *
     * @return float|null
     */
    public function getRowTotalInclTax()
    {
        return $this->container['row_total_incl_tax'];
    }

    /**
     * Sets row_total_incl_tax
     *
     * @param float|null $row_total_incl_tax Row total including tax in quote currency. Otherwise, null.
     *
     * @return self
     */
    public function setRowTotalInclTax($row_total_incl_tax)
    {
        $this->container['row_total_incl_tax'] = $row_total_incl_tax;

        return $this;
    }

    /**
     * Gets base_row_total_incl_tax
     *
     * @return float|null
     */
    public function getBaseRowTotalInclTax()
    {
        return $this->container['base_row_total_incl_tax'];
    }

    /**
     * Sets base_row_total_incl_tax
     *
     * @param float|null $base_row_total_incl_tax Row total including tax in base currency. Otherwise, null.
     *
     * @return self
     */
    public function setBaseRowTotalInclTax($base_row_total_incl_tax)
    {
        $this->container['base_row_total_incl_tax'] = $base_row_total_incl_tax;

        return $this;
    }

    /**
     * Gets options
     *
     * @return string
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param string $options Item price in quote currency.
     *
     * @return self
     */
    public function setOptions($options)
    {
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets weee_tax_applied_amount
     *
     * @return float
     */
    public function getWeeeTaxAppliedAmount()
    {
        return $this->container['weee_tax_applied_amount'];
    }

    /**
     * Sets weee_tax_applied_amount
     *
     * @param float $weee_tax_applied_amount Item weee tax applied amount in quote currency.
     *
     * @return self
     */
    public function setWeeeTaxAppliedAmount($weee_tax_applied_amount)
    {
        $this->container['weee_tax_applied_amount'] = $weee_tax_applied_amount;

        return $this;
    }

    /**
     * Gets weee_tax_applied
     *
     * @return string
     */
    public function getWeeeTaxApplied()
    {
        return $this->container['weee_tax_applied'];
    }

    /**
     * Sets weee_tax_applied
     *
     * @param string $weee_tax_applied Item weee tax applied in quote currency.
     *
     * @return self
     */
    public function setWeeeTaxApplied($weee_tax_applied)
    {
        $this->container['weee_tax_applied'] = $weee_tax_applied;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Quote\\Api\\Data\\TotalsItemInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Product name. Otherwise, null.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


