<?php
/**
 * QuoteDataShippingMethodInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * QuoteDataShippingMethodInterface Class Doc Comment
 *
 * @category Class
 * @description Interface ShippingMethodInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class QuoteDataShippingMethodInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'quote-data-shipping-method-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'carrier_code' => 'string',
        'method_code' => 'string',
        'carrier_title' => 'string',
        'method_title' => 'string',
        'amount' => 'float',
        'base_amount' => 'float',
        'available' => 'bool',
        'extension_attributes' => 'object',
        'error_message' => 'string',
        'price_excl_tax' => 'float',
        'price_incl_tax' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'carrier_code' => null,
        'method_code' => null,
        'carrier_title' => null,
        'method_title' => null,
        'amount' => null,
        'base_amount' => null,
        'available' => null,
        'extension_attributes' => null,
        'error_message' => null,
        'price_excl_tax' => null,
        'price_incl_tax' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'carrier_code' => 'carrier_code',
        'method_code' => 'method_code',
        'carrier_title' => 'carrier_title',
        'method_title' => 'method_title',
        'amount' => 'amount',
        'base_amount' => 'base_amount',
        'available' => 'available',
        'extension_attributes' => 'extension_attributes',
        'error_message' => 'error_message',
        'price_excl_tax' => 'price_excl_tax',
        'price_incl_tax' => 'price_incl_tax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'carrier_code' => 'setCarrierCode',
        'method_code' => 'setMethodCode',
        'carrier_title' => 'setCarrierTitle',
        'method_title' => 'setMethodTitle',
        'amount' => 'setAmount',
        'base_amount' => 'setBaseAmount',
        'available' => 'setAvailable',
        'extension_attributes' => 'setExtensionAttributes',
        'error_message' => 'setErrorMessage',
        'price_excl_tax' => 'setPriceExclTax',
        'price_incl_tax' => 'setPriceInclTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'carrier_code' => 'getCarrierCode',
        'method_code' => 'getMethodCode',
        'carrier_title' => 'getCarrierTitle',
        'method_title' => 'getMethodTitle',
        'amount' => 'getAmount',
        'base_amount' => 'getBaseAmount',
        'available' => 'getAvailable',
        'extension_attributes' => 'getExtensionAttributes',
        'error_message' => 'getErrorMessage',
        'price_excl_tax' => 'getPriceExclTax',
        'price_incl_tax' => 'getPriceInclTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['carrier_code'] = $data['carrier_code'] ?? null;
        $this->container['method_code'] = $data['method_code'] ?? null;
        $this->container['carrier_title'] = $data['carrier_title'] ?? null;
        $this->container['method_title'] = $data['method_title'] ?? null;
        $this->container['amount'] = $data['amount'] ?? null;
        $this->container['base_amount'] = $data['base_amount'] ?? null;
        $this->container['available'] = $data['available'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
        $this->container['error_message'] = $data['error_message'] ?? null;
        $this->container['price_excl_tax'] = $data['price_excl_tax'] ?? null;
        $this->container['price_incl_tax'] = $data['price_incl_tax'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['carrier_code'] === null) {
            $invalidProperties[] = "'carrier_code' can't be null";
        }
        if ($this->container['method_code'] === null) {
            $invalidProperties[] = "'method_code' can't be null";
        }
        if ($this->container['amount'] === null) {
            $invalidProperties[] = "'amount' can't be null";
        }
        if ($this->container['base_amount'] === null) {
            $invalidProperties[] = "'base_amount' can't be null";
        }
        if ($this->container['available'] === null) {
            $invalidProperties[] = "'available' can't be null";
        }
        if ($this->container['error_message'] === null) {
            $invalidProperties[] = "'error_message' can't be null";
        }
        if ($this->container['price_excl_tax'] === null) {
            $invalidProperties[] = "'price_excl_tax' can't be null";
        }
        if ($this->container['price_incl_tax'] === null) {
            $invalidProperties[] = "'price_incl_tax' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets carrier_code
     *
     * @return string
     */
    public function getCarrierCode()
    {
        return $this->container['carrier_code'];
    }

    /**
     * Sets carrier_code
     *
     * @param string $carrier_code Shipping carrier code.
     *
     * @return self
     */
    public function setCarrierCode($carrier_code)
    {
        $this->container['carrier_code'] = $carrier_code;

        return $this;
    }

    /**
     * Gets method_code
     *
     * @return string
     */
    public function getMethodCode()
    {
        return $this->container['method_code'];
    }

    /**
     * Sets method_code
     *
     * @param string $method_code Shipping method code.
     *
     * @return self
     */
    public function setMethodCode($method_code)
    {
        $this->container['method_code'] = $method_code;

        return $this;
    }

    /**
     * Gets carrier_title
     *
     * @return string|null
     */
    public function getCarrierTitle()
    {
        return $this->container['carrier_title'];
    }

    /**
     * Sets carrier_title
     *
     * @param string|null $carrier_title Shipping carrier title. Otherwise, null.
     *
     * @return self
     */
    public function setCarrierTitle($carrier_title)
    {
        $this->container['carrier_title'] = $carrier_title;

        return $this;
    }

    /**
     * Gets method_title
     *
     * @return string|null
     */
    public function getMethodTitle()
    {
        return $this->container['method_title'];
    }

    /**
     * Sets method_title
     *
     * @param string|null $method_title Shipping method title. Otherwise, null.
     *
     * @return self
     */
    public function setMethodTitle($method_title)
    {
        $this->container['method_title'] = $method_title;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float $amount Shipping amount in store currency.
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets base_amount
     *
     * @return float
     */
    public function getBaseAmount()
    {
        return $this->container['base_amount'];
    }

    /**
     * Sets base_amount
     *
     * @param float $base_amount Shipping amount in base currency.
     *
     * @return self
     */
    public function setBaseAmount($base_amount)
    {
        $this->container['base_amount'] = $base_amount;

        return $this;
    }

    /**
     * Gets available
     *
     * @return bool
     */
    public function getAvailable()
    {
        return $this->container['available'];
    }

    /**
     * Sets available
     *
     * @param bool $available The value of the availability flag for the current shipping method.
     *
     * @return self
     */
    public function setAvailable($available)
    {
        $this->container['available'] = $available;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Quote\\Api\\Data\\ShippingMethodInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }

    /**
     * Gets error_message
     *
     * @return string
     */
    public function getErrorMessage()
    {
        return $this->container['error_message'];
    }

    /**
     * Sets error_message
     *
     * @param string $error_message Shipping Error message.
     *
     * @return self
     */
    public function setErrorMessage($error_message)
    {
        $this->container['error_message'] = $error_message;

        return $this;
    }

    /**
     * Gets price_excl_tax
     *
     * @return float
     */
    public function getPriceExclTax()
    {
        return $this->container['price_excl_tax'];
    }

    /**
     * Sets price_excl_tax
     *
     * @param float $price_excl_tax Shipping price excl tax.
     *
     * @return self
     */
    public function setPriceExclTax($price_excl_tax)
    {
        $this->container['price_excl_tax'] = $price_excl_tax;

        return $this;
    }

    /**
     * Gets price_incl_tax
     *
     * @return float
     */
    public function getPriceInclTax()
    {
        return $this->container['price_incl_tax'];
    }

    /**
     * Sets price_incl_tax
     *
     * @param float $price_incl_tax Shipping price incl tax.
     *
     * @return self
     */
    public function setPriceInclTax($price_incl_tax)
    {
        $this->container['price_incl_tax'] = $price_incl_tax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


