<?php
/**
 * QuoteDataCurrencyInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * QuoteDataCurrencyInterface Class Doc Comment
 *
 * @category Class
 * @description Interface CurrencyInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class QuoteDataCurrencyInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'quote-data-currency-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'global_currency_code' => 'string',
        'base_currency_code' => 'string',
        'store_currency_code' => 'string',
        'quote_currency_code' => 'string',
        'store_to_base_rate' => 'float',
        'store_to_quote_rate' => 'float',
        'base_to_global_rate' => 'float',
        'base_to_quote_rate' => 'float',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'global_currency_code' => null,
        'base_currency_code' => null,
        'store_currency_code' => null,
        'quote_currency_code' => null,
        'store_to_base_rate' => null,
        'store_to_quote_rate' => null,
        'base_to_global_rate' => null,
        'base_to_quote_rate' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'global_currency_code' => 'global_currency_code',
        'base_currency_code' => 'base_currency_code',
        'store_currency_code' => 'store_currency_code',
        'quote_currency_code' => 'quote_currency_code',
        'store_to_base_rate' => 'store_to_base_rate',
        'store_to_quote_rate' => 'store_to_quote_rate',
        'base_to_global_rate' => 'base_to_global_rate',
        'base_to_quote_rate' => 'base_to_quote_rate',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'global_currency_code' => 'setGlobalCurrencyCode',
        'base_currency_code' => 'setBaseCurrencyCode',
        'store_currency_code' => 'setStoreCurrencyCode',
        'quote_currency_code' => 'setQuoteCurrencyCode',
        'store_to_base_rate' => 'setStoreToBaseRate',
        'store_to_quote_rate' => 'setStoreToQuoteRate',
        'base_to_global_rate' => 'setBaseToGlobalRate',
        'base_to_quote_rate' => 'setBaseToQuoteRate',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'global_currency_code' => 'getGlobalCurrencyCode',
        'base_currency_code' => 'getBaseCurrencyCode',
        'store_currency_code' => 'getStoreCurrencyCode',
        'quote_currency_code' => 'getQuoteCurrencyCode',
        'store_to_base_rate' => 'getStoreToBaseRate',
        'store_to_quote_rate' => 'getStoreToQuoteRate',
        'base_to_global_rate' => 'getBaseToGlobalRate',
        'base_to_quote_rate' => 'getBaseToQuoteRate',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['global_currency_code'] = $data['global_currency_code'] ?? null;
        $this->container['base_currency_code'] = $data['base_currency_code'] ?? null;
        $this->container['store_currency_code'] = $data['store_currency_code'] ?? null;
        $this->container['quote_currency_code'] = $data['quote_currency_code'] ?? null;
        $this->container['store_to_base_rate'] = $data['store_to_base_rate'] ?? null;
        $this->container['store_to_quote_rate'] = $data['store_to_quote_rate'] ?? null;
        $this->container['base_to_global_rate'] = $data['base_to_global_rate'] ?? null;
        $this->container['base_to_quote_rate'] = $data['base_to_quote_rate'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets global_currency_code
     *
     * @return string|null
     */
    public function getGlobalCurrencyCode()
    {
        return $this->container['global_currency_code'];
    }

    /**
     * Sets global_currency_code
     *
     * @param string|null $global_currency_code Global currency code
     *
     * @return self
     */
    public function setGlobalCurrencyCode($global_currency_code)
    {
        $this->container['global_currency_code'] = $global_currency_code;

        return $this;
    }

    /**
     * Gets base_currency_code
     *
     * @return string|null
     */
    public function getBaseCurrencyCode()
    {
        return $this->container['base_currency_code'];
    }

    /**
     * Sets base_currency_code
     *
     * @param string|null $base_currency_code Base currency code
     *
     * @return self
     */
    public function setBaseCurrencyCode($base_currency_code)
    {
        $this->container['base_currency_code'] = $base_currency_code;

        return $this;
    }

    /**
     * Gets store_currency_code
     *
     * @return string|null
     */
    public function getStoreCurrencyCode()
    {
        return $this->container['store_currency_code'];
    }

    /**
     * Sets store_currency_code
     *
     * @param string|null $store_currency_code Store currency code
     *
     * @return self
     */
    public function setStoreCurrencyCode($store_currency_code)
    {
        $this->container['store_currency_code'] = $store_currency_code;

        return $this;
    }

    /**
     * Gets quote_currency_code
     *
     * @return string|null
     */
    public function getQuoteCurrencyCode()
    {
        return $this->container['quote_currency_code'];
    }

    /**
     * Sets quote_currency_code
     *
     * @param string|null $quote_currency_code Quote currency code
     *
     * @return self
     */
    public function setQuoteCurrencyCode($quote_currency_code)
    {
        $this->container['quote_currency_code'] = $quote_currency_code;

        return $this;
    }

    /**
     * Gets store_to_base_rate
     *
     * @return float|null
     */
    public function getStoreToBaseRate()
    {
        return $this->container['store_to_base_rate'];
    }

    /**
     * Sets store_to_base_rate
     *
     * @param float|null $store_to_base_rate Store currency to base currency rate
     *
     * @return self
     */
    public function setStoreToBaseRate($store_to_base_rate)
    {
        $this->container['store_to_base_rate'] = $store_to_base_rate;

        return $this;
    }

    /**
     * Gets store_to_quote_rate
     *
     * @return float|null
     */
    public function getStoreToQuoteRate()
    {
        return $this->container['store_to_quote_rate'];
    }

    /**
     * Sets store_to_quote_rate
     *
     * @param float|null $store_to_quote_rate Store currency to quote currency rate
     *
     * @return self
     */
    public function setStoreToQuoteRate($store_to_quote_rate)
    {
        $this->container['store_to_quote_rate'] = $store_to_quote_rate;

        return $this;
    }

    /**
     * Gets base_to_global_rate
     *
     * @return float|null
     */
    public function getBaseToGlobalRate()
    {
        return $this->container['base_to_global_rate'];
    }

    /**
     * Sets base_to_global_rate
     *
     * @param float|null $base_to_global_rate Base currency to global currency rate
     *
     * @return self
     */
    public function setBaseToGlobalRate($base_to_global_rate)
    {
        $this->container['base_to_global_rate'] = $base_to_global_rate;

        return $this;
    }

    /**
     * Gets base_to_quote_rate
     *
     * @return float|null
     */
    public function getBaseToQuoteRate()
    {
        return $this->container['base_to_quote_rate'];
    }

    /**
     * Sets base_to_quote_rate
     *
     * @param float|null $base_to_quote_rate Base currency to quote currency rate
     *
     * @return self
     */
    public function setBaseToQuoteRate($base_to_quote_rate)
    {
        $this->container['base_to_quote_rate'] = $base_to_quote_rate;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Quote\\Api\\Data\\CurrencyInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


