<?php
/**
 * QuoteDataCartInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * QuoteDataCartInterface Class Doc Comment
 *
 * @category Class
 * @description Interface CartInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class QuoteDataCartInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'quote-data-cart-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'created_at' => 'string',
        'updated_at' => 'string',
        'converted_at' => 'string',
        'is_active' => 'bool',
        'is_virtual' => 'bool',
        'items' => '\Magento2\Model\QuoteDataCartItemInterface[]',
        'items_count' => 'int',
        'items_qty' => 'float',
        'customer' => '\Magento2\Model\CustomerDataCustomerInterface',
        'billing_address' => '\Magento2\Model\QuoteDataAddressInterface',
        'reserved_order_id' => 'string',
        'orig_order_id' => 'int',
        'currency' => '\Magento2\Model\QuoteDataCurrencyInterface',
        'customer_is_guest' => 'bool',
        'customer_note' => 'string',
        'customer_note_notify' => 'bool',
        'customer_tax_class_id' => 'int',
        'store_id' => 'int',
        'extension_attributes' => '\Magento2\Model\QuoteDataCartExtensionInterface'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'created_at' => null,
        'updated_at' => null,
        'converted_at' => null,
        'is_active' => null,
        'is_virtual' => null,
        'items' => null,
        'items_count' => null,
        'items_qty' => null,
        'customer' => null,
        'billing_address' => null,
        'reserved_order_id' => null,
        'orig_order_id' => null,
        'currency' => null,
        'customer_is_guest' => null,
        'customer_note' => null,
        'customer_note_notify' => null,
        'customer_tax_class_id' => null,
        'store_id' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'converted_at' => 'converted_at',
        'is_active' => 'is_active',
        'is_virtual' => 'is_virtual',
        'items' => 'items',
        'items_count' => 'items_count',
        'items_qty' => 'items_qty',
        'customer' => 'customer',
        'billing_address' => 'billing_address',
        'reserved_order_id' => 'reserved_order_id',
        'orig_order_id' => 'orig_order_id',
        'currency' => 'currency',
        'customer_is_guest' => 'customer_is_guest',
        'customer_note' => 'customer_note',
        'customer_note_notify' => 'customer_note_notify',
        'customer_tax_class_id' => 'customer_tax_class_id',
        'store_id' => 'store_id',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'converted_at' => 'setConvertedAt',
        'is_active' => 'setIsActive',
        'is_virtual' => 'setIsVirtual',
        'items' => 'setItems',
        'items_count' => 'setItemsCount',
        'items_qty' => 'setItemsQty',
        'customer' => 'setCustomer',
        'billing_address' => 'setBillingAddress',
        'reserved_order_id' => 'setReservedOrderId',
        'orig_order_id' => 'setOrigOrderId',
        'currency' => 'setCurrency',
        'customer_is_guest' => 'setCustomerIsGuest',
        'customer_note' => 'setCustomerNote',
        'customer_note_notify' => 'setCustomerNoteNotify',
        'customer_tax_class_id' => 'setCustomerTaxClassId',
        'store_id' => 'setStoreId',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'converted_at' => 'getConvertedAt',
        'is_active' => 'getIsActive',
        'is_virtual' => 'getIsVirtual',
        'items' => 'getItems',
        'items_count' => 'getItemsCount',
        'items_qty' => 'getItemsQty',
        'customer' => 'getCustomer',
        'billing_address' => 'getBillingAddress',
        'reserved_order_id' => 'getReservedOrderId',
        'orig_order_id' => 'getOrigOrderId',
        'currency' => 'getCurrency',
        'customer_is_guest' => 'getCustomerIsGuest',
        'customer_note' => 'getCustomerNote',
        'customer_note_notify' => 'getCustomerNoteNotify',
        'customer_tax_class_id' => 'getCustomerTaxClassId',
        'store_id' => 'getStoreId',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['converted_at'] = $data['converted_at'] ?? null;
        $this->container['is_active'] = $data['is_active'] ?? null;
        $this->container['is_virtual'] = $data['is_virtual'] ?? null;
        $this->container['items'] = $data['items'] ?? null;
        $this->container['items_count'] = $data['items_count'] ?? null;
        $this->container['items_qty'] = $data['items_qty'] ?? null;
        $this->container['customer'] = $data['customer'] ?? null;
        $this->container['billing_address'] = $data['billing_address'] ?? null;
        $this->container['reserved_order_id'] = $data['reserved_order_id'] ?? null;
        $this->container['orig_order_id'] = $data['orig_order_id'] ?? null;
        $this->container['currency'] = $data['currency'] ?? null;
        $this->container['customer_is_guest'] = $data['customer_is_guest'] ?? null;
        $this->container['customer_note'] = $data['customer_note'] ?? null;
        $this->container['customer_note_notify'] = $data['customer_note_notify'] ?? null;
        $this->container['customer_tax_class_id'] = $data['customer_tax_class_id'] ?? null;
        $this->container['store_id'] = $data['store_id'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['customer'] === null) {
            $invalidProperties[] = "'customer' can't be null";
        }
        if ($this->container['store_id'] === null) {
            $invalidProperties[] = "'store_id' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id Cart/quote ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at Cart creation date and time. Otherwise, null.
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Cart last update date and time. Otherwise, null.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets converted_at
     *
     * @return string|null
     */
    public function getConvertedAt()
    {
        return $this->container['converted_at'];
    }

    /**
     * Sets converted_at
     *
     * @param string|null $converted_at Cart conversion date and time. Otherwise, null.
     *
     * @return self
     */
    public function setConvertedAt($converted_at)
    {
        $this->container['converted_at'] = $converted_at;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active Active status flag value. Otherwise, null.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets is_virtual
     *
     * @return bool|null
     */
    public function getIsVirtual()
    {
        return $this->container['is_virtual'];
    }

    /**
     * Sets is_virtual
     *
     * @param bool|null $is_virtual Virtual flag value. Otherwise, null.
     *
     * @return self
     */
    public function setIsVirtual($is_virtual)
    {
        $this->container['is_virtual'] = $is_virtual;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Magento2\Model\QuoteDataCartItemInterface[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Magento2\Model\QuoteDataCartItemInterface[]|null $items Array of items. Otherwise, null.
     *
     * @return self
     */
    public function setItems($items)
    {
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets items_count
     *
     * @return int|null
     */
    public function getItemsCount()
    {
        return $this->container['items_count'];
    }

    /**
     * Sets items_count
     *
     * @param int|null $items_count Number of different items or products in the cart. Otherwise, null.
     *
     * @return self
     */
    public function setItemsCount($items_count)
    {
        $this->container['items_count'] = $items_count;

        return $this;
    }

    /**
     * Gets items_qty
     *
     * @return float|null
     */
    public function getItemsQty()
    {
        return $this->container['items_qty'];
    }

    /**
     * Sets items_qty
     *
     * @param float|null $items_qty Total quantity of all cart items. Otherwise, null.
     *
     * @return self
     */
    public function setItemsQty($items_qty)
    {
        $this->container['items_qty'] = $items_qty;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \Magento2\Model\CustomerDataCustomerInterface
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \Magento2\Model\CustomerDataCustomerInterface $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets billing_address
     *
     * @return \Magento2\Model\QuoteDataAddressInterface|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Magento2\Model\QuoteDataAddressInterface|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets reserved_order_id
     *
     * @return string|null
     */
    public function getReservedOrderId()
    {
        return $this->container['reserved_order_id'];
    }

    /**
     * Sets reserved_order_id
     *
     * @param string|null $reserved_order_id Reserved order ID. Otherwise, null.
     *
     * @return self
     */
    public function setReservedOrderId($reserved_order_id)
    {
        $this->container['reserved_order_id'] = $reserved_order_id;

        return $this;
    }

    /**
     * Gets orig_order_id
     *
     * @return int|null
     */
    public function getOrigOrderId()
    {
        return $this->container['orig_order_id'];
    }

    /**
     * Sets orig_order_id
     *
     * @param int|null $orig_order_id Original order ID. Otherwise, null.
     *
     * @return self
     */
    public function setOrigOrderId($orig_order_id)
    {
        $this->container['orig_order_id'] = $orig_order_id;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Magento2\Model\QuoteDataCurrencyInterface|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Magento2\Model\QuoteDataCurrencyInterface|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets customer_is_guest
     *
     * @return bool|null
     */
    public function getCustomerIsGuest()
    {
        return $this->container['customer_is_guest'];
    }

    /**
     * Sets customer_is_guest
     *
     * @param bool|null $customer_is_guest For guest customers, false for logged in customers
     *
     * @return self
     */
    public function setCustomerIsGuest($customer_is_guest)
    {
        $this->container['customer_is_guest'] = $customer_is_guest;

        return $this;
    }

    /**
     * Gets customer_note
     *
     * @return string|null
     */
    public function getCustomerNote()
    {
        return $this->container['customer_note'];
    }

    /**
     * Sets customer_note
     *
     * @param string|null $customer_note Notice text
     *
     * @return self
     */
    public function setCustomerNote($customer_note)
    {
        $this->container['customer_note'] = $customer_note;

        return $this;
    }

    /**
     * Gets customer_note_notify
     *
     * @return bool|null
     */
    public function getCustomerNoteNotify()
    {
        return $this->container['customer_note_notify'];
    }

    /**
     * Sets customer_note_notify
     *
     * @param bool|null $customer_note_notify Customer notification flag
     *
     * @return self
     */
    public function setCustomerNoteNotify($customer_note_notify)
    {
        $this->container['customer_note_notify'] = $customer_note_notify;

        return $this;
    }

    /**
     * Gets customer_tax_class_id
     *
     * @return int|null
     */
    public function getCustomerTaxClassId()
    {
        return $this->container['customer_tax_class_id'];
    }

    /**
     * Sets customer_tax_class_id
     *
     * @param int|null $customer_tax_class_id Customer tax class ID.
     *
     * @return self
     */
    public function setCustomerTaxClassId($customer_tax_class_id)
    {
        $this->container['customer_tax_class_id'] = $customer_tax_class_id;

        return $this;
    }

    /**
     * Gets store_id
     *
     * @return int
     */
    public function getStoreId()
    {
        return $this->container['store_id'];
    }

    /**
     * Sets store_id
     *
     * @param int $store_id Store identifier
     *
     * @return self
     */
    public function setStoreId($store_id)
    {
        $this->container['store_id'] = $store_id;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return \Magento2\Model\QuoteDataCartExtensionInterface|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param \Magento2\Model\QuoteDataCartExtensionInterface|null $extension_attributes extension_attributes
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


