<?php
/**
 * InventoryApiDataSourceInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * InventoryApiDataSourceInterface Class Doc Comment
 *
 * @category Class
 * @description Represents physical storage, i.e. brick and mortar store or warehouse Used fully qualified namespaces in annotations for proper work of WebApi request parser
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class InventoryApiDataSourceInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'inventory-api-data-source-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'source_code' => 'string',
        'name' => 'string',
        'email' => 'string',
        'contact_name' => 'string',
        'enabled' => 'bool',
        'description' => 'string',
        'latitude' => 'float',
        'longitude' => 'float',
        'country_id' => 'string',
        'region_id' => 'int',
        'region' => 'string',
        'city' => 'string',
        'street' => 'string',
        'postcode' => 'string',
        'phone' => 'string',
        'fax' => 'string',
        'use_default_carrier_config' => 'bool',
        'carrier_links' => '\Magento2\Model\InventoryApiDataSourceCarrierLinkInterface[]',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'source_code' => null,
        'name' => null,
        'email' => null,
        'contact_name' => null,
        'enabled' => null,
        'description' => null,
        'latitude' => null,
        'longitude' => null,
        'country_id' => null,
        'region_id' => null,
        'region' => null,
        'city' => null,
        'street' => null,
        'postcode' => null,
        'phone' => null,
        'fax' => null,
        'use_default_carrier_config' => null,
        'carrier_links' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'source_code' => 'source_code',
        'name' => 'name',
        'email' => 'email',
        'contact_name' => 'contact_name',
        'enabled' => 'enabled',
        'description' => 'description',
        'latitude' => 'latitude',
        'longitude' => 'longitude',
        'country_id' => 'country_id',
        'region_id' => 'region_id',
        'region' => 'region',
        'city' => 'city',
        'street' => 'street',
        'postcode' => 'postcode',
        'phone' => 'phone',
        'fax' => 'fax',
        'use_default_carrier_config' => 'use_default_carrier_config',
        'carrier_links' => 'carrier_links',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'source_code' => 'setSourceCode',
        'name' => 'setName',
        'email' => 'setEmail',
        'contact_name' => 'setContactName',
        'enabled' => 'setEnabled',
        'description' => 'setDescription',
        'latitude' => 'setLatitude',
        'longitude' => 'setLongitude',
        'country_id' => 'setCountryId',
        'region_id' => 'setRegionId',
        'region' => 'setRegion',
        'city' => 'setCity',
        'street' => 'setStreet',
        'postcode' => 'setPostcode',
        'phone' => 'setPhone',
        'fax' => 'setFax',
        'use_default_carrier_config' => 'setUseDefaultCarrierConfig',
        'carrier_links' => 'setCarrierLinks',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'source_code' => 'getSourceCode',
        'name' => 'getName',
        'email' => 'getEmail',
        'contact_name' => 'getContactName',
        'enabled' => 'getEnabled',
        'description' => 'getDescription',
        'latitude' => 'getLatitude',
        'longitude' => 'getLongitude',
        'country_id' => 'getCountryId',
        'region_id' => 'getRegionId',
        'region' => 'getRegion',
        'city' => 'getCity',
        'street' => 'getStreet',
        'postcode' => 'getPostcode',
        'phone' => 'getPhone',
        'fax' => 'getFax',
        'use_default_carrier_config' => 'getUseDefaultCarrierConfig',
        'carrier_links' => 'getCarrierLinks',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['source_code'] = $data['source_code'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['contact_name'] = $data['contact_name'] ?? null;
        $this->container['enabled'] = $data['enabled'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['latitude'] = $data['latitude'] ?? null;
        $this->container['longitude'] = $data['longitude'] ?? null;
        $this->container['country_id'] = $data['country_id'] ?? null;
        $this->container['region_id'] = $data['region_id'] ?? null;
        $this->container['region'] = $data['region'] ?? null;
        $this->container['city'] = $data['city'] ?? null;
        $this->container['street'] = $data['street'] ?? null;
        $this->container['postcode'] = $data['postcode'] ?? null;
        $this->container['phone'] = $data['phone'] ?? null;
        $this->container['fax'] = $data['fax'] ?? null;
        $this->container['use_default_carrier_config'] = $data['use_default_carrier_config'] ?? null;
        $this->container['carrier_links'] = $data['carrier_links'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets source_code
     *
     * @return string|null
     */
    public function getSourceCode()
    {
        return $this->container['source_code'];
    }

    /**
     * Sets source_code
     *
     * @param string|null $source_code Source code
     *
     * @return self
     */
    public function setSourceCode($source_code)
    {
        $this->container['source_code'] = $source_code;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Source name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Source email
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets contact_name
     *
     * @return string|null
     */
    public function getContactName()
    {
        return $this->container['contact_name'];
    }

    /**
     * Sets contact_name
     *
     * @param string|null $contact_name Source contact name
     *
     * @return self
     */
    public function setContactName($contact_name)
    {
        $this->container['contact_name'] = $contact_name;

        return $this;
    }

    /**
     * Gets enabled
     *
     * @return bool|null
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     *
     * @param bool|null $enabled If source is enabled. For new entity can be null
     *
     * @return self
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description Source description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets latitude
     *
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->container['latitude'];
    }

    /**
     * Sets latitude
     *
     * @param float|null $latitude Source latitude
     *
     * @return self
     */
    public function setLatitude($latitude)
    {
        $this->container['latitude'] = $latitude;

        return $this;
    }

    /**
     * Gets longitude
     *
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->container['longitude'];
    }

    /**
     * Sets longitude
     *
     * @param float|null $longitude Source longitude
     *
     * @return self
     */
    public function setLongitude($longitude)
    {
        $this->container['longitude'] = $longitude;

        return $this;
    }

    /**
     * Gets country_id
     *
     * @return string|null
     */
    public function getCountryId()
    {
        return $this->container['country_id'];
    }

    /**
     * Sets country_id
     *
     * @param string|null $country_id Source country id
     *
     * @return self
     */
    public function setCountryId($country_id)
    {
        $this->container['country_id'] = $country_id;

        return $this;
    }

    /**
     * Gets region_id
     *
     * @return int|null
     */
    public function getRegionId()
    {
        return $this->container['region_id'];
    }

    /**
     * Sets region_id
     *
     * @param int|null $region_id Region id if source has registered region.
     *
     * @return self
     */
    public function setRegionId($region_id)
    {
        $this->container['region_id'] = $region_id;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region Region title if source has custom region
     *
     * @return self
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city Source city
     *
     * @return self
     */
    public function setCity($city)
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets street
     *
     * @return string|null
     */
    public function getStreet()
    {
        return $this->container['street'];
    }

    /**
     * Sets street
     *
     * @param string|null $street Source street name
     *
     * @return self
     */
    public function setStreet($street)
    {
        $this->container['street'] = $street;

        return $this;
    }

    /**
     * Gets postcode
     *
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->container['postcode'];
    }

    /**
     * Sets postcode
     *
     * @param string|null $postcode Source post code
     *
     * @return self
     */
    public function setPostcode($postcode)
    {
        $this->container['postcode'] = $postcode;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Source phone number
     *
     * @return self
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax Source fax
     *
     * @return self
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets use_default_carrier_config
     *
     * @return bool|null
     */
    public function getUseDefaultCarrierConfig()
    {
        return $this->container['use_default_carrier_config'];
    }

    /**
     * Sets use_default_carrier_config
     *
     * @param bool|null $use_default_carrier_config Is need to use default config
     *
     * @return self
     */
    public function setUseDefaultCarrierConfig($use_default_carrier_config)
    {
        $this->container['use_default_carrier_config'] = $use_default_carrier_config;

        return $this;
    }

    /**
     * Gets carrier_links
     *
     * @return \Magento2\Model\InventoryApiDataSourceCarrierLinkInterface[]|null
     */
    public function getCarrierLinks()
    {
        return $this->container['carrier_links'];
    }

    /**
     * Sets carrier_links
     *
     * @param \Magento2\Model\InventoryApiDataSourceCarrierLinkInterface[]|null $carrier_links carrier_links
     *
     * @return self
     */
    public function setCarrierLinks($carrier_links)
    {
        $this->container['carrier_links'] = $carrier_links;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\InventoryApi\\Api\\Data\\SourceInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


