<?php
/**
 * FrameworkDataVideoContentInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * FrameworkDataVideoContentInterface Class Doc Comment
 *
 * @category Class
 * @description Video Content data interface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class FrameworkDataVideoContentInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'framework-data-video-content-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'media_type' => 'string',
        'video_provider' => 'string',
        'video_url' => 'string',
        'video_title' => 'string',
        'video_description' => 'string',
        'video_metadata' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'media_type' => null,
        'video_provider' => null,
        'video_url' => null,
        'video_title' => null,
        'video_description' => null,
        'video_metadata' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'media_type' => 'media_type',
        'video_provider' => 'video_provider',
        'video_url' => 'video_url',
        'video_title' => 'video_title',
        'video_description' => 'video_description',
        'video_metadata' => 'video_metadata'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'media_type' => 'setMediaType',
        'video_provider' => 'setVideoProvider',
        'video_url' => 'setVideoUrl',
        'video_title' => 'setVideoTitle',
        'video_description' => 'setVideoDescription',
        'video_metadata' => 'setVideoMetadata'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'media_type' => 'getMediaType',
        'video_provider' => 'getVideoProvider',
        'video_url' => 'getVideoUrl',
        'video_title' => 'getVideoTitle',
        'video_description' => 'getVideoDescription',
        'video_metadata' => 'getVideoMetadata'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['media_type'] = $data['media_type'] ?? null;
        $this->container['video_provider'] = $data['video_provider'] ?? null;
        $this->container['video_url'] = $data['video_url'] ?? null;
        $this->container['video_title'] = $data['video_title'] ?? null;
        $this->container['video_description'] = $data['video_description'] ?? null;
        $this->container['video_metadata'] = $data['video_metadata'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['media_type'] === null) {
            $invalidProperties[] = "'media_type' can't be null";
        }
        if ($this->container['video_provider'] === null) {
            $invalidProperties[] = "'video_provider' can't be null";
        }
        if ($this->container['video_url'] === null) {
            $invalidProperties[] = "'video_url' can't be null";
        }
        if ($this->container['video_title'] === null) {
            $invalidProperties[] = "'video_title' can't be null";
        }
        if ($this->container['video_description'] === null) {
            $invalidProperties[] = "'video_description' can't be null";
        }
        if ($this->container['video_metadata'] === null) {
            $invalidProperties[] = "'video_metadata' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets media_type
     *
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['media_type'];
    }

    /**
     * Sets media_type
     *
     * @param string $media_type MIME type
     *
     * @return self
     */
    public function setMediaType($media_type)
    {
        $this->container['media_type'] = $media_type;

        return $this;
    }

    /**
     * Gets video_provider
     *
     * @return string
     */
    public function getVideoProvider()
    {
        return $this->container['video_provider'];
    }

    /**
     * Sets video_provider
     *
     * @param string $video_provider Provider
     *
     * @return self
     */
    public function setVideoProvider($video_provider)
    {
        $this->container['video_provider'] = $video_provider;

        return $this;
    }

    /**
     * Gets video_url
     *
     * @return string
     */
    public function getVideoUrl()
    {
        return $this->container['video_url'];
    }

    /**
     * Sets video_url
     *
     * @param string $video_url Video URL
     *
     * @return self
     */
    public function setVideoUrl($video_url)
    {
        $this->container['video_url'] = $video_url;

        return $this;
    }

    /**
     * Gets video_title
     *
     * @return string
     */
    public function getVideoTitle()
    {
        return $this->container['video_title'];
    }

    /**
     * Sets video_title
     *
     * @param string $video_title Title
     *
     * @return self
     */
    public function setVideoTitle($video_title)
    {
        $this->container['video_title'] = $video_title;

        return $this;
    }

    /**
     * Gets video_description
     *
     * @return string
     */
    public function getVideoDescription()
    {
        return $this->container['video_description'];
    }

    /**
     * Sets video_description
     *
     * @param string $video_description Video Description
     *
     * @return self
     */
    public function setVideoDescription($video_description)
    {
        $this->container['video_description'] = $video_description;

        return $this;
    }

    /**
     * Gets video_metadata
     *
     * @return string
     */
    public function getVideoMetadata()
    {
        return $this->container['video_metadata'];
    }

    /**
     * Sets video_metadata
     *
     * @param string $video_metadata Metadata
     *
     * @return self
     */
    public function setVideoMetadata($video_metadata)
    {
        $this->container['video_metadata'] = $video_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


