<?php
/**
 * EavDataAttributeSetInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * EavDataAttributeSetInterface Class Doc Comment
 *
 * @category Class
 * @description Interface AttributeSetInterface
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class EavDataAttributeSetInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'eav-data-attribute-set-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'attribute_set_id' => 'int',
        'attribute_set_name' => 'string',
        'sort_order' => 'int',
        'entity_type_id' => 'int',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'attribute_set_id' => null,
        'attribute_set_name' => null,
        'sort_order' => null,
        'entity_type_id' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'attribute_set_id' => 'attribute_set_id',
        'attribute_set_name' => 'attribute_set_name',
        'sort_order' => 'sort_order',
        'entity_type_id' => 'entity_type_id',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'attribute_set_id' => 'setAttributeSetId',
        'attribute_set_name' => 'setAttributeSetName',
        'sort_order' => 'setSortOrder',
        'entity_type_id' => 'setEntityTypeId',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'attribute_set_id' => 'getAttributeSetId',
        'attribute_set_name' => 'getAttributeSetName',
        'sort_order' => 'getSortOrder',
        'entity_type_id' => 'getEntityTypeId',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['attribute_set_id'] = $data['attribute_set_id'] ?? null;
        $this->container['attribute_set_name'] = $data['attribute_set_name'] ?? null;
        $this->container['sort_order'] = $data['sort_order'] ?? null;
        $this->container['entity_type_id'] = $data['entity_type_id'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['attribute_set_name'] === null) {
            $invalidProperties[] = "'attribute_set_name' can't be null";
        }
        if ($this->container['sort_order'] === null) {
            $invalidProperties[] = "'sort_order' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets attribute_set_id
     *
     * @return int|null
     */
    public function getAttributeSetId()
    {
        return $this->container['attribute_set_id'];
    }

    /**
     * Sets attribute_set_id
     *
     * @param int|null $attribute_set_id Attribute set ID
     *
     * @return self
     */
    public function setAttributeSetId($attribute_set_id)
    {
        $this->container['attribute_set_id'] = $attribute_set_id;

        return $this;
    }

    /**
     * Gets attribute_set_name
     *
     * @return string
     */
    public function getAttributeSetName()
    {
        return $this->container['attribute_set_name'];
    }

    /**
     * Sets attribute_set_name
     *
     * @param string $attribute_set_name Attribute set name
     *
     * @return self
     */
    public function setAttributeSetName($attribute_set_name)
    {
        $this->container['attribute_set_name'] = $attribute_set_name;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int $sort_order Attribute set sort order index
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets entity_type_id
     *
     * @return int|null
     */
    public function getEntityTypeId()
    {
        return $this->container['entity_type_id'];
    }

    /**
     * Sets entity_type_id
     *
     * @param int|null $entity_type_id Attribute set entity type id
     *
     * @return self
     */
    public function setEntityTypeId($entity_type_id)
    {
        $this->container['entity_type_id'] = $entity_type_id;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Eav\\Api\\Data\\AttributeSetInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


