<?php
/**
 * DirectoryDataCurrencyInformationInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * DirectoryDataCurrencyInformationInterface Class Doc Comment
 *
 * @category Class
 * @description Currency Information interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class DirectoryDataCurrencyInformationInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'directory-data-currency-information-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'base_currency_code' => 'string',
        'base_currency_symbol' => 'string',
        'default_display_currency_code' => 'string',
        'default_display_currency_symbol' => 'string',
        'available_currency_codes' => 'string[]',
        'exchange_rates' => '\Magento2\Model\DirectoryDataExchangeRateInterface[]',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'base_currency_code' => null,
        'base_currency_symbol' => null,
        'default_display_currency_code' => null,
        'default_display_currency_symbol' => null,
        'available_currency_codes' => null,
        'exchange_rates' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'base_currency_code' => 'base_currency_code',
        'base_currency_symbol' => 'base_currency_symbol',
        'default_display_currency_code' => 'default_display_currency_code',
        'default_display_currency_symbol' => 'default_display_currency_symbol',
        'available_currency_codes' => 'available_currency_codes',
        'exchange_rates' => 'exchange_rates',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'base_currency_code' => 'setBaseCurrencyCode',
        'base_currency_symbol' => 'setBaseCurrencySymbol',
        'default_display_currency_code' => 'setDefaultDisplayCurrencyCode',
        'default_display_currency_symbol' => 'setDefaultDisplayCurrencySymbol',
        'available_currency_codes' => 'setAvailableCurrencyCodes',
        'exchange_rates' => 'setExchangeRates',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'base_currency_code' => 'getBaseCurrencyCode',
        'base_currency_symbol' => 'getBaseCurrencySymbol',
        'default_display_currency_code' => 'getDefaultDisplayCurrencyCode',
        'default_display_currency_symbol' => 'getDefaultDisplayCurrencySymbol',
        'available_currency_codes' => 'getAvailableCurrencyCodes',
        'exchange_rates' => 'getExchangeRates',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['base_currency_code'] = $data['base_currency_code'] ?? null;
        $this->container['base_currency_symbol'] = $data['base_currency_symbol'] ?? null;
        $this->container['default_display_currency_code'] = $data['default_display_currency_code'] ?? null;
        $this->container['default_display_currency_symbol'] = $data['default_display_currency_symbol'] ?? null;
        $this->container['available_currency_codes'] = $data['available_currency_codes'] ?? null;
        $this->container['exchange_rates'] = $data['exchange_rates'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['base_currency_code'] === null) {
            $invalidProperties[] = "'base_currency_code' can't be null";
        }
        if ($this->container['base_currency_symbol'] === null) {
            $invalidProperties[] = "'base_currency_symbol' can't be null";
        }
        if ($this->container['default_display_currency_code'] === null) {
            $invalidProperties[] = "'default_display_currency_code' can't be null";
        }
        if ($this->container['default_display_currency_symbol'] === null) {
            $invalidProperties[] = "'default_display_currency_symbol' can't be null";
        }
        if ($this->container['available_currency_codes'] === null) {
            $invalidProperties[] = "'available_currency_codes' can't be null";
        }
        if ($this->container['exchange_rates'] === null) {
            $invalidProperties[] = "'exchange_rates' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets base_currency_code
     *
     * @return string
     */
    public function getBaseCurrencyCode()
    {
        return $this->container['base_currency_code'];
    }

    /**
     * Sets base_currency_code
     *
     * @param string $base_currency_code The base currency code for the store.
     *
     * @return self
     */
    public function setBaseCurrencyCode($base_currency_code)
    {
        $this->container['base_currency_code'] = $base_currency_code;

        return $this;
    }

    /**
     * Gets base_currency_symbol
     *
     * @return string
     */
    public function getBaseCurrencySymbol()
    {
        return $this->container['base_currency_symbol'];
    }

    /**
     * Sets base_currency_symbol
     *
     * @param string $base_currency_symbol The currency symbol of the base currency for the store.
     *
     * @return self
     */
    public function setBaseCurrencySymbol($base_currency_symbol)
    {
        $this->container['base_currency_symbol'] = $base_currency_symbol;

        return $this;
    }

    /**
     * Gets default_display_currency_code
     *
     * @return string
     */
    public function getDefaultDisplayCurrencyCode()
    {
        return $this->container['default_display_currency_code'];
    }

    /**
     * Sets default_display_currency_code
     *
     * @param string $default_display_currency_code The default display currency code for the store.
     *
     * @return self
     */
    public function setDefaultDisplayCurrencyCode($default_display_currency_code)
    {
        $this->container['default_display_currency_code'] = $default_display_currency_code;

        return $this;
    }

    /**
     * Gets default_display_currency_symbol
     *
     * @return string
     */
    public function getDefaultDisplayCurrencySymbol()
    {
        return $this->container['default_display_currency_symbol'];
    }

    /**
     * Sets default_display_currency_symbol
     *
     * @param string $default_display_currency_symbol The currency symbol of the default display currency for the store.
     *
     * @return self
     */
    public function setDefaultDisplayCurrencySymbol($default_display_currency_symbol)
    {
        $this->container['default_display_currency_symbol'] = $default_display_currency_symbol;

        return $this;
    }

    /**
     * Gets available_currency_codes
     *
     * @return string[]
     */
    public function getAvailableCurrencyCodes()
    {
        return $this->container['available_currency_codes'];
    }

    /**
     * Sets available_currency_codes
     *
     * @param string[] $available_currency_codes The list of allowed currency codes for the store.
     *
     * @return self
     */
    public function setAvailableCurrencyCodes($available_currency_codes)
    {
        $this->container['available_currency_codes'] = $available_currency_codes;

        return $this;
    }

    /**
     * Gets exchange_rates
     *
     * @return \Magento2\Model\DirectoryDataExchangeRateInterface[]
     */
    public function getExchangeRates()
    {
        return $this->container['exchange_rates'];
    }

    /**
     * Sets exchange_rates
     *
     * @param \Magento2\Model\DirectoryDataExchangeRateInterface[] $exchange_rates The list of exchange rate information for the store.
     *
     * @return self
     */
    public function setExchangeRates($exchange_rates)
    {
        $this->container['exchange_rates'] = $exchange_rates;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Directory\\Api\\Data\\CurrencyInformationInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


