<?php
/**
 * DirectoryDataCountryInformationInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * DirectoryDataCountryInformationInterface Class Doc Comment
 *
 * @category Class
 * @description Country Information interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class DirectoryDataCountryInformationInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'directory-data-country-information-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'two_letter_abbreviation' => 'string',
        'three_letter_abbreviation' => 'string',
        'full_name_locale' => 'string',
        'full_name_english' => 'string',
        'available_regions' => '\Magento2\Model\DirectoryDataRegionInformationInterface[]',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'two_letter_abbreviation' => null,
        'three_letter_abbreviation' => null,
        'full_name_locale' => null,
        'full_name_english' => null,
        'available_regions' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'two_letter_abbreviation' => 'two_letter_abbreviation',
        'three_letter_abbreviation' => 'three_letter_abbreviation',
        'full_name_locale' => 'full_name_locale',
        'full_name_english' => 'full_name_english',
        'available_regions' => 'available_regions',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'two_letter_abbreviation' => 'setTwoLetterAbbreviation',
        'three_letter_abbreviation' => 'setThreeLetterAbbreviation',
        'full_name_locale' => 'setFullNameLocale',
        'full_name_english' => 'setFullNameEnglish',
        'available_regions' => 'setAvailableRegions',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'two_letter_abbreviation' => 'getTwoLetterAbbreviation',
        'three_letter_abbreviation' => 'getThreeLetterAbbreviation',
        'full_name_locale' => 'getFullNameLocale',
        'full_name_english' => 'getFullNameEnglish',
        'available_regions' => 'getAvailableRegions',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['two_letter_abbreviation'] = $data['two_letter_abbreviation'] ?? null;
        $this->container['three_letter_abbreviation'] = $data['three_letter_abbreviation'] ?? null;
        $this->container['full_name_locale'] = $data['full_name_locale'] ?? null;
        $this->container['full_name_english'] = $data['full_name_english'] ?? null;
        $this->container['available_regions'] = $data['available_regions'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['id'] === null) {
            $invalidProperties[] = "'id' can't be null";
        }
        if ($this->container['two_letter_abbreviation'] === null) {
            $invalidProperties[] = "'two_letter_abbreviation' can't be null";
        }
        if ($this->container['three_letter_abbreviation'] === null) {
            $invalidProperties[] = "'three_letter_abbreviation' can't be null";
        }
        if ($this->container['full_name_locale'] === null) {
            $invalidProperties[] = "'full_name_locale' can't be null";
        }
        if ($this->container['full_name_english'] === null) {
            $invalidProperties[] = "'full_name_english' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string $id The country id for the store.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets two_letter_abbreviation
     *
     * @return string
     */
    public function getTwoLetterAbbreviation()
    {
        return $this->container['two_letter_abbreviation'];
    }

    /**
     * Sets two_letter_abbreviation
     *
     * @param string $two_letter_abbreviation The country 2 letter abbreviation for the store.
     *
     * @return self
     */
    public function setTwoLetterAbbreviation($two_letter_abbreviation)
    {
        $this->container['two_letter_abbreviation'] = $two_letter_abbreviation;

        return $this;
    }

    /**
     * Gets three_letter_abbreviation
     *
     * @return string
     */
    public function getThreeLetterAbbreviation()
    {
        return $this->container['three_letter_abbreviation'];
    }

    /**
     * Sets three_letter_abbreviation
     *
     * @param string $three_letter_abbreviation The country 3 letter abbreviation for the store.
     *
     * @return self
     */
    public function setThreeLetterAbbreviation($three_letter_abbreviation)
    {
        $this->container['three_letter_abbreviation'] = $three_letter_abbreviation;

        return $this;
    }

    /**
     * Gets full_name_locale
     *
     * @return string
     */
    public function getFullNameLocale()
    {
        return $this->container['full_name_locale'];
    }

    /**
     * Sets full_name_locale
     *
     * @param string $full_name_locale The country full name (in store locale) for the store.
     *
     * @return self
     */
    public function setFullNameLocale($full_name_locale)
    {
        $this->container['full_name_locale'] = $full_name_locale;

        return $this;
    }

    /**
     * Gets full_name_english
     *
     * @return string
     */
    public function getFullNameEnglish()
    {
        return $this->container['full_name_english'];
    }

    /**
     * Sets full_name_english
     *
     * @param string $full_name_english The country full name (in English) for the store.
     *
     * @return self
     */
    public function setFullNameEnglish($full_name_english)
    {
        $this->container['full_name_english'] = $full_name_english;

        return $this;
    }

    /**
     * Gets available_regions
     *
     * @return \Magento2\Model\DirectoryDataRegionInformationInterface[]|null
     */
    public function getAvailableRegions()
    {
        return $this->container['available_regions'];
    }

    /**
     * Sets available_regions
     *
     * @param \Magento2\Model\DirectoryDataRegionInformationInterface[]|null $available_regions The available regions for the store.
     *
     * @return self
     */
    public function setAvailableRegions($available_regions)
    {
        $this->container['available_regions'] = $available_regions;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Directory\\Api\\Data\\CountryInformationInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


