<?php
/**
 * CustomerDataAttributeMetadataInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * CustomerDataAttributeMetadataInterface Class Doc Comment
 *
 * @category Class
 * @description Customer attribute metadata interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CustomerDataAttributeMetadataInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customer-data-attribute-metadata-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'frontend_input' => 'string',
        'input_filter' => 'string',
        'store_label' => 'string',
        'validation_rules' => '\Magento2\Model\CustomerDataValidationRuleInterface[]',
        'multiline_count' => 'int',
        'visible' => 'bool',
        'required' => 'bool',
        'data_model' => 'string',
        'options' => '\Magento2\Model\CustomerDataOptionInterface[]',
        'frontend_class' => 'string',
        'user_defined' => 'bool',
        'sort_order' => 'int',
        'frontend_label' => 'string',
        'note' => 'string',
        'system' => 'bool',
        'backend_type' => 'string',
        'is_used_in_grid' => 'bool',
        'is_visible_in_grid' => 'bool',
        'is_filterable_in_grid' => 'bool',
        'is_searchable_in_grid' => 'bool',
        'attribute_code' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'frontend_input' => null,
        'input_filter' => null,
        'store_label' => null,
        'validation_rules' => null,
        'multiline_count' => null,
        'visible' => null,
        'required' => null,
        'data_model' => null,
        'options' => null,
        'frontend_class' => null,
        'user_defined' => null,
        'sort_order' => null,
        'frontend_label' => null,
        'note' => null,
        'system' => null,
        'backend_type' => null,
        'is_used_in_grid' => null,
        'is_visible_in_grid' => null,
        'is_filterable_in_grid' => null,
        'is_searchable_in_grid' => null,
        'attribute_code' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'frontend_input' => 'frontend_input',
        'input_filter' => 'input_filter',
        'store_label' => 'store_label',
        'validation_rules' => 'validation_rules',
        'multiline_count' => 'multiline_count',
        'visible' => 'visible',
        'required' => 'required',
        'data_model' => 'data_model',
        'options' => 'options',
        'frontend_class' => 'frontend_class',
        'user_defined' => 'user_defined',
        'sort_order' => 'sort_order',
        'frontend_label' => 'frontend_label',
        'note' => 'note',
        'system' => 'system',
        'backend_type' => 'backend_type',
        'is_used_in_grid' => 'is_used_in_grid',
        'is_visible_in_grid' => 'is_visible_in_grid',
        'is_filterable_in_grid' => 'is_filterable_in_grid',
        'is_searchable_in_grid' => 'is_searchable_in_grid',
        'attribute_code' => 'attribute_code'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'frontend_input' => 'setFrontendInput',
        'input_filter' => 'setInputFilter',
        'store_label' => 'setStoreLabel',
        'validation_rules' => 'setValidationRules',
        'multiline_count' => 'setMultilineCount',
        'visible' => 'setVisible',
        'required' => 'setRequired',
        'data_model' => 'setDataModel',
        'options' => 'setOptions',
        'frontend_class' => 'setFrontendClass',
        'user_defined' => 'setUserDefined',
        'sort_order' => 'setSortOrder',
        'frontend_label' => 'setFrontendLabel',
        'note' => 'setNote',
        'system' => 'setSystem',
        'backend_type' => 'setBackendType',
        'is_used_in_grid' => 'setIsUsedInGrid',
        'is_visible_in_grid' => 'setIsVisibleInGrid',
        'is_filterable_in_grid' => 'setIsFilterableInGrid',
        'is_searchable_in_grid' => 'setIsSearchableInGrid',
        'attribute_code' => 'setAttributeCode'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'frontend_input' => 'getFrontendInput',
        'input_filter' => 'getInputFilter',
        'store_label' => 'getStoreLabel',
        'validation_rules' => 'getValidationRules',
        'multiline_count' => 'getMultilineCount',
        'visible' => 'getVisible',
        'required' => 'getRequired',
        'data_model' => 'getDataModel',
        'options' => 'getOptions',
        'frontend_class' => 'getFrontendClass',
        'user_defined' => 'getUserDefined',
        'sort_order' => 'getSortOrder',
        'frontend_label' => 'getFrontendLabel',
        'note' => 'getNote',
        'system' => 'getSystem',
        'backend_type' => 'getBackendType',
        'is_used_in_grid' => 'getIsUsedInGrid',
        'is_visible_in_grid' => 'getIsVisibleInGrid',
        'is_filterable_in_grid' => 'getIsFilterableInGrid',
        'is_searchable_in_grid' => 'getIsSearchableInGrid',
        'attribute_code' => 'getAttributeCode'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['frontend_input'] = $data['frontend_input'] ?? null;
        $this->container['input_filter'] = $data['input_filter'] ?? null;
        $this->container['store_label'] = $data['store_label'] ?? null;
        $this->container['validation_rules'] = $data['validation_rules'] ?? null;
        $this->container['multiline_count'] = $data['multiline_count'] ?? null;
        $this->container['visible'] = $data['visible'] ?? null;
        $this->container['required'] = $data['required'] ?? null;
        $this->container['data_model'] = $data['data_model'] ?? null;
        $this->container['options'] = $data['options'] ?? null;
        $this->container['frontend_class'] = $data['frontend_class'] ?? null;
        $this->container['user_defined'] = $data['user_defined'] ?? null;
        $this->container['sort_order'] = $data['sort_order'] ?? null;
        $this->container['frontend_label'] = $data['frontend_label'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['system'] = $data['system'] ?? null;
        $this->container['backend_type'] = $data['backend_type'] ?? null;
        $this->container['is_used_in_grid'] = $data['is_used_in_grid'] ?? null;
        $this->container['is_visible_in_grid'] = $data['is_visible_in_grid'] ?? null;
        $this->container['is_filterable_in_grid'] = $data['is_filterable_in_grid'] ?? null;
        $this->container['is_searchable_in_grid'] = $data['is_searchable_in_grid'] ?? null;
        $this->container['attribute_code'] = $data['attribute_code'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['frontend_input'] === null) {
            $invalidProperties[] = "'frontend_input' can't be null";
        }
        if ($this->container['input_filter'] === null) {
            $invalidProperties[] = "'input_filter' can't be null";
        }
        if ($this->container['store_label'] === null) {
            $invalidProperties[] = "'store_label' can't be null";
        }
        if ($this->container['validation_rules'] === null) {
            $invalidProperties[] = "'validation_rules' can't be null";
        }
        if ($this->container['multiline_count'] === null) {
            $invalidProperties[] = "'multiline_count' can't be null";
        }
        if ($this->container['visible'] === null) {
            $invalidProperties[] = "'visible' can't be null";
        }
        if ($this->container['required'] === null) {
            $invalidProperties[] = "'required' can't be null";
        }
        if ($this->container['data_model'] === null) {
            $invalidProperties[] = "'data_model' can't be null";
        }
        if ($this->container['options'] === null) {
            $invalidProperties[] = "'options' can't be null";
        }
        if ($this->container['frontend_class'] === null) {
            $invalidProperties[] = "'frontend_class' can't be null";
        }
        if ($this->container['user_defined'] === null) {
            $invalidProperties[] = "'user_defined' can't be null";
        }
        if ($this->container['sort_order'] === null) {
            $invalidProperties[] = "'sort_order' can't be null";
        }
        if ($this->container['frontend_label'] === null) {
            $invalidProperties[] = "'frontend_label' can't be null";
        }
        if ($this->container['note'] === null) {
            $invalidProperties[] = "'note' can't be null";
        }
        if ($this->container['system'] === null) {
            $invalidProperties[] = "'system' can't be null";
        }
        if ($this->container['backend_type'] === null) {
            $invalidProperties[] = "'backend_type' can't be null";
        }
        if ($this->container['attribute_code'] === null) {
            $invalidProperties[] = "'attribute_code' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets frontend_input
     *
     * @return string
     */
    public function getFrontendInput()
    {
        return $this->container['frontend_input'];
    }

    /**
     * Sets frontend_input
     *
     * @param string $frontend_input HTML for input element.
     *
     * @return self
     */
    public function setFrontendInput($frontend_input)
    {
        $this->container['frontend_input'] = $frontend_input;

        return $this;
    }

    /**
     * Gets input_filter
     *
     * @return string
     */
    public function getInputFilter()
    {
        return $this->container['input_filter'];
    }

    /**
     * Sets input_filter
     *
     * @param string $input_filter Template used for input (e.g. \"date\")
     *
     * @return self
     */
    public function setInputFilter($input_filter)
    {
        $this->container['input_filter'] = $input_filter;

        return $this;
    }

    /**
     * Gets store_label
     *
     * @return string
     */
    public function getStoreLabel()
    {
        return $this->container['store_label'];
    }

    /**
     * Sets store_label
     *
     * @param string $store_label Label of the store.
     *
     * @return self
     */
    public function setStoreLabel($store_label)
    {
        $this->container['store_label'] = $store_label;

        return $this;
    }

    /**
     * Gets validation_rules
     *
     * @return \Magento2\Model\CustomerDataValidationRuleInterface[]
     */
    public function getValidationRules()
    {
        return $this->container['validation_rules'];
    }

    /**
     * Sets validation_rules
     *
     * @param \Magento2\Model\CustomerDataValidationRuleInterface[] $validation_rules Validation rules.
     *
     * @return self
     */
    public function setValidationRules($validation_rules)
    {
        $this->container['validation_rules'] = $validation_rules;

        return $this;
    }

    /**
     * Gets multiline_count
     *
     * @return int
     */
    public function getMultilineCount()
    {
        return $this->container['multiline_count'];
    }

    /**
     * Sets multiline_count
     *
     * @param int $multiline_count Of lines of the attribute value.
     *
     * @return self
     */
    public function setMultilineCount($multiline_count)
    {
        $this->container['multiline_count'] = $multiline_count;

        return $this;
    }

    /**
     * Gets visible
     *
     * @return bool
     */
    public function getVisible()
    {
        return $this->container['visible'];
    }

    /**
     * Sets visible
     *
     * @param bool $visible Attribute is visible on frontend.
     *
     * @return self
     */
    public function setVisible($visible)
    {
        $this->container['visible'] = $visible;

        return $this;
    }

    /**
     * Gets required
     *
     * @return bool
     */
    public function getRequired()
    {
        return $this->container['required'];
    }

    /**
     * Sets required
     *
     * @param bool $required Attribute is required.
     *
     * @return self
     */
    public function setRequired($required)
    {
        $this->container['required'] = $required;

        return $this;
    }

    /**
     * Gets data_model
     *
     * @return string
     */
    public function getDataModel()
    {
        return $this->container['data_model'];
    }

    /**
     * Sets data_model
     *
     * @param string $data_model Data model for attribute.
     *
     * @return self
     */
    public function setDataModel($data_model)
    {
        $this->container['data_model'] = $data_model;

        return $this;
    }

    /**
     * Gets options
     *
     * @return \Magento2\Model\CustomerDataOptionInterface[]
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param \Magento2\Model\CustomerDataOptionInterface[] $options Options of the attribute (key => value pairs for select)
     *
     * @return self
     */
    public function setOptions($options)
    {
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets frontend_class
     *
     * @return string
     */
    public function getFrontendClass()
    {
        return $this->container['frontend_class'];
    }

    /**
     * Sets frontend_class
     *
     * @param string $frontend_class Class which is used to display the attribute on frontend.
     *
     * @return self
     */
    public function setFrontendClass($frontend_class)
    {
        $this->container['frontend_class'] = $frontend_class;

        return $this;
    }

    /**
     * Gets user_defined
     *
     * @return bool
     */
    public function getUserDefined()
    {
        return $this->container['user_defined'];
    }

    /**
     * Sets user_defined
     *
     * @param bool $user_defined Current attribute has been defined by a user.
     *
     * @return self
     */
    public function setUserDefined($user_defined)
    {
        $this->container['user_defined'] = $user_defined;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int $sort_order Attributes sort order.
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets frontend_label
     *
     * @return string
     */
    public function getFrontendLabel()
    {
        return $this->container['frontend_label'];
    }

    /**
     * Sets frontend_label
     *
     * @param string $frontend_label Label which supposed to be displayed on frontend.
     *
     * @return self
     */
    public function setFrontendLabel($frontend_label)
    {
        $this->container['frontend_label'] = $frontend_label;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string $note The note attribute for the element.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets system
     *
     * @return bool
     */
    public function getSystem()
    {
        return $this->container['system'];
    }

    /**
     * Sets system
     *
     * @param bool $system This is a system attribute.
     *
     * @return self
     */
    public function setSystem($system)
    {
        $this->container['system'] = $system;

        return $this;
    }

    /**
     * Gets backend_type
     *
     * @return string
     */
    public function getBackendType()
    {
        return $this->container['backend_type'];
    }

    /**
     * Sets backend_type
     *
     * @param string $backend_type Backend type.
     *
     * @return self
     */
    public function setBackendType($backend_type)
    {
        $this->container['backend_type'] = $backend_type;

        return $this;
    }

    /**
     * Gets is_used_in_grid
     *
     * @return bool|null
     */
    public function getIsUsedInGrid()
    {
        return $this->container['is_used_in_grid'];
    }

    /**
     * Sets is_used_in_grid
     *
     * @param bool|null $is_used_in_grid It is used in customer grid
     *
     * @return self
     */
    public function setIsUsedInGrid($is_used_in_grid)
    {
        $this->container['is_used_in_grid'] = $is_used_in_grid;

        return $this;
    }

    /**
     * Gets is_visible_in_grid
     *
     * @return bool|null
     */
    public function getIsVisibleInGrid()
    {
        return $this->container['is_visible_in_grid'];
    }

    /**
     * Sets is_visible_in_grid
     *
     * @param bool|null $is_visible_in_grid It is visible in customer grid
     *
     * @return self
     */
    public function setIsVisibleInGrid($is_visible_in_grid)
    {
        $this->container['is_visible_in_grid'] = $is_visible_in_grid;

        return $this;
    }

    /**
     * Gets is_filterable_in_grid
     *
     * @return bool|null
     */
    public function getIsFilterableInGrid()
    {
        return $this->container['is_filterable_in_grid'];
    }

    /**
     * Sets is_filterable_in_grid
     *
     * @param bool|null $is_filterable_in_grid It is filterable in customer grid
     *
     * @return self
     */
    public function setIsFilterableInGrid($is_filterable_in_grid)
    {
        $this->container['is_filterable_in_grid'] = $is_filterable_in_grid;

        return $this;
    }

    /**
     * Gets is_searchable_in_grid
     *
     * @return bool|null
     */
    public function getIsSearchableInGrid()
    {
        return $this->container['is_searchable_in_grid'];
    }

    /**
     * Sets is_searchable_in_grid
     *
     * @param bool|null $is_searchable_in_grid It is searchable in customer grid
     *
     * @return self
     */
    public function setIsSearchableInGrid($is_searchable_in_grid)
    {
        $this->container['is_searchable_in_grid'] = $is_searchable_in_grid;

        return $this;
    }

    /**
     * Gets attribute_code
     *
     * @return string
     */
    public function getAttributeCode()
    {
        return $this->container['attribute_code'];
    }

    /**
     * Sets attribute_code
     *
     * @param string $attribute_code Code of the attribute.
     *
     * @return self
     */
    public function setAttributeCode($attribute_code)
    {
        $this->container['attribute_code'] = $attribute_code;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


