<?php
/**
 * CustomerDataAddressInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * CustomerDataAddressInterface Class Doc Comment
 *
 * @category Class
 * @description Customer address interface.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CustomerDataAddressInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customer-data-address-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'int',
        'customer_id' => 'int',
        'region' => '\Magento2\Model\CustomerDataRegionInterface',
        'region_id' => 'int',
        'country_id' => 'string',
        'street' => 'string[]',
        'company' => 'string',
        'telephone' => 'string',
        'fax' => 'string',
        'postcode' => 'string',
        'city' => 'string',
        'firstname' => 'string',
        'lastname' => 'string',
        'middlename' => 'string',
        'prefix' => 'string',
        'suffix' => 'string',
        'vat_id' => 'string',
        'default_shipping' => 'bool',
        'default_billing' => 'bool',
        'extension_attributes' => 'object',
        'custom_attributes' => '\Magento2\Model\FrameworkAttributeInterface[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'customer_id' => null,
        'region' => null,
        'region_id' => null,
        'country_id' => null,
        'street' => null,
        'company' => null,
        'telephone' => null,
        'fax' => null,
        'postcode' => null,
        'city' => null,
        'firstname' => null,
        'lastname' => null,
        'middlename' => null,
        'prefix' => null,
        'suffix' => null,
        'vat_id' => null,
        'default_shipping' => null,
        'default_billing' => null,
        'extension_attributes' => null,
        'custom_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'customer_id' => 'customer_id',
        'region' => 'region',
        'region_id' => 'region_id',
        'country_id' => 'country_id',
        'street' => 'street',
        'company' => 'company',
        'telephone' => 'telephone',
        'fax' => 'fax',
        'postcode' => 'postcode',
        'city' => 'city',
        'firstname' => 'firstname',
        'lastname' => 'lastname',
        'middlename' => 'middlename',
        'prefix' => 'prefix',
        'suffix' => 'suffix',
        'vat_id' => 'vat_id',
        'default_shipping' => 'default_shipping',
        'default_billing' => 'default_billing',
        'extension_attributes' => 'extension_attributes',
        'custom_attributes' => 'custom_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'customer_id' => 'setCustomerId',
        'region' => 'setRegion',
        'region_id' => 'setRegionId',
        'country_id' => 'setCountryId',
        'street' => 'setStreet',
        'company' => 'setCompany',
        'telephone' => 'setTelephone',
        'fax' => 'setFax',
        'postcode' => 'setPostcode',
        'city' => 'setCity',
        'firstname' => 'setFirstname',
        'lastname' => 'setLastname',
        'middlename' => 'setMiddlename',
        'prefix' => 'setPrefix',
        'suffix' => 'setSuffix',
        'vat_id' => 'setVatId',
        'default_shipping' => 'setDefaultShipping',
        'default_billing' => 'setDefaultBilling',
        'extension_attributes' => 'setExtensionAttributes',
        'custom_attributes' => 'setCustomAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'customer_id' => 'getCustomerId',
        'region' => 'getRegion',
        'region_id' => 'getRegionId',
        'country_id' => 'getCountryId',
        'street' => 'getStreet',
        'company' => 'getCompany',
        'telephone' => 'getTelephone',
        'fax' => 'getFax',
        'postcode' => 'getPostcode',
        'city' => 'getCity',
        'firstname' => 'getFirstname',
        'lastname' => 'getLastname',
        'middlename' => 'getMiddlename',
        'prefix' => 'getPrefix',
        'suffix' => 'getSuffix',
        'vat_id' => 'getVatId',
        'default_shipping' => 'getDefaultShipping',
        'default_billing' => 'getDefaultBilling',
        'extension_attributes' => 'getExtensionAttributes',
        'custom_attributes' => 'getCustomAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['region'] = $data['region'] ?? null;
        $this->container['region_id'] = $data['region_id'] ?? null;
        $this->container['country_id'] = $data['country_id'] ?? null;
        $this->container['street'] = $data['street'] ?? null;
        $this->container['company'] = $data['company'] ?? null;
        $this->container['telephone'] = $data['telephone'] ?? null;
        $this->container['fax'] = $data['fax'] ?? null;
        $this->container['postcode'] = $data['postcode'] ?? null;
        $this->container['city'] = $data['city'] ?? null;
        $this->container['firstname'] = $data['firstname'] ?? null;
        $this->container['lastname'] = $data['lastname'] ?? null;
        $this->container['middlename'] = $data['middlename'] ?? null;
        $this->container['prefix'] = $data['prefix'] ?? null;
        $this->container['suffix'] = $data['suffix'] ?? null;
        $this->container['vat_id'] = $data['vat_id'] ?? null;
        $this->container['default_shipping'] = $data['default_shipping'] ?? null;
        $this->container['default_billing'] = $data['default_billing'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
        $this->container['custom_attributes'] = $data['custom_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int|null $id ID
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return int|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param int|null $customer_id Customer ID
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets region
     *
     * @return \Magento2\Model\CustomerDataRegionInterface|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param \Magento2\Model\CustomerDataRegionInterface|null $region region
     *
     * @return self
     */
    public function setRegion($region)
    {
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets region_id
     *
     * @return int|null
     */
    public function getRegionId()
    {
        return $this->container['region_id'];
    }

    /**
     * Sets region_id
     *
     * @param int|null $region_id Region ID
     *
     * @return self
     */
    public function setRegionId($region_id)
    {
        $this->container['region_id'] = $region_id;

        return $this;
    }

    /**
     * Gets country_id
     *
     * @return string|null
     */
    public function getCountryId()
    {
        return $this->container['country_id'];
    }

    /**
     * Sets country_id
     *
     * @param string|null $country_id Country code in ISO_3166-2 format
     *
     * @return self
     */
    public function setCountryId($country_id)
    {
        $this->container['country_id'] = $country_id;

        return $this;
    }

    /**
     * Gets street
     *
     * @return string[]|null
     */
    public function getStreet()
    {
        return $this->container['street'];
    }

    /**
     * Sets street
     *
     * @param string[]|null $street Street
     *
     * @return self
     */
    public function setStreet($street)
    {
        $this->container['street'] = $street;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company Company
     *
     * @return self
     */
    public function setCompany($company)
    {
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets telephone
     *
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->container['telephone'];
    }

    /**
     * Sets telephone
     *
     * @param string|null $telephone Telephone number
     *
     * @return self
     */
    public function setTelephone($telephone)
    {
        $this->container['telephone'] = $telephone;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax Fax number
     *
     * @return self
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets postcode
     *
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->container['postcode'];
    }

    /**
     * Sets postcode
     *
     * @param string|null $postcode Postcode
     *
     * @return self
     */
    public function setPostcode($postcode)
    {
        $this->container['postcode'] = $postcode;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city City name
     *
     * @return self
     */
    public function setCity($city)
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets firstname
     *
     * @return string|null
     */
    public function getFirstname()
    {
        return $this->container['firstname'];
    }

    /**
     * Sets firstname
     *
     * @param string|null $firstname First name
     *
     * @return self
     */
    public function setFirstname($firstname)
    {
        $this->container['firstname'] = $firstname;

        return $this;
    }

    /**
     * Gets lastname
     *
     * @return string|null
     */
    public function getLastname()
    {
        return $this->container['lastname'];
    }

    /**
     * Sets lastname
     *
     * @param string|null $lastname Last name
     *
     * @return self
     */
    public function setLastname($lastname)
    {
        $this->container['lastname'] = $lastname;

        return $this;
    }

    /**
     * Gets middlename
     *
     * @return string|null
     */
    public function getMiddlename()
    {
        return $this->container['middlename'];
    }

    /**
     * Sets middlename
     *
     * @param string|null $middlename Middle name
     *
     * @return self
     */
    public function setMiddlename($middlename)
    {
        $this->container['middlename'] = $middlename;

        return $this;
    }

    /**
     * Gets prefix
     *
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->container['prefix'];
    }

    /**
     * Sets prefix
     *
     * @param string|null $prefix Prefix
     *
     * @return self
     */
    public function setPrefix($prefix)
    {
        $this->container['prefix'] = $prefix;

        return $this;
    }

    /**
     * Gets suffix
     *
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->container['suffix'];
    }

    /**
     * Sets suffix
     *
     * @param string|null $suffix Suffix
     *
     * @return self
     */
    public function setSuffix($suffix)
    {
        $this->container['suffix'] = $suffix;

        return $this;
    }

    /**
     * Gets vat_id
     *
     * @return string|null
     */
    public function getVatId()
    {
        return $this->container['vat_id'];
    }

    /**
     * Sets vat_id
     *
     * @param string|null $vat_id Vat id
     *
     * @return self
     */
    public function setVatId($vat_id)
    {
        $this->container['vat_id'] = $vat_id;

        return $this;
    }

    /**
     * Gets default_shipping
     *
     * @return bool|null
     */
    public function getDefaultShipping()
    {
        return $this->container['default_shipping'];
    }

    /**
     * Sets default_shipping
     *
     * @param bool|null $default_shipping If this address is default shipping address.
     *
     * @return self
     */
    public function setDefaultShipping($default_shipping)
    {
        $this->container['default_shipping'] = $default_shipping;

        return $this;
    }

    /**
     * Gets default_billing
     *
     * @return bool|null
     */
    public function getDefaultBilling()
    {
        return $this->container['default_billing'];
    }

    /**
     * Sets default_billing
     *
     * @param bool|null $default_billing If this address is default billing address
     *
     * @return self
     */
    public function setDefaultBilling($default_billing)
    {
        $this->container['default_billing'] = $default_billing;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Customer\\Api\\Data\\AddressInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }

    /**
     * Gets custom_attributes
     *
     * @return \Magento2\Model\FrameworkAttributeInterface[]|null
     */
    public function getCustomAttributes()
    {
        return $this->container['custom_attributes'];
    }

    /**
     * Sets custom_attributes
     *
     * @param \Magento2\Model\FrameworkAttributeInterface[]|null $custom_attributes Custom attributes values.
     *
     * @return self
     */
    public function setCustomAttributes($custom_attributes)
    {
        $this->container['custom_attributes'] = $custom_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


