<?php
/**
 * CatalogInventoryDataStockItemInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * CatalogInventoryDataStockItemInterface Class Doc Comment
 *
 * @category Class
 * @description Interface StockItem
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CatalogInventoryDataStockItemInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'catalog-inventory-data-stock-item-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_id' => 'int',
        'product_id' => 'int',
        'stock_id' => 'int',
        'qty' => 'float',
        'is_in_stock' => 'bool',
        'is_qty_decimal' => 'bool',
        'show_default_notification_message' => 'bool',
        'use_config_min_qty' => 'bool',
        'min_qty' => 'float',
        'use_config_min_sale_qty' => 'int',
        'min_sale_qty' => 'float',
        'use_config_max_sale_qty' => 'bool',
        'max_sale_qty' => 'float',
        'use_config_backorders' => 'bool',
        'backorders' => 'int',
        'use_config_notify_stock_qty' => 'bool',
        'notify_stock_qty' => 'float',
        'use_config_qty_increments' => 'bool',
        'qty_increments' => 'float',
        'use_config_enable_qty_inc' => 'bool',
        'enable_qty_increments' => 'bool',
        'use_config_manage_stock' => 'bool',
        'manage_stock' => 'bool',
        'low_stock_date' => 'string',
        'is_decimal_divided' => 'bool',
        'stock_status_changed_auto' => 'int',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_id' => null,
        'product_id' => null,
        'stock_id' => null,
        'qty' => null,
        'is_in_stock' => null,
        'is_qty_decimal' => null,
        'show_default_notification_message' => null,
        'use_config_min_qty' => null,
        'min_qty' => null,
        'use_config_min_sale_qty' => null,
        'min_sale_qty' => null,
        'use_config_max_sale_qty' => null,
        'max_sale_qty' => null,
        'use_config_backorders' => null,
        'backorders' => null,
        'use_config_notify_stock_qty' => null,
        'notify_stock_qty' => null,
        'use_config_qty_increments' => null,
        'qty_increments' => null,
        'use_config_enable_qty_inc' => null,
        'enable_qty_increments' => null,
        'use_config_manage_stock' => null,
        'manage_stock' => null,
        'low_stock_date' => null,
        'is_decimal_divided' => null,
        'stock_status_changed_auto' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_id' => 'item_id',
        'product_id' => 'product_id',
        'stock_id' => 'stock_id',
        'qty' => 'qty',
        'is_in_stock' => 'is_in_stock',
        'is_qty_decimal' => 'is_qty_decimal',
        'show_default_notification_message' => 'show_default_notification_message',
        'use_config_min_qty' => 'use_config_min_qty',
        'min_qty' => 'min_qty',
        'use_config_min_sale_qty' => 'use_config_min_sale_qty',
        'min_sale_qty' => 'min_sale_qty',
        'use_config_max_sale_qty' => 'use_config_max_sale_qty',
        'max_sale_qty' => 'max_sale_qty',
        'use_config_backorders' => 'use_config_backorders',
        'backorders' => 'backorders',
        'use_config_notify_stock_qty' => 'use_config_notify_stock_qty',
        'notify_stock_qty' => 'notify_stock_qty',
        'use_config_qty_increments' => 'use_config_qty_increments',
        'qty_increments' => 'qty_increments',
        'use_config_enable_qty_inc' => 'use_config_enable_qty_inc',
        'enable_qty_increments' => 'enable_qty_increments',
        'use_config_manage_stock' => 'use_config_manage_stock',
        'manage_stock' => 'manage_stock',
        'low_stock_date' => 'low_stock_date',
        'is_decimal_divided' => 'is_decimal_divided',
        'stock_status_changed_auto' => 'stock_status_changed_auto',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_id' => 'setItemId',
        'product_id' => 'setProductId',
        'stock_id' => 'setStockId',
        'qty' => 'setQty',
        'is_in_stock' => 'setIsInStock',
        'is_qty_decimal' => 'setIsQtyDecimal',
        'show_default_notification_message' => 'setShowDefaultNotificationMessage',
        'use_config_min_qty' => 'setUseConfigMinQty',
        'min_qty' => 'setMinQty',
        'use_config_min_sale_qty' => 'setUseConfigMinSaleQty',
        'min_sale_qty' => 'setMinSaleQty',
        'use_config_max_sale_qty' => 'setUseConfigMaxSaleQty',
        'max_sale_qty' => 'setMaxSaleQty',
        'use_config_backorders' => 'setUseConfigBackorders',
        'backorders' => 'setBackorders',
        'use_config_notify_stock_qty' => 'setUseConfigNotifyStockQty',
        'notify_stock_qty' => 'setNotifyStockQty',
        'use_config_qty_increments' => 'setUseConfigQtyIncrements',
        'qty_increments' => 'setQtyIncrements',
        'use_config_enable_qty_inc' => 'setUseConfigEnableQtyInc',
        'enable_qty_increments' => 'setEnableQtyIncrements',
        'use_config_manage_stock' => 'setUseConfigManageStock',
        'manage_stock' => 'setManageStock',
        'low_stock_date' => 'setLowStockDate',
        'is_decimal_divided' => 'setIsDecimalDivided',
        'stock_status_changed_auto' => 'setStockStatusChangedAuto',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_id' => 'getItemId',
        'product_id' => 'getProductId',
        'stock_id' => 'getStockId',
        'qty' => 'getQty',
        'is_in_stock' => 'getIsInStock',
        'is_qty_decimal' => 'getIsQtyDecimal',
        'show_default_notification_message' => 'getShowDefaultNotificationMessage',
        'use_config_min_qty' => 'getUseConfigMinQty',
        'min_qty' => 'getMinQty',
        'use_config_min_sale_qty' => 'getUseConfigMinSaleQty',
        'min_sale_qty' => 'getMinSaleQty',
        'use_config_max_sale_qty' => 'getUseConfigMaxSaleQty',
        'max_sale_qty' => 'getMaxSaleQty',
        'use_config_backorders' => 'getUseConfigBackorders',
        'backorders' => 'getBackorders',
        'use_config_notify_stock_qty' => 'getUseConfigNotifyStockQty',
        'notify_stock_qty' => 'getNotifyStockQty',
        'use_config_qty_increments' => 'getUseConfigQtyIncrements',
        'qty_increments' => 'getQtyIncrements',
        'use_config_enable_qty_inc' => 'getUseConfigEnableQtyInc',
        'enable_qty_increments' => 'getEnableQtyIncrements',
        'use_config_manage_stock' => 'getUseConfigManageStock',
        'manage_stock' => 'getManageStock',
        'low_stock_date' => 'getLowStockDate',
        'is_decimal_divided' => 'getIsDecimalDivided',
        'stock_status_changed_auto' => 'getStockStatusChangedAuto',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['item_id'] = $data['item_id'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['stock_id'] = $data['stock_id'] ?? null;
        $this->container['qty'] = $data['qty'] ?? null;
        $this->container['is_in_stock'] = $data['is_in_stock'] ?? null;
        $this->container['is_qty_decimal'] = $data['is_qty_decimal'] ?? null;
        $this->container['show_default_notification_message'] = $data['show_default_notification_message'] ?? null;
        $this->container['use_config_min_qty'] = $data['use_config_min_qty'] ?? null;
        $this->container['min_qty'] = $data['min_qty'] ?? null;
        $this->container['use_config_min_sale_qty'] = $data['use_config_min_sale_qty'] ?? null;
        $this->container['min_sale_qty'] = $data['min_sale_qty'] ?? null;
        $this->container['use_config_max_sale_qty'] = $data['use_config_max_sale_qty'] ?? null;
        $this->container['max_sale_qty'] = $data['max_sale_qty'] ?? null;
        $this->container['use_config_backorders'] = $data['use_config_backorders'] ?? null;
        $this->container['backorders'] = $data['backorders'] ?? null;
        $this->container['use_config_notify_stock_qty'] = $data['use_config_notify_stock_qty'] ?? null;
        $this->container['notify_stock_qty'] = $data['notify_stock_qty'] ?? null;
        $this->container['use_config_qty_increments'] = $data['use_config_qty_increments'] ?? null;
        $this->container['qty_increments'] = $data['qty_increments'] ?? null;
        $this->container['use_config_enable_qty_inc'] = $data['use_config_enable_qty_inc'] ?? null;
        $this->container['enable_qty_increments'] = $data['enable_qty_increments'] ?? null;
        $this->container['use_config_manage_stock'] = $data['use_config_manage_stock'] ?? null;
        $this->container['manage_stock'] = $data['manage_stock'] ?? null;
        $this->container['low_stock_date'] = $data['low_stock_date'] ?? null;
        $this->container['is_decimal_divided'] = $data['is_decimal_divided'] ?? null;
        $this->container['stock_status_changed_auto'] = $data['stock_status_changed_auto'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['qty'] === null) {
            $invalidProperties[] = "'qty' can't be null";
        }
        if ($this->container['is_in_stock'] === null) {
            $invalidProperties[] = "'is_in_stock' can't be null";
        }
        if ($this->container['is_qty_decimal'] === null) {
            $invalidProperties[] = "'is_qty_decimal' can't be null";
        }
        if ($this->container['show_default_notification_message'] === null) {
            $invalidProperties[] = "'show_default_notification_message' can't be null";
        }
        if ($this->container['use_config_min_qty'] === null) {
            $invalidProperties[] = "'use_config_min_qty' can't be null";
        }
        if ($this->container['min_qty'] === null) {
            $invalidProperties[] = "'min_qty' can't be null";
        }
        if ($this->container['use_config_min_sale_qty'] === null) {
            $invalidProperties[] = "'use_config_min_sale_qty' can't be null";
        }
        if ($this->container['min_sale_qty'] === null) {
            $invalidProperties[] = "'min_sale_qty' can't be null";
        }
        if ($this->container['use_config_max_sale_qty'] === null) {
            $invalidProperties[] = "'use_config_max_sale_qty' can't be null";
        }
        if ($this->container['max_sale_qty'] === null) {
            $invalidProperties[] = "'max_sale_qty' can't be null";
        }
        if ($this->container['use_config_backorders'] === null) {
            $invalidProperties[] = "'use_config_backorders' can't be null";
        }
        if ($this->container['backorders'] === null) {
            $invalidProperties[] = "'backorders' can't be null";
        }
        if ($this->container['use_config_notify_stock_qty'] === null) {
            $invalidProperties[] = "'use_config_notify_stock_qty' can't be null";
        }
        if ($this->container['notify_stock_qty'] === null) {
            $invalidProperties[] = "'notify_stock_qty' can't be null";
        }
        if ($this->container['use_config_qty_increments'] === null) {
            $invalidProperties[] = "'use_config_qty_increments' can't be null";
        }
        if ($this->container['qty_increments'] === null) {
            $invalidProperties[] = "'qty_increments' can't be null";
        }
        if ($this->container['use_config_enable_qty_inc'] === null) {
            $invalidProperties[] = "'use_config_enable_qty_inc' can't be null";
        }
        if ($this->container['enable_qty_increments'] === null) {
            $invalidProperties[] = "'enable_qty_increments' can't be null";
        }
        if ($this->container['use_config_manage_stock'] === null) {
            $invalidProperties[] = "'use_config_manage_stock' can't be null";
        }
        if ($this->container['manage_stock'] === null) {
            $invalidProperties[] = "'manage_stock' can't be null";
        }
        if ($this->container['low_stock_date'] === null) {
            $invalidProperties[] = "'low_stock_date' can't be null";
        }
        if ($this->container['is_decimal_divided'] === null) {
            $invalidProperties[] = "'is_decimal_divided' can't be null";
        }
        if ($this->container['stock_status_changed_auto'] === null) {
            $invalidProperties[] = "'stock_status_changed_auto' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_id
     *
     * @return int|null
     */
    public function getItemId()
    {
        return $this->container['item_id'];
    }

    /**
     * Sets item_id
     *
     * @param int|null $item_id item_id
     *
     * @return self
     */
    public function setItemId($item_id)
    {
        $this->container['item_id'] = $item_id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return int|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param int|null $product_id product_id
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets stock_id
     *
     * @return int|null
     */
    public function getStockId()
    {
        return $this->container['stock_id'];
    }

    /**
     * Sets stock_id
     *
     * @param int|null $stock_id Stock identifier
     *
     * @return self
     */
    public function setStockId($stock_id)
    {
        $this->container['stock_id'] = $stock_id;

        return $this;
    }

    /**
     * Gets qty
     *
     * @return float
     */
    public function getQty()
    {
        return $this->container['qty'];
    }

    /**
     * Sets qty
     *
     * @param float $qty qty
     *
     * @return self
     */
    public function setQty($qty)
    {
        $this->container['qty'] = $qty;

        return $this;
    }

    /**
     * Gets is_in_stock
     *
     * @return bool
     */
    public function getIsInStock()
    {
        return $this->container['is_in_stock'];
    }

    /**
     * Sets is_in_stock
     *
     * @param bool $is_in_stock Stock Availability
     *
     * @return self
     */
    public function setIsInStock($is_in_stock)
    {
        $this->container['is_in_stock'] = $is_in_stock;

        return $this;
    }

    /**
     * Gets is_qty_decimal
     *
     * @return bool
     */
    public function getIsQtyDecimal()
    {
        return $this->container['is_qty_decimal'];
    }

    /**
     * Sets is_qty_decimal
     *
     * @param bool $is_qty_decimal is_qty_decimal
     *
     * @return self
     */
    public function setIsQtyDecimal($is_qty_decimal)
    {
        $this->container['is_qty_decimal'] = $is_qty_decimal;

        return $this;
    }

    /**
     * Gets show_default_notification_message
     *
     * @return bool
     */
    public function getShowDefaultNotificationMessage()
    {
        return $this->container['show_default_notification_message'];
    }

    /**
     * Sets show_default_notification_message
     *
     * @param bool $show_default_notification_message show_default_notification_message
     *
     * @return self
     */
    public function setShowDefaultNotificationMessage($show_default_notification_message)
    {
        $this->container['show_default_notification_message'] = $show_default_notification_message;

        return $this;
    }

    /**
     * Gets use_config_min_qty
     *
     * @return bool
     */
    public function getUseConfigMinQty()
    {
        return $this->container['use_config_min_qty'];
    }

    /**
     * Sets use_config_min_qty
     *
     * @param bool $use_config_min_qty use_config_min_qty
     *
     * @return self
     */
    public function setUseConfigMinQty($use_config_min_qty)
    {
        $this->container['use_config_min_qty'] = $use_config_min_qty;

        return $this;
    }

    /**
     * Gets min_qty
     *
     * @return float
     */
    public function getMinQty()
    {
        return $this->container['min_qty'];
    }

    /**
     * Sets min_qty
     *
     * @param float $min_qty Minimal quantity available for item status in stock
     *
     * @return self
     */
    public function setMinQty($min_qty)
    {
        $this->container['min_qty'] = $min_qty;

        return $this;
    }

    /**
     * Gets use_config_min_sale_qty
     *
     * @return int
     */
    public function getUseConfigMinSaleQty()
    {
        return $this->container['use_config_min_sale_qty'];
    }

    /**
     * Sets use_config_min_sale_qty
     *
     * @param int $use_config_min_sale_qty use_config_min_sale_qty
     *
     * @return self
     */
    public function setUseConfigMinSaleQty($use_config_min_sale_qty)
    {
        $this->container['use_config_min_sale_qty'] = $use_config_min_sale_qty;

        return $this;
    }

    /**
     * Gets min_sale_qty
     *
     * @return float
     */
    public function getMinSaleQty()
    {
        return $this->container['min_sale_qty'];
    }

    /**
     * Sets min_sale_qty
     *
     * @param float $min_sale_qty Minimum Qty Allowed in Shopping Cart or NULL when there is no limitation
     *
     * @return self
     */
    public function setMinSaleQty($min_sale_qty)
    {
        $this->container['min_sale_qty'] = $min_sale_qty;

        return $this;
    }

    /**
     * Gets use_config_max_sale_qty
     *
     * @return bool
     */
    public function getUseConfigMaxSaleQty()
    {
        return $this->container['use_config_max_sale_qty'];
    }

    /**
     * Sets use_config_max_sale_qty
     *
     * @param bool $use_config_max_sale_qty use_config_max_sale_qty
     *
     * @return self
     */
    public function setUseConfigMaxSaleQty($use_config_max_sale_qty)
    {
        $this->container['use_config_max_sale_qty'] = $use_config_max_sale_qty;

        return $this;
    }

    /**
     * Gets max_sale_qty
     *
     * @return float
     */
    public function getMaxSaleQty()
    {
        return $this->container['max_sale_qty'];
    }

    /**
     * Sets max_sale_qty
     *
     * @param float $max_sale_qty Maximum Qty Allowed in Shopping Cart data wrapper
     *
     * @return self
     */
    public function setMaxSaleQty($max_sale_qty)
    {
        $this->container['max_sale_qty'] = $max_sale_qty;

        return $this;
    }

    /**
     * Gets use_config_backorders
     *
     * @return bool
     */
    public function getUseConfigBackorders()
    {
        return $this->container['use_config_backorders'];
    }

    /**
     * Sets use_config_backorders
     *
     * @param bool $use_config_backorders use_config_backorders
     *
     * @return self
     */
    public function setUseConfigBackorders($use_config_backorders)
    {
        $this->container['use_config_backorders'] = $use_config_backorders;

        return $this;
    }

    /**
     * Gets backorders
     *
     * @return int
     */
    public function getBackorders()
    {
        return $this->container['backorders'];
    }

    /**
     * Sets backorders
     *
     * @param int $backorders Backorders status
     *
     * @return self
     */
    public function setBackorders($backorders)
    {
        $this->container['backorders'] = $backorders;

        return $this;
    }

    /**
     * Gets use_config_notify_stock_qty
     *
     * @return bool
     */
    public function getUseConfigNotifyStockQty()
    {
        return $this->container['use_config_notify_stock_qty'];
    }

    /**
     * Sets use_config_notify_stock_qty
     *
     * @param bool $use_config_notify_stock_qty use_config_notify_stock_qty
     *
     * @return self
     */
    public function setUseConfigNotifyStockQty($use_config_notify_stock_qty)
    {
        $this->container['use_config_notify_stock_qty'] = $use_config_notify_stock_qty;

        return $this;
    }

    /**
     * Gets notify_stock_qty
     *
     * @return float
     */
    public function getNotifyStockQty()
    {
        return $this->container['notify_stock_qty'];
    }

    /**
     * Sets notify_stock_qty
     *
     * @param float $notify_stock_qty Notify for Quantity Below data wrapper
     *
     * @return self
     */
    public function setNotifyStockQty($notify_stock_qty)
    {
        $this->container['notify_stock_qty'] = $notify_stock_qty;

        return $this;
    }

    /**
     * Gets use_config_qty_increments
     *
     * @return bool
     */
    public function getUseConfigQtyIncrements()
    {
        return $this->container['use_config_qty_increments'];
    }

    /**
     * Sets use_config_qty_increments
     *
     * @param bool $use_config_qty_increments use_config_qty_increments
     *
     * @return self
     */
    public function setUseConfigQtyIncrements($use_config_qty_increments)
    {
        $this->container['use_config_qty_increments'] = $use_config_qty_increments;

        return $this;
    }

    /**
     * Gets qty_increments
     *
     * @return float
     */
    public function getQtyIncrements()
    {
        return $this->container['qty_increments'];
    }

    /**
     * Sets qty_increments
     *
     * @param float $qty_increments Quantity Increments data wrapper
     *
     * @return self
     */
    public function setQtyIncrements($qty_increments)
    {
        $this->container['qty_increments'] = $qty_increments;

        return $this;
    }

    /**
     * Gets use_config_enable_qty_inc
     *
     * @return bool
     */
    public function getUseConfigEnableQtyInc()
    {
        return $this->container['use_config_enable_qty_inc'];
    }

    /**
     * Sets use_config_enable_qty_inc
     *
     * @param bool $use_config_enable_qty_inc use_config_enable_qty_inc
     *
     * @return self
     */
    public function setUseConfigEnableQtyInc($use_config_enable_qty_inc)
    {
        $this->container['use_config_enable_qty_inc'] = $use_config_enable_qty_inc;

        return $this;
    }

    /**
     * Gets enable_qty_increments
     *
     * @return bool
     */
    public function getEnableQtyIncrements()
    {
        return $this->container['enable_qty_increments'];
    }

    /**
     * Sets enable_qty_increments
     *
     * @param bool $enable_qty_increments Whether Quantity Increments is enabled
     *
     * @return self
     */
    public function setEnableQtyIncrements($enable_qty_increments)
    {
        $this->container['enable_qty_increments'] = $enable_qty_increments;

        return $this;
    }

    /**
     * Gets use_config_manage_stock
     *
     * @return bool
     */
    public function getUseConfigManageStock()
    {
        return $this->container['use_config_manage_stock'];
    }

    /**
     * Sets use_config_manage_stock
     *
     * @param bool $use_config_manage_stock use_config_manage_stock
     *
     * @return self
     */
    public function setUseConfigManageStock($use_config_manage_stock)
    {
        $this->container['use_config_manage_stock'] = $use_config_manage_stock;

        return $this;
    }

    /**
     * Gets manage_stock
     *
     * @return bool
     */
    public function getManageStock()
    {
        return $this->container['manage_stock'];
    }

    /**
     * Sets manage_stock
     *
     * @param bool $manage_stock Can Manage Stock
     *
     * @return self
     */
    public function setManageStock($manage_stock)
    {
        $this->container['manage_stock'] = $manage_stock;

        return $this;
    }

    /**
     * Gets low_stock_date
     *
     * @return string
     */
    public function getLowStockDate()
    {
        return $this->container['low_stock_date'];
    }

    /**
     * Sets low_stock_date
     *
     * @param string $low_stock_date low_stock_date
     *
     * @return self
     */
    public function setLowStockDate($low_stock_date)
    {
        $this->container['low_stock_date'] = $low_stock_date;

        return $this;
    }

    /**
     * Gets is_decimal_divided
     *
     * @return bool
     */
    public function getIsDecimalDivided()
    {
        return $this->container['is_decimal_divided'];
    }

    /**
     * Sets is_decimal_divided
     *
     * @param bool $is_decimal_divided is_decimal_divided
     *
     * @return self
     */
    public function setIsDecimalDivided($is_decimal_divided)
    {
        $this->container['is_decimal_divided'] = $is_decimal_divided;

        return $this;
    }

    /**
     * Gets stock_status_changed_auto
     *
     * @return int
     */
    public function getStockStatusChangedAuto()
    {
        return $this->container['stock_status_changed_auto'];
    }

    /**
     * Sets stock_status_changed_auto
     *
     * @param int $stock_status_changed_auto stock_status_changed_auto
     *
     * @return self
     */
    public function setStockStatusChangedAuto($stock_status_changed_auto)
    {
        $this->container['stock_status_changed_auto'] = $stock_status_changed_auto;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\CatalogInventory\\Api\\Data\\StockItemInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


