<?php
/**
 * CatalogDataProductRenderFormattedPriceInfoInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * CatalogDataProductRenderFormattedPriceInfoInterface Class Doc Comment
 *
 * @category Class
 * @description Formatted Price interface. Aggregate formatted html with price representations. E.g.: &lt;span class&#x3D;\&quot;price\&quot;&gt;$9.00&lt;/span&gt; Consider currency, rounding and html
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CatalogDataProductRenderFormattedPriceInfoInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'catalog-data-product-render-formatted-price-info-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'final_price' => 'string',
        'max_price' => 'string',
        'minimal_price' => 'string',
        'max_regular_price' => 'string',
        'minimal_regular_price' => 'string',
        'special_price' => 'string',
        'regular_price' => 'string',
        'extension_attributes' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'final_price' => null,
        'max_price' => null,
        'minimal_price' => null,
        'max_regular_price' => null,
        'minimal_regular_price' => null,
        'special_price' => null,
        'regular_price' => null,
        'extension_attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'final_price' => 'final_price',
        'max_price' => 'max_price',
        'minimal_price' => 'minimal_price',
        'max_regular_price' => 'max_regular_price',
        'minimal_regular_price' => 'minimal_regular_price',
        'special_price' => 'special_price',
        'regular_price' => 'regular_price',
        'extension_attributes' => 'extension_attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'final_price' => 'setFinalPrice',
        'max_price' => 'setMaxPrice',
        'minimal_price' => 'setMinimalPrice',
        'max_regular_price' => 'setMaxRegularPrice',
        'minimal_regular_price' => 'setMinimalRegularPrice',
        'special_price' => 'setSpecialPrice',
        'regular_price' => 'setRegularPrice',
        'extension_attributes' => 'setExtensionAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'final_price' => 'getFinalPrice',
        'max_price' => 'getMaxPrice',
        'minimal_price' => 'getMinimalPrice',
        'max_regular_price' => 'getMaxRegularPrice',
        'minimal_regular_price' => 'getMinimalRegularPrice',
        'special_price' => 'getSpecialPrice',
        'regular_price' => 'getRegularPrice',
        'extension_attributes' => 'getExtensionAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['final_price'] = $data['final_price'] ?? null;
        $this->container['max_price'] = $data['max_price'] ?? null;
        $this->container['minimal_price'] = $data['minimal_price'] ?? null;
        $this->container['max_regular_price'] = $data['max_regular_price'] ?? null;
        $this->container['minimal_regular_price'] = $data['minimal_regular_price'] ?? null;
        $this->container['special_price'] = $data['special_price'] ?? null;
        $this->container['regular_price'] = $data['regular_price'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['final_price'] === null) {
            $invalidProperties[] = "'final_price' can't be null";
        }
        if ($this->container['max_price'] === null) {
            $invalidProperties[] = "'max_price' can't be null";
        }
        if ($this->container['minimal_price'] === null) {
            $invalidProperties[] = "'minimal_price' can't be null";
        }
        if ($this->container['max_regular_price'] === null) {
            $invalidProperties[] = "'max_regular_price' can't be null";
        }
        if ($this->container['minimal_regular_price'] === null) {
            $invalidProperties[] = "'minimal_regular_price' can't be null";
        }
        if ($this->container['special_price'] === null) {
            $invalidProperties[] = "'special_price' can't be null";
        }
        if ($this->container['regular_price'] === null) {
            $invalidProperties[] = "'regular_price' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets final_price
     *
     * @return string
     */
    public function getFinalPrice()
    {
        return $this->container['final_price'];
    }

    /**
     * Sets final_price
     *
     * @param string $final_price Html with final price
     *
     * @return self
     */
    public function setFinalPrice($final_price)
    {
        $this->container['final_price'] = $final_price;

        return $this;
    }

    /**
     * Gets max_price
     *
     * @return string
     */
    public function getMaxPrice()
    {
        return $this->container['max_price'];
    }

    /**
     * Sets max_price
     *
     * @param string $max_price Max price of a product
     *
     * @return self
     */
    public function setMaxPrice($max_price)
    {
        $this->container['max_price'] = $max_price;

        return $this;
    }

    /**
     * Gets minimal_price
     *
     * @return string
     */
    public function getMinimalPrice()
    {
        return $this->container['minimal_price'];
    }

    /**
     * Sets minimal_price
     *
     * @param string $minimal_price The minimal price of the product or variation
     *
     * @return self
     */
    public function setMinimalPrice($minimal_price)
    {
        $this->container['minimal_price'] = $minimal_price;

        return $this;
    }

    /**
     * Gets max_regular_price
     *
     * @return string
     */
    public function getMaxRegularPrice()
    {
        return $this->container['max_regular_price'];
    }

    /**
     * Sets max_regular_price
     *
     * @param string $max_regular_price Max regular price
     *
     * @return self
     */
    public function setMaxRegularPrice($max_regular_price)
    {
        $this->container['max_regular_price'] = $max_regular_price;

        return $this;
    }

    /**
     * Gets minimal_regular_price
     *
     * @return string
     */
    public function getMinimalRegularPrice()
    {
        return $this->container['minimal_regular_price'];
    }

    /**
     * Sets minimal_regular_price
     *
     * @param string $minimal_regular_price Minimal regular price
     *
     * @return self
     */
    public function setMinimalRegularPrice($minimal_regular_price)
    {
        $this->container['minimal_regular_price'] = $minimal_regular_price;

        return $this;
    }

    /**
     * Gets special_price
     *
     * @return string
     */
    public function getSpecialPrice()
    {
        return $this->container['special_price'];
    }

    /**
     * Sets special_price
     *
     * @param string $special_price Special price
     *
     * @return self
     */
    public function setSpecialPrice($special_price)
    {
        $this->container['special_price'] = $special_price;

        return $this;
    }

    /**
     * Gets regular_price
     *
     * @return string
     */
    public function getRegularPrice()
    {
        return $this->container['regular_price'];
    }

    /**
     * Sets regular_price
     *
     * @param string $regular_price Price - is price of product without discounts and special price with taxes and fixed product tax
     *
     * @return self
     */
    public function setRegularPrice($regular_price)
    {
        $this->container['regular_price'] = $regular_price;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\Catalog\\Api\\Data\\ProductRender\\FormattedPriceInfoInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


