<?php
/**
 * AsynchronousOperationsDataBulkOperationsStatusInterface
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Model;

use \ArrayAccess;
use \Magento2\ObjectSerializer;

/**
 * AsynchronousOperationsDataBulkOperationsStatusInterface Class Doc Comment
 *
 * @category Class
 * @description Interface BulkStatusInterface Bulk summary data with list of operations items summary data.
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class AsynchronousOperationsDataBulkOperationsStatusInterface implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'asynchronous-operations-data-bulk-operations-status-interface';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'operations_list' => '\Magento2\Model\AsynchronousOperationsDataSummaryOperationStatusInterface[]',
        'extension_attributes' => 'object',
        'user_type' => 'int',
        'bulk_id' => 'string',
        'description' => 'string',
        'start_time' => 'string',
        'user_id' => 'int',
        'operation_count' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'operations_list' => null,
        'extension_attributes' => null,
        'user_type' => null,
        'bulk_id' => null,
        'description' => null,
        'start_time' => null,
        'user_id' => null,
        'operation_count' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'operations_list' => 'operations_list',
        'extension_attributes' => 'extension_attributes',
        'user_type' => 'user_type',
        'bulk_id' => 'bulk_id',
        'description' => 'description',
        'start_time' => 'start_time',
        'user_id' => 'user_id',
        'operation_count' => 'operation_count'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'operations_list' => 'setOperationsList',
        'extension_attributes' => 'setExtensionAttributes',
        'user_type' => 'setUserType',
        'bulk_id' => 'setBulkId',
        'description' => 'setDescription',
        'start_time' => 'setStartTime',
        'user_id' => 'setUserId',
        'operation_count' => 'setOperationCount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'operations_list' => 'getOperationsList',
        'extension_attributes' => 'getExtensionAttributes',
        'user_type' => 'getUserType',
        'bulk_id' => 'getBulkId',
        'description' => 'getDescription',
        'start_time' => 'getStartTime',
        'user_id' => 'getUserId',
        'operation_count' => 'getOperationCount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['operations_list'] = $data['operations_list'] ?? null;
        $this->container['extension_attributes'] = $data['extension_attributes'] ?? null;
        $this->container['user_type'] = $data['user_type'] ?? null;
        $this->container['bulk_id'] = $data['bulk_id'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['start_time'] = $data['start_time'] ?? null;
        $this->container['user_id'] = $data['user_id'] ?? null;
        $this->container['operation_count'] = $data['operation_count'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['operations_list'] === null) {
            $invalidProperties[] = "'operations_list' can't be null";
        }
        if ($this->container['user_type'] === null) {
            $invalidProperties[] = "'user_type' can't be null";
        }
        if ($this->container['bulk_id'] === null) {
            $invalidProperties[] = "'bulk_id' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalidProperties[] = "'description' can't be null";
        }
        if ($this->container['start_time'] === null) {
            $invalidProperties[] = "'start_time' can't be null";
        }
        if ($this->container['user_id'] === null) {
            $invalidProperties[] = "'user_id' can't be null";
        }
        if ($this->container['operation_count'] === null) {
            $invalidProperties[] = "'operation_count' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets operations_list
     *
     * @return \Magento2\Model\AsynchronousOperationsDataSummaryOperationStatusInterface[]
     */
    public function getOperationsList()
    {
        return $this->container['operations_list'];
    }

    /**
     * Sets operations_list
     *
     * @param \Magento2\Model\AsynchronousOperationsDataSummaryOperationStatusInterface[] $operations_list List of operation with statuses (short data).
     *
     * @return self
     */
    public function setOperationsList($operations_list)
    {
        $this->container['operations_list'] = $operations_list;

        return $this;
    }

    /**
     * Gets extension_attributes
     *
     * @return object|null
     */
    public function getExtensionAttributes()
    {
        return $this->container['extension_attributes'];
    }

    /**
     * Sets extension_attributes
     *
     * @param object|null $extension_attributes ExtensionInterface class for @see \\Magento\\AsynchronousOperations\\Api\\Data\\BulkSummaryInterface
     *
     * @return self
     */
    public function setExtensionAttributes($extension_attributes)
    {
        $this->container['extension_attributes'] = $extension_attributes;

        return $this;
    }

    /**
     * Gets user_type
     *
     * @return int
     */
    public function getUserType()
    {
        return $this->container['user_type'];
    }

    /**
     * Sets user_type
     *
     * @param int $user_type User type
     *
     * @return self
     */
    public function setUserType($user_type)
    {
        $this->container['user_type'] = $user_type;

        return $this;
    }

    /**
     * Gets bulk_id
     *
     * @return string
     */
    public function getBulkId()
    {
        return $this->container['bulk_id'];
    }

    /**
     * Sets bulk_id
     *
     * @param string $bulk_id Bulk uuid
     *
     * @return self
     */
    public function setBulkId($bulk_id)
    {
        $this->container['bulk_id'] = $bulk_id;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description Bulk description
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets start_time
     *
     * @return string
     */
    public function getStartTime()
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time
     *
     * @param string $start_time Bulk scheduled time
     *
     * @return self
     */
    public function setStartTime($start_time)
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int $user_id User id
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets operation_count
     *
     * @return int
     */
    public function getOperationCount()
    {
        return $this->container['operation_count'];
    }

    /**
     * Sets operation_count
     *
     * @param int $operation_count Total number of operations scheduled in scope of this bulk
     *
     * @return self
     */
    public function setOperationCount($operation_count)
    {
        $this->container['operation_count'] = $operation_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


