<?php
/**
 * QuoteGuestPaymentMethodManagementV1Api
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Magento2\ApiException;
use Magento2\Configuration;
use Magento2\HeaderSelector;
use Magento2\ObjectSerializer;

/**
 * QuoteGuestPaymentMethodManagementV1Api Class Doc Comment
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class QuoteGuestPaymentMethodManagementV1Api
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetGet
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Magento2\Model\QuoteDataPaymentInterface|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function quoteGuestPaymentMethodManagementV1GetGet($cart_id)
    {
        list($response) = $this->quoteGuestPaymentMethodManagementV1GetGetWithHttpInfo($cart_id);
        return $response;
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetGetWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Magento2\Model\QuoteDataPaymentInterface|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function quoteGuestPaymentMethodManagementV1GetGetWithHttpInfo($cart_id)
    {
        $request = $this->quoteGuestPaymentMethodManagementV1GetGetRequest($cart_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Magento2\Model\QuoteDataPaymentInterface' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\QuoteDataPaymentInterface' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\QuoteDataPaymentInterface', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Magento2\Model\QuoteDataPaymentInterface';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\QuoteDataPaymentInterface',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetGetAsync
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1GetGetAsync($cart_id)
    {
        return $this->quoteGuestPaymentMethodManagementV1GetGetAsyncWithHttpInfo($cart_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetGetAsyncWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1GetGetAsyncWithHttpInfo($cart_id)
    {
        $returnType = '\Magento2\Model\QuoteDataPaymentInterface';
        $request = $this->quoteGuestPaymentMethodManagementV1GetGetRequest($cart_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'quoteGuestPaymentMethodManagementV1GetGet'
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function quoteGuestPaymentMethodManagementV1GetGetRequest($cart_id)
    {
        // verify the required parameter 'cart_id' is set
        if ($cart_id === null || (is_array($cart_id) && count($cart_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cart_id when calling quoteGuestPaymentMethodManagementV1GetGet'
            );
        }

        $resourcePath = '/V1/guest-carts/{cartId}/selected-payment-method';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($cart_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cartId' . '}',
                ObjectSerializer::toPathValue($cart_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetListGet
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Magento2\Model\QuoteDataPaymentMethodInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function quoteGuestPaymentMethodManagementV1GetListGet($cart_id)
    {
        list($response) = $this->quoteGuestPaymentMethodManagementV1GetListGetWithHttpInfo($cart_id);
        return $response;
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetListGetWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Magento2\Model\QuoteDataPaymentMethodInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function quoteGuestPaymentMethodManagementV1GetListGetWithHttpInfo($cart_id)
    {
        $request = $this->quoteGuestPaymentMethodManagementV1GetListGetRequest($cart_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Magento2\Model\QuoteDataPaymentMethodInterface[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\QuoteDataPaymentMethodInterface[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\QuoteDataPaymentMethodInterface[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Magento2\Model\QuoteDataPaymentMethodInterface[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\QuoteDataPaymentMethodInterface[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetListGetAsync
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1GetListGetAsync($cart_id)
    {
        return $this->quoteGuestPaymentMethodManagementV1GetListGetAsyncWithHttpInfo($cart_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1GetListGetAsyncWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1GetListGetAsyncWithHttpInfo($cart_id)
    {
        $returnType = '\Magento2\Model\QuoteDataPaymentMethodInterface[]';
        $request = $this->quoteGuestPaymentMethodManagementV1GetListGetRequest($cart_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'quoteGuestPaymentMethodManagementV1GetListGet'
     *
     * @param  string $cart_id The cart ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function quoteGuestPaymentMethodManagementV1GetListGetRequest($cart_id)
    {
        // verify the required parameter 'cart_id' is set
        if ($cart_id === null || (is_array($cart_id) && count($cart_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cart_id when calling quoteGuestPaymentMethodManagementV1GetListGet'
            );
        }

        $resourcePath = '/V1/guest-carts/{cartId}/payment-methods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($cart_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cartId' . '}',
                ObjectSerializer::toPathValue($cart_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1SetPut
     *
     * @param  string $cart_id The cart ID. (required)
     * @param  \Magento2\Model\QuotePaymentMethodManagementV1SetPutRequest $quote_guest_payment_method_management_v1_set_put_body quote_guest_payment_method_management_v1_set_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function quoteGuestPaymentMethodManagementV1SetPut($cart_id, $quote_guest_payment_method_management_v1_set_put_body = null)
    {
        list($response) = $this->quoteGuestPaymentMethodManagementV1SetPutWithHttpInfo($cart_id, $quote_guest_payment_method_management_v1_set_put_body);
        return $response;
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1SetPutWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     * @param  \Magento2\Model\QuotePaymentMethodManagementV1SetPutRequest $quote_guest_payment_method_management_v1_set_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function quoteGuestPaymentMethodManagementV1SetPutWithHttpInfo($cart_id, $quote_guest_payment_method_management_v1_set_put_body = null)
    {
        $request = $this->quoteGuestPaymentMethodManagementV1SetPutRequest($cart_id, $quote_guest_payment_method_management_v1_set_put_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('int' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('int' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'int', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'int';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1SetPutAsync
     *
     * @param  string $cart_id The cart ID. (required)
     * @param  \Magento2\Model\QuotePaymentMethodManagementV1SetPutRequest $quote_guest_payment_method_management_v1_set_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1SetPutAsync($cart_id, $quote_guest_payment_method_management_v1_set_put_body = null)
    {
        return $this->quoteGuestPaymentMethodManagementV1SetPutAsyncWithHttpInfo($cart_id, $quote_guest_payment_method_management_v1_set_put_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation quoteGuestPaymentMethodManagementV1SetPutAsyncWithHttpInfo
     *
     * @param  string $cart_id The cart ID. (required)
     * @param  \Magento2\Model\QuotePaymentMethodManagementV1SetPutRequest $quote_guest_payment_method_management_v1_set_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function quoteGuestPaymentMethodManagementV1SetPutAsyncWithHttpInfo($cart_id, $quote_guest_payment_method_management_v1_set_put_body = null)
    {
        $returnType = 'int';
        $request = $this->quoteGuestPaymentMethodManagementV1SetPutRequest($cart_id, $quote_guest_payment_method_management_v1_set_put_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'quoteGuestPaymentMethodManagementV1SetPut'
     *
     * @param  string $cart_id The cart ID. (required)
     * @param  \Magento2\Model\QuotePaymentMethodManagementV1SetPutRequest $quote_guest_payment_method_management_v1_set_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function quoteGuestPaymentMethodManagementV1SetPutRequest($cart_id, $quote_guest_payment_method_management_v1_set_put_body = null)
    {
        // verify the required parameter 'cart_id' is set
        if ($cart_id === null || (is_array($cart_id) && count($cart_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $cart_id when calling quoteGuestPaymentMethodManagementV1SetPut'
            );
        }

        $resourcePath = '/V1/guest-carts/{cartId}/selected-payment-method';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($cart_id !== null) {
            $resourcePath = str_replace(
                '{' . 'cartId' . '}',
                ObjectSerializer::toPathValue($cart_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (isset($quote_guest_payment_method_management_v1_set_put_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($quote_guest_payment_method_management_v1_set_put_body));
            } else {
                $httpBody = $quote_guest_payment_method_management_v1_set_put_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
