<?php
/**
 * InventoryExportStockApiExportStockIndexDataV1Api
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Magento2\ApiException;
use Magento2\Configuration;
use Magento2\HeaderSelector;
use Magento2\ObjectSerializer;

/**
 * InventoryExportStockApiExportStockIndexDataV1Api Class Doc Comment
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InventoryExportStockApiExportStockIndexDataV1Api
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation inventoryExportStockApiExportStockIndexDataV1ExecuteGet
     *
     * @param  string $sales_channel_type sales_channel_type (required)
     * @param  string $sales_channel_code sales_channel_code (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function inventoryExportStockApiExportStockIndexDataV1ExecuteGet($sales_channel_type, $sales_channel_code)
    {
        list($response) = $this->inventoryExportStockApiExportStockIndexDataV1ExecuteGetWithHttpInfo($sales_channel_type, $sales_channel_code);
        return $response;
    }

    /**
     * Operation inventoryExportStockApiExportStockIndexDataV1ExecuteGetWithHttpInfo
     *
     * @param  string $sales_channel_type (required)
     * @param  string $sales_channel_code (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function inventoryExportStockApiExportStockIndexDataV1ExecuteGetWithHttpInfo($sales_channel_type, $sales_channel_code)
    {
        $request = $this->inventoryExportStockApiExportStockIndexDataV1ExecuteGetRequest($sales_channel_type, $sales_channel_code);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation inventoryExportStockApiExportStockIndexDataV1ExecuteGetAsync
     *
     * @param  string $sales_channel_type (required)
     * @param  string $sales_channel_code (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventoryExportStockApiExportStockIndexDataV1ExecuteGetAsync($sales_channel_type, $sales_channel_code)
    {
        return $this->inventoryExportStockApiExportStockIndexDataV1ExecuteGetAsyncWithHttpInfo($sales_channel_type, $sales_channel_code)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation inventoryExportStockApiExportStockIndexDataV1ExecuteGetAsyncWithHttpInfo
     *
     * @param  string $sales_channel_type (required)
     * @param  string $sales_channel_code (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function inventoryExportStockApiExportStockIndexDataV1ExecuteGetAsyncWithHttpInfo($sales_channel_type, $sales_channel_code)
    {
        $returnType = '\Magento2\Model\InventoryExportStockApiDataProductStockIndexDataInterface[]';
        $request = $this->inventoryExportStockApiExportStockIndexDataV1ExecuteGetRequest($sales_channel_type, $sales_channel_code);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'inventoryExportStockApiExportStockIndexDataV1ExecuteGet'
     *
     * @param  string $sales_channel_type (required)
     * @param  string $sales_channel_code (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function inventoryExportStockApiExportStockIndexDataV1ExecuteGetRequest($sales_channel_type, $sales_channel_code)
    {
        // verify the required parameter 'sales_channel_type' is set
        if ($sales_channel_type === null || (is_array($sales_channel_type) && count($sales_channel_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_channel_type when calling inventoryExportStockApiExportStockIndexDataV1ExecuteGet'
            );
        }
        // verify the required parameter 'sales_channel_code' is set
        if ($sales_channel_code === null || (is_array($sales_channel_code) && count($sales_channel_code) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sales_channel_code when calling inventoryExportStockApiExportStockIndexDataV1ExecuteGet'
            );
        }

        $resourcePath = '/V1/inventory/dump-stock-index-data/{salesChannelType}/{salesChannelCode}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sales_channel_type !== null) {
            $resourcePath = str_replace(
                '{' . 'salesChannelType' . '}',
                ObjectSerializer::toPathValue($sales_channel_type),
                $resourcePath
            );
        }
        // path params
        if ($sales_channel_code !== null) {
            $resourcePath = str_replace(
                '{' . 'salesChannelCode' . '}',
                ObjectSerializer::toPathValue($sales_channel_code),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
