<?php
/**
 * BundleProductLinkManagementV1Api
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Magento2\ApiException;
use Magento2\Configuration;
use Magento2\HeaderSelector;
use Magento2\ObjectSerializer;

/**
 * BundleProductLinkManagementV1Api Class Doc Comment
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BundleProductLinkManagementV1Api
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation bundleProductLinkManagementV1AddChildByProductSkuPost
     *
     * @param  string $sku sku (required)
     * @param  int $option_id option_id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_add_child_by_product_sku_post_body bundle_product_link_management_v1_add_child_by_product_sku_post_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function bundleProductLinkManagementV1AddChildByProductSkuPost($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body = null)
    {
        list($response) = $this->bundleProductLinkManagementV1AddChildByProductSkuPostWithHttpInfo($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body);
        return $response;
    }

    /**
     * Operation bundleProductLinkManagementV1AddChildByProductSkuPostWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_add_child_by_product_sku_post_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function bundleProductLinkManagementV1AddChildByProductSkuPostWithHttpInfo($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body = null)
    {
        $request = $this->bundleProductLinkManagementV1AddChildByProductSkuPostRequest($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('int' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('int' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'int', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'int';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation bundleProductLinkManagementV1AddChildByProductSkuPostAsync
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_add_child_by_product_sku_post_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1AddChildByProductSkuPostAsync($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body = null)
    {
        return $this->bundleProductLinkManagementV1AddChildByProductSkuPostAsyncWithHttpInfo($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bundleProductLinkManagementV1AddChildByProductSkuPostAsyncWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_add_child_by_product_sku_post_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1AddChildByProductSkuPostAsyncWithHttpInfo($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body = null)
    {
        $returnType = 'int';
        $request = $this->bundleProductLinkManagementV1AddChildByProductSkuPostRequest($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bundleProductLinkManagementV1AddChildByProductSkuPost'
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_add_child_by_product_sku_post_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bundleProductLinkManagementV1AddChildByProductSkuPostRequest($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body = null)
    {
        // verify the required parameter 'sku' is set
        if ($sku === null || (is_array($sku) && count($sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sku when calling bundleProductLinkManagementV1AddChildByProductSkuPost'
            );
        }
        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling bundleProductLinkManagementV1AddChildByProductSkuPost'
            );
        }

        $resourcePath = '/V1/bundle-products/{sku}/links/{optionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sku !== null) {
            $resourcePath = str_replace(
                '{' . 'sku' . '}',
                ObjectSerializer::toPathValue($sku),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (isset($bundle_product_link_management_v1_add_child_by_product_sku_post_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($bundle_product_link_management_v1_add_child_by_product_sku_post_body));
            } else {
                $httpBody = $bundle_product_link_management_v1_add_child_by_product_sku_post_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bundleProductLinkManagementV1GetChildrenGet
     *
     * @param  string $product_sku product_sku (required)
     * @param  int $option_id option_id (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Magento2\Model\BundleDataLinkInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function bundleProductLinkManagementV1GetChildrenGet($product_sku, $option_id = null)
    {
        list($response) = $this->bundleProductLinkManagementV1GetChildrenGetWithHttpInfo($product_sku, $option_id);
        return $response;
    }

    /**
     * Operation bundleProductLinkManagementV1GetChildrenGetWithHttpInfo
     *
     * @param  string $product_sku (required)
     * @param  int $option_id (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Magento2\Model\BundleDataLinkInterface[]|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function bundleProductLinkManagementV1GetChildrenGetWithHttpInfo($product_sku, $option_id = null)
    {
        $request = $this->bundleProductLinkManagementV1GetChildrenGetRequest($product_sku, $option_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Magento2\Model\BundleDataLinkInterface[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\BundleDataLinkInterface[]' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\BundleDataLinkInterface[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Magento2\Model\BundleDataLinkInterface[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\BundleDataLinkInterface[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation bundleProductLinkManagementV1GetChildrenGetAsync
     *
     * @param  string $product_sku (required)
     * @param  int $option_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1GetChildrenGetAsync($product_sku, $option_id = null)
    {
        return $this->bundleProductLinkManagementV1GetChildrenGetAsyncWithHttpInfo($product_sku, $option_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bundleProductLinkManagementV1GetChildrenGetAsyncWithHttpInfo
     *
     * @param  string $product_sku (required)
     * @param  int $option_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1GetChildrenGetAsyncWithHttpInfo($product_sku, $option_id = null)
    {
        $returnType = '\Magento2\Model\BundleDataLinkInterface[]';
        $request = $this->bundleProductLinkManagementV1GetChildrenGetRequest($product_sku, $option_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bundleProductLinkManagementV1GetChildrenGet'
     *
     * @param  string $product_sku (required)
     * @param  int $option_id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bundleProductLinkManagementV1GetChildrenGetRequest($product_sku, $option_id = null)
    {
        // verify the required parameter 'product_sku' is set
        if ($product_sku === null || (is_array($product_sku) && count($product_sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_sku when calling bundleProductLinkManagementV1GetChildrenGet'
            );
        }

        $resourcePath = '/V1/bundle-products/{productSku}/children';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $option_id,
            'optionId', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($product_sku !== null) {
            $resourcePath = str_replace(
                '{' . 'productSku' . '}',
                ObjectSerializer::toPathValue($product_sku),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bundleProductLinkManagementV1RemoveChildDelete
     *
     * @param  string $sku sku (required)
     * @param  int $option_id option_id (required)
     * @param  string $child_sku child_sku (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return bool|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function bundleProductLinkManagementV1RemoveChildDelete($sku, $option_id, $child_sku)
    {
        list($response) = $this->bundleProductLinkManagementV1RemoveChildDeleteWithHttpInfo($sku, $option_id, $child_sku);
        return $response;
    }

    /**
     * Operation bundleProductLinkManagementV1RemoveChildDeleteWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  string $child_sku (required)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of bool|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function bundleProductLinkManagementV1RemoveChildDeleteWithHttpInfo($sku, $option_id, $child_sku)
    {
        $request = $this->bundleProductLinkManagementV1RemoveChildDeleteRequest($sku, $option_id, $child_sku);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('bool' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('bool' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'bool', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'bool';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation bundleProductLinkManagementV1RemoveChildDeleteAsync
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  string $child_sku (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1RemoveChildDeleteAsync($sku, $option_id, $child_sku)
    {
        return $this->bundleProductLinkManagementV1RemoveChildDeleteAsyncWithHttpInfo($sku, $option_id, $child_sku)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bundleProductLinkManagementV1RemoveChildDeleteAsyncWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  string $child_sku (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1RemoveChildDeleteAsyncWithHttpInfo($sku, $option_id, $child_sku)
    {
        $returnType = 'bool';
        $request = $this->bundleProductLinkManagementV1RemoveChildDeleteRequest($sku, $option_id, $child_sku);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bundleProductLinkManagementV1RemoveChildDelete'
     *
     * @param  string $sku (required)
     * @param  int $option_id (required)
     * @param  string $child_sku (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bundleProductLinkManagementV1RemoveChildDeleteRequest($sku, $option_id, $child_sku)
    {
        // verify the required parameter 'sku' is set
        if ($sku === null || (is_array($sku) && count($sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sku when calling bundleProductLinkManagementV1RemoveChildDelete'
            );
        }
        // verify the required parameter 'option_id' is set
        if ($option_id === null || (is_array($option_id) && count($option_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $option_id when calling bundleProductLinkManagementV1RemoveChildDelete'
            );
        }
        // verify the required parameter 'child_sku' is set
        if ($child_sku === null || (is_array($child_sku) && count($child_sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $child_sku when calling bundleProductLinkManagementV1RemoveChildDelete'
            );
        }

        $resourcePath = '/V1/bundle-products/{sku}/options/{optionId}/children/{childSku}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sku !== null) {
            $resourcePath = str_replace(
                '{' . 'sku' . '}',
                ObjectSerializer::toPathValue($sku),
                $resourcePath
            );
        }
        // path params
        if ($option_id !== null) {
            $resourcePath = str_replace(
                '{' . 'optionId' . '}',
                ObjectSerializer::toPathValue($option_id),
                $resourcePath
            );
        }
        // path params
        if ($child_sku !== null) {
            $resourcePath = str_replace(
                '{' . 'childSku' . '}',
                ObjectSerializer::toPathValue($child_sku),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bundleProductLinkManagementV1SaveChildPut
     *
     * @param  string $sku sku (required)
     * @param  string $id id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_save_child_put_body bundle_product_link_management_v1_save_child_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return bool|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse
     */
    public function bundleProductLinkManagementV1SaveChildPut($sku, $id, $bundle_product_link_management_v1_save_child_put_body = null)
    {
        list($response) = $this->bundleProductLinkManagementV1SaveChildPutWithHttpInfo($sku, $id, $bundle_product_link_management_v1_save_child_put_body);
        return $response;
    }

    /**
     * Operation bundleProductLinkManagementV1SaveChildPutWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  string $id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_save_child_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of bool|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function bundleProductLinkManagementV1SaveChildPutWithHttpInfo($sku, $id, $bundle_product_link_management_v1_save_child_put_body = null)
    {
        $request = $this->bundleProductLinkManagementV1SaveChildPutRequest($sku, $id, $bundle_product_link_management_v1_save_child_put_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('bool' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('bool' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'bool', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 401:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'bool';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation bundleProductLinkManagementV1SaveChildPutAsync
     *
     * @param  string $sku (required)
     * @param  string $id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_save_child_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1SaveChildPutAsync($sku, $id, $bundle_product_link_management_v1_save_child_put_body = null)
    {
        return $this->bundleProductLinkManagementV1SaveChildPutAsyncWithHttpInfo($sku, $id, $bundle_product_link_management_v1_save_child_put_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bundleProductLinkManagementV1SaveChildPutAsyncWithHttpInfo
     *
     * @param  string $sku (required)
     * @param  string $id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_save_child_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bundleProductLinkManagementV1SaveChildPutAsyncWithHttpInfo($sku, $id, $bundle_product_link_management_v1_save_child_put_body = null)
    {
        $returnType = 'bool';
        $request = $this->bundleProductLinkManagementV1SaveChildPutRequest($sku, $id, $bundle_product_link_management_v1_save_child_put_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bundleProductLinkManagementV1SaveChildPut'
     *
     * @param  string $sku (required)
     * @param  string $id (required)
     * @param  \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest $bundle_product_link_management_v1_save_child_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bundleProductLinkManagementV1SaveChildPutRequest($sku, $id, $bundle_product_link_management_v1_save_child_put_body = null)
    {
        // verify the required parameter 'sku' is set
        if ($sku === null || (is_array($sku) && count($sku) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sku when calling bundleProductLinkManagementV1SaveChildPut'
            );
        }
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling bundleProductLinkManagementV1SaveChildPut'
            );
        }

        $resourcePath = '/V1/bundle-products/{sku}/links/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sku !== null) {
            $resourcePath = str_replace(
                '{' . 'sku' . '}',
                ObjectSerializer::toPathValue($sku),
                $resourcePath
            );
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (isset($bundle_product_link_management_v1_save_child_put_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($bundle_product_link_management_v1_save_child_put_body));
            } else {
                $httpBody = $bundle_product_link_management_v1_save_child_put_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
