<?php
/**
 * AmazonPaymentAddressManagementV1Api
 * PHP version 7.4
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Magento Community
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 2.3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Magento2\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Magento2\ApiException;
use Magento2\Configuration;
use Magento2\HeaderSelector;
use Magento2\ObjectSerializer;

/**
 * AmazonPaymentAddressManagementV1Api Class Doc Comment
 *
 * @category Class
 * @package  Magento2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AmazonPaymentAddressManagementV1Api
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetBillingAddressPut
     *
     * @param  string $amazon_order_reference_id amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_billing_address_put_body amazon_payment_address_management_v1_get_billing_address_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|\Magento2\Model\ErrorResponse
     */
    public function amazonPaymentAddressManagementV1GetBillingAddressPut($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body = null)
    {
        list($response) = $this->amazonPaymentAddressManagementV1GetBillingAddressPutWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body);
        return $response;
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetBillingAddressPutWithHttpInfo
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_billing_address_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function amazonPaymentAddressManagementV1GetBillingAddressPutWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body = null)
    {
        $request = $this->amazonPaymentAddressManagementV1GetBillingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetBillingAddressPutAsync
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_billing_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function amazonPaymentAddressManagementV1GetBillingAddressPutAsync($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body = null)
    {
        return $this->amazonPaymentAddressManagementV1GetBillingAddressPutAsyncWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetBillingAddressPutAsyncWithHttpInfo
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_billing_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function amazonPaymentAddressManagementV1GetBillingAddressPutAsyncWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body = null)
    {
        $returnType = 'string';
        $request = $this->amazonPaymentAddressManagementV1GetBillingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'amazonPaymentAddressManagementV1GetBillingAddressPut'
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_billing_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function amazonPaymentAddressManagementV1GetBillingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body = null)
    {
        // verify the required parameter 'amazon_order_reference_id' is set
        if ($amazon_order_reference_id === null || (is_array($amazon_order_reference_id) && count($amazon_order_reference_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $amazon_order_reference_id when calling amazonPaymentAddressManagementV1GetBillingAddressPut'
            );
        }

        $resourcePath = '/V1/amazon-billing-address/{amazonOrderReferenceId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($amazon_order_reference_id !== null) {
            $resourcePath = str_replace(
                '{' . 'amazonOrderReferenceId' . '}',
                ObjectSerializer::toPathValue($amazon_order_reference_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (isset($amazon_payment_address_management_v1_get_billing_address_put_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($amazon_payment_address_management_v1_get_billing_address_put_body));
            } else {
                $httpBody = $amazon_payment_address_management_v1_get_billing_address_put_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetShippingAddressPut
     *
     * @param  string $amazon_order_reference_id amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_shipping_address_put_body amazon_payment_address_management_v1_get_shipping_address_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|\Magento2\Model\ErrorResponse
     */
    public function amazonPaymentAddressManagementV1GetShippingAddressPut($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body = null)
    {
        list($response) = $this->amazonPaymentAddressManagementV1GetShippingAddressPutWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body);
        return $response;
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetShippingAddressPutWithHttpInfo
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_shipping_address_put_body (optional)
     *
     * @throws \Magento2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|\Magento2\Model\ErrorResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function amazonPaymentAddressManagementV1GetShippingAddressPutWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body = null)
    {
        $request = $this->amazonPaymentAddressManagementV1GetShippingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\Magento2\Model\ErrorResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Magento2\Model\ErrorResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Magento2\Model\ErrorResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Magento2\Model\ErrorResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetShippingAddressPutAsync
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_shipping_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function amazonPaymentAddressManagementV1GetShippingAddressPutAsync($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body = null)
    {
        return $this->amazonPaymentAddressManagementV1GetShippingAddressPutAsyncWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation amazonPaymentAddressManagementV1GetShippingAddressPutAsyncWithHttpInfo
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_shipping_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function amazonPaymentAddressManagementV1GetShippingAddressPutAsyncWithHttpInfo($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body = null)
    {
        $returnType = 'string';
        $request = $this->amazonPaymentAddressManagementV1GetShippingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'amazonPaymentAddressManagementV1GetShippingAddressPut'
     *
     * @param  string $amazon_order_reference_id (required)
     * @param  \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest $amazon_payment_address_management_v1_get_shipping_address_put_body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function amazonPaymentAddressManagementV1GetShippingAddressPutRequest($amazon_order_reference_id, $amazon_payment_address_management_v1_get_shipping_address_put_body = null)
    {
        // verify the required parameter 'amazon_order_reference_id' is set
        if ($amazon_order_reference_id === null || (is_array($amazon_order_reference_id) && count($amazon_order_reference_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $amazon_order_reference_id when calling amazonPaymentAddressManagementV1GetShippingAddressPut'
            );
        }

        $resourcePath = '/V1/amazon-shipping-address/{amazonOrderReferenceId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($amazon_order_reference_id !== null) {
            $resourcePath = str_replace(
                '{' . 'amazonOrderReferenceId' . '}',
                ObjectSerializer::toPathValue($amazon_order_reference_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['*/*']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['*/*'],
                []
            );
        }

        // for model (json/xml)
        if (isset($amazon_payment_address_management_v1_get_shipping_address_put_body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($amazon_payment_address_management_v1_get_shipping_address_put_body));
            } else {
                $httpBody = $amazon_payment_address_management_v1_get_shipping_address_put_body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
