# Magento2\TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete()**](TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete) | **DELETE** /V1/guest-carts/{cartId}/collection-point/search-request | 
[**temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet()**](TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet) | **GET** /V1/guest-carts/{cartId}/collection-point/search-result | 
[**temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut()**](TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut) | **PUT** /V1/guest-carts/{cartId}/collection-point/search-request | 
[**temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost()**](TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost) | **POST** /V1/guest-carts/{cartId}/checkout-collection-point/select | 


## `temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete()`

```php
temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete($cart_id): bool
```



Delete a customer's search for collection points.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string

try {
    $result = $apiInstance->temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete($cart_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api->temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet()`

```php
temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet($cart_id): \Magento2\Model\TemandoShippingDataDeliveryQuoteCollectionPointInterface[]
```



Retrieve collection points matching the customer's search parameters.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string

try {
    $result = $apiInstance->temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet($cart_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api->temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**|  |

### Return type

[**\Magento2\Model\TemandoShippingDataDeliveryQuoteCollectionPointInterface[]**](../Model/TemandoShippingDataDeliveryQuoteCollectionPointInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut()`

```php
temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut($cart_id, $temando_shipping_checkout_guest_cart_collection_point_management_v1_save_search_request_put_body): \Magento2\Model\TemandoShippingDataDeliveryCollectionPointSearchRequestInterface
```



Save a customer's search for collection points.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string
$temando_shipping_checkout_guest_cart_collection_point_management_v1_save_search_request_put_body = new \Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest(); // \Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest

try {
    $result = $apiInstance->temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut($cart_id, $temando_shipping_checkout_guest_cart_collection_point_management_v1_save_search_request_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api->temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**|  |
 **temando_shipping_checkout_guest_cart_collection_point_management_v1_save_search_request_put_body** | [**\Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest**](../Model/TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\TemandoShippingDataDeliveryCollectionPointSearchRequestInterface**](../Model/TemandoShippingDataDeliveryCollectionPointSearchRequestInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost()`

```php
temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost($cart_id, $temando_shipping_checkout_guest_cart_collection_point_management_v1_select_collection_point_post_body): bool
```



Select a given collection point for checkout.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string
$temando_shipping_checkout_guest_cart_collection_point_management_v1_select_collection_point_post_body = new \Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest(); // \Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest

try {
    $result = $apiInstance->temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost($cart_id, $temando_shipping_checkout_guest_cart_collection_point_management_v1_select_collection_point_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api->temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**|  |
 **temando_shipping_checkout_guest_cart_collection_point_management_v1_select_collection_point_post_body** | [**\Magento2\Model\TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest**](../Model/TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
