# Magento2\SalesShipmentManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**salesShipmentManagementV1GetCommentsListGet()**](SalesShipmentManagementV1Api.md#salesShipmentManagementV1GetCommentsListGet) | **GET** /V1/shipment/{id}/comments | 
[**salesShipmentManagementV1GetLabelGet()**](SalesShipmentManagementV1Api.md#salesShipmentManagementV1GetLabelGet) | **GET** /V1/shipment/{id}/label | 
[**salesShipmentManagementV1NotifyPost()**](SalesShipmentManagementV1Api.md#salesShipmentManagementV1NotifyPost) | **POST** /V1/shipment/{id}/emails | 


## `salesShipmentManagementV1GetCommentsListGet()`

```php
salesShipmentManagementV1GetCommentsListGet($id): \Magento2\Model\SalesDataShipmentCommentSearchResultInterface
```



Lists comments for a specified shipment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesShipmentManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The shipment ID.

try {
    $result = $apiInstance->salesShipmentManagementV1GetCommentsListGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentManagementV1Api->salesShipmentManagementV1GetCommentsListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The shipment ID. |

### Return type

[**\Magento2\Model\SalesDataShipmentCommentSearchResultInterface**](../Model/SalesDataShipmentCommentSearchResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesShipmentManagementV1GetLabelGet()`

```php
salesShipmentManagementV1GetLabelGet($id): string
```



Gets a specified shipment label.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesShipmentManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The shipment label ID.

try {
    $result = $apiInstance->salesShipmentManagementV1GetLabelGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentManagementV1Api->salesShipmentManagementV1GetLabelGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The shipment label ID. |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesShipmentManagementV1NotifyPost()`

```php
salesShipmentManagementV1NotifyPost($id): bool
```



Emails user a specified shipment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesShipmentManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The shipment ID.

try {
    $result = $apiInstance->salesShipmentManagementV1NotifyPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipmentManagementV1Api->salesShipmentManagementV1NotifyPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The shipment ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
