# Magento2\SalesShipOrderV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**salesShipOrderV1ExecutePost()**](SalesShipOrderV1Api.md#salesShipOrderV1ExecutePost) | **POST** /V1/order/{orderId}/ship | 


## `salesShipOrderV1ExecutePost()`

```php
salesShipOrderV1ExecutePost($order_id, $sales_ship_order_v1_execute_post_body): int
```



Creates new Shipment for given Order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesShipOrderV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$order_id = 56; // int
$sales_ship_order_v1_execute_post_body = new \Magento2\Model\SalesShipOrderV1ExecutePostRequest(); // \Magento2\Model\SalesShipOrderV1ExecutePostRequest

try {
    $result = $apiInstance->salesShipOrderV1ExecutePost($order_id, $sales_ship_order_v1_execute_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesShipOrderV1Api->salesShipOrderV1ExecutePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **order_id** | **int**|  |
 **sales_ship_order_v1_execute_post_body** | [**\Magento2\Model\SalesShipOrderV1ExecutePostRequest**](../Model/SalesShipOrderV1ExecutePostRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
