# Magento2\SalesOrderManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**salesOrderManagementV1AddCommentPost()**](SalesOrderManagementV1Api.md#salesOrderManagementV1AddCommentPost) | **POST** /V1/orders/{id}/comments | 
[**salesOrderManagementV1CancelPost()**](SalesOrderManagementV1Api.md#salesOrderManagementV1CancelPost) | **POST** /V1/orders/{id}/cancel | 
[**salesOrderManagementV1GetCommentsListGet()**](SalesOrderManagementV1Api.md#salesOrderManagementV1GetCommentsListGet) | **GET** /V1/orders/{id}/comments | 
[**salesOrderManagementV1GetStatusGet()**](SalesOrderManagementV1Api.md#salesOrderManagementV1GetStatusGet) | **GET** /V1/orders/{id}/statuses | 
[**salesOrderManagementV1HoldPost()**](SalesOrderManagementV1Api.md#salesOrderManagementV1HoldPost) | **POST** /V1/orders/{id}/hold | 
[**salesOrderManagementV1NotifyPost()**](SalesOrderManagementV1Api.md#salesOrderManagementV1NotifyPost) | **POST** /V1/orders/{id}/emails | 
[**salesOrderManagementV1UnHoldPost()**](SalesOrderManagementV1Api.md#salesOrderManagementV1UnHoldPost) | **POST** /V1/orders/{id}/unhold | 


## `salesOrderManagementV1AddCommentPost()`

```php
salesOrderManagementV1AddCommentPost($id, $sales_order_management_v1_add_comment_post_body): bool
```



Adds a comment to a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.
$sales_order_management_v1_add_comment_post_body = new \Magento2\Model\SalesOrderManagementV1AddCommentPostRequest(); // \Magento2\Model\SalesOrderManagementV1AddCommentPostRequest

try {
    $result = $apiInstance->salesOrderManagementV1AddCommentPost($id, $sales_order_management_v1_add_comment_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1AddCommentPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |
 **sales_order_management_v1_add_comment_post_body** | [**\Magento2\Model\SalesOrderManagementV1AddCommentPostRequest**](../Model/SalesOrderManagementV1AddCommentPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1CancelPost()`

```php
salesOrderManagementV1CancelPost($id): bool
```



Cancels a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1CancelPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1CancelPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1GetCommentsListGet()`

```php
salesOrderManagementV1GetCommentsListGet($id): \Magento2\Model\SalesDataOrderStatusHistorySearchResultInterface
```



Lists comments for a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1GetCommentsListGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1GetCommentsListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

[**\Magento2\Model\SalesDataOrderStatusHistorySearchResultInterface**](../Model/SalesDataOrderStatusHistorySearchResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1GetStatusGet()`

```php
salesOrderManagementV1GetStatusGet($id): string
```



Gets the status for a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1GetStatusGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1GetStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1HoldPost()`

```php
salesOrderManagementV1HoldPost($id): bool
```



Holds a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1HoldPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1HoldPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1NotifyPost()`

```php
salesOrderManagementV1NotifyPost($id): bool
```



Emails a user a specified order.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1NotifyPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1NotifyPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesOrderManagementV1UnHoldPost()`

```php
salesOrderManagementV1UnHoldPost($id): bool
```



Releases a specified order from hold status.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The order ID.

try {
    $result = $apiInstance->salesOrderManagementV1UnHoldPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderManagementV1Api->salesOrderManagementV1UnHoldPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The order ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
