# Magento2\SalesOrderAddressRepositoryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**salesOrderAddressRepositoryV1SavePut()**](SalesOrderAddressRepositoryV1Api.md#salesOrderAddressRepositoryV1SavePut) | **PUT** /V1/orders/{parent_id} | 


## `salesOrderAddressRepositoryV1SavePut()`

```php
salesOrderAddressRepositoryV1SavePut($parent_id, $sales_order_address_repository_v1_save_put_body): \Magento2\Model\SalesDataOrderAddressInterface
```



Performs persist operations for a specified order address.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesOrderAddressRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$parent_id = 'parent_id_example'; // string
$sales_order_address_repository_v1_save_put_body = new \Magento2\Model\SalesOrderAddressRepositoryV1SavePutRequest(); // \Magento2\Model\SalesOrderAddressRepositoryV1SavePutRequest

try {
    $result = $apiInstance->salesOrderAddressRepositoryV1SavePut($parent_id, $sales_order_address_repository_v1_save_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesOrderAddressRepositoryV1Api->salesOrderAddressRepositoryV1SavePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **parent_id** | **string**|  |
 **sales_order_address_repository_v1_save_put_body** | [**\Magento2\Model\SalesOrderAddressRepositoryV1SavePutRequest**](../Model/SalesOrderAddressRepositoryV1SavePutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\SalesDataOrderAddressInterface**](../Model/SalesDataOrderAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
