# Magento2\SalesInvoiceManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**salesInvoiceManagementV1GetCommentsListGet()**](SalesInvoiceManagementV1Api.md#salesInvoiceManagementV1GetCommentsListGet) | **GET** /V1/invoices/{id}/comments | 
[**salesInvoiceManagementV1NotifyPost()**](SalesInvoiceManagementV1Api.md#salesInvoiceManagementV1NotifyPost) | **POST** /V1/invoices/{id}/emails | 
[**salesInvoiceManagementV1SetCapturePost()**](SalesInvoiceManagementV1Api.md#salesInvoiceManagementV1SetCapturePost) | **POST** /V1/invoices/{id}/capture | 
[**salesInvoiceManagementV1SetVoidPost()**](SalesInvoiceManagementV1Api.md#salesInvoiceManagementV1SetVoidPost) | **POST** /V1/invoices/{id}/void | 


## `salesInvoiceManagementV1GetCommentsListGet()`

```php
salesInvoiceManagementV1GetCommentsListGet($id): \Magento2\Model\SalesDataInvoiceCommentSearchResultInterface
```



Lists comments for a specified invoice.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesInvoiceManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The invoice ID.

try {
    $result = $apiInstance->salesInvoiceManagementV1GetCommentsListGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoiceManagementV1Api->salesInvoiceManagementV1GetCommentsListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The invoice ID. |

### Return type

[**\Magento2\Model\SalesDataInvoiceCommentSearchResultInterface**](../Model/SalesDataInvoiceCommentSearchResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesInvoiceManagementV1NotifyPost()`

```php
salesInvoiceManagementV1NotifyPost($id): bool
```



Emails a user a specified invoice.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesInvoiceManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The invoice ID.

try {
    $result = $apiInstance->salesInvoiceManagementV1NotifyPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoiceManagementV1Api->salesInvoiceManagementV1NotifyPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The invoice ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesInvoiceManagementV1SetCapturePost()`

```php
salesInvoiceManagementV1SetCapturePost($id): string
```



Sets invoice capture.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesInvoiceManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->salesInvoiceManagementV1SetCapturePost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoiceManagementV1Api->salesInvoiceManagementV1SetCapturePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `salesInvoiceManagementV1SetVoidPost()`

```php
salesInvoiceManagementV1SetVoidPost($id): bool
```



Voids a specified invoice.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\SalesInvoiceManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | The invoice ID.

try {
    $result = $apiInstance->salesInvoiceManagementV1SetVoidPost($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SalesInvoiceManagementV1Api->salesInvoiceManagementV1SetVoidPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| The invoice ID. |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
