# Magento2\QuoteShippingMethodManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**quoteShippingMethodManagementV1EstimateByAddressIdPost()**](QuoteShippingMethodManagementV1Api.md#quoteShippingMethodManagementV1EstimateByAddressIdPost) | **POST** /V1/carts/{cartId}/estimate-shipping-methods-by-address-id | 
[**quoteShippingMethodManagementV1EstimateByAddressIdPost_0()**](QuoteShippingMethodManagementV1Api.md#quoteShippingMethodManagementV1EstimateByAddressIdPost_0) | **POST** /V1/carts/mine/estimate-shipping-methods-by-address-id | 
[**quoteShippingMethodManagementV1GetListGet()**](QuoteShippingMethodManagementV1Api.md#quoteShippingMethodManagementV1GetListGet) | **GET** /V1/carts/{cartId}/shipping-methods | 
[**quoteShippingMethodManagementV1GetListGet_0()**](QuoteShippingMethodManagementV1Api.md#quoteShippingMethodManagementV1GetListGet_0) | **GET** /V1/carts/mine/shipping-methods | 


## `quoteShippingMethodManagementV1EstimateByAddressIdPost()`

```php
quoteShippingMethodManagementV1EstimateByAddressIdPost($cart_id, $quote_shipping_method_management_v1_estimate_by_address_id_post_body): \Magento2\Model\QuoteDataShippingMethodInterface[]
```



Estimate shipping

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteShippingMethodManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 56; // int | The shopping cart ID.
$quote_shipping_method_management_v1_estimate_by_address_id_post_body = new \Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest(); // \Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest

try {
    $result = $apiInstance->quoteShippingMethodManagementV1EstimateByAddressIdPost($cart_id, $quote_shipping_method_management_v1_estimate_by_address_id_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteShippingMethodManagementV1Api->quoteShippingMethodManagementV1EstimateByAddressIdPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **int**| The shopping cart ID. |
 **quote_shipping_method_management_v1_estimate_by_address_id_post_body** | [**\Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest**](../Model/QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\QuoteDataShippingMethodInterface[]**](../Model/QuoteDataShippingMethodInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `quoteShippingMethodManagementV1EstimateByAddressIdPost_0()`

```php
quoteShippingMethodManagementV1EstimateByAddressIdPost_0($quote_shipping_method_management_v1_estimate_by_address_id_post_body): \Magento2\Model\QuoteDataShippingMethodInterface[]
```



Estimate shipping

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteShippingMethodManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$quote_shipping_method_management_v1_estimate_by_address_id_post_body = new \Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest(); // \Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest

try {
    $result = $apiInstance->quoteShippingMethodManagementV1EstimateByAddressIdPost_0($quote_shipping_method_management_v1_estimate_by_address_id_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteShippingMethodManagementV1Api->quoteShippingMethodManagementV1EstimateByAddressIdPost_0: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **quote_shipping_method_management_v1_estimate_by_address_id_post_body** | [**\Magento2\Model\QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest**](../Model/QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\QuoteDataShippingMethodInterface[]**](../Model/QuoteDataShippingMethodInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `quoteShippingMethodManagementV1GetListGet()`

```php
quoteShippingMethodManagementV1GetListGet($cart_id): \Magento2\Model\QuoteDataShippingMethodInterface[]
```



Lists applicable shipping methods for a specified quote.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteShippingMethodManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 56; // int | The shopping cart ID.

try {
    $result = $apiInstance->quoteShippingMethodManagementV1GetListGet($cart_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteShippingMethodManagementV1Api->quoteShippingMethodManagementV1GetListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **int**| The shopping cart ID. |

### Return type

[**\Magento2\Model\QuoteDataShippingMethodInterface[]**](../Model/QuoteDataShippingMethodInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `quoteShippingMethodManagementV1GetListGet_0()`

```php
quoteShippingMethodManagementV1GetListGet_0(): \Magento2\Model\QuoteDataShippingMethodInterface[]
```



Lists applicable shipping methods for a specified quote.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteShippingMethodManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->quoteShippingMethodManagementV1GetListGet_0();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteShippingMethodManagementV1Api->quoteShippingMethodManagementV1GetListGet_0: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\QuoteDataShippingMethodInterface[]**](../Model/QuoteDataShippingMethodInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
