# Magento2\QuoteGuestCartManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**quoteGuestCartManagementV1AssignCustomerPut()**](QuoteGuestCartManagementV1Api.md#quoteGuestCartManagementV1AssignCustomerPut) | **PUT** /V1/guest-carts/{cartId} | 
[**quoteGuestCartManagementV1CreateEmptyCartPost()**](QuoteGuestCartManagementV1Api.md#quoteGuestCartManagementV1CreateEmptyCartPost) | **POST** /V1/guest-carts | 
[**quoteGuestCartManagementV1PlaceOrderPut()**](QuoteGuestCartManagementV1Api.md#quoteGuestCartManagementV1PlaceOrderPut) | **PUT** /V1/guest-carts/{cartId}/order | 


## `quoteGuestCartManagementV1AssignCustomerPut()`

```php
quoteGuestCartManagementV1AssignCustomerPut($cart_id, $quote_guest_cart_management_v1_assign_customer_put_body): bool
```



Assign a specified customer to a specified shopping cart.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteGuestCartManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string | The cart ID.
$quote_guest_cart_management_v1_assign_customer_put_body = new \Magento2\Model\QuoteCartManagementV1AssignCustomerPutRequest(); // \Magento2\Model\QuoteCartManagementV1AssignCustomerPutRequest

try {
    $result = $apiInstance->quoteGuestCartManagementV1AssignCustomerPut($cart_id, $quote_guest_cart_management_v1_assign_customer_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteGuestCartManagementV1Api->quoteGuestCartManagementV1AssignCustomerPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**| The cart ID. |
 **quote_guest_cart_management_v1_assign_customer_put_body** | [**\Magento2\Model\QuoteCartManagementV1AssignCustomerPutRequest**](../Model/QuoteCartManagementV1AssignCustomerPutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `quoteGuestCartManagementV1CreateEmptyCartPost()`

```php
quoteGuestCartManagementV1CreateEmptyCartPost(): string
```



Enable an customer or guest user to create an empty cart and quote for an anonymous customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteGuestCartManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->quoteGuestCartManagementV1CreateEmptyCartPost();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteGuestCartManagementV1Api->quoteGuestCartManagementV1CreateEmptyCartPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `quoteGuestCartManagementV1PlaceOrderPut()`

```php
quoteGuestCartManagementV1PlaceOrderPut($cart_id, $quote_guest_cart_management_v1_place_order_put_body): int
```



Place an order for a specified cart.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\QuoteGuestCartManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string | The cart ID.
$quote_guest_cart_management_v1_place_order_put_body = new \Magento2\Model\QuoteCartManagementV1PlaceOrderPutRequest(); // \Magento2\Model\QuoteCartManagementV1PlaceOrderPutRequest

try {
    $result = $apiInstance->quoteGuestCartManagementV1PlaceOrderPut($cart_id, $quote_guest_cart_management_v1_place_order_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling QuoteGuestCartManagementV1Api->quoteGuestCartManagementV1PlaceOrderPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**| The cart ID. |
 **quote_guest_cart_management_v1_place_order_put_body** | [**\Magento2\Model\QuoteCartManagementV1PlaceOrderPutRequest**](../Model/QuoteCartManagementV1PlaceOrderPutRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
