# Magento2\MSPTwoFactorAuthTfaV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**mSPTwoFactorAuthTfaV1GetAllProvidersGet()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1GetAllProvidersGet) | **GET** /V1/msp-2fa/installed-providers | 
[**mSPTwoFactorAuthTfaV1GetForcedProvidersGet()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1GetForcedProvidersGet) | **GET** /V1/msp-2fa/forced-providers | 
[**mSPTwoFactorAuthTfaV1GetProvidersToActivateGet()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1GetProvidersToActivateGet) | **GET** /V1/msp-2fa/providers-to-activate/{userId} | 
[**mSPTwoFactorAuthTfaV1GetTrustedDevicesGet()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1GetTrustedDevicesGet) | **GET** /V1/msp-2fa/trusted-devices/{userId} | 
[**mSPTwoFactorAuthTfaV1GetUserProvidersGet()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1GetUserProvidersGet) | **GET** /V1/msp-2fa/user-providers/{userId} | 
[**mSPTwoFactorAuthTfaV1ResetProviderConfigPost()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1ResetProviderConfigPost) | **POST** /V1/msp-2fa/reset-provider/{userId}/{providerCode} | 
[**mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut) | **PUT** /V1/msp-2fa/default-provider-code/{userId} | 
[**mSPTwoFactorAuthTfaV1SetProvidersCodesPut()**](MSPTwoFactorAuthTfaV1Api.md#mSPTwoFactorAuthTfaV1SetProvidersCodesPut) | **PUT** /V1/msp-2fa/user-providers/{userId} | 


## `mSPTwoFactorAuthTfaV1GetAllProvidersGet()`

```php
mSPTwoFactorAuthTfaV1GetAllProvidersGet(): \Magento2\Model\MSpTwoFactorAuthProviderInterface[]
```



Get a list of providers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1GetAllProvidersGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1GetAllProvidersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\MSpTwoFactorAuthProviderInterface[]**](../Model/MSpTwoFactorAuthProviderInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1GetForcedProvidersGet()`

```php
mSPTwoFactorAuthTfaV1GetForcedProvidersGet(): \Magento2\Model\MSpTwoFactorAuthProviderInterface[]
```



Retrieve forced providers list

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1GetForcedProvidersGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1GetForcedProvidersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\MSpTwoFactorAuthProviderInterface[]**](../Model/MSpTwoFactorAuthProviderInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1GetProvidersToActivateGet()`

```php
mSPTwoFactorAuthTfaV1GetProvidersToActivateGet($user_id): \Magento2\Model\MSpTwoFactorAuthProviderInterface[]
```



Returns a list of providers to configure/enroll

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1GetProvidersToActivateGet($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1GetProvidersToActivateGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |

### Return type

[**\Magento2\Model\MSpTwoFactorAuthProviderInterface[]**](../Model/MSpTwoFactorAuthProviderInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1GetTrustedDevicesGet()`

```php
mSPTwoFactorAuthTfaV1GetTrustedDevicesGet($user_id): \Magento2\Model\MSpTwoFactorAuthDataTrustedInterface[]
```



Return a list of trusted devices for given user id

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1GetTrustedDevicesGet($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1GetTrustedDevicesGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |

### Return type

[**\Magento2\Model\MSpTwoFactorAuthDataTrustedInterface[]**](../Model/MSpTwoFactorAuthDataTrustedInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1GetUserProvidersGet()`

```php
mSPTwoFactorAuthTfaV1GetUserProvidersGet($user_id): \Magento2\Model\MSpTwoFactorAuthProviderInterface[]
```



Get a user provider

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1GetUserProvidersGet($user_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1GetUserProvidersGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |

### Return type

[**\Magento2\Model\MSpTwoFactorAuthProviderInterface[]**](../Model/MSpTwoFactorAuthProviderInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1ResetProviderConfigPost()`

```php
mSPTwoFactorAuthTfaV1ResetProviderConfigPost($user_id, $provider_code): bool
```



Reset default provider code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int
$provider_code = 'provider_code_example'; // string

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1ResetProviderConfigPost($user_id, $provider_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1ResetProviderConfigPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |
 **provider_code** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut()`

```php
mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut($user_id, $_msp_two_factor_auth_tfa_v1_set_default_provider_code_put_body): bool
```



Set default provider code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int
$_msp_two_factor_auth_tfa_v1_set_default_provider_code_put_body = new \Magento2\Model\MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest(); // \Magento2\Model\MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut($user_id, $_msp_two_factor_auth_tfa_v1_set_default_provider_code_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |
 **_msp_two_factor_auth_tfa_v1_set_default_provider_code_put_body** | [**\Magento2\Model\MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest**](../Model/MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `mSPTwoFactorAuthTfaV1SetProvidersCodesPut()`

```php
mSPTwoFactorAuthTfaV1SetProvidersCodesPut($user_id, $_msp_two_factor_auth_tfa_v1_set_providers_codes_put_body): bool
```



Set providers

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\MSPTwoFactorAuthTfaV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$user_id = 56; // int
$_msp_two_factor_auth_tfa_v1_set_providers_codes_put_body = new \Magento2\Model\MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest(); // \Magento2\Model\MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest

try {
    $result = $apiInstance->mSPTwoFactorAuthTfaV1SetProvidersCodesPut($user_id, $_msp_two_factor_auth_tfa_v1_set_providers_codes_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MSPTwoFactorAuthTfaV1Api->mSPTwoFactorAuthTfaV1SetProvidersCodesPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **user_id** | **int**|  |
 **_msp_two_factor_auth_tfa_v1_set_providers_codes_put_body** | [**\Magento2\Model\MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest**](../Model/MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
