# Magento2\InventorySalesApiStockResolverV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventorySalesApiStockResolverV1ExecuteGet()**](InventorySalesApiStockResolverV1Api.md#inventorySalesApiStockResolverV1ExecuteGet) | **GET** /V1/inventory/stock-resolver/{type}/{code} | 


## `inventorySalesApiStockResolverV1ExecuteGet()`

```php
inventorySalesApiStockResolverV1ExecuteGet($type, $code): \Magento2\Model\InventoryApiDataStockInterface
```



Resolve Stock by Sales Channel type and code

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventorySalesApiStockResolverV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$type = 'type_example'; // string
$code = 'code_example'; // string

try {
    $result = $apiInstance->inventorySalesApiStockResolverV1ExecuteGet($type, $code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventorySalesApiStockResolverV1Api->inventorySalesApiStockResolverV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**|  |
 **code** | **string**|  |

### Return type

[**\Magento2\Model\InventoryApiDataStockInterface**](../Model/InventoryApiDataStockInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
