# Magento2\InventorySalesApiIsProductSalableForRequestedQtyV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet()**](InventorySalesApiIsProductSalableForRequestedQtyV1Api.md#inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet) | **GET** /V1/inventory/is-product-salable-for-requested-qty/{sku}/{stockId}/{requestedQty} | 


## `inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet()`

```php
inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet($sku, $stock_id, $requested_qty): \Magento2\Model\InventorySalesApiDataProductSalableResultInterface
```



Get is product salable for given SKU in a given Stock for a certain Qty

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventorySalesApiIsProductSalableForRequestedQtyV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$stock_id = 56; // int
$requested_qty = 3.4; // float

try {
    $result = $apiInstance->inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet($sku, $stock_id, $requested_qty);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventorySalesApiIsProductSalableForRequestedQtyV1Api->inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **stock_id** | **int**|  |
 **requested_qty** | **float**|  |

### Return type

[**\Magento2\Model\InventorySalesApiDataProductSalableResultInterface**](../Model/InventorySalesApiDataProductSalableResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
