# Magento2\InventorySalesApiGetProductSalableQtyV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventorySalesApiGetProductSalableQtyV1ExecuteGet()**](InventorySalesApiGetProductSalableQtyV1Api.md#inventorySalesApiGetProductSalableQtyV1ExecuteGet) | **GET** /V1/inventory/get-product-salable-quantity/{sku}/{stockId} | 


## `inventorySalesApiGetProductSalableQtyV1ExecuteGet()`

```php
inventorySalesApiGetProductSalableQtyV1ExecuteGet($sku, $stock_id): float
```



Get Product Quantity for given SKU and Stock

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventorySalesApiGetProductSalableQtyV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$stock_id = 56; // int

try {
    $result = $apiInstance->inventorySalesApiGetProductSalableQtyV1ExecuteGet($sku, $stock_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventorySalesApiGetProductSalableQtyV1Api->inventorySalesApiGetProductSalableQtyV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **stock_id** | **int**|  |

### Return type

**float**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
