# Magento2\InventoryExportStockApiExportStockSalableQtyV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventoryExportStockApiExportStockSalableQtyV1ExecuteGet()**](InventoryExportStockApiExportStockSalableQtyV1Api.md#inventoryExportStockApiExportStockSalableQtyV1ExecuteGet) | **GET** /V1/inventory/export-stock-salable-qty/{salesChannelType}/{salesChannelCode} | 


## `inventoryExportStockApiExportStockSalableQtyV1ExecuteGet()`

```php
inventoryExportStockApiExportStockSalableQtyV1ExecuteGet($sales_channel_type, $sales_channel_code, $search_criteria_filter_groups_0_filters_0_field, $search_criteria_filter_groups_0_filters_0_value, $search_criteria_filter_groups_0_filters_0_condition_type, $search_criteria_sort_orders_0_field, $search_criteria_sort_orders_0_direction, $search_criteria_page_size, $search_criteria_current_page): \Magento2\Model\InventoryExportStockApiDataExportStockSalableQtySearchResultInterface
```



Export product stock data filtered by search criteria.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryExportStockApiExportStockSalableQtyV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sales_channel_type = 'sales_channel_type_example'; // string
$sales_channel_code = 'sales_channel_code_example'; // string
$search_criteria_filter_groups_0_filters_0_field = 'search_criteria_filter_groups_0_filters_0_field_example'; // string | Field
$search_criteria_filter_groups_0_filters_0_value = 'search_criteria_filter_groups_0_filters_0_value_example'; // string | Value
$search_criteria_filter_groups_0_filters_0_condition_type = 'search_criteria_filter_groups_0_filters_0_condition_type_example'; // string | Condition type
$search_criteria_sort_orders_0_field = 'search_criteria_sort_orders_0_field_example'; // string | Sorting field.
$search_criteria_sort_orders_0_direction = 'search_criteria_sort_orders_0_direction_example'; // string | Sorting direction.
$search_criteria_page_size = 56; // int | Page size.
$search_criteria_current_page = 56; // int | Current page.

try {
    $result = $apiInstance->inventoryExportStockApiExportStockSalableQtyV1ExecuteGet($sales_channel_type, $sales_channel_code, $search_criteria_filter_groups_0_filters_0_field, $search_criteria_filter_groups_0_filters_0_value, $search_criteria_filter_groups_0_filters_0_condition_type, $search_criteria_sort_orders_0_field, $search_criteria_sort_orders_0_direction, $search_criteria_page_size, $search_criteria_current_page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryExportStockApiExportStockSalableQtyV1Api->inventoryExportStockApiExportStockSalableQtyV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sales_channel_type** | **string**|  |
 **sales_channel_code** | **string**|  |
 **search_criteria_filter_groups_0_filters_0_field** | **string**| Field | [optional]
 **search_criteria_filter_groups_0_filters_0_value** | **string**| Value | [optional]
 **search_criteria_filter_groups_0_filters_0_condition_type** | **string**| Condition type | [optional]
 **search_criteria_sort_orders_0_field** | **string**| Sorting field. | [optional]
 **search_criteria_sort_orders_0_direction** | **string**| Sorting direction. | [optional]
 **search_criteria_page_size** | **int**| Page size. | [optional]
 **search_criteria_current_page** | **int**| Current page. | [optional]

### Return type

[**\Magento2\Model\InventoryExportStockApiDataExportStockSalableQtySearchResultInterface**](../Model/InventoryExportStockApiDataExportStockSalableQtySearchResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
