# Magento2\InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet()**](InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api.md#inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet) | **GET** /V1/inventory/get-latlng-from-address | 


## `inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet()`

```php
inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet($address_country, $address_postcode, $address_street, $address_region, $address_city): \Magento2\Model\InventoryDistanceBasedSourceSelectionApiDataLatLngInterface
```



Get latitude and longitude object from address

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$address_country = 'address_country_example'; // string | Shipping country
$address_postcode = 'address_postcode_example'; // string | Shipping postcode
$address_street = 'address_street_example'; // string | Shipping street address
$address_region = 'address_region_example'; // string | Shipping region
$address_city = 'address_city_example'; // string | Shipping city

try {
    $result = $apiInstance->inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet($address_country, $address_postcode, $address_street, $address_region, $address_city);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api->inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **address_country** | **string**| Shipping country | [optional]
 **address_postcode** | **string**| Shipping postcode | [optional]
 **address_street** | **string**| Shipping street address | [optional]
 **address_region** | **string**| Shipping region | [optional]
 **address_city** | **string**| Shipping city | [optional]

### Return type

[**\Magento2\Model\InventoryDistanceBasedSourceSelectionApiDataLatLngInterface**](../Model/InventoryDistanceBasedSourceSelectionApiDataLatLngInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
