# Magento2\InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet()**](InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api.md#inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet) | **GET** /V1/inventory/get-distance | 


## `inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet()`

```php
inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet($source_lat, $source_lng, $destination_lat, $destination_lng): float
```



Get distance between two points

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$source_lat = 3.4; // float | Latitude
$source_lng = 3.4; // float | Longitude
$destination_lat = 3.4; // float | Latitude
$destination_lng = 3.4; // float | Longitude

try {
    $result = $apiInstance->inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet($source_lat, $source_lng, $destination_lat, $destination_lng);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api->inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **source_lat** | **float**| Latitude | [optional]
 **source_lng** | **float**| Longitude | [optional]
 **destination_lat** | **float**| Latitude | [optional]
 **destination_lng** | **float**| Longitude | [optional]

### Return type

**float**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
