# Magento2\InventoryApiSourceRepositoryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventoryApiSourceRepositoryV1GetGet()**](InventoryApiSourceRepositoryV1Api.md#inventoryApiSourceRepositoryV1GetGet) | **GET** /V1/inventory/sources/{sourceCode} | 
[**inventoryApiSourceRepositoryV1GetListGet()**](InventoryApiSourceRepositoryV1Api.md#inventoryApiSourceRepositoryV1GetListGet) | **GET** /V1/inventory/sources | 
[**inventoryApiSourceRepositoryV1SavePost()**](InventoryApiSourceRepositoryV1Api.md#inventoryApiSourceRepositoryV1SavePost) | **POST** /V1/inventory/sources | 
[**inventoryApiSourceRepositoryV1SavePut()**](InventoryApiSourceRepositoryV1Api.md#inventoryApiSourceRepositoryV1SavePut) | **PUT** /V1/inventory/sources/{sourceCode} | 


## `inventoryApiSourceRepositoryV1GetGet()`

```php
inventoryApiSourceRepositoryV1GetGet($source_code): \Magento2\Model\InventoryApiDataSourceInterface
```



Get Source data by given code. If you want to create plugin on get method, also you need to create separate plugin on getList method, because entity loading way is different for these methods

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryApiSourceRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$source_code = 'source_code_example'; // string

try {
    $result = $apiInstance->inventoryApiSourceRepositoryV1GetGet($source_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApiSourceRepositoryV1Api->inventoryApiSourceRepositoryV1GetGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **source_code** | **string**|  |

### Return type

[**\Magento2\Model\InventoryApiDataSourceInterface**](../Model/InventoryApiDataSourceInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryApiSourceRepositoryV1GetListGet()`

```php
inventoryApiSourceRepositoryV1GetListGet($search_criteria_filter_groups_0_filters_0_field, $search_criteria_filter_groups_0_filters_0_value, $search_criteria_filter_groups_0_filters_0_condition_type, $search_criteria_sort_orders_0_field, $search_criteria_sort_orders_0_direction, $search_criteria_page_size, $search_criteria_current_page): \Magento2\Model\InventoryApiDataSourceSearchResultsInterface
```



Find Sources by SearchCriteria SearchCriteria is not required because load all stocks is useful case

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryApiSourceRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search_criteria_filter_groups_0_filters_0_field = 'search_criteria_filter_groups_0_filters_0_field_example'; // string | Field
$search_criteria_filter_groups_0_filters_0_value = 'search_criteria_filter_groups_0_filters_0_value_example'; // string | Value
$search_criteria_filter_groups_0_filters_0_condition_type = 'search_criteria_filter_groups_0_filters_0_condition_type_example'; // string | Condition type
$search_criteria_sort_orders_0_field = 'search_criteria_sort_orders_0_field_example'; // string | Sorting field.
$search_criteria_sort_orders_0_direction = 'search_criteria_sort_orders_0_direction_example'; // string | Sorting direction.
$search_criteria_page_size = 56; // int | Page size.
$search_criteria_current_page = 56; // int | Current page.

try {
    $result = $apiInstance->inventoryApiSourceRepositoryV1GetListGet($search_criteria_filter_groups_0_filters_0_field, $search_criteria_filter_groups_0_filters_0_value, $search_criteria_filter_groups_0_filters_0_condition_type, $search_criteria_sort_orders_0_field, $search_criteria_sort_orders_0_direction, $search_criteria_page_size, $search_criteria_current_page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApiSourceRepositoryV1Api->inventoryApiSourceRepositoryV1GetListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search_criteria_filter_groups_0_filters_0_field** | **string**| Field | [optional]
 **search_criteria_filter_groups_0_filters_0_value** | **string**| Value | [optional]
 **search_criteria_filter_groups_0_filters_0_condition_type** | **string**| Condition type | [optional]
 **search_criteria_sort_orders_0_field** | **string**| Sorting field. | [optional]
 **search_criteria_sort_orders_0_direction** | **string**| Sorting direction. | [optional]
 **search_criteria_page_size** | **int**| Page size. | [optional]
 **search_criteria_current_page** | **int**| Current page. | [optional]

### Return type

[**\Magento2\Model\InventoryApiDataSourceSearchResultsInterface**](../Model/InventoryApiDataSourceSearchResultsInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryApiSourceRepositoryV1SavePost()`

```php
inventoryApiSourceRepositoryV1SavePost($inventory_api_source_repository_v1_save_post_body): \Magento2\Model\ErrorResponse
```



Save Source data

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryApiSourceRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$inventory_api_source_repository_v1_save_post_body = new \Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest(); // \Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest

try {
    $result = $apiInstance->inventoryApiSourceRepositoryV1SavePost($inventory_api_source_repository_v1_save_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApiSourceRepositoryV1Api->inventoryApiSourceRepositoryV1SavePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inventory_api_source_repository_v1_save_post_body** | [**\Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest**](../Model/InventoryApiSourceRepositoryV1SavePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\ErrorResponse**](../Model/ErrorResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `inventoryApiSourceRepositoryV1SavePut()`

```php
inventoryApiSourceRepositoryV1SavePut($source_code, $inventory_api_source_repository_v1_save_put_body): \Magento2\Model\ErrorResponse
```



Save Source data

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryApiSourceRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$source_code = 'source_code_example'; // string
$inventory_api_source_repository_v1_save_put_body = new \Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest(); // \Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest

try {
    $result = $apiInstance->inventoryApiSourceRepositoryV1SavePut($source_code, $inventory_api_source_repository_v1_save_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApiSourceRepositoryV1Api->inventoryApiSourceRepositoryV1SavePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **source_code** | **string**|  |
 **inventory_api_source_repository_v1_save_put_body** | [**\Magento2\Model\InventoryApiSourceRepositoryV1SavePostRequest**](../Model/InventoryApiSourceRepositoryV1SavePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\ErrorResponse**](../Model/ErrorResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
