# Magento2\InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet()**](InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api.md#inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet) | **GET** /V1/inventory/get-sources-assigned-to-stock-ordered-by-priority/{stockId} | 


## `inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet()`

```php
inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet($stock_id): \Magento2\Model\InventoryApiDataSourceInterface[]
```



Get Sources assigned to Stock ordered by priority If Stock with given id doesn't exist then return an empty array

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$stock_id = 56; // int

try {
    $result = $apiInstance->inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet($stock_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api->inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **stock_id** | **int**|  |

### Return type

[**\Magento2\Model\InventoryApiDataSourceInterface[]**](../Model/InventoryApiDataSourceInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
