# Magento2\DirectoryCountryInformationAcquirerV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**directoryCountryInformationAcquirerV1GetCountriesInfoGet()**](DirectoryCountryInformationAcquirerV1Api.md#directoryCountryInformationAcquirerV1GetCountriesInfoGet) | **GET** /V1/directory/countries | 
[**directoryCountryInformationAcquirerV1GetCountryInfoGet()**](DirectoryCountryInformationAcquirerV1Api.md#directoryCountryInformationAcquirerV1GetCountryInfoGet) | **GET** /V1/directory/countries/{countryId} | 


## `directoryCountryInformationAcquirerV1GetCountriesInfoGet()`

```php
directoryCountryInformationAcquirerV1GetCountriesInfoGet(): \Magento2\Model\DirectoryDataCountryInformationInterface[]
```



Get all countries and regions information for the store.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\DirectoryCountryInformationAcquirerV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->directoryCountryInformationAcquirerV1GetCountriesInfoGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DirectoryCountryInformationAcquirerV1Api->directoryCountryInformationAcquirerV1GetCountriesInfoGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\DirectoryDataCountryInformationInterface[]**](../Model/DirectoryDataCountryInformationInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `directoryCountryInformationAcquirerV1GetCountryInfoGet()`

```php
directoryCountryInformationAcquirerV1GetCountryInfoGet($country_id): \Magento2\Model\DirectoryDataCountryInformationInterface
```



Get country and region information for the store.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\DirectoryCountryInformationAcquirerV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$country_id = 'country_id_example'; // string

try {
    $result = $apiInstance->directoryCountryInformationAcquirerV1GetCountryInfoGet($country_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling DirectoryCountryInformationAcquirerV1Api->directoryCountryInformationAcquirerV1GetCountryInfoGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country_id** | **string**|  |

### Return type

[**\Magento2\Model\DirectoryDataCountryInformationInterface**](../Model/DirectoryDataCountryInformationInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
