# Magento2\CustomerGroupManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**customerGroupManagementV1GetDefaultGroupGet()**](CustomerGroupManagementV1Api.md#customerGroupManagementV1GetDefaultGroupGet) | **GET** /V1/customerGroups/default/{storeId} | 
[**customerGroupManagementV1GetDefaultGroupGet_0()**](CustomerGroupManagementV1Api.md#customerGroupManagementV1GetDefaultGroupGet_0) | **GET** /V1/customerGroups/default | 
[**customerGroupManagementV1IsReadonlyGet()**](CustomerGroupManagementV1Api.md#customerGroupManagementV1IsReadonlyGet) | **GET** /V1/customerGroups/{id}/permissions | 


## `customerGroupManagementV1GetDefaultGroupGet()`

```php
customerGroupManagementV1GetDefaultGroupGet($store_id): \Magento2\Model\CustomerDataGroupInterface
```



Get default customer group.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerGroupManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store_id = 56; // int

try {
    $result = $apiInstance->customerGroupManagementV1GetDefaultGroupGet($store_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupManagementV1Api->customerGroupManagementV1GetDefaultGroupGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **int**|  |

### Return type

[**\Magento2\Model\CustomerDataGroupInterface**](../Model/CustomerDataGroupInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerGroupManagementV1GetDefaultGroupGet_0()`

```php
customerGroupManagementV1GetDefaultGroupGet_0($store_id): \Magento2\Model\CustomerDataGroupInterface
```



Get default customer group.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerGroupManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store_id = 56; // int

try {
    $result = $apiInstance->customerGroupManagementV1GetDefaultGroupGet_0($store_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupManagementV1Api->customerGroupManagementV1GetDefaultGroupGet_0: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store_id** | **int**|  | [optional]

### Return type

[**\Magento2\Model\CustomerDataGroupInterface**](../Model/CustomerDataGroupInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerGroupManagementV1IsReadonlyGet()`

```php
customerGroupManagementV1IsReadonlyGet($id): bool
```



Check if customer group can be deleted.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerGroupManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int

try {
    $result = $apiInstance->customerGroupManagementV1IsReadonlyGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupManagementV1Api->customerGroupManagementV1IsReadonlyGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
