# Magento2\CustomerAddressRepositoryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**customerAddressRepositoryV1DeleteByIdDelete()**](CustomerAddressRepositoryV1Api.md#customerAddressRepositoryV1DeleteByIdDelete) | **DELETE** /V1/addresses/{addressId} | 
[**customerAddressRepositoryV1GetByIdGet()**](CustomerAddressRepositoryV1Api.md#customerAddressRepositoryV1GetByIdGet) | **GET** /V1/customers/addresses/{addressId} | 


## `customerAddressRepositoryV1DeleteByIdDelete()`

```php
customerAddressRepositoryV1DeleteByIdDelete($address_id): bool
```



Delete customer address by ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAddressRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$address_id = 56; // int

try {
    $result = $apiInstance->customerAddressRepositoryV1DeleteByIdDelete($address_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressRepositoryV1Api->customerAddressRepositoryV1DeleteByIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **address_id** | **int**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAddressRepositoryV1GetByIdGet()`

```php
customerAddressRepositoryV1GetByIdGet($address_id): \Magento2\Model\CustomerDataAddressInterface
```



Retrieve customer address.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAddressRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$address_id = 56; // int

try {
    $result = $apiInstance->customerAddressRepositoryV1GetByIdGet($address_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAddressRepositoryV1Api->customerAddressRepositoryV1GetByIdGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **address_id** | **int**|  |

### Return type

[**\Magento2\Model\CustomerDataAddressInterface**](../Model/CustomerDataAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
