# Magento2\CustomerAccountManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**customerAccountManagementV1ActivateByIdPut()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ActivateByIdPut) | **PUT** /V1/customers/me/activate | 
[**customerAccountManagementV1ActivatePut()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ActivatePut) | **PUT** /V1/customers/{email}/activate | 
[**customerAccountManagementV1ChangePasswordByIdPut()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ChangePasswordByIdPut) | **PUT** /V1/customers/me/password | 
[**customerAccountManagementV1CreateAccountPost()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1CreateAccountPost) | **POST** /V1/customers | 
[**customerAccountManagementV1GetConfirmationStatusGet()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1GetConfirmationStatusGet) | **GET** /V1/customers/{customerId}/confirm | 
[**customerAccountManagementV1GetDefaultBillingAddressGet()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1GetDefaultBillingAddressGet) | **GET** /V1/customers/me/billingAddress | 
[**customerAccountManagementV1GetDefaultBillingAddressGet_0()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1GetDefaultBillingAddressGet_0) | **GET** /V1/customers/{customerId}/billingAddress | 
[**customerAccountManagementV1GetDefaultShippingAddressGet()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1GetDefaultShippingAddressGet) | **GET** /V1/customers/me/shippingAddress | 
[**customerAccountManagementV1GetDefaultShippingAddressGet_0()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1GetDefaultShippingAddressGet_0) | **GET** /V1/customers/{customerId}/shippingAddress | 
[**customerAccountManagementV1InitiatePasswordResetPut()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1InitiatePasswordResetPut) | **PUT** /V1/customers/password | 
[**customerAccountManagementV1IsEmailAvailablePost()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1IsEmailAvailablePost) | **POST** /V1/customers/isEmailAvailable | 
[**customerAccountManagementV1IsReadonlyGet()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1IsReadonlyGet) | **GET** /V1/customers/{customerId}/permissions/readonly | 
[**customerAccountManagementV1ResendConfirmationPost()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ResendConfirmationPost) | **POST** /V1/customers/confirm | 
[**customerAccountManagementV1ResetPasswordPost()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ResetPasswordPost) | **POST** /V1/customers/resetPassword | 
[**customerAccountManagementV1ValidatePut()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ValidatePut) | **PUT** /V1/customers/validate | 
[**customerAccountManagementV1ValidateResetPasswordLinkTokenGet()**](CustomerAccountManagementV1Api.md#customerAccountManagementV1ValidateResetPasswordLinkTokenGet) | **GET** /V1/customers/{customerId}/password/resetLinkToken/{resetPasswordLinkToken} | 


## `customerAccountManagementV1ActivateByIdPut()`

```php
customerAccountManagementV1ActivateByIdPut($customer_account_management_v1_activate_by_id_put_body): \Magento2\Model\CustomerDataCustomerInterface
```



Activate a customer account using a key that was sent in a confirmation email.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_activate_by_id_put_body = new \Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest(); // \Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest

try {
    $result = $apiInstance->customerAccountManagementV1ActivateByIdPut($customer_account_management_v1_activate_by_id_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ActivateByIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_activate_by_id_put_body** | [**\Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest**](../Model/CustomerAccountManagementV1ActivateByIdPutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CustomerDataCustomerInterface**](../Model/CustomerDataCustomerInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ActivatePut()`

```php
customerAccountManagementV1ActivatePut($email, $customer_account_management_v1_activate_put_body): \Magento2\Model\CustomerDataCustomerInterface
```



Activate a customer account using a key that was sent in a confirmation email.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$email = 'email_example'; // string
$customer_account_management_v1_activate_put_body = new \Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest(); // \Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest

try {
    $result = $apiInstance->customerAccountManagementV1ActivatePut($email, $customer_account_management_v1_activate_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ActivatePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **email** | **string**|  |
 **customer_account_management_v1_activate_put_body** | [**\Magento2\Model\CustomerAccountManagementV1ActivateByIdPutRequest**](../Model/CustomerAccountManagementV1ActivateByIdPutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CustomerDataCustomerInterface**](../Model/CustomerDataCustomerInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ChangePasswordByIdPut()`

```php
customerAccountManagementV1ChangePasswordByIdPut($customer_account_management_v1_change_password_by_id_put_body): bool
```



Change customer password.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_change_password_by_id_put_body = new \Magento2\Model\CustomerAccountManagementV1ChangePasswordByIdPutRequest(); // \Magento2\Model\CustomerAccountManagementV1ChangePasswordByIdPutRequest

try {
    $result = $apiInstance->customerAccountManagementV1ChangePasswordByIdPut($customer_account_management_v1_change_password_by_id_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ChangePasswordByIdPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_change_password_by_id_put_body** | [**\Magento2\Model\CustomerAccountManagementV1ChangePasswordByIdPutRequest**](../Model/CustomerAccountManagementV1ChangePasswordByIdPutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1CreateAccountPost()`

```php
customerAccountManagementV1CreateAccountPost($customer_account_management_v1_create_account_post_body): \Magento2\Model\CustomerDataCustomerInterface
```



Create customer account. Perform necessary business operations like sending email.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_create_account_post_body = new \Magento2\Model\CustomerAccountManagementV1CreateAccountPostRequest(); // \Magento2\Model\CustomerAccountManagementV1CreateAccountPostRequest

try {
    $result = $apiInstance->customerAccountManagementV1CreateAccountPost($customer_account_management_v1_create_account_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1CreateAccountPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_create_account_post_body** | [**\Magento2\Model\CustomerAccountManagementV1CreateAccountPostRequest**](../Model/CustomerAccountManagementV1CreateAccountPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CustomerDataCustomerInterface**](../Model/CustomerDataCustomerInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1GetConfirmationStatusGet()`

```php
customerAccountManagementV1GetConfirmationStatusGet($customer_id): string
```



Gets the account confirmation status.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 56; // int

try {
    $result = $apiInstance->customerAccountManagementV1GetConfirmationStatusGet($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1GetConfirmationStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**|  |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1GetDefaultBillingAddressGet()`

```php
customerAccountManagementV1GetDefaultBillingAddressGet(): \Magento2\Model\CustomerDataAddressInterface
```



Retrieve default billing address for the given customerId.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->customerAccountManagementV1GetDefaultBillingAddressGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1GetDefaultBillingAddressGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\CustomerDataAddressInterface**](../Model/CustomerDataAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1GetDefaultBillingAddressGet_0()`

```php
customerAccountManagementV1GetDefaultBillingAddressGet_0($customer_id): \Magento2\Model\CustomerDataAddressInterface
```



Retrieve default billing address for the given customerId.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 56; // int

try {
    $result = $apiInstance->customerAccountManagementV1GetDefaultBillingAddressGet_0($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1GetDefaultBillingAddressGet_0: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**|  |

### Return type

[**\Magento2\Model\CustomerDataAddressInterface**](../Model/CustomerDataAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1GetDefaultShippingAddressGet()`

```php
customerAccountManagementV1GetDefaultShippingAddressGet(): \Magento2\Model\CustomerDataAddressInterface
```



Retrieve default shipping address for the given customerId.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->customerAccountManagementV1GetDefaultShippingAddressGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1GetDefaultShippingAddressGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Magento2\Model\CustomerDataAddressInterface**](../Model/CustomerDataAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1GetDefaultShippingAddressGet_0()`

```php
customerAccountManagementV1GetDefaultShippingAddressGet_0($customer_id): \Magento2\Model\CustomerDataAddressInterface
```



Retrieve default shipping address for the given customerId.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 56; // int

try {
    $result = $apiInstance->customerAccountManagementV1GetDefaultShippingAddressGet_0($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1GetDefaultShippingAddressGet_0: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**|  |

### Return type

[**\Magento2\Model\CustomerDataAddressInterface**](../Model/CustomerDataAddressInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1InitiatePasswordResetPut()`

```php
customerAccountManagementV1InitiatePasswordResetPut($customer_account_management_v1_initiate_password_reset_put_body): bool
```



Send an email to the customer with a password reset link.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_initiate_password_reset_put_body = new \Magento2\Model\CustomerAccountManagementV1InitiatePasswordResetPutRequest(); // \Magento2\Model\CustomerAccountManagementV1InitiatePasswordResetPutRequest

try {
    $result = $apiInstance->customerAccountManagementV1InitiatePasswordResetPut($customer_account_management_v1_initiate_password_reset_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1InitiatePasswordResetPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_initiate_password_reset_put_body** | [**\Magento2\Model\CustomerAccountManagementV1InitiatePasswordResetPutRequest**](../Model/CustomerAccountManagementV1InitiatePasswordResetPutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1IsEmailAvailablePost()`

```php
customerAccountManagementV1IsEmailAvailablePost($customer_account_management_v1_is_email_available_post_body): bool
```



Check if given email is associated with a customer account in given website.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_is_email_available_post_body = new \Magento2\Model\CustomerAccountManagementV1IsEmailAvailablePostRequest(); // \Magento2\Model\CustomerAccountManagementV1IsEmailAvailablePostRequest

try {
    $result = $apiInstance->customerAccountManagementV1IsEmailAvailablePost($customer_account_management_v1_is_email_available_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1IsEmailAvailablePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_is_email_available_post_body** | [**\Magento2\Model\CustomerAccountManagementV1IsEmailAvailablePostRequest**](../Model/CustomerAccountManagementV1IsEmailAvailablePostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1IsReadonlyGet()`

```php
customerAccountManagementV1IsReadonlyGet($customer_id): bool
```



Check if customer can be deleted.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 56; // int

try {
    $result = $apiInstance->customerAccountManagementV1IsReadonlyGet($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1IsReadonlyGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ResendConfirmationPost()`

```php
customerAccountManagementV1ResendConfirmationPost($customer_account_management_v1_resend_confirmation_post_body): bool
```



Resend confirmation email.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_resend_confirmation_post_body = new \Magento2\Model\CustomerAccountManagementV1ResendConfirmationPostRequest(); // \Magento2\Model\CustomerAccountManagementV1ResendConfirmationPostRequest

try {
    $result = $apiInstance->customerAccountManagementV1ResendConfirmationPost($customer_account_management_v1_resend_confirmation_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ResendConfirmationPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_resend_confirmation_post_body** | [**\Magento2\Model\CustomerAccountManagementV1ResendConfirmationPostRequest**](../Model/CustomerAccountManagementV1ResendConfirmationPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ResetPasswordPost()`

```php
customerAccountManagementV1ResetPasswordPost($customer_account_management_v1_reset_password_post_body): bool
```



Reset customer password.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_reset_password_post_body = new \Magento2\Model\CustomerAccountManagementV1ResetPasswordPostRequest(); // \Magento2\Model\CustomerAccountManagementV1ResetPasswordPostRequest

try {
    $result = $apiInstance->customerAccountManagementV1ResetPasswordPost($customer_account_management_v1_reset_password_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ResetPasswordPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_reset_password_post_body** | [**\Magento2\Model\CustomerAccountManagementV1ResetPasswordPostRequest**](../Model/CustomerAccountManagementV1ResetPasswordPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ValidatePut()`

```php
customerAccountManagementV1ValidatePut($customer_account_management_v1_validate_put_body): \Magento2\Model\CustomerDataValidationResultsInterface
```



Validate customer data.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_account_management_v1_validate_put_body = new \Magento2\Model\CustomerAccountManagementV1ValidatePutRequest(); // \Magento2\Model\CustomerAccountManagementV1ValidatePutRequest

try {
    $result = $apiInstance->customerAccountManagementV1ValidatePut($customer_account_management_v1_validate_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ValidatePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_account_management_v1_validate_put_body** | [**\Magento2\Model\CustomerAccountManagementV1ValidatePutRequest**](../Model/CustomerAccountManagementV1ValidatePutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CustomerDataValidationResultsInterface**](../Model/CustomerDataValidationResultsInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `customerAccountManagementV1ValidateResetPasswordLinkTokenGet()`

```php
customerAccountManagementV1ValidateResetPasswordLinkTokenGet($customer_id, $reset_password_link_token): bool
```



Check if password reset token is valid.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CustomerAccountManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer_id = 56; // int | If null is given then a customer will be matched by the RP token.
$reset_password_link_token = 'reset_password_link_token_example'; // string

try {
    $result = $apiInstance->customerAccountManagementV1ValidateResetPasswordLinkTokenGet($customer_id, $reset_password_link_token);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerAccountManagementV1Api->customerAccountManagementV1ValidateResetPasswordLinkTokenGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **int**| If null is given then a customer will be matched by the RP token. |
 **reset_password_link_token** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
