# Magento2\CheckoutGuestTotalsInformationManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**checkoutGuestTotalsInformationManagementV1CalculatePost()**](CheckoutGuestTotalsInformationManagementV1Api.md#checkoutGuestTotalsInformationManagementV1CalculatePost) | **POST** /V1/guest-carts/{cartId}/totals-information | 


## `checkoutGuestTotalsInformationManagementV1CalculatePost()`

```php
checkoutGuestTotalsInformationManagementV1CalculatePost($cart_id, $checkout_guest_totals_information_management_v1_calculate_post_body): \Magento2\Model\QuoteDataTotalsInterface
```



Calculate quote totals based on address and shipping method.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CheckoutGuestTotalsInformationManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cart_id = 'cart_id_example'; // string
$checkout_guest_totals_information_management_v1_calculate_post_body = new \Magento2\Model\CheckoutTotalsInformationManagementV1CalculatePostRequest(); // \Magento2\Model\CheckoutTotalsInformationManagementV1CalculatePostRequest

try {
    $result = $apiInstance->checkoutGuestTotalsInformationManagementV1CalculatePost($cart_id, $checkout_guest_totals_information_management_v1_calculate_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CheckoutGuestTotalsInformationManagementV1Api->checkoutGuestTotalsInformationManagementV1CalculatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cart_id** | **string**|  |
 **checkout_guest_totals_information_management_v1_calculate_post_body** | [**\Magento2\Model\CheckoutTotalsInformationManagementV1CalculatePostRequest**](../Model/CheckoutTotalsInformationManagementV1CalculatePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\QuoteDataTotalsInterface**](../Model/QuoteDataTotalsInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
