# Magento2\CatalogTierPriceStorageV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogTierPriceStorageV1DeletePost()**](CatalogTierPriceStorageV1Api.md#catalogTierPriceStorageV1DeletePost) | **POST** /V1/products/tier-prices-delete | 
[**catalogTierPriceStorageV1GetPost()**](CatalogTierPriceStorageV1Api.md#catalogTierPriceStorageV1GetPost) | **POST** /V1/products/tier-prices-information | 
[**catalogTierPriceStorageV1ReplacePut()**](CatalogTierPriceStorageV1Api.md#catalogTierPriceStorageV1ReplacePut) | **PUT** /V1/products/tier-prices | 
[**catalogTierPriceStorageV1UpdatePost()**](CatalogTierPriceStorageV1Api.md#catalogTierPriceStorageV1UpdatePost) | **POST** /V1/products/tier-prices | 


## `catalogTierPriceStorageV1DeletePost()`

```php
catalogTierPriceStorageV1DeletePost($catalog_tier_price_storage_v1_delete_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Delete product tier prices. If any items will have invalid price, price type, website id, sku, customer group or quantity, they will be marked as failed and excluded from delete list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogTierPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_tier_price_storage_v1_delete_post_body = new \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest(); // \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest

try {
    $result = $apiInstance->catalogTierPriceStorageV1DeletePost($catalog_tier_price_storage_v1_delete_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogTierPriceStorageV1Api->catalogTierPriceStorageV1DeletePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_tier_price_storage_v1_delete_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest**](../Model/CatalogTierPriceStorageV1ReplacePutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogTierPriceStorageV1GetPost()`

```php
catalogTierPriceStorageV1GetPost($catalog_tier_price_storage_v1_get_post_body): \Magento2\Model\CatalogDataTierPriceInterface[]
```



Return product prices. In case of at least one of skus is not found exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogTierPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_tier_price_storage_v1_get_post_body = new \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest(); // \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest

try {
    $result = $apiInstance->catalogTierPriceStorageV1GetPost($catalog_tier_price_storage_v1_get_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogTierPriceStorageV1Api->catalogTierPriceStorageV1GetPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_tier_price_storage_v1_get_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1GetPostRequest**](../Model/CatalogTierPriceStorageV1GetPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataTierPriceInterface[]**](../Model/CatalogDataTierPriceInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogTierPriceStorageV1ReplacePut()`

```php
catalogTierPriceStorageV1ReplacePut($catalog_tier_price_storage_v1_replace_put_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Remove existing tier prices and replace them with the new ones. If any items will have invalid price, price type, website id, sku, customer group or quantity, they will be marked as failed and excluded from replace list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogTierPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_tier_price_storage_v1_replace_put_body = new \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest(); // \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest

try {
    $result = $apiInstance->catalogTierPriceStorageV1ReplacePut($catalog_tier_price_storage_v1_replace_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogTierPriceStorageV1Api->catalogTierPriceStorageV1ReplacePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_tier_price_storage_v1_replace_put_body** | [**\Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest**](../Model/CatalogTierPriceStorageV1ReplacePutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogTierPriceStorageV1UpdatePost()`

```php
catalogTierPriceStorageV1UpdatePost($catalog_tier_price_storage_v1_update_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Add or update product prices. If any items will have invalid price, price type, website id, sku, customer group or quantity, they will be marked as failed and excluded from update list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogTierPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_tier_price_storage_v1_update_post_body = new \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest(); // \Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest

try {
    $result = $apiInstance->catalogTierPriceStorageV1UpdatePost($catalog_tier_price_storage_v1_update_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogTierPriceStorageV1Api->catalogTierPriceStorageV1UpdatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_tier_price_storage_v1_update_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1ReplacePutRequest**](../Model/CatalogTierPriceStorageV1ReplacePutRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
