# Magento2\CatalogSpecialPriceStorageV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogSpecialPriceStorageV1DeletePost()**](CatalogSpecialPriceStorageV1Api.md#catalogSpecialPriceStorageV1DeletePost) | **POST** /V1/products/special-price-delete | 
[**catalogSpecialPriceStorageV1GetPost()**](CatalogSpecialPriceStorageV1Api.md#catalogSpecialPriceStorageV1GetPost) | **POST** /V1/products/special-price-information | 
[**catalogSpecialPriceStorageV1UpdatePost()**](CatalogSpecialPriceStorageV1Api.md#catalogSpecialPriceStorageV1UpdatePost) | **POST** /V1/products/special-price | 


## `catalogSpecialPriceStorageV1DeletePost()`

```php
catalogSpecialPriceStorageV1DeletePost($catalog_special_price_storage_v1_delete_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Delete product's special price. If any items will have invalid price, store id, sku or dates, they will be marked as failed and excluded from delete list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the delete exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogSpecialPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_special_price_storage_v1_delete_post_body = new \Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest(); // \Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest

try {
    $result = $apiInstance->catalogSpecialPriceStorageV1DeletePost($catalog_special_price_storage_v1_delete_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogSpecialPriceStorageV1Api->catalogSpecialPriceStorageV1DeletePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_special_price_storage_v1_delete_post_body** | [**\Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest**](../Model/CatalogSpecialPriceStorageV1UpdatePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogSpecialPriceStorageV1GetPost()`

```php
catalogSpecialPriceStorageV1GetPost($catalog_special_price_storage_v1_get_post_body): \Magento2\Model\CatalogDataSpecialPriceInterface[]
```



Return product's special price. In case of at least one of skus is not found exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogSpecialPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_special_price_storage_v1_get_post_body = new \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest(); // \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest

try {
    $result = $apiInstance->catalogSpecialPriceStorageV1GetPost($catalog_special_price_storage_v1_get_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogSpecialPriceStorageV1Api->catalogSpecialPriceStorageV1GetPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_special_price_storage_v1_get_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1GetPostRequest**](../Model/CatalogTierPriceStorageV1GetPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataSpecialPriceInterface[]**](../Model/CatalogDataSpecialPriceInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogSpecialPriceStorageV1UpdatePost()`

```php
catalogSpecialPriceStorageV1UpdatePost($catalog_special_price_storage_v1_update_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Add or update product's special price. If any items will have invalid price, store id, sku or dates, they will be marked as failed and excluded from update list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogSpecialPriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_special_price_storage_v1_update_post_body = new \Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest(); // \Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest

try {
    $result = $apiInstance->catalogSpecialPriceStorageV1UpdatePost($catalog_special_price_storage_v1_update_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogSpecialPriceStorageV1Api->catalogSpecialPriceStorageV1UpdatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_special_price_storage_v1_update_post_body** | [**\Magento2\Model\CatalogSpecialPriceStorageV1UpdatePostRequest**](../Model/CatalogSpecialPriceStorageV1UpdatePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
