# Magento2\CatalogProductWebsiteLinkRepositoryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete()**](CatalogProductWebsiteLinkRepositoryV1Api.md#catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete) | **DELETE** /V1/products/{sku}/websites/{websiteId} | 
[**catalogProductWebsiteLinkRepositoryV1SavePost()**](CatalogProductWebsiteLinkRepositoryV1Api.md#catalogProductWebsiteLinkRepositoryV1SavePost) | **POST** /V1/products/{sku}/websites | 
[**catalogProductWebsiteLinkRepositoryV1SavePut()**](CatalogProductWebsiteLinkRepositoryV1Api.md#catalogProductWebsiteLinkRepositoryV1SavePut) | **PUT** /V1/products/{sku}/websites | 


## `catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete()`

```php
catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete($sku, $website_id): bool
```



Remove the website assignment from the product by product sku

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductWebsiteLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$website_id = 56; // int

try {
    $result = $apiInstance->catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete($sku, $website_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductWebsiteLinkRepositoryV1Api->catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **website_id** | **int**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductWebsiteLinkRepositoryV1SavePost()`

```php
catalogProductWebsiteLinkRepositoryV1SavePost($sku, $catalog_product_website_link_repository_v1_save_post_body): bool
```



Assign a product to the website

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductWebsiteLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$catalog_product_website_link_repository_v1_save_post_body = new \Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest(); // \Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest

try {
    $result = $apiInstance->catalogProductWebsiteLinkRepositoryV1SavePost($sku, $catalog_product_website_link_repository_v1_save_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductWebsiteLinkRepositoryV1Api->catalogProductWebsiteLinkRepositoryV1SavePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **catalog_product_website_link_repository_v1_save_post_body** | [**\Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest**](../Model/CatalogProductWebsiteLinkRepositoryV1SavePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductWebsiteLinkRepositoryV1SavePut()`

```php
catalogProductWebsiteLinkRepositoryV1SavePut($sku, $catalog_product_website_link_repository_v1_save_put_body): bool
```



Assign a product to the website

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductWebsiteLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$catalog_product_website_link_repository_v1_save_put_body = new \Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest(); // \Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest

try {
    $result = $apiInstance->catalogProductWebsiteLinkRepositoryV1SavePut($sku, $catalog_product_website_link_repository_v1_save_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductWebsiteLinkRepositoryV1Api->catalogProductWebsiteLinkRepositoryV1SavePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **catalog_product_website_link_repository_v1_save_put_body** | [**\Magento2\Model\CatalogProductWebsiteLinkRepositoryV1SavePutRequest**](../Model/CatalogProductWebsiteLinkRepositoryV1SavePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
