# Magento2\CatalogProductMediaAttributeManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogProductMediaAttributeManagementV1GetListGet()**](CatalogProductMediaAttributeManagementV1Api.md#catalogProductMediaAttributeManagementV1GetListGet) | **GET** /V1/products/media/types/{attributeSetName} | 


## `catalogProductMediaAttributeManagementV1GetListGet()`

```php
catalogProductMediaAttributeManagementV1GetListGet($attribute_set_name): \Magento2\Model\CatalogDataProductAttributeInterface[]
```



Retrieve the list of media attributes (fronted input type is media_image) assigned to the given attribute set.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductMediaAttributeManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attribute_set_name = 'attribute_set_name_example'; // string

try {
    $result = $apiInstance->catalogProductMediaAttributeManagementV1GetListGet($attribute_set_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductMediaAttributeManagementV1Api->catalogProductMediaAttributeManagementV1GetListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_set_name** | **string**|  |

### Return type

[**\Magento2\Model\CatalogDataProductAttributeInterface[]**](../Model/CatalogDataProductAttributeInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
